# -*- coding: utf-8 -*- #
# Copyright 2018 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Flags for the `compute sole-tenancy node-types` commands."""
from __future__ import absolute_import
from __future__ import unicode_literals
from googlecloudsdk.command_lib.compute import completers as compute_completers
from googlecloudsdk.command_lib.compute import flags as compute_flags


def MakeNodeTypeArg():
  return compute_flags.ResourceArgument(
      resource_name='node types',
      completer=NodeTypesCompleter,
      zonal_collection='compute.nodeTypes',
      zone_explanation=compute_flags.ZONE_PROPERTY_EXPLANATION)


class NodeTypesCompleter(compute_completers.ListCommandCompleter):

  def __init__(self, **kwargs):
    super(NodeTypesCompleter, self).__init__(
        collection='compute.nodeTypes',
        api_version='beta',
        list_command='beta compute sole-tenancy node-types list --uri',
        **kwargs)
