"""Generated message classes for cloudiot version v1.

Registers and manages IoT (Internet of Things) devices that connect to the
Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudiot'


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CloudiotProjectsLocationsRegistriesCreateRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesCreateRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    parent: The project and cloud region where this device registry must be
      created. For example, `projects/example-project/locations/us-central1`.
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDeleteRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDeleteRequest object.

  Fields:
    name: The name of the device registry. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest
  object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
    numVersions: The number of versions to list. Versions are listed in
      decreasing order of the version number. The maximum number of versions
      retained is 10. If this value is zero, it will return all the versions
      available.
  """

  name = _messages.StringField(1, required=True)
  numVersions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesDevicesCreateRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesCreateRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    parent: The name of the device registry where this device should be
      created. For example, `projects/example-project/locations/us-
      central1/registries/my-registry`.
  """

  device = _messages.MessageField('Device', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesDeleteRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesDeleteRequest object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesGetRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesGetRequest object.

  Fields:
    fieldMask: The fields of the `Device` resource to be returned in the
      response. If the field mask is unset or empty, all fields are returned.
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  fieldMask = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesListRequest object.

  Fields:
    deviceIds: A list of device string identifiers. If empty, it will ignore
      this field. For example, `['device0', 'device12']`. This field cannot
      hold more than 10,000 entries.
    deviceNumIds: A list of device numerical ids. If empty, it will ignore
      this field. This field cannot hold more than 10,000 entries.
    fieldMask: The fields of the `Device` resource to be returned in the
      response. The fields `id`, and `num_id` are always returned by default,
      along with any other fields specified.
    pageSize: The maximum number of devices to return in the response. If this
      value is zero, the service will select a default size. A call may return
      fewer objects than requested, but if there is a non-empty `page_token`,
      it indicates that more entries are available.
    pageToken: The value returned by the last `ListDevicesResponse`; indicates
      that this is a continuation of a prior `ListDevices` call, and that the
      system should return the next page of data.
    parent: The device registry path. Required. For example, `projects/my-
      project/locations/us-central1/registries/my-registry`.
  """

  deviceIds = _messages.StringField(1, repeated=True)
  deviceNumIds = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.UINT64)
  fieldMask = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)


class CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest(_messages.Message):
  r"""A
  CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest
  object.

  Fields:
    modifyCloudToDeviceConfigRequest: A ModifyCloudToDeviceConfigRequest
      resource to be passed as the request body.
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  modifyCloudToDeviceConfigRequest = _messages.MessageField('ModifyCloudToDeviceConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesPatchRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesPatchRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or `projects/p1/locations
      /us-central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    updateMask: Only updates the `device` fields indicated by this mask. The
      field mask must not be empty, and it must not contain fields that are
      immutable or only set by the server. Mutable top-level fields:
      `credentials`, `blocked`, and `metadata`
  """

  device = _messages.MessageField('Device', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesDevicesStatesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesStatesListRequest object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
    numStates: The number of states to list. States are listed in descending
      order of update time. The maximum number of states retained is 10. If
      this value is zero, it will return all the states available.
  """

  name = _messages.StringField(1, required=True)
  numStates = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesGetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGetRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGetRequest object.

  Fields:
    name: The name of the device registry. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesGroupsDevicesConfigVersionsListRequest(_messages.Message):
  r"""A
  CloudiotProjectsLocationsRegistriesGroupsDevicesConfigVersionsListRequest
  object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
    numVersions: The number of versions to list. Versions are listed in
      decreasing order of the version number. The maximum number of versions
      retained is 10. If this value is zero, it will return all the versions
      available.
  """

  name = _messages.StringField(1, required=True)
  numVersions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesGroupsDevicesDeleteRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesDeleteRequest object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesGroupsDevicesGetRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesGetRequest object.

  Fields:
    fieldMask: The fields of the `Device` resource to be returned in the
      response. If the field mask is unset or empty, all fields are returned.
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  fieldMask = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGroupsDevicesModifyCloudToDeviceConfigRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesModifyCloudToDeviceCon
  figRequest object.

  Fields:
    modifyCloudToDeviceConfigRequest: A ModifyCloudToDeviceConfigRequest
      resource to be passed as the request body.
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  modifyCloudToDeviceConfigRequest = _messages.MessageField('ModifyCloudToDeviceConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGroupsDevicesPatchRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesPatchRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or `projects/p1/locations
      /us-central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    updateMask: Only updates the `device` fields indicated by this mask. The
      field mask must not be empty, and it must not contain fields that are
      immutable or only set by the server. Mutable top-level fields:
      `credentials`, `blocked`, and `metadata`
  """

  device = _messages.MessageField('Device', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesGroupsDevicesStatesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesStatesListRequest
  object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
    numStates: The number of states to list. States are listed in descending
      order of update time. The maximum number of states retained is 10. If
      this value is zero, it will return all the states available.
  """

  name = _messages.StringField(1, required=True)
  numStates = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesGroupsGetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGroupsSetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudiotProjectsLocationsRegistriesGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudiotProjectsLocationsRegistriesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesListRequest object.

  Fields:
    pageSize: The maximum number of registries to return in the response. If
      this value is zero, the service will select a default size. A call may
      return fewer objects than requested, but if there is a non-empty
      `page_token`, it indicates that more entries are available.
    pageToken: The value returned by the last `ListDeviceRegistriesResponse`;
      indicates that this is a continuation of a prior `ListDeviceRegistries`
      call, and that the system should return the next page of data.
    parent: The project and cloud region path. For example, `projects/example-
      project/locations/us-central1`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudiotProjectsLocationsRegistriesPatchRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesPatchRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
    updateMask: Only updates the `device_registry` fields indicated by this
      mask. The field mask must not be empty, and it must not contain fields
      that are immutable or only set by the server. Mutable top-level fields:
      `event_notification_config`, `http_config`, `mqtt_config`, and
      `state_notification_config`.
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesSetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Device(_messages.Message):
  r"""The device resource.

  Messages:
    MetadataValue: The metadata key-value pairs assigned to the device. This
      metadata is not interpreted or indexed by Cloud IoT Core. It can be used
      to add contextual information for the device.  Keys must conform to the
      regular expression a-zA-Z+ and be less than 128 bytes in length.  Values
      are free-form strings. Each value must be less than or equal to 32 KB in
      size.  The total size of all keys and values must be less than 256 KB,
      and the maximum number of key-value pairs is 500.

  Fields:
    blocked: If a device is blocked, connections or requests from this device
      will fail. Can be used to temporarily prevent the device from connecting
      if, for example, the sensor is generating bad data and needs
      maintenance.
    config: The most recent device configuration, which is eventually sent
      from Cloud IoT Core to the device. If not present on creation, the
      configuration will be initialized with an empty payload and version
      value of `1`. To update this field after creation, use the
      `DeviceManager.ModifyCloudToDeviceConfig` method.
    credentials: The credentials used to authenticate this device. To allow
      credential rotation without interruption, multiple device credentials
      can be bound to this device. No more than 3 credentials can be bound to
      a single device at a time. When new credentials are added to a device,
      they are verified against the registry credentials. For details, see the
      description of the `DeviceRegistry.credentials` field.
    id: The user-defined device identifier. The device ID must be unique
      within a device registry.
    lastConfigAckTime: [Output only] The last time a cloud-to-device config
      version acknowledgment was received from the device. This field is only
      for configurations sent through MQTT.
    lastConfigSendTime: [Output only] The last time a cloud-to-device config
      version was sent to the device.
    lastErrorStatus: [Output only] The error message of the most recent error,
      such as a failure to publish to Cloud Pub/Sub. 'last_error_time' is the
      timestamp of this field. If no errors have occurred, this field has an
      empty message and the status code 0 == OK. Otherwise, this field is
      expected to have a status code other than OK.
    lastErrorTime: [Output only] The time the most recent error occurred, such
      as a failure to publish to Cloud Pub/Sub. This field is the timestamp of
      'last_error_status'.
    lastEventTime: [Output only] The last time a telemetry event was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    lastHeartbeatTime: [Output only] The last time an MQTT `PINGREQ` was
      received. This field applies only to devices connecting through MQTT.
      MQTT clients usually only send `PINGREQ` messages if the connection is
      idle, and no other messages have been sent. Timestamps are periodically
      collected and written to storage; they may be stale by a few minutes.
    lastStateTime: [Output only] The last time a state event was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    metadata: The metadata key-value pairs assigned to the device. This
      metadata is not interpreted or indexed by Cloud IoT Core. It can be used
      to add contextual information for the device.  Keys must conform to the
      regular expression a-zA-Z+ and be less than 128 bytes in length.  Values
      are free-form strings. Each value must be less than or equal to 32 KB in
      size.  The total size of all keys and values must be less than 256 KB,
      and the maximum number of key-value pairs is 500.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or `projects/p1/locations
      /us-central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    numId: [Output only] A server-defined unique numeric ID for the device.
      This is a more compact way to identify devices, and it is globally
      unique.
    state: [Output only] The state most recently received from the device. If
      no state has been reported, this field is not present.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata key-value pairs assigned to the device. This metadata is
    not interpreted or indexed by Cloud IoT Core. It can be used to add
    contextual information for the device.  Keys must conform to the regular
    expression a-zA-Z+ and be less than 128 bytes in length.  Values are free-
    form strings. Each value must be less than or equal to 32 KB in size.  The
    total size of all keys and values must be less than 256 KB, and the
    maximum number of key-value pairs is 500.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  blocked = _messages.BooleanField(1)
  config = _messages.MessageField('DeviceConfig', 2)
  credentials = _messages.MessageField('DeviceCredential', 3, repeated=True)
  id = _messages.StringField(4)
  lastConfigAckTime = _messages.StringField(5)
  lastConfigSendTime = _messages.StringField(6)
  lastErrorStatus = _messages.MessageField('Status', 7)
  lastErrorTime = _messages.StringField(8)
  lastEventTime = _messages.StringField(9)
  lastHeartbeatTime = _messages.StringField(10)
  lastStateTime = _messages.StringField(11)
  metadata = _messages.MessageField('MetadataValue', 12)
  name = _messages.StringField(13)
  numId = _messages.IntegerField(14, variant=_messages.Variant.UINT64)
  state = _messages.MessageField('DeviceState', 15)


class DeviceConfig(_messages.Message):
  r"""The device configuration. Eventually delivered to devices.

  Fields:
    binaryData: The device configuration data.
    cloudUpdateTime: [Output only] The time at which this configuration
      version was updated in Cloud IoT Core. This timestamp is set by the
      server.
    deviceAckTime: [Output only] The time at which Cloud IoT Core received the
      acknowledgment from the device, indicating that the device has received
      this configuration version. If this field is not present, the device has
      not yet acknowledged that it received this version. Note that when the
      config was sent to the device, many config versions may have been
      available in Cloud IoT Core while the device was disconnected, and on
      connection, only the latest version is sent to the device. Some versions
      may never be sent to the device, and therefore are never acknowledged.
      This timestamp is set by Cloud IoT Core.
    version: [Output only] The version of this update. The version number is
      assigned by the server, and is always greater than 0 after device
      creation. The version must be 0 on the `CreateDevice` request if a
      `config` is specified; the response of `CreateDevice` will always have a
      value of 1.
  """

  binaryData = _messages.BytesField(1)
  cloudUpdateTime = _messages.StringField(2)
  deviceAckTime = _messages.StringField(3)
  version = _messages.IntegerField(4)


class DeviceCredential(_messages.Message):
  r"""A server-stored device credential used for authentication.

  Fields:
    expirationTime: [Optional] The time at which this credential becomes
      invalid. This credential will be ignored for new client authentication
      requests after this timestamp; however, it will not be automatically
      deleted.
    publicKey: A public key used to verify the signature of JSON Web Tokens
      (JWTs). When adding a new device credential, either via device creation
      or via modifications, this public key credential may be required to be
      signed by one of the registry level certificates. More specifically, if
      the registry contains at least one certificate, any new device
      credential must be signed by one of the registry certificates. As a
      result, when the registry contains certificates, only X.509 certificates
      are accepted as device credentials. However, if the registry does not
      contain a certificate, self-signed certificates and public keys will be
      accepted. New device credentials must be different from every registry-
      level certificate.
  """

  expirationTime = _messages.StringField(1)
  publicKey = _messages.MessageField('PublicKeyCredential', 2)


class DeviceRegistry(_messages.Message):
  r"""A container for a group of devices.

  Fields:
    credentials: The credentials used to verify the device credentials. No
      more than 10 credentials can be bound to a single registry at a time.
      The verification process occurs at the time of device creation or
      update. If this field is empty, no verification is performed. Otherwise,
      the credentials of a newly created device or added credentials of an
      updated device should be signed with one of these registry credentials.
      Note, however, that existing devices will never be affected by
      modifications to this list of credentials: after a device has been
      successfully created in a registry, it should be able to connect even if
      its registry credentials are revoked, deleted, or modified.
    eventNotificationConfigs: The configuration for notification of telemetry
      events received from the device. All telemetry events that were
      successfully published by the device and acknowledged by Cloud IoT Core
      are guaranteed to be delivered to Cloud Pub/Sub. If multiple
      configurations match a message, only the first matching configuration is
      used. If you try to publish a device telemetry event using MQTT without
      specifying a Cloud Pub/Sub topic for the device's registry, the
      connection closes automatically. If you try to do so using an HTTP
      connection, an error is returned. Up to 10 configurations may be
      provided.
    httpConfig: The DeviceService (HTTP) configuration for this device
      registry.
    id: The identifier of this device registry. For example, `myRegistry`.
    mqttConfig: The MQTT configuration for this device registry.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
    stateNotificationConfig: The configuration for notification of new states
      received from the device. State updates are guaranteed to be stored in
      the state history, but notifications to Cloud Pub/Sub are not
      guaranteed. For example, if permissions are misconfigured or the
      specified topic doesn't exist, no notification will be published but the
      state will still be stored in Cloud IoT Core.
  """

  credentials = _messages.MessageField('RegistryCredential', 1, repeated=True)
  eventNotificationConfigs = _messages.MessageField('EventNotificationConfig', 2, repeated=True)
  httpConfig = _messages.MessageField('HttpConfig', 3)
  id = _messages.StringField(4)
  mqttConfig = _messages.MessageField('MqttConfig', 5)
  name = _messages.StringField(6)
  stateNotificationConfig = _messages.MessageField('StateNotificationConfig', 7)


class DeviceState(_messages.Message):
  r"""The device state, as reported by the device.

  Fields:
    binaryData: The device state data.
    updateTime: [Output only] The time at which this state version was updated
      in Cloud IoT Core.
  """

  binaryData = _messages.BytesField(1)
  updateTime = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class EventNotificationConfig(_messages.Message):
  r"""The configuration for forwarding telemetry events.

  Fields:
    pubsubTopicName: A Cloud Pub/Sub topic name. For example,
      `projects/myProject/topics/deviceEvents`.
    subfolderMatches: If the subfolder name matches this string exactly, this
      configuration will be used. The string must not include the leading '/'
      character. If empty, all strings are matched. This field is used only
      for telemetry events; subfolders are not supported for state changes.
  """

  pubsubTopicName = _messages.StringField(1)
  subfolderMatches = _messages.StringField(2)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class HttpConfig(_messages.Message):
  r"""The configuration of the HTTP bridge for a device registry.

  Enums:
    HttpEnabledStateValueValuesEnum: If enabled, allows devices to use
      DeviceService via the HTTP protocol. Otherwise, any requests to
      DeviceService will fail for this registry.

  Fields:
    httpEnabledState: If enabled, allows devices to use DeviceService via the
      HTTP protocol. Otherwise, any requests to DeviceService will fail for
      this registry.
  """

  class HttpEnabledStateValueValuesEnum(_messages.Enum):
    r"""If enabled, allows devices to use DeviceService via the HTTP protocol.
    Otherwise, any requests to DeviceService will fail for this registry.

    Values:
      HTTP_STATE_UNSPECIFIED: No HTTP state specified. If not specified,
        DeviceService will be enabled by default.
      HTTP_ENABLED: Enables DeviceService (HTTP) service for the registry.
      HTTP_DISABLED: Disables DeviceService (HTTP) service for the registry.
    """
    HTTP_STATE_UNSPECIFIED = 0
    HTTP_ENABLED = 1
    HTTP_DISABLED = 2

  httpEnabledState = _messages.EnumField('HttpEnabledStateValueValuesEnum', 1)


class ListDeviceConfigVersionsResponse(_messages.Message):
  r"""Response for `ListDeviceConfigVersions`.

  Fields:
    deviceConfigs: The device configuration for the last few versions.
      Versions are listed in decreasing order, starting from the most recent
      one.
  """

  deviceConfigs = _messages.MessageField('DeviceConfig', 1, repeated=True)


class ListDeviceRegistriesResponse(_messages.Message):
  r"""Response for `ListDeviceRegistries`.

  Fields:
    deviceRegistries: The registries that matched the query.
    nextPageToken: If not empty, indicates that there may be more registries
      that match the request; this value should be passed in a new
      `ListDeviceRegistriesRequest`.
  """

  deviceRegistries = _messages.MessageField('DeviceRegistry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeviceStatesResponse(_messages.Message):
  r"""Response for `ListDeviceStates`.

  Fields:
    deviceStates: The last few device states. States are listed in descending
      order of server update time, starting from the most recent one.
  """

  deviceStates = _messages.MessageField('DeviceState', 1, repeated=True)


class ListDevicesResponse(_messages.Message):
  r"""Response for `ListDevices`.

  Fields:
    devices: The devices that match the request.
    nextPageToken: If not empty, indicates that there may be more devices that
      match the request; this value should be passed in a new
      `ListDevicesRequest`.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ModifyCloudToDeviceConfigRequest(_messages.Message):
  r"""Request for `ModifyCloudToDeviceConfig`.

  Fields:
    binaryData: The configuration data for the device.
    versionToUpdate: The version number to update. If this value is zero, it
      will not check the version number of the server and will always update
      the current version; otherwise, this update will fail if the version
      number found on the server does not match this version number. This is
      used to support multiple simultaneous updates without losing data.
  """

  binaryData = _messages.BytesField(1)
  versionToUpdate = _messages.IntegerField(2)


class MqttConfig(_messages.Message):
  r"""The configuration of MQTT for a device registry.

  Enums:
    MqttEnabledStateValueValuesEnum: If enabled, allows connections using the
      MQTT protocol. Otherwise, MQTT connections to this registry will fail.

  Fields:
    mqttEnabledState: If enabled, allows connections using the MQTT protocol.
      Otherwise, MQTT connections to this registry will fail.
  """

  class MqttEnabledStateValueValuesEnum(_messages.Enum):
    r"""If enabled, allows connections using the MQTT protocol. Otherwise,
    MQTT connections to this registry will fail.

    Values:
      MQTT_STATE_UNSPECIFIED: No MQTT state specified. If not specified, MQTT
        will be enabled by default.
      MQTT_ENABLED: Enables a MQTT connection.
      MQTT_DISABLED: Disables a MQTT connection.
    """
    MQTT_STATE_UNSPECIFIED = 0
    MQTT_ENABLED = 1
    MQTT_DISABLED = 2

  mqttEnabledState = _messages.EnumField('MqttEnabledStateValueValuesEnum', 1)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class PublicKeyCertificate(_messages.Message):
  r"""A public key certificate format and data.

  Enums:
    FormatValueValuesEnum: The certificate format.

  Fields:
    certificate: The certificate data.
    format: The certificate format.
    x509Details: [Output only] The certificate details. Used only for X.509
      certificates.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The certificate format.

    Values:
      UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT: The format has not been
        specified. This is an invalid default value and must not be used.
      X509_CERTIFICATE_PEM: An X.509v3 certificate
        ([RFC5280](https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
    """
    UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT = 0
    X509_CERTIFICATE_PEM = 1

  certificate = _messages.StringField(1)
  format = _messages.EnumField('FormatValueValuesEnum', 2)
  x509Details = _messages.MessageField('X509CertificateDetails', 3)


class PublicKeyCredential(_messages.Message):
  r"""A public key format and data.

  Enums:
    FormatValueValuesEnum: The format of the key.

  Fields:
    format: The format of the key.
    key: The key data.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The format of the key.

    Values:
      UNSPECIFIED_PUBLIC_KEY_FORMAT: The format has not been specified. This
        is an invalid default value and must not be used.
      RSA_PEM: An RSA public key encoded in base64, and wrapped by `-----BEGIN
        PUBLIC KEY-----` and `-----END PUBLIC KEY-----`. This can be used to
        verify `RS256` signatures in JWT tokens ([RFC7518](
        https://www.ietf.org/rfc/rfc7518.txt)).
      RSA_X509_PEM: As RSA_PEM, but wrapped in an X.509v3 certificate
        ([RFC5280]( https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
      ES256_PEM: Public key for the ECDSA algorithm using P-256 and SHA-256,
        encoded in base64, and wrapped by `-----BEGIN PUBLIC KEY-----` and
        `-----END PUBLIC KEY-----`. This can be used to verify JWT tokens with
        the `ES256` algorithm
        ([RFC7518](https://www.ietf.org/rfc/rfc7518.txt)). This curve is
        defined in [OpenSSL](https://www.openssl.org/) as the `prime256v1`
        curve.
      ES256_X509_PEM: As ES256_PEM, but wrapped in an X.509v3 certificate
        ([RFC5280]( https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
    """
    UNSPECIFIED_PUBLIC_KEY_FORMAT = 0
    RSA_PEM = 1
    RSA_X509_PEM = 2
    ES256_PEM = 3
    ES256_X509_PEM = 4

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  key = _messages.StringField(2)


class RegistryCredential(_messages.Message):
  r"""A server-stored registry credential used to validate device credentials.

  Fields:
    publicKeyCertificate: A public key certificate used to verify the device
      credentials.
  """

  publicKeyCertificate = _messages.MessageField('PublicKeyCertificate', 1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class StateNotificationConfig(_messages.Message):
  r"""The configuration for notification of new states received from the
  device.

  Fields:
    pubsubTopicName: A Cloud Pub/Sub topic name. For example,
      `projects/myProject/topics/deviceEvents`.
  """

  pubsubTopicName = _messages.StringField(1)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class X509CertificateDetails(_messages.Message):
  r"""Details of an X.509 certificate. For informational purposes only.

  Fields:
    expiryTime: The time the certificate becomes invalid.
    issuer: The entity that signed the certificate.
    publicKeyType: The type of public key in the certificate.
    signatureAlgorithm: The algorithm used to sign the certificate.
    startTime: The time the certificate becomes valid.
    subject: The entity the certificate and public key belong to.
  """

  expiryTime = _messages.StringField(1)
  issuer = _messages.StringField(2)
  publicKeyType = _messages.StringField(3)
  signatureAlgorithm = _messages.StringField(4)
  startTime = _messages.StringField(5)
  subject = _messages.StringField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
