"""Generated message classes for container version v1beta1.

The Google Kubernetes Engine API is used for building and managing container
based applications, powered by the open source Kubernetes technology.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'container'


class AcceleratorConfig(_messages.Message):
  r"""AcceleratorConfig represents a Hardware Accelerator request.

  Fields:
    acceleratorCount: The number of the accelerator cards exposed to an
      instance.
    acceleratorType: The accelerator type resource name. List of supported
      accelerators [here](/compute/docs/gpus/#Introduction)
  """

  acceleratorCount = _messages.IntegerField(1)
  acceleratorType = _messages.StringField(2)


class AddonsConfig(_messages.Message):
  r"""Configuration for the addons that can be automatically spun up in the
  cluster, enabling additional functionality.

  Fields:
    horizontalPodAutoscaling: Configuration for the horizontal pod autoscaling
      feature, which increases or decreases the number of replica pods a
      replication controller has based on the resource usage of the existing
      pods.
    httpLoadBalancing: Configuration for the HTTP (L7) load balancing
      controller addon, which makes it easy to set up HTTP load balancers for
      services in a cluster.
    kubernetesDashboard: Configuration for the Kubernetes Dashboard.
    networkPolicyConfig: Configuration for NetworkPolicy. This only tracks
      whether the addon is enabled or not on the Master, it does not track
      whether network policy is enabled for the nodes.
  """

  horizontalPodAutoscaling = _messages.MessageField('HorizontalPodAutoscaling', 1)
  httpLoadBalancing = _messages.MessageField('HttpLoadBalancing', 2)
  kubernetesDashboard = _messages.MessageField('KubernetesDashboard', 3)
  networkPolicyConfig = _messages.MessageField('NetworkPolicyConfig', 4)


class AuditConfig(_messages.Message):
  r"""Configuration for audit logging.

  Fields:
    enabled: Enable audit logging of the Kubernetes API.  If enabled, audit
      logs will be exported to Cloud Audit Logging.
  """

  enabled = _messages.BooleanField(1)


class AutoUpgradeOptions(_messages.Message):
  r"""AutoUpgradeOptions defines the set of options for the user to control
  how the Auto Upgrades will proceed.

  Fields:
    autoUpgradeStartTime: [Output only] This field is set when upgrades are
      about to commence with the approximate start time for the upgrades, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    description: [Output only] This field is set when upgrades are about to
      commence with the description of the upgrade.
    requestedUpgradeStartTime: User requested start time, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
  """

  autoUpgradeStartTime = _messages.StringField(1)
  description = _messages.StringField(2)
  requestedUpgradeStartTime = _messages.StringField(3)


class BinaryAuthorization(_messages.Message):
  r"""Configuration for Binary Authorization.

  Fields:
    enabled: Enable Binary Authorization for this cluster. If enabled, all
      container images will be validated by Google Binauthz.
  """

  enabled = _messages.BooleanField(1)


class CIDR(_messages.Message):
  r"""CIDR contains an optional name and one CIDR block.

  Fields:
    name: Network name is an optional field for users to identify CIDR blocks.
    network: Authorized network must be specified in CIDR notation.
  """

  name = _messages.StringField(1)
  network = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  r"""CancelOperationRequest cancels a single operation.

  Fields:
    name: The name (project, location, operation id) of the operation to
      cancel. Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation resides.
      This field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class CidrBlock(_messages.Message):
  r"""CidrBlock contains an optional name and one CIDR block.

  Fields:
    cidrBlock: cidr_block must be specified in CIDR notation.
    displayName: display_name is an optional field for users to identify CIDR
      blocks.
  """

  cidrBlock = _messages.StringField(1)
  displayName = _messages.StringField(2)


class ClientCertificateConfig(_messages.Message):
  r"""Configuration for client certificates on the cluster.

  Fields:
    issueClientCertificate: Issue a client certificate.
  """

  issueClientCertificate = _messages.BooleanField(1)


class Cluster(_messages.Message):
  r"""A Google Kubernetes Engine cluster.

  Enums:
    StatusValueValuesEnum: [Output only] The current status of this cluster.

  Messages:
    ResourceLabelsValue: The resource labels for the cluster to use to
      annotate any related Google Compute Engine resources.

  Fields:
    addonsConfig: Configurations for the various addons available to run in
      the cluster.
    auditConfig: Configuration for audit logging.
    binaryAuthorization: Configuration for Binary Authorization.
    clusterIpv4Cidr: The IP address range of the container pods in this
      cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one
      automatically chosen or specify a `/14` block in `10.0.0.0/8`.
    createTime: [Output only] The time the cluster was created, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    currentMasterVersion: [Output only] The current software version of the
      master endpoint.
    currentNodeCount: [Output only] The number of nodes currently in the
      cluster.
    currentNodeVersion: [Output only] The current version of the node software
      components. If they are currently at multiple versions because they're
      in the process of being upgraded, this reflects the minimum version of
      all nodes.
    description: An optional description of this cluster.
    enableKubernetesAlpha: Kubernetes alpha features are enabled on this
      cluster. This includes alpha API groups (e.g. v1beta1) and features that
      may not be production ready in the kubernetes version of the master and
      nodes. The cluster has no SLA for uptime and master/node upgrades are
      disabled. Alpha enabled clusters are automatically deleted thirty days
      after creation.
    enableTpu: Enable the ability to use Cloud TPUs in this cluster.
    endpoint: [Output only] The IP address of this cluster's master endpoint.
      The endpoint can be accessed from the internet at
      `https://username:password@endpoint/`.  See the `masterAuth` property of
      this resource for username and password information.
    expireTime: [Output only] The time the cluster will be automatically
      deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    initialClusterVersion: The initial Kubernetes version for this cluster.
      Valid versions are those found in validMasterVersions returned by
      getServerConfig.  The version can be upgraded over time; such upgrades
      are reflected in currentMasterVersion and currentNodeVersion.  Users may
      specify either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior:  - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "","-": picks the default Kubernetes version
    initialNodeCount: The number of nodes to create in this cluster. You must
      ensure that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota. For requests,
      this field should only be used in lieu of a "node_pool" object, since
      this configuration (along with the "node_config") will be used to create
      a "NodePool" object with an auto-generated name. Do not use this and a
      node_pool at the same time.
    instanceGroupUrls: Deprecated. Use node_pools.instance_group_urls.
    ipAllocationPolicy: Configuration for cluster IP allocation.
    labelFingerprint: The fingerprint of the set of labels for this cluster.
    legacyAbac: Configuration for the legacy ABAC authorization mode.
    location: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/regions-zones/regions-zones#available) or
      [region](/compute/docs/regions-zones/regions-zones#available) in which
      the cluster resides.
    locations: The list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located.
    loggingService: The logging service the cluster should use to write logs.
      Currently available options:  * `logging.googleapis.com` - the Google
      Cloud Logging service. * `none` - no logs will be exported from the
      cluster. * if left as an empty string,`logging.googleapis.com` will be
      used.
    maintenancePolicy: Configure the maintenance policy for this cluster.
    masterAuth: The authentication information for accessing the master
      endpoint.
    masterAuthorizedNetworks: The configuration options for master authorized
      networks feature. This field is deprecated, use
      master_authorized_networks_config instead.
    masterAuthorizedNetworksConfig: The configuration options for master
      authorized networks feature.
    masterIpv4CidrBlock: The IP prefix in CIDR notation to use for the hosted
      master network. This prefix will be used for assigning private IP
      addresses to the master or set of masters, as well as the ILB VIP.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options:  * `monitoring.googleapis.com` -
      the Google Cloud Monitoring service. * `none` - no metrics will be
      exported from the cluster. * if left as an empty string,
      `monitoring.googleapis.com` will be used.
    name: The name of this cluster. The name must be unique within this
      project and zone, and can be up to 40 characters with the following
      restrictions:  * Lowercase letters, numbers, and hyphens only. * Must
      start with a letter. * Must end with a number or a letter.
    network: The name of the Google Compute Engine [network](/compute/docs
      /networks-and-firewalls#networks) to which the cluster is connected. If
      left unspecified, the `default` network will be used. On output this
      shows the network ID instead of the name.
    networkConfig: Configuration for cluster networking.
    networkPolicy: Configuration options for the NetworkPolicy feature.
    nodeConfig: Parameters used in creating the cluster's nodes. See
      `nodeConfig` for the description of its properties. For requests, this
      field should only be used in lieu of a "node_pool" object, since this
      configuration (along with the "initial_node_count") will be used to
      create a "NodePool" object with an auto-generated name. Do not use this
      and a node_pool at the same time. For responses, this field will be
      populated with the node configuration of the first node pool.  If
      unspecified, the defaults are used.
    nodeIpv4CidrSize: [Output only] The size of the address space on each node
      for hosting containers. This is provisioned from within the
      `container_ipv4_cidr` range.
    nodePools: The node pools associated with this cluster. This field should
      not be set if "node_config" or "initial_node_count" are specified.
    podSecurityPolicyConfig: Configuration for the PodSecurityPolicy feature.
    privateCluster: If this is a private cluster setup. Private clusters are
      clusters that, by default have no external IP addresses on the nodes and
      where nodes and the master communicate over private IP addresses.
    resourceLabels: The resource labels for the cluster to use to annotate any
      related Google Compute Engine resources.
    selfLink: [Output only] Server-defined URL for the resource.
    servicesIpv4Cidr: [Output only] The IP address range of the Kubernetes
      services in this cluster, in [CIDR](http://en.wikipedia.org/wiki
      /Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`). Service
      addresses are typically put in the last `/16` from the container CIDR.
    status: [Output only] The current status of this cluster.
    statusMessage: [Output only] Additional information about the current
      status of this cluster, if available.
    subnetwork: The name of the Google Compute Engine
      [subnetwork](/compute/docs/subnetworks) to which the cluster is
      connected. On output this shows the subnetwork ID instead of the name.
    tpuIpv4CidrBlock: [Output only] The IP address range of the Cloud TPUs in
      this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `1.2.3.4/29`).
    zone: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field is deprecated, use location instead.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The current status of this cluster.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the cluster, such as upgrading the master or node
        software. Details can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster may be unusable. Details
        can be found in the `statusMessage` field.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality. Details can be found in the
        `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""The resource labels for the cluster to use to annotate any related
    Google Compute Engine resources.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  auditConfig = _messages.MessageField('AuditConfig', 2)
  binaryAuthorization = _messages.MessageField('BinaryAuthorization', 3)
  clusterIpv4Cidr = _messages.StringField(4)
  createTime = _messages.StringField(5)
  currentMasterVersion = _messages.StringField(6)
  currentNodeCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  currentNodeVersion = _messages.StringField(8)
  description = _messages.StringField(9)
  enableKubernetesAlpha = _messages.BooleanField(10)
  enableTpu = _messages.BooleanField(11)
  endpoint = _messages.StringField(12)
  expireTime = _messages.StringField(13)
  initialClusterVersion = _messages.StringField(14)
  initialNodeCount = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(16, repeated=True)
  ipAllocationPolicy = _messages.MessageField('IPAllocationPolicy', 17)
  labelFingerprint = _messages.StringField(18)
  legacyAbac = _messages.MessageField('LegacyAbac', 19)
  location = _messages.StringField(20)
  locations = _messages.StringField(21, repeated=True)
  loggingService = _messages.StringField(22)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 23)
  masterAuth = _messages.MessageField('MasterAuth', 24)
  masterAuthorizedNetworks = _messages.MessageField('MasterAuthorizedNetworks', 25)
  masterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 26)
  masterIpv4CidrBlock = _messages.StringField(27)
  monitoringService = _messages.StringField(28)
  name = _messages.StringField(29)
  network = _messages.StringField(30)
  networkConfig = _messages.MessageField('NetworkConfig', 31)
  networkPolicy = _messages.MessageField('NetworkPolicy', 32)
  nodeConfig = _messages.MessageField('NodeConfig', 33)
  nodeIpv4CidrSize = _messages.IntegerField(34, variant=_messages.Variant.INT32)
  nodePools = _messages.MessageField('NodePool', 35, repeated=True)
  podSecurityPolicyConfig = _messages.MessageField('PodSecurityPolicyConfig', 36)
  privateCluster = _messages.BooleanField(37)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 38)
  selfLink = _messages.StringField(39)
  servicesIpv4Cidr = _messages.StringField(40)
  status = _messages.EnumField('StatusValueValuesEnum', 41)
  statusMessage = _messages.StringField(42)
  subnetwork = _messages.StringField(43)
  tpuIpv4CidrBlock = _messages.StringField(44)
  zone = _messages.StringField(45)


class ClusterStatus(_messages.Message):
  r"""ClusterStatus is used for internal only purposes to transition a cluster
  between DEGRADED AND RUNNING using UpdateClusterInternal. The message is
  used in ClusterUpdate's DesiredClusterStatus field and should not be
  confused with Cluster's Status Enum.

  Enums:
    StatusValueValuesEnum: The current status of the cluster.

  Fields:
    internal: An internal field for the sub-error type or other metadata for
      the Status.
    message: A human-readable message that describes the status of the
      cluster.
    status: The current status of the cluster.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""The current status of the cluster.

    Values:
      UNKNOWN: The UNKNOWN status should never be set
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      DEGRADED: The DEGRADED state indicates the cluster is not fully
        functional and requires user action. Details can be found in the
        `message` field.
    """
    UNKNOWN = 0
    RUNNING = 1
    DEGRADED = 2

  internal = _messages.StringField(1)
  message = _messages.StringField(2)
  status = _messages.EnumField('StatusValueValuesEnum', 3)


class ClusterUpdate(_messages.Message):
  r"""ClusterUpdate describes an update to the cluster. Exactly one update can
  be applied to a cluster with each request, so at most one field can be
  provided.

  Fields:
    concurrentNodeCount: Controls how many nodes to upgrade in parallel. A
      maximum of 20 concurrent nodes is allowed.
    desiredAddonsConfig: Configurations for the various addons available to
      run in the cluster.
    desiredAuditConfig: The desired configuration for audit logging.
    desiredBinaryAuthorization: The desired configuration options for the
      Binary Authorization feature.
    desiredClusterStatus: The desired status fields for the cluster.
    desiredImage: The desired name of the image to use for this node. This is
      used to create clusters using a custom image.
    desiredImageProject: The project containing the desired image to use for
      this node. This is used to create clusters using a custom image.
    desiredImageType: The desired image type for the node pool. NOTE: Set the
      "desired_node_pool" field as well.
    desiredLocations: The desired list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located. Changing the locations a cluster is in will result in
      nodes being either created or removed from the cluster, depending on
      whether locations are being added or removed.  This list must always
      include the cluster's primary zone.
    desiredMasterAuthorizedNetworks: The desired configuration options for
      master authorized networks feature. This field is deprecated, use
      desired_master_authorized_networks_config instead.
    desiredMasterAuthorizedNetworksConfig: The desired configuration options
      for master authorized networks feature.
    desiredMasterId: An id of master replica to be updated. Can be set only
      when desired_master_version is set. If not set, all replicas will be
      updated.
    desiredMasterMachineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-8`) to change the
      master to.
    desiredMasterVersion: The Kubernetes version to change the master to. The
      only valid value is the latest supported version.  Users may specify
      either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior:  - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "-": picks the default Kubernetes version
    desiredMonitoringService: The monitoring service the cluster should use to
      write metrics. Currently available options:  *
      "monitoring.googleapis.com" - the Google Cloud Monitoring service *
      "none" - no metrics will be exported from the cluster
    desiredNodePoolAutoscaling: Autoscaler configuration for the node pool
      specified in desired_node_pool_id. If there is only one pool in the
      cluster and desired_node_pool_id is not provided then the change applies
      to that single node pool.
    desiredNodePoolId: The node pool to be upgraded. This field is mandatory
      if "desired_node_version", "desired_image_family" or
      "desired_node_pool_autoscaling" is specified and there is more than one
      node pool on the cluster.
    desiredNodeVersion: The Kubernetes version to change the nodes to
      (typically an upgrade).  Users may specify either explicit versions
      offered by Kubernetes Engine or version aliases, which have the
      following behavior:  - "latest": picks the highest valid Kubernetes
      version - "1.X": picks the highest valid patch+gke.N patch in the 1.X
      version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y
      version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-":
      picks the Kubernetes master version
    desiredPodSecurityPolicyConfig: The desired configuration options for the
      PodSecurityPolicy feature.
  """

  concurrentNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  desiredAddonsConfig = _messages.MessageField('AddonsConfig', 2)
  desiredAuditConfig = _messages.MessageField('AuditConfig', 3)
  desiredBinaryAuthorization = _messages.MessageField('BinaryAuthorization', 4)
  desiredClusterStatus = _messages.MessageField('ClusterStatus', 5)
  desiredImage = _messages.StringField(6)
  desiredImageProject = _messages.StringField(7)
  desiredImageType = _messages.StringField(8)
  desiredLocations = _messages.StringField(9, repeated=True)
  desiredMasterAuthorizedNetworks = _messages.MessageField('MasterAuthorizedNetworks', 10)
  desiredMasterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 11)
  desiredMasterId = _messages.StringField(12)
  desiredMasterMachineType = _messages.StringField(13)
  desiredMasterVersion = _messages.StringField(14)
  desiredMonitoringService = _messages.StringField(15)
  desiredNodePoolAutoscaling = _messages.MessageField('NodePoolAutoscaling', 16)
  desiredNodePoolId = _messages.StringField(17)
  desiredNodeVersion = _messages.StringField(18)
  desiredPodSecurityPolicyConfig = _messages.MessageField('PodSecurityPolicyConfig', 19)


class ClusterUpdateOptions(_messages.Message):
  r"""ClusterUpdateOptions specifies extra options or settings that affect how
  a cluster update operation runs. It is an optional object passed in to
  ClusterUpdate calls.

  Fields:
    useMaintenancePolicy: Whether the update call should respect the
      maintenance policy in the cluster, if one is set. This flag is used to
      determine whether the update should be stopped if it finds itself
      running outside of a configured maintenance policy (if present).
  """

  useMaintenancePolicy = _messages.BooleanField(1)


class CompleteIPRotationRequest(_messages.Message):
  r"""CompleteIPRotationRequest moves the cluster master back into single-IP
  mode.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to complete
      IP rotation. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsAggregatedUsableSubnetworksListRequest(_messages.Message):
  r"""A ContainerProjectsAggregatedUsableSubnetworksListRequest object.

  Fields:
    filter: Filtering currently only supports equality on the networkProjectId
      and must be in the form: "networkProjectId=[PROJECTID]", where
      `networkProjectId` is the project which owns the listed subnetworks.
      This defaults to the parent project ID.
    pageSize: The max number of results per page that should be returned. If
      the number of available results is larger than `page_size`, a
      `next_page_token` is returned which can be used to get the next page of
      results in subsequent requests. Acceptable values are 0 to 500,
      inclusive. (Default: 500)
    pageToken: Specifies a page token to use. Set this to the nextPageToken
      returned by previous list requests to get the next page of results.
    parent: The parent project where subnetworks are usable. Specified in the
      format 'projects/*'.
    version: API request version that initiates this operation.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  version = _messages.StringField(5)


class ContainerProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides, or
      "-" for all zones. This field has been deprecated and replaced by the
      parent field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  version = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class ContainerProjectsLocationsClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class ContainerProjectsLocationsClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsGetServerConfigRequest(_messages.Message):
  r"""A ContainerProjectsLocationsGetServerConfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get
      Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  version = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsListRequest object.

  Fields:
    pageSize: Only return up to this many ListLocationsResponse in the
      response. If not specified the service will pick the maximum number of
      results. Note: Specifying page_size = 0 is equivalent to not specifying
      a page_size, i.e., will result in the service picking a page_size value.
      This is currently not used and will be honored once we use pagination.
    pageToken: Only return Locations that occur after the page_token. This
      value should be populated from the ListLocationsResponse.next_page_token
      if that response token was set (which happens when listing more
      Locations than fit in a single ListLocationsResponse). This is currently
      not used and will be honored once we use pagination.
    parent: Contains the name of the resource requested. Specific in the
      format 'projects/*/locations'.
    version: API request version that initiates this operation.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  version = _messages.StringField(4)


class ContainerProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1, required=True)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for, or `-`
      for all zones. This field has been deprecated and replaced by the parent
      field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  version = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsZonesClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  version = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  version = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides, or
      "-" for all zones. This field has been deprecated and replaced by the
      parent field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  version = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  version = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ContainerProjectsZonesClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  version = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ContainerProjectsZonesClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1, required=True)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  version = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesGetServerconfigRequest(_messages.Message):
  r"""A ContainerProjectsZonesGetServerconfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get
      Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  version = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  version = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for, or `-`
      for all zones. This field has been deprecated and replaced by the parent
      field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  version = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class CreateClusterRequest(_messages.Message):
  r"""CreateClusterRequest creates a cluster.

  Fields:
    cluster: A [cluster resource](/container-
      engine/reference/rest/v1beta1/projects.zones.clusters)
    parent: The parent (project and location) where the cluster will be
      created. Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  cluster = _messages.MessageField('Cluster', 1)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3)
  version = _messages.StringField(4)
  zone = _messages.StringField(5)


class CreateNodePoolRequest(_messages.Message):
  r"""CreateNodePoolRequest creates a node pool for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    nodePool: The node pool to create.
    parent: The parent (project, location, cluster id) where the node pool
      will be created. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1)
  nodePool = _messages.MessageField('NodePool', 2)
  parent = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class CustomImageConfig(_messages.Message):
  r"""CustomImageConfig contains the information r

  Fields:
    image: The name of the image to use for this node.
    imageFamily: The name of the image family to use for this node.
    imageProject: The project containing the image to use for this node.
  """

  image = _messages.StringField(1)
  imageFamily = _messages.StringField(2)
  imageProject = _messages.StringField(3)


class DailyMaintenanceWindow(_messages.Message):
  r"""Time window specified for daily maintenance operations.

  Fields:
    daysInCycle: Allows to define schedule that runs every nth day of the
      month. NOTE: Unimplemented, reserved for future use.
    duration: [Output only] Duration of the time window, automatically chosen
      to be smallest possible in the given scenario.
    startTime: Time within the maintenance window to start the maintenance
      operations. It must be in format "HH:MM\u201d, where HH : [00-23] and MM :
      [00-59] GMT.
  """

  daysInCycle = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  duration = _messages.StringField(2)
  startTime = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class HorizontalPodAutoscaling(_messages.Message):
  r"""Configuration options for the horizontal pod autoscaling feature, which
  increases or decreases the number of replica pods a replication controller
  has based on the resource usage of the existing pods.

  Fields:
    disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the
      cluster. When enabled, it ensures that a Heapster pod is running in the
      cluster, which is also used by the Cloud Monitoring service.
  """

  disabled = _messages.BooleanField(1)


class HttpLoadBalancing(_messages.Message):
  r"""Configuration options for the HTTP (L7) load balancing controller addon,
  which makes it easy to set up HTTP load balancers for services in a cluster.

  Fields:
    disabled: Whether the HTTP Load Balancing controller is enabled in the
      cluster. When enabled, it runs a small pod in the cluster that manages
      the load balancers.
  """

  disabled = _messages.BooleanField(1)


class IPAllocationPolicy(_messages.Message):
  r"""Configuration for controlling how IPs are allocated in the cluster.

  Fields:
    allowRouteOverlap: If true, allow allocation of cluster CIDR ranges that
      overlap with certain kinds of network routes. By default we do not allow
      cluster CIDR ranges to intersect with any user declared routes. With
      allow_route_overlap == true, we allow overlapping with CIDR ranges that
      are larger than the cluster CIDR range.  If this field is set to true,
      then cluster and services CIDRs must be fully-specified (e.g.
      `10.96.0.0/14`, but not `/14`), which means: 1) When `use_ip_aliases` is
      true, `cluster_ipv4_cidr_block` and    `services_ipv4_cidr_block` must
      be fully-specified. 2) When `use_ip_aliases` is false,
      `cluster.cluster_ipv4_cidr` muse be    fully-specified.
    clusterIpv4Cidr: This field is deprecated, use cluster_ipv4_cidr_block.
    clusterIpv4CidrBlock: The IP address range for the cluster pod IPs. If
      this field is set, then `cluster.cluster_ipv4_cidr` must be left blank.
      This field is only applicable when `use_ip_aliases` is true.  Set to
      blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    clusterSecondaryRangeName: The name of the secondary range to be used for
      the cluster CIDR block.  The secondary range will be used for pod IP
      addresses. This must be an existing secondary range associated with the
      cluster subnetwork.  This field is only applicable with use_ip_aliases
      and create_subnetwork is false.
    createSubnetwork: Whether a new subnetwork will be created automatically
      for the cluster.  This field is only applicable when `use_ip_aliases` is
      true.
    nodeIpv4Cidr: This field is deprecated, use node_ipv4_cidr_block.
    nodeIpv4CidrBlock: The IP address range of the instance IPs in this
      cluster.  This is applicable only if `create_subnetwork` is true.  Set
      to blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesIpv4Cidr: This field is deprecated, use services_ipv4_cidr_block.
    servicesIpv4CidrBlock: The IP address range of the services IPs in this
      cluster. If blank, a range will be automatically chosen with the default
      size.  This field is only applicable when `use_ip_aliases` is true.  Set
      to blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesSecondaryRangeName: The name of the secondary range to be used as
      for the services CIDR block.  The secondary range will be used for
      service ClusterIPs. This must be an existing secondary range associated
      with the cluster subnetwork.  This field is only applicable with
      use_ip_aliases and create_subnetwork is false.
    subnetworkName: A custom subnetwork name to be used if `create_subnetwork`
      is true.  If this field is empty, then an automatic name will be chosen
      for the new subnetwork.
    tpuIpv4CidrBlock: The IP address range of the Cloud TPUs in this cluster.
      If unspecified, a range will be automatically chosen with the default
      size.  This field is only applicable when `use_ip_aliases` is true.  If
      unspecified, the range will use the default size.  Set to /netmask (e.g.
      `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    useIpAliases: Whether alias IPs will be used for pod IPs in the cluster.
  """

  allowRouteOverlap = _messages.BooleanField(1)
  clusterIpv4Cidr = _messages.StringField(2)
  clusterIpv4CidrBlock = _messages.StringField(3)
  clusterSecondaryRangeName = _messages.StringField(4)
  createSubnetwork = _messages.BooleanField(5)
  nodeIpv4Cidr = _messages.StringField(6)
  nodeIpv4CidrBlock = _messages.StringField(7)
  servicesIpv4Cidr = _messages.StringField(8)
  servicesIpv4CidrBlock = _messages.StringField(9)
  servicesSecondaryRangeName = _messages.StringField(10)
  subnetworkName = _messages.StringField(11)
  tpuIpv4CidrBlock = _messages.StringField(12)
  useIpAliases = _messages.BooleanField(13)


class KubernetesDashboard(_messages.Message):
  r"""Configuration for the Kubernetes Dashboard.

  Fields:
    disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class LegacyAbac(_messages.Message):
  r"""Configuration for the legacy Attribute Based Access Control
  authorization mode.

  Fields:
    enabled: Whether the ABAC authorizer is enabled for this cluster. When
      enabled, identities in the system, including service accounts, nodes,
      and controllers, will have statically granted permissions beyond those
      provided by the RBAC configuration or IAM.
  """

  enabled = _messages.BooleanField(1)


class ListClustersResponse(_messages.Message):
  r"""ListClustersResponse is the result of ListClustersRequest.

  Fields:
    clusters: A list of clusters in the project in the specified zone, or
      across all ones.
    missingZones: If any zones are listed here, the list of clusters returned
      may be missing those zones.
    version: API request version that initiates this operation.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  missingZones = _messages.StringField(2, repeated=True)
  version = _messages.StringField(3)


class ListLocationsResponse(_messages.Message):
  r"""ListLocationsResponse returns the list of all GKE locations and their
  recommendation state.

  Fields:
    locations: A full list of GKE locations.
    nextPageToken: Only return ListLocationsResponse that occur after the
      page_token. This value should be populated from the
      ListLocationsResponse.next_page_token if that response token was set
      (which happens when listing more Locations than fit in a single
      ListLocationsResponse).
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNodePoolsResponse(_messages.Message):
  r"""ListNodePoolsResponse is the result of ListNodePoolsRequest.

  Fields:
    nodePools: A list of node pools for a cluster.
  """

  nodePools = _messages.MessageField('NodePool', 1, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""ListOperationsResponse is the result of ListOperationsRequest.

  Fields:
    missingZones: If any zones are listed here, the list of operations
      returned may be missing the operations from those zones.
    operations: A list of operations in the project in the specified zone.
    version: API request version that initiates this operation.
  """

  missingZones = _messages.StringField(1, repeated=True)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  version = _messages.StringField(3)


class ListUsableSubnetworksResponse(_messages.Message):
  r"""ListUsableSubnetworksResponse is the response of
  ListUsableSubnetworksRequest.

  Fields:
    nextPageToken: This token allows you to get the next page of results for
      list requests. If the number of results is larger than `page_size`, use
      the `next_page_token` as a value for the query parameter `page_token` in
      the next request. The value will become empty when there are no more
      pages.
    subnetworks: A list of usable subnetworks in the specified network
      project.
    version: API request version that initiates this operation.
  """

  nextPageToken = _messages.StringField(1)
  subnetworks = _messages.MessageField('UsableSubnetwork', 2, repeated=True)
  version = _messages.StringField(3)


class Location(_messages.Message):
  r"""Location returns the location name, and if the location is recommended
  for GKE cluster scheduling.

  Enums:
    TypeValueValuesEnum: Contains the type of location this Location is for.
      Regional or Zonal.

  Fields:
    name: Contains the name of the resource requested. Specific in the format
      'projects/*/locations/*'.
    recommended: Recommended is a bool combining the drain state of the
      location (ie- has the region been drained manually?), and the stockout
      status of any zone according to Zone Advisor. This will be internal only
      for use by pantheon.
    type: Contains the type of location this Location is for. Regional or
      Zonal.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Contains the type of location this Location is for. Regional or Zonal.

    Values:
      LOCATION_TYPE_UNSPECIFIED: LOCATION_TYPE_UNSPECIFIED means the location
        type was not determined.
      ZONE: A GKE Location where Zonal clusters can be created.
      REGION: A GKE Location where Regional clusters can be created.
    """
    LOCATION_TYPE_UNSPECIFIED = 0
    ZONE = 1
    REGION = 2

  name = _messages.StringField(1)
  recommended = _messages.BooleanField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class MaintenancePolicy(_messages.Message):
  r"""MaintenancePolicy defines the maintenance policy to be used for the
  cluster.

  Fields:
    window: Specifies the maintenance window in which maintenance may be
      performed.
  """

  window = _messages.MessageField('MaintenanceWindow', 1)


class MaintenanceWindow(_messages.Message):
  r"""MaintenanceWindow defines the maintenance window to be used for the
  cluster.

  Fields:
    dailyMaintenanceWindow: DailyMaintenanceWindow specifies a daily
      maintenance operation window.
  """

  dailyMaintenanceWindow = _messages.MessageField('DailyMaintenanceWindow', 1)


class MasterAuth(_messages.Message):
  r"""The authentication information for accessing the master endpoint.
  Authentication can be done using HTTP basic auth or using client
  certificates.

  Fields:
    clientCertificate: [Output only] Base64-encoded public certificate used by
      clients to authenticate to the cluster endpoint.
    clientCertificateConfig: Configuration for client certificate
      authentication on the cluster.  If no configuration is specified, a
      client certificate is issued.
    clientKey: [Output only] Base64-encoded private key used by clients to
      authenticate to the cluster endpoint.
    clusterCaCertificate: [Output only] Base64-encoded public certificate that
      is the root of trust for the cluster.
    password: The password to use for HTTP basic authentication to the master
      endpoint. Because the master endpoint is open to the Internet, you
      should create a strong password.  If a password is provided for cluster
      creation, username must be non-empty.
    username: The username to use for HTTP basic authentication to the master
      endpoint. For clusters v1.6.0 and later, you can disable basic
      authentication by providing an empty username.
  """

  clientCertificate = _messages.StringField(1)
  clientCertificateConfig = _messages.MessageField('ClientCertificateConfig', 2)
  clientKey = _messages.StringField(3)
  clusterCaCertificate = _messages.StringField(4)
  password = _messages.StringField(5)
  username = _messages.StringField(6)


class MasterAuthorizedNetworks(_messages.Message):
  r"""Configuration options for the master authorized networks feature.
  Enabled master authorized networks will disallow all external traffic to
  access Kubernetes master through HTTPS except traffic from the given CIDR
  blocks, Google Compute Engine Public IPs and Google Prod IPs. This message
  is deprecated, use MasterAuthorizedNetworksConfig instead.

  Fields:
    cidrs: Network CIDRs define up to 10 external networks that could access
      Kubernetes master through HTTPS.
    enabled: Whether or not master authorized networks is enabled.
  """

  cidrs = _messages.MessageField('CIDR', 1, repeated=True)
  enabled = _messages.BooleanField(2)


class MasterAuthorizedNetworksConfig(_messages.Message):
  r"""Configuration options for the master authorized networks feature.
  Enabled master authorized networks will disallow all external traffic to
  access Kubernetes master through HTTPS except traffic from the given CIDR
  blocks, Google Compute Engine Public IPs and Google Prod IPs.

  Fields:
    cidrBlocks: cidr_blocks define up to 10 external networks that could
      access Kubernetes master through HTTPS.
    enabled: Whether or not master authorized networks is enabled.
  """

  cidrBlocks = _messages.MessageField('CidrBlock', 1, repeated=True)
  enabled = _messages.BooleanField(2)


class NetworkConfig(_messages.Message):
  r"""NetworkConfig reports the relative names of network & subnetwork.

  Fields:
    network: Output only. The name of the Google Compute Engine
      network(/compute/docs/networks-and-firewalls#networks). Example:
      projects/my-project/global/networks/my-network
    subnetwork: Output only. The name of the Google Compute Engine
      [subnetwork](/compute/docs/vpc). Example: projects/my-project/regions
      /us-central1/subnetworks/my-subnet
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NetworkPolicy(_messages.Message):
  r"""Configuration options for the NetworkPolicy feature.
  https://kubernetes.io/docs/concepts/services-networking/networkpolicies/

  Enums:
    ProviderValueValuesEnum: The selected network policy provider.

  Fields:
    enabled: Whether network policy is enabled on the cluster.
    provider: The selected network policy provider.
  """

  class ProviderValueValuesEnum(_messages.Enum):
    r"""The selected network policy provider.

    Values:
      PROVIDER_UNSPECIFIED: Not set
      CALICO: Tigera (Calico Felix).
    """
    PROVIDER_UNSPECIFIED = 0
    CALICO = 1

  enabled = _messages.BooleanField(1)
  provider = _messages.EnumField('ProviderValueValuesEnum', 2)


class NetworkPolicyConfig(_messages.Message):
  r"""Configuration for NetworkPolicy. This only tracks whether the addon is
  enabled or not on the Master, it does not track whether network policy is
  enabled for the nodes.

  Fields:
    disabled: Whether NetworkPolicy is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class NodeConfig(_messages.Message):
  r"""Parameters that describe the nodes in a cluster.

  Messages:
    LabelsValue: The map of Kubernetes labels (key/value pairs) to be applied
      to each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    MetadataValue: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys:  "cluster-location"  "cluster-name"  "cluster-uid"
      "configure-sh"  "gci-update-strategy"  "gci-ensure-gke-docker"
      "instance-template"  "kube-env"  "startup-script"  "user-data"  Values
      are free-form strings, and only have meaning as interpreted by the image
      running in the instance. The only restriction placed on them is that
      each value's size must be less than or equal to 32 KB.  The total size
      of all keys and values must be less than 512 KB.

  Fields:
    accelerators: A list of hardware accelerators to be attached to each node.
      See https://cloud.google.com/compute/docs/gpus for more information
      about support for GPUs.
    diskSizeGb: Size of the disk attached to each node, specified in GB. The
      smallest allowed disk size is 10GB.  If unspecified, the default disk
      size is 100GB.
    diskType: Type of the disk attached to each node (e.g. 'pd-standard' or
      'pd-ssd')  If unspecified, the default disk type is 'pd-standard'
    enableAuditLogging: Whether to enable execve audit logging on the nodes.
    imageType: The image type to use for this node. Note that for a given
      image type, the latest version of it will be used.
    labels: The map of Kubernetes labels (key/value pairs) to be applied to
      each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    localSsdCount: The number of local SSD disks to be attached to the node.
      The limit for this value is dependant upon the maximum number of disks
      available on a machine per zone. See:
      https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
      for more information.
    machineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-1`).  If
      unspecified, the default machine type is `n1-standard-1`.
    metadata: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys:  "cluster-location"  "cluster-name"  "cluster-uid"
      "configure-sh"  "gci-update-strategy"  "gci-ensure-gke-docker"
      "instance-template"  "kube-env"  "startup-script"  "user-data"  Values
      are free-form strings, and only have meaning as interpreted by the image
      running in the instance. The only restriction placed on them is that
      each value's size must be less than or equal to 32 KB.  The total size
      of all keys and values must be less than 512 KB.
    minCpuPlatform: Minimum CPU platform to be used by this instance. The
      instance may be scheduled on the specified or newer CPU platform.
      Applicable values are the friendly names of CPU platforms, such as
      <code>minCpuPlatform: &quot;Intel Haswell&quot;</code> or
      <code>minCpuPlatform: &quot;Intel Sandy Bridge&quot;</code>. For more
      information, read [how to specify min CPU
      platform](https://cloud.google.com/compute/docs/instances/specify-min-
      cpu-platform)
    nodeImageConfig: The node image configuration to use for this node pool.
      Note that this is only applicable for node pools using
      image_type=CUSTOM.
    oauthScopes: The set of Google API scopes to be made available on all of
      the node VMs under the "default" service account.  The following scopes
      are recommended, but not required, and by default are not included:  *
      `https://www.googleapis.com/auth/compute` is required for mounting
      persistent storage on your nodes. *
      `https://www.googleapis.com/auth/devstorage.read_only` is required for
      communicating with **gcr.io** (the [Google Container Registry
      ](/container-registry/)).  If unspecified, no scopes are added, unless
      Cloud Logging or Cloud Monitoring are enabled, in which case their
      required scopes will be added.
    preemptible: Whether the nodes are created as preemptible VM instances.
      See: https://cloud.google.com/compute/docs/instances/preemptible for
      more inforamtion about preemptible VM instances.
    serviceAccount: The Google Cloud Platform Service Account to be used by
      the node VMs. If no Service Account is specified, the "default" service
      account is used.
    tags: The list of instance tags applied to all nodes. Tags are used to
      identify valid sources or targets for network firewalls and are
      specified by the client during cluster or node pool creation. Each tag
      within the list must comply with RFC1035.
    taints: List of kubernetes taints to be applied to each node.  For more
      information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
    workloadMetadataConfig: The workload metadata configuration for this node.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The map of Kubernetes labels (key/value pairs) to be applied to each
    node. These will added in addition to any default label(s) that Kubernetes
    may apply to the node. In case of conflict in label keys, the applied set
    may differ depending on the Kubernetes version -- it's best to assume the
    behavior is undefined and conflicts should be avoided. For more
    information, including usage and the valid values, see:
    https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata key/value pairs assigned to instances in the cluster.
    Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
    in length. These are reflected as part of a URL in the metadata server.
    Additionally, to avoid ambiguity, keys must not conflict with any other
    metadata keys for the project or be one of the reserved keys:  "cluster-
    location"  "cluster-name"  "cluster-uid"  "configure-sh"  "gci-update-
    strategy"  "gci-ensure-gke-docker"  "instance-template"  "kube-env"
    "startup-script"  "user-data"  Values are free-form strings, and only have
    meaning as interpreted by the image running in the instance. The only
    restriction placed on them is that each value's size must be less than or
    equal to 32 KB.  The total size of all keys and values must be less than
    512 KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accelerators = _messages.MessageField('AcceleratorConfig', 1, repeated=True)
  diskSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  diskType = _messages.StringField(3)
  enableAuditLogging = _messages.BooleanField(4)
  imageType = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  localSsdCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  machineType = _messages.StringField(8)
  metadata = _messages.MessageField('MetadataValue', 9)
  minCpuPlatform = _messages.StringField(10)
  nodeImageConfig = _messages.MessageField('CustomImageConfig', 11)
  oauthScopes = _messages.StringField(12, repeated=True)
  preemptible = _messages.BooleanField(13)
  serviceAccount = _messages.StringField(14)
  tags = _messages.StringField(15, repeated=True)
  taints = _messages.MessageField('NodeTaint', 16, repeated=True)
  workloadMetadataConfig = _messages.MessageField('WorkloadMetadataConfig', 17)


class NodeManagement(_messages.Message):
  r"""NodeManagement defines the set of node management services turned on for
  the node pool.

  Fields:
    autoRepair: Whether the nodes will be automatically repaired.
    autoUpgrade: Whether the nodes will be automatically upgraded.
    upgradeOptions: Specifies the Auto Upgrade knobs for the node pool.
  """

  autoRepair = _messages.BooleanField(1)
  autoUpgrade = _messages.BooleanField(2)
  upgradeOptions = _messages.MessageField('AutoUpgradeOptions', 3)


class NodePool(_messages.Message):
  r"""NodePool contains the name and configuration for a cluster's node pool.
  Node pools are a set of nodes (i.e. VM's), with a common configuration and
  specification, under the control of the cluster master. They may have a set
  of Kubernetes labels applied to them, which may be used to reference them
  during pod scheduling. They may also be resized up or down, to accommodate
  the workload.

  Enums:
    StatusValueValuesEnum: [Output only] The status of the nodes in this pool
      instance.

  Fields:
    autoscaling: Autoscaler configuration for this NodePool. Autoscaler is
      enabled only if a valid configuration is present.
    config: The node configuration of the pool.
    initialNodeCount: The initial node count for the pool. You must ensure
      that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota.
    instanceGroupUrls: [Output only] The resource URLs of the [managed
      instance groups](/compute/docs/instance-groups/creating-groups-of-
      managed-instances) associated with this node pool.
    management: NodeManagement configuration for this NodePool.
    name: The name of the node pool.
    selfLink: [Output only] Server-defined URL for the resource.
    status: [Output only] The status of the nodes in this pool instance.
    statusMessage: [Output only] Additional information about the current
      status of this node pool instance, if available.
    version: The version of the Kubernetes of this node.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The status of the nodes in this pool instance.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RUNNING_WITH_ERROR: The RUNNING_WITH_ERROR state indicates the node pool
        has been created and is partially usable. Some error state has
        occurred and some functionality may be impaired. Customer may need to
        reissue a request or trigger a new update.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the node pool, such as upgrading node software. Details
        can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool may be unusable. Details
        can be found in the `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RUNNING_WITH_ERROR = 3
    RECONCILING = 4
    STOPPING = 5
    ERROR = 6

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  config = _messages.MessageField('NodeConfig', 2)
  initialNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(4, repeated=True)
  management = _messages.MessageField('NodeManagement', 5)
  name = _messages.StringField(6)
  selfLink = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  statusMessage = _messages.StringField(9)
  version = _messages.StringField(10)


class NodePoolAutoscaling(_messages.Message):
  r"""NodePoolAutoscaling contains information required by cluster autoscaler
  to adjust the size of the node pool to the current cluster usage.

  Fields:
    enabled: Is autoscaling enabled for this node pool.
    maxNodeCount: Maximum number of nodes in the NodePool. Must be >=
      min_node_count. There has to enough quota to scale up the cluster.
    minNodeCount: Minimum number of nodes in the NodePool. Must be >= 1 and <=
      max_node_count.
  """

  enabled = _messages.BooleanField(1)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class NodeTaint(_messages.Message):
  r"""Kubernetes taint is comprised of three fields: key, value, and effect.
  Effect can only be one of three types:  NoSchedule, PreferNoSchedule or
  NoExecute.  For more information, including usage and the valid values, see:
  https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/

  Enums:
    EffectValueValuesEnum: Effect for taint.

  Fields:
    effect: Effect for taint.
    key: Key for taint.
    value: Value for taint.
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""Effect for taint.

    Values:
      EFFECT_UNSPECIFIED: Not set
      NO_SCHEDULE: NoSchedule
      PREFER_NO_SCHEDULE: PreferNoSchedule
      NO_EXECUTE: NoExecute
    """
    EFFECT_UNSPECIFIED = 0
    NO_SCHEDULE = 1
    PREFER_NO_SCHEDULE = 2
    NO_EXECUTE = 3

  effect = _messages.EnumField('EffectValueValuesEnum', 1)
  key = _messages.StringField(2)
  value = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This operation resource represents operations that may have happened or
  are happening on the cluster. All fields are output only.

  Enums:
    OperationTypeValueValuesEnum: The operation type.
    StatusValueValuesEnum: The current status of the operation.

  Fields:
    detail: Detailed operation progress, if available.
    endTime: [Output only] The time the operation completed, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    location: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/regions-zones/regions-zones#available) or
      [region](/compute/docs/regions-zones/regions-zones#available) in which
      the cluster resides.
    name: The server-assigned ID for the operation.
    operationType: The operation type.
    selfLink: Server-defined URL for the resource.
    startTime: [Output only] The time the operation started, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    status: The current status of the operation.
    statusMessage: If an error has occurred, a textual description of the
      error.
    targetLink: Server-defined URL for the target of the operation.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation is taking
      place. This field is deprecated, use location instead.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The operation type.

    Values:
      TYPE_UNSPECIFIED: Not set.
      CREATE_CLUSTER: Cluster create.
      DELETE_CLUSTER: Cluster delete.
      UPGRADE_MASTER: A master upgrade.
      UPGRADE_NODES: A node upgrade.
      REPAIR_CLUSTER: Cluster repair.
      UPDATE_CLUSTER: Cluster update.
      CREATE_NODE_POOL: Node pool create.
      DELETE_NODE_POOL: Node pool delete.
      SET_NODE_POOL_MANAGEMENT: Set node pool management.
      AUTO_REPAIR_NODES: Automatic node pool repair.
      AUTO_UPGRADE_NODES: Automatic node upgrade.
      SET_LABELS: Set labels.
      SET_MASTER_AUTH: Set/generate master auth materials
      SET_NODE_POOL_SIZE: Set node pool size.
      SET_NETWORK_POLICY: Updates network policy for a cluster.
      SET_MAINTENANCE_POLICY: Set the maintenance policy.
    """
    TYPE_UNSPECIFIED = 0
    CREATE_CLUSTER = 1
    DELETE_CLUSTER = 2
    UPGRADE_MASTER = 3
    UPGRADE_NODES = 4
    REPAIR_CLUSTER = 5
    UPDATE_CLUSTER = 6
    CREATE_NODE_POOL = 7
    DELETE_NODE_POOL = 8
    SET_NODE_POOL_MANAGEMENT = 9
    AUTO_REPAIR_NODES = 10
    AUTO_UPGRADE_NODES = 11
    SET_LABELS = 12
    SET_MASTER_AUTH = 13
    SET_NODE_POOL_SIZE = 14
    SET_NETWORK_POLICY = 15
    SET_MAINTENANCE_POLICY = 16

  class StatusValueValuesEnum(_messages.Enum):
    r"""The current status of the operation.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
      ABORTING: The operation is aborting.
    """
    STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    ABORTING = 4

  detail = _messages.StringField(1)
  endTime = _messages.StringField(2)
  location = _messages.StringField(3)
  name = _messages.StringField(4)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 5)
  selfLink = _messages.StringField(6)
  startTime = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  statusMessage = _messages.StringField(9)
  targetLink = _messages.StringField(10)
  zone = _messages.StringField(11)


class PodSecurityPolicyConfig(_messages.Message):
  r"""Configuration for the PodSecurityPolicy feature.

  Fields:
    enabled: Enable the PodSecurityPolicy controller for this cluster. If
      enabled, pods must be valid under a PodSecurityPolicy to be created.
  """

  enabled = _messages.BooleanField(1)


class RollbackNodePoolUpgradeRequest(_messages.Message):
  r"""RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or
  Failed NodePool upgrade. This will be an no-op if the last upgrade
  successfully completed.

  Fields:
    clusterId: Deprecated. The name of the cluster to rollback. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node poll
      to rollback upgrade. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to rollback. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class ServerConfig(_messages.Message):
  r"""Kubernetes Engine service configuration.

  Fields:
    buildClientInfo: apiserver build BuildData::ClientInfo()
    defaultClusterVersion: Version of Kubernetes the service deploys by
      default.
    defaultImageType: Default image type.
    validImageTypes: List of valid image types.
    validMasterVersions: List of valid master versions.
    validNodeVersions: List of valid node upgrade target versions.
  """

  buildClientInfo = _messages.StringField(1)
  defaultClusterVersion = _messages.StringField(2)
  defaultImageType = _messages.StringField(3)
  validImageTypes = _messages.StringField(4, repeated=True)
  validMasterVersions = _messages.StringField(5, repeated=True)
  validNodeVersions = _messages.StringField(6, repeated=True)


class SetAddonsConfigRequest(_messages.Message):
  r"""SetAddonsRequest sets the addons associated with the cluster.

  Fields:
    addonsConfig: The desired configurations for the various addons available
      to run in the cluster.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set addons.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetLabelsRequest(_messages.Message):
  r"""SetLabelsRequest sets the Google Cloud Platform labels on a Google
  Container Engine cluster, which will in turn set them for Google Compute
  Engine resources used by that cluster

  Messages:
    ResourceLabelsValue: The labels to set for that cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Kubernetes Engine and changes after every request to modify
      or update labels. You must always provide an up-to-date fingerprint hash
      when updating or changing labels. Make a <code>get()</code> request to
      the resource to get the latest fingerprint.
    name: The name (project, location, cluster id) of the cluster to set
      labels. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    resourceLabels: The labels to set for that cluster.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""The labels to set for that cluster.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterId = _messages.StringField(1)
  labelFingerprint = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class SetLegacyAbacRequest(_messages.Message):
  r"""SetLegacyAbacRequest enables or disables the ABAC authorization
  mechanism for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    enabled: Whether ABAC authorization will be enabled in the cluster.
    name: The name (project, location, cluster id) of the cluster to set
      legacy abac. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  enabled = _messages.BooleanField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetLocationsRequest(_messages.Message):
  r"""SetLocationsRequest sets the locations of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    locations: The desired list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located. Changing the locations a cluster is in will result in
      nodes being either created or removed from the cluster, depending on
      whether locations are being added or removed.  This list must always
      include the cluster's primary zone.
    name: The name (project, location, cluster) of the cluster to set
      locations. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  locations = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetLoggingServiceRequest(_messages.Message):
  r"""SetLoggingServiceRequest sets the logging service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    loggingService: The logging service the cluster should use to write
      metrics. Currently available options:  * "logging.googleapis.com" - the
      Google Cloud Logging service * "none" - no metrics will be exported from
      the cluster
    name: The name (project, location, cluster) of the cluster to set logging.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  loggingService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetMaintenancePolicyRequest(_messages.Message):
  r"""SetMaintenancePolicyRequest sets the maintenance policy for a cluster.

  Fields:
    clusterId: The name of the cluster to update.
    maintenancePolicy: The maintenance policy to be set for the cluster. An
      empty field clears the existing maintenance policy.
    name: The name (project, location, cluster id) of the cluster to set
      maintenance policy. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    version: API request version that initiates this operation.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetMasterAuthRequest(_messages.Message):
  r"""SetMasterAuthRequest updates the admin password of a cluster.

  Enums:
    ActionValueValuesEnum: The exact form of action to be taken on the master
      auth.

  Fields:
    action: The exact form of action to be taken on the master auth.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set auth.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: A description of the update.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The exact form of action to be taken on the master auth.

    Values:
      UNKNOWN: Operation is unknown and will error out.
      SET_PASSWORD: Set the password to a user generated value.
      GENERATE_PASSWORD: Generate a new password and set it to that.
      SET_USERNAME: Set the username.  If an empty username is provided, basic
        authentication is disabled for the cluster.  If a non-empty username
        is provided, basic authentication is enabled, with either a provided
        password or a generated one.
    """
    UNKNOWN = 0
    SET_PASSWORD = 1
    GENERATE_PASSWORD = 2
    SET_USERNAME = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  update = _messages.MessageField('MasterAuth', 5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class SetMonitoringServiceRequest(_messages.Message):
  r"""SetMonitoringServiceRequest sets the monitoring service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options:  * "monitoring.googleapis.com" -
      the Google Cloud Monitoring service * "none" - no metrics will be
      exported from the cluster
    name: The name (project, location, cluster) of the cluster to set
      monitoring. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  monitoringService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNetworkPolicyRequest(_messages.Message):
  r"""SetNetworkPolicyRequest enables/disables network policy for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to set
      networking policy. Specified in the format
      'projects/*/locations/*/clusters/*'.
    networkPolicy: Configuration options for the NetworkPolicy feature.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  networkPolicy = _messages.MessageField('NetworkPolicy', 3)
  projectId = _messages.StringField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNodePoolAutoscalingRequest(_messages.Message):
  r"""SetNodePoolAutoscalingRequest sets the autoscaler settings of a node
  pool.

  Fields:
    autoscaling: Autoscaling configuration for the node pool.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool) of the node pool to
      set autoscaler settings. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class SetNodePoolManagementRequest(_messages.Message):
  r"""SetNodePoolManagementRequest sets the node management properties of a
  node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    management: NodeManagement configuration for the node pool.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set management properties. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  management = _messages.MessageField('NodeManagement', 2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class SetNodePoolSizeRequest(_messages.Message):
  r"""SetNodePoolSizeRequest sets the size a node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set size. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodeCount: The desired node count for the pool.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class StartIPRotationRequest(_messages.Message):
  r"""StartIPRotationRequest creates a new IP for the cluster and then
  performs a node upgrade on each node pool to point to the new IP.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to start IP
      rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    rotateCredentials: Whether to rotate credentials during IP rotation.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  rotateCredentials = _messages.BooleanField(4)
  version = _messages.StringField(5)
  zone = _messages.StringField(6)


class UpdateClusterRequest(_messages.Message):
  r"""UpdateClusterRequest updates the settings of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    options: Additional options that affects how the update is done.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: A description of the update.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  options = _messages.MessageField('ClusterUpdateOptions', 3)
  projectId = _messages.StringField(4)
  update = _messages.MessageField('ClusterUpdate', 5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class UpdateMasterRequest(_messages.Message):
  r"""UpdateMasterRequest updates the master of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    masterMachineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-8`) to change the
      master to.
    masterVersion: The Kubernetes version to change the master to.  Users may
      specify either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior:  - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "-": picks the default Kubernetes version
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  masterMachineType = _messages.StringField(2)
  masterVersion = _messages.StringField(3)
  name = _messages.StringField(4)
  projectId = _messages.StringField(5)
  version = _messages.StringField(6)
  zone = _messages.StringField(7)


class UpdateNodePoolRequest(_messages.Message):
  r"""SetNodePoolVersionRequest updates the version of a node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    image: The desired name of the image name to use for this node. This is
      used to create clusters using a custom image.
    imageProject: The project containing the desired image to use for this
      node pool. This is used to create clusters using a custom image.
    imageType: The desired image type for the node pool.
    name: The name (project, location, cluster, node pool) of the node pool to
      update. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    nodeVersion: The Kubernetes version to change the nodes to (typically an
      upgrade).  Users may specify either explicit versions offered by
      Kubernetes Engine or version aliases, which have the following behavior:
      - "latest": picks the highest valid Kubernetes version - "1.X": picks
      the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks
      the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N":
      picks an explicit Kubernetes version - "-": picks the Kubernetes master
      version
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    version: API request version that initiates this operation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  image = _messages.StringField(2)
  imageProject = _messages.StringField(3)
  imageType = _messages.StringField(4)
  name = _messages.StringField(5)
  nodePoolId = _messages.StringField(6)
  nodeVersion = _messages.StringField(7)
  projectId = _messages.StringField(8)
  version = _messages.StringField(9)
  zone = _messages.StringField(10)


class UsableSubnetwork(_messages.Message):
  r"""UsableSubnetwork resource returns the subnetwork name, its associated
  network and the primary CIDR range.

  Fields:
    ipCidrRange: The range of internal addresses that are owned by this
      subnetwork.
    network: Network Name. Example: projects/my-project/global/networks/my-
      network
    subnetwork: Subnetwork Name. Example: projects/my-project/regions/us-
      central1/subnetworks/my-subnet
  """

  ipCidrRange = _messages.StringField(1)
  network = _messages.StringField(2)
  subnetwork = _messages.StringField(3)


class WorkloadMetadataConfig(_messages.Message):
  r"""WorkloadMetadataConfig defines the metadata configuration to expose to
  workloads on the node pool.

  Enums:
    NodeMetadataValueValuesEnum: NodeMetadata is the configuration for how to
      expose the node metadata to the workload running on the node.

  Fields:
    nodeMetadata: NodeMetadata is the configuration for how to expose the node
      metadata to the workload running on the node.
  """

  class NodeMetadataValueValuesEnum(_messages.Enum):
    r"""NodeMetadata is the configuration for how to expose the node metadata
    to the workload running on the node.

    Values:
      UNSPECIFIED: Not set.
      SECURE: Prevent workloads not in hostNetwork from accessing certain VM
        metadata, specifically kube-env, which contains Kubelet credentials,
        and the instance identity token.  Metadata concealment is a temporary
        security solution available while the bootstrapping process for
        cluster nodes is being redesigned with significant security
        improvements.  This feature is scheduled to be deprecated in the
        future and later removed.
      EXPOSE: Expose all VM metadata to pods.
    """
    UNSPECIFIED = 0
    SECURE = 1
    EXPOSE = 2

  nodeMetadata = _messages.EnumField('NodeMetadataValueValuesEnum', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
