# Copyright 2018 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Package for the sole tenant node types CLI commands."""

from googlecloudsdk.calliope import base


class SoleTenancyNodeTypes(base.Group):
  """Read Google Compute Engine sole-tenancy node types.

  Node types are the types of dedicated Compute Engine servers that
  are used for nodes in node groups. Node types will differ in
  the amount of vCPU, Memory, and local SSD space.
  """
