"""Generated client library for servicenetworking version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.servicenetworking.v1alpha import servicenetworking_v1alpha_messages as messages


class ServicenetworkingV1alpha(base_api.BaseApiClient):
  """Generated client library for service servicenetworking version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://servicenetworking.googleapis.com/'

  _PACKAGE = u'servicenetworking'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/service.management']
  _VERSION = u'v1alpha'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ServicenetworkingV1alpha'
  _URL_VERSION = u'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new servicenetworking handle."""
    url = url or self.BASE_URL
    super(ServicenetworkingV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.operations = self.OperationsService(self)
    self.services = self.ServicesService(self)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(ServicenetworkingV1alpha.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (ServicenetworkingOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'servicenetworking.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'ServicenetworkingOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ServicesService(base_api.BaseApiService):
    """Service class for the services resource."""

    _NAME = u'services'

    def __init__(self, client):
      super(ServicenetworkingV1alpha.ServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSubnetwork(self, request, global_params=None):
      r"""Service provider use this method to provision a new subnet in a.
peered service shared VPC network.
It will validate previously provided reserved ranges, find non-conflicting
sub-range of requested size (expressed in
number of leading bits of ipv4 network mask, as in CIDR range notation).
It will then create a subnetwork in the request region.
Operation<response: AddSubnetworkResponse>

      Args:
        request: (ServicenetworkingServicesAddSubnetworkRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSubnetwork')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSubnetwork.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/services/{servicesId}/{servicesId1}/{servicesId2}:addSubnetwork',
        http_method=u'POST',
        method_id=u'servicenetworking.services.addSubnetwork',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha/{+parent}:addSubnetwork',
        request_field=u'addSubnetworkRequest',
        request_type_name=u'ServicenetworkingServicesAddSubnetworkRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Peer(self, request, global_params=None):
      r"""To connect service to a VPC network peering connection.
must be established prior to service provisioning.
This method must be invoked by the consumer VPC network administrator
It will establish a permanent peering connection with a shared
network created in the service producer organization and register a
reserved IP range(s) to be used for service subnetwork provisioning.
This connection will be used for all supported services in the service
producer organization, so it only needs to be invoked once.
Operation<response: Empty>.

      Args:
        request: (ServicenetworkingServicesPeerRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Peer')
      return self._RunMethod(
          config, request, global_params=global_params)

    Peer.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/services/{servicesId}:peer',
        http_method=u'POST',
        method_id=u'servicenetworking.services.peer',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:peer',
        request_field=u'peerSharedNetworkRequest',
        request_type_name=u'ServicenetworkingServicesPeerRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )
