"""Generated client library for container version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.container.v1 import container_v1_messages as messages


class ContainerV1(base_api.BaseApiClient):
  """Generated client library for service container version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://container.googleapis.com/'

  _PACKAGE = u'container'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/userinfo.email']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ContainerV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new container handle."""
    url = url or self.BASE_URL
    super(ContainerV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.masterProjects_locations_projects_clusters_master = self.MasterProjectsLocationsProjectsClustersMasterService(self)
    self.masterProjects_locations_projects_clusters_namespaces = self.MasterProjectsLocationsProjectsClustersNamespacesService(self)
    self.masterProjects_locations_projects_clusters = self.MasterProjectsLocationsProjectsClustersService(self)
    self.masterProjects_locations_projects = self.MasterProjectsLocationsProjectsService(self)
    self.masterProjects_locations_signedUrls = self.MasterProjectsLocationsSignedUrlsService(self)
    self.masterProjects_locations_tokens = self.MasterProjectsLocationsTokensService(self)
    self.masterProjects_locations = self.MasterProjectsLocationsService(self)
    self.masterProjects_zones_signedUrls = self.MasterProjectsZonesSignedUrlsService(self)
    self.masterProjects_zones_tokens = self.MasterProjectsZonesTokensService(self)
    self.masterProjects_zones = self.MasterProjectsZonesService(self)
    self.masterProjects = self.MasterProjectsService(self)
    self.projects_locations_clusters_nodePools = self.ProjectsLocationsClustersNodePoolsService(self)
    self.projects_locations_clusters = self.ProjectsLocationsClustersService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_zones_clusters_nodePools = self.ProjectsZonesClustersNodePoolsService(self)
    self.projects_zones_clusters = self.ProjectsZonesClustersService(self)
    self.projects_zones_operations = self.ProjectsZonesOperationsService(self)
    self.projects_zones = self.ProjectsZonesService(self)
    self.projects = self.ProjectsService(self)

  class MasterProjectsLocationsProjectsClustersMasterService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_projects_clusters_master resource."""

    _NAME = u'masterProjects_locations_projects_clusters_master'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsProjectsClustersMasterService, self).__init__(client)
      self._upload_configs = {
          }

    def AckRepairwork(self, request, global_params=None):
      r"""AcknowledgeRepairWork accepts acknowledgements of repair work from the.
Hosted Master.

      Args:
        request: (ContainerMasterProjectsLocationsProjectsClustersMasterAckRepairworkRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AckRepairWorkResponse) The response message.
      """
      config = self.GetMethodConfig('AckRepairwork')
      return self._RunMethod(
          config, request, global_params=global_params)

    AckRepairwork.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.projects.clusters.master.ackRepairwork',
        ordered_params=[u'masterProjectName', u'location', u'projectNumber', u'clusterId', u'masterId'],
        path_params=[u'clusterId', u'location', u'masterId', u'masterProjectName', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectName}/locations/{location}/projects/{projectNumber}/clusters/{clusterId}/master/{masterId}/ackRepairwork',
        request_field=u'ackRepairWorkRequest',
        request_type_name=u'ContainerMasterProjectsLocationsProjectsClustersMasterAckRepairworkRequest',
        response_type_name=u'AckRepairWorkResponse',
        supports_download=False,
    )

    def GetRepairwork(self, request, global_params=None):
      r"""This method requests work from the API server to see if there are.
any repairs to be done on the Hosted Master.

      Args:
        request: (ContainerMasterProjectsLocationsProjectsClustersMasterGetRepairworkRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetRepairWorkResponse) The response message.
      """
      config = self.GetMethodConfig('GetRepairwork')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRepairwork.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.masterProjects.locations.projects.clusters.master.getRepairwork',
        ordered_params=[u'masterProjectName', u'location', u'projectNumber', u'clusterId', u'masterId'],
        path_params=[u'clusterId', u'location', u'masterId', u'masterProjectName', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectName}/locations/{location}/projects/{projectNumber}/clusters/{clusterId}/master/{masterId}/repairwork',
        request_field='',
        request_type_name=u'ContainerMasterProjectsLocationsProjectsClustersMasterGetRepairworkRequest',
        response_type_name=u'GetRepairWorkResponse',
        supports_download=False,
    )

  class MasterProjectsLocationsProjectsClustersNamespacesService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_projects_clusters_namespaces resource."""

    _NAME = u'masterProjects_locations_projects_clusters_namespaces'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsProjectsClustersNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Finalize(self, request, global_params=None):
      r"""FinalizeNamespace finalizes the GKE bits for a Kubernetes namespace.  Right.
now, this involved purging IAM policies.

      Args:
        request: (ContainerMasterProjectsLocationsProjectsClustersNamespacesFinalizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Finalize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Finalize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.projects.clusters.namespaces.finalize',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId', u'namespaceId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'namespaceId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/projects/{projectNumber}/clusters/{clusterId}/namespaces/{namespaceId}/finalize',
        request_field='',
        request_type_name=u'ContainerMasterProjectsLocationsProjectsClustersNamespacesFinalizeRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

  class MasterProjectsLocationsProjectsClustersService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_projects_clusters resource."""

    _NAME = u'masterProjects_locations_projects_clusters'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsProjectsClustersService, self).__init__(client)
      self._upload_configs = {
          }

  class MasterProjectsLocationsProjectsService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_projects resource."""

    _NAME = u'masterProjects_locations_projects'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class MasterProjectsLocationsSignedUrlsService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_signedUrls resource."""

    _NAME = u'masterProjects_locations_signedUrls'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsSignedUrlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates signed URLs that allow for writing a file to a private GCS bucket.
for storing backups of hosted master data. Signed URLs are explained here:
https://cloud.google.com/storage/docs/access-control#Signed-URLs

      Args:
        request: (ContainerMasterProjectsLocationsSignedUrlsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignedUrls) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.signedUrls.create',
        ordered_params=[u'masterProjectId', u'location'],
        path_params=[u'location', u'masterProjectId'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/signedUrls',
        request_field=u'createSignedUrlsRequest',
        request_type_name=u'ContainerMasterProjectsLocationsSignedUrlsCreateRequest',
        response_type_name=u'SignedUrls',
        supports_download=False,
    )

  class MasterProjectsLocationsTokensService(base_api.BaseApiService):
    """Service class for the masterProjects_locations_tokens resource."""

    _NAME = u'masterProjects_locations_tokens'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsTokensService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a compute-read-write (https://www.googleapis.com/auth/compute).
scoped OAuth2 access token for <project_number>, to allow a hosted master
to make modifications to its user's project.

      Args:
        request: (ContainerMasterProjectsLocationsTokensCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Token) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.tokens.create',
        ordered_params=[u'masterProjectId', u'location'],
        path_params=[u'location', u'masterProjectId'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/tokens',
        request_field=u'createTokenRequest',
        request_type_name=u'ContainerMasterProjectsLocationsTokensCreateRequest',
        response_type_name=u'Token',
        supports_download=False,
    )

  class MasterProjectsLocationsService(base_api.BaseApiService):
    """Service class for the masterProjects_locations resource."""

    _NAME = u'masterProjects_locations'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Audit(self, request, global_params=None):
      r"""Audits the provided events to Cloud Audit Logging and/or Gin, depending on.
policies defined by GKE.

      Args:
        request: (ContainerMasterProjectsLocationsAuditRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuditResponse) The response message.
      """
      config = self.GetMethodConfig('Audit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Audit.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.audit',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/{projectNumber}/{clusterId}/audit',
        request_field=u'auditEventList',
        request_type_name=u'ContainerMasterProjectsLocationsAuditRequest',
        response_type_name=u'AuditResponse',
        supports_download=False,
    )

    def Authenticate(self, request, global_params=None):
      r"""Processes a request to authenticate a token. If it is able to authenticate.
the token, the email for the authorized user is also returned.
AuthenticateResponse also contains fields from the AuthenticateRequest. The
server is expected to only fill in the AuthenticateResponse.Status. This is
due to how the Authentication types are defined for the Kubernetes webhook
authenticator:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/authentication.k8s.io/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsLocationsAuthenticateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthenticateResponse) The response message.
      """
      config = self.GetMethodConfig('Authenticate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Authenticate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.authenticate',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/{projectNumber}/{clusterId}/authenticate',
        request_field=u'authenticateRequest',
        request_type_name=u'ContainerMasterProjectsLocationsAuthenticateRequest',
        response_type_name=u'AuthenticateResponse',
        supports_download=False,
    )

    def Authorize(self, request, global_params=None):
      r"""Processes the attributes of a user request and determines whether or not.
to authorize the request. If unauthorized, a reason is also provided. The
AuthorizeResponse also contains fields from the AuthorizeRequest. The
server is expected to only fill in the AuthorizeResponse.Status. This is
due to how the Authorization types are defined for the Kubernetes webhook
authorizer:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/authorization/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsLocationsAuthorizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthorizeResponse) The response message.
      """
      config = self.GetMethodConfig('Authorize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Authorize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.authorize',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/{projectNumber}/{clusterId}/authorize',
        request_field=u'authorizeRequest',
        request_type_name=u'ContainerMasterProjectsLocationsAuthorizeRequest',
        response_type_name=u'AuthorizeResponse',
        supports_download=False,
    )

    def Imagereview(self, request, global_params=None):
      r"""Processes a request to verify the container image. If unverified, a reason.
is also provided. The ImageReviewResponse also contains fields from the
ImageReviewRequest. The server is expected to only fill in the
ImageReviewResponse.Status. This is due to how the ImageReview types are
defined for the Kubernetes webhook image review:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/imagepolicy/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsLocationsImagereviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageReviewResponse) The response message.
      """
      config = self.GetMethodConfig('Imagereview')
      return self._RunMethod(
          config, request, global_params=global_params)

    Imagereview.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.imagereview',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/{projectNumber}/{clusterId}/imagereview',
        request_field=u'imageReviewRequest',
        request_type_name=u'ContainerMasterProjectsLocationsImagereviewRequest',
        response_type_name=u'ImageReviewResponse',
        supports_download=False,
    )

    def Signcertificate(self, request, global_params=None):
      r"""Signs a CertificateSigningRequest (CSR) with the cluster's certificate.
authority (CA).

      Args:
        request: (CertificateSigningRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CertificateSigningRequest) The response message.
      """
      config = self.GetMethodConfig('Signcertificate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Signcertificate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.locations.signcertificate',
        ordered_params=[u'masterProjectId', u'location', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'location', u'masterProjectId', u'projectNumber'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/locations/{location}/{projectNumber}/{clusterId}/signcertificate',
        request_field='<request>',
        request_type_name=u'CertificateSigningRequest',
        response_type_name=u'CertificateSigningRequest',
        supports_download=False,
    )

  class MasterProjectsZonesSignedUrlsService(base_api.BaseApiService):
    """Service class for the masterProjects_zones_signedUrls resource."""

    _NAME = u'masterProjects_zones_signedUrls'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsZonesSignedUrlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates signed URLs that allow for writing a file to a private GCS bucket.
for storing backups of hosted master data. Signed URLs are explained here:
https://cloud.google.com/storage/docs/access-control#Signed-URLs

      Args:
        request: (ContainerMasterProjectsZonesSignedUrlsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignedUrls) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.signedUrls.create',
        ordered_params=[u'masterProjectId', u'zone'],
        path_params=[u'masterProjectId', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/signedUrls',
        request_field=u'createSignedUrlsRequest',
        request_type_name=u'ContainerMasterProjectsZonesSignedUrlsCreateRequest',
        response_type_name=u'SignedUrls',
        supports_download=False,
    )

  class MasterProjectsZonesTokensService(base_api.BaseApiService):
    """Service class for the masterProjects_zones_tokens resource."""

    _NAME = u'masterProjects_zones_tokens'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsZonesTokensService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a compute-read-write (https://www.googleapis.com/auth/compute).
scoped OAuth2 access token for <project_number>, to allow a hosted master
to make modifications to its user's project.

      Args:
        request: (ContainerMasterProjectsZonesTokensCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Token) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.tokens.create',
        ordered_params=[u'masterProjectId', u'zone'],
        path_params=[u'masterProjectId', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/tokens',
        request_field=u'createTokenRequest',
        request_type_name=u'ContainerMasterProjectsZonesTokensCreateRequest',
        response_type_name=u'Token',
        supports_download=False,
    )

  class MasterProjectsZonesService(base_api.BaseApiService):
    """Service class for the masterProjects_zones resource."""

    _NAME = u'masterProjects_zones'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def Audit(self, request, global_params=None):
      r"""Audits the provided events to Cloud Audit Logging and/or Gin, depending on.
policies defined by GKE.

      Args:
        request: (ContainerMasterProjectsZonesAuditRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuditResponse) The response message.
      """
      config = self.GetMethodConfig('Audit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Audit.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.audit',
        ordered_params=[u'masterProjectId', u'zone', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'masterProjectId', u'projectNumber', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/{projectNumber}/{clusterId}/audit',
        request_field=u'auditEventList',
        request_type_name=u'ContainerMasterProjectsZonesAuditRequest',
        response_type_name=u'AuditResponse',
        supports_download=False,
    )

    def Authenticate(self, request, global_params=None):
      r"""Processes a request to authenticate a token. If it is able to authenticate.
the token, the email for the authorized user is also returned.
AuthenticateResponse also contains fields from the AuthenticateRequest. The
server is expected to only fill in the AuthenticateResponse.Status. This is
due to how the Authentication types are defined for the Kubernetes webhook
authenticator:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/authentication.k8s.io/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsZonesAuthenticateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthenticateResponse) The response message.
      """
      config = self.GetMethodConfig('Authenticate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Authenticate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.authenticate',
        ordered_params=[u'masterProjectId', u'zone', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'masterProjectId', u'projectNumber', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/{projectNumber}/{clusterId}/authenticate',
        request_field=u'authenticateRequest',
        request_type_name=u'ContainerMasterProjectsZonesAuthenticateRequest',
        response_type_name=u'AuthenticateResponse',
        supports_download=False,
    )

    def Authorize(self, request, global_params=None):
      r"""Processes the attributes of a user request and determines whether or not.
to authorize the request. If unauthorized, a reason is also provided. The
AuthorizeResponse also contains fields from the AuthorizeRequest. The
server is expected to only fill in the AuthorizeResponse.Status. This is
due to how the Authorization types are defined for the Kubernetes webhook
authorizer:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/authorization/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsZonesAuthorizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthorizeResponse) The response message.
      """
      config = self.GetMethodConfig('Authorize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Authorize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.authorize',
        ordered_params=[u'masterProjectId', u'zone', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'masterProjectId', u'projectNumber', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/{projectNumber}/{clusterId}/authorize',
        request_field=u'authorizeRequest',
        request_type_name=u'ContainerMasterProjectsZonesAuthorizeRequest',
        response_type_name=u'AuthorizeResponse',
        supports_download=False,
    )

    def Imagereview(self, request, global_params=None):
      r"""Processes a request to verify the container image. If unverified, a reason.
is also provided. The ImageReviewResponse also contains fields from the
ImageReviewRequest. The server is expected to only fill in the
ImageReviewResponse.Status. This is due to how the ImageReview types are
defined for the Kubernetes webhook image review:
https://github.com/kubernetes/kubernetes/blob/master/pkg/apis/imagepolicy/v1beta1/types.go.

      Args:
        request: (ContainerMasterProjectsZonesImagereviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageReviewResponse) The response message.
      """
      config = self.GetMethodConfig('Imagereview')
      return self._RunMethod(
          config, request, global_params=global_params)

    Imagereview.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.imagereview',
        ordered_params=[u'masterProjectId', u'zone', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'masterProjectId', u'projectNumber', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/{projectNumber}/{clusterId}/imagereview',
        request_field=u'imageReviewRequest',
        request_type_name=u'ContainerMasterProjectsZonesImagereviewRequest',
        response_type_name=u'ImageReviewResponse',
        supports_download=False,
    )

    def Signcertificate(self, request, global_params=None):
      r"""Signs a CertificateSigningRequest (CSR) with the cluster's certificate.
authority (CA).

      Args:
        request: (CertificateSigningRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CertificateSigningRequest) The response message.
      """
      config = self.GetMethodConfig('Signcertificate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Signcertificate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.masterProjects.zones.signcertificate',
        ordered_params=[u'masterProjectId', u'zone', u'projectNumber', u'clusterId'],
        path_params=[u'clusterId', u'masterProjectId', u'projectNumber', u'zone'],
        query_params=[],
        relative_path=u'v1/masterProjects/{masterProjectId}/zones/{zone}/{projectNumber}/{clusterId}/signcertificate',
        request_field='<request>',
        request_type_name=u'CertificateSigningRequest',
        response_type_name=u'CertificateSigningRequest',
        supports_download=False,
    )

  class MasterProjectsService(base_api.BaseApiService):
    """Service class for the masterProjects resource."""

    _NAME = u'masterProjects'

    def __init__(self, client):
      super(ContainerV1.MasterProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsClustersNodePoolsService(base_api.BaseApiService):
    """Service class for the projects_locations_clusters_nodePools resource."""

    _NAME = u'projects_locations_clusters_nodePools'

    def __init__(self, client):
      super(ContainerV1.ProjectsLocationsClustersNodePoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a node pool for a cluster.

      Args:
        request: (CreateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.nodePools.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/nodePools',
        request_field='<request>',
        request_type_name=u'CreateNodePoolRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a node pool from a cluster.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method=u'DELETE',
        method_id=u'container.projects.locations.clusters.nodePools.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'clusterId', u'nodePoolId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersNodePoolsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the node pool requested.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodePool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method=u'GET',
        method_id=u'container.projects.locations.clusters.nodePools.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'clusterId', u'nodePoolId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersNodePoolsGetRequest',
        response_type_name=u'NodePool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the node pools for a cluster.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNodePoolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools',
        http_method=u'GET',
        method_id=u'container.projects.locations.clusters.nodePools.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'clusterId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+parent}/nodePools',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersNodePoolsListRequest',
        response_type_name=u'ListNodePoolsResponse',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Roll back the previously Aborted or Failed NodePool upgrade.
This will be an no-op if the last upgrade successfully completed.

      Args:
        request: (RollbackNodePoolUpgradeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:rollback',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.nodePools.rollback',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:rollback',
        request_field='<request>',
        request_type_name=u'RollbackNodePoolUpgradeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetAutoscaling(self, request, global_params=None):
      r"""Sets the autoscaling settings of a specific node pool.

      Args:
        request: (SetNodePoolAutoscalingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoscaling')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoscaling.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setAutoscaling',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.nodePools.setAutoscaling',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setAutoscaling',
        request_field='<request>',
        request_type_name=u'SetNodePoolAutoscalingRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetManagement(self, request, global_params=None):
      r"""Sets the NodeManagement options for a node pool.

      Args:
        request: (SetNodePoolManagementRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetManagement')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetManagement.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setManagement',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.nodePools.setManagement',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setManagement',
        request_field='<request>',
        request_type_name=u'SetNodePoolManagementRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSize(self, request, global_params=None):
      r"""Sets the size of a specific node pool.

      Args:
        request: (SetNodePoolSizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSize')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSize.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setSize',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.nodePools.setSize',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setSize',
        request_field='<request>',
        request_type_name=u'SetNodePoolSizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the version and/or image type of a specific node pool.

      Args:
        request: (UpdateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method=u'PUT',
        method_id=u'container.projects.locations.clusters.nodePools.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='<request>',
        request_type_name=u'UpdateNodePoolRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsClustersService(base_api.BaseApiService):
    """Service class for the projects_locations_clusters resource."""

    _NAME = u'projects_locations_clusters'

    def __init__(self, client):
      super(ContainerV1.ProjectsLocationsClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def CompleteIpRotation(self, request, global_params=None):
      r"""Completes master IP rotation.

      Args:
        request: (CompleteIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CompleteIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:completeIpRotation',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.completeIpRotation',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:completeIpRotation',
        request_field='<request>',
        request_type_name=u'CompleteIPRotationRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a cluster, consisting of the specified number and type of Google.
Compute Engine instances.

By default, the cluster is created in the project's
[default network](/compute/docs/networks-and-firewalls#networks).

One firewall is added for the cluster. After cluster creation,
the cluster creates routes for each node to allow the containers
on that node to communicate with all other instances in the
cluster.

Finally, an entry is added to the project's global metadata indicating
which CIDR range is being used by the cluster.

      Args:
        request: (CreateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/clusters',
        request_field='<request>',
        request_type_name=u'CreateClusterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the cluster, including the Kubernetes endpoint and all worker.
nodes.

Firewalls and routes that were configured during cluster creation
are also deleted.

Other Google Compute Engine resources that might be in use by the cluster
(e.g. load balancer resources) will not be deleted if they weren't present
at the initial create time.

      Args:
        request: (ContainerProjectsLocationsClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method=u'DELETE',
        method_id=u'container.projects.locations.clusters.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'clusterId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details of a specific cluster.

      Args:
        request: (ContainerProjectsLocationsClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method=u'GET',
        method_id=u'container.projects.locations.clusters.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'clusterId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersGetRequest',
        response_type_name=u'Cluster',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all clusters owned by a project in either the specified zone or all.
zones.

      Args:
        request: (ContainerProjectsLocationsClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters',
        http_method=u'GET',
        method_id=u'container.projects.locations.clusters.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+parent}/clusters',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsClustersListRequest',
        response_type_name=u'ListClustersResponse',
        supports_download=False,
    )

    def SetAddons(self, request, global_params=None):
      r"""Sets the addons of a specific cluster.

      Args:
        request: (SetAddonsConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAddons')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAddons.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setAddons',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setAddons',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setAddons',
        request_field='<request>',
        request_type_name=u'SetAddonsConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLegacyAbac(self, request, global_params=None):
      r"""Enables or disables the ABAC authorization mechanism on a cluster.

      Args:
        request: (SetLegacyAbacRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLegacyAbac')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLegacyAbac.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLegacyAbac',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setLegacyAbac',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setLegacyAbac',
        request_field='<request>',
        request_type_name=u'SetLegacyAbacRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLocations(self, request, global_params=None):
      r"""Sets the locations of a specific cluster.

      Args:
        request: (SetLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLocations')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLocations.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLocations',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setLocations',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setLocations',
        request_field='<request>',
        request_type_name=u'SetLocationsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLogging(self, request, global_params=None):
      r"""Sets the logging service of a specific cluster.

      Args:
        request: (SetLoggingServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLogging')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLogging.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLogging',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setLogging',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setLogging',
        request_field='<request>',
        request_type_name=u'SetLoggingServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMaintenancePolicy(self, request, global_params=None):
      r"""Sets the maintenance policy for a cluster.

      Args:
        request: (SetMaintenancePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMaintenancePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMaintenancePolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMaintenancePolicy',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setMaintenancePolicy',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setMaintenancePolicy',
        request_field='<request>',
        request_type_name=u'SetMaintenancePolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMasterAuth(self, request, global_params=None):
      r"""Used to set master auth materials. Currently supports :-.
Changing the admin password of a specific cluster.
This can be either via password generation or explicitly set the password.

      Args:
        request: (SetMasterAuthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMasterAuth')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMasterAuth.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMasterAuth',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setMasterAuth',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setMasterAuth',
        request_field='<request>',
        request_type_name=u'SetMasterAuthRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMonitoring(self, request, global_params=None):
      r"""Sets the monitoring service of a specific cluster.

      Args:
        request: (SetMonitoringServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMonitoring')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMonitoring.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMonitoring',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setMonitoring',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setMonitoring',
        request_field='<request>',
        request_type_name=u'SetMonitoringServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetNetworkPolicy(self, request, global_params=None):
      r"""Enables/Disables Network Policy for a cluster.

      Args:
        request: (SetNetworkPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNetworkPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNetworkPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setNetworkPolicy',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setNetworkPolicy',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setNetworkPolicy',
        request_field='<request>',
        request_type_name=u'SetNetworkPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetResourceLabels(self, request, global_params=None):
      r"""Sets labels on a cluster.

      Args:
        request: (SetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetResourceLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetResourceLabels.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setResourceLabels',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.setResourceLabels',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:setResourceLabels',
        request_field='<request>',
        request_type_name=u'SetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StartIpRotation(self, request, global_params=None):
      r"""Start master IP rotation.

      Args:
        request: (StartIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:startIpRotation',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.startIpRotation',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:startIpRotation',
        request_field='<request>',
        request_type_name=u'StartIPRotationRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the settings of a specific cluster.

      Args:
        request: (UpdateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method=u'PUT',
        method_id=u'container.projects.locations.clusters.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='<request>',
        request_type_name=u'UpdateClusterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateMaster(self, request, global_params=None):
      r"""Updates the master of a specific cluster.

      Args:
        request: (UpdateMasterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateMaster')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateMaster.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:updateMaster',
        http_method=u'POST',
        method_id=u'container.projects.locations.clusters.updateMaster',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:updateMaster',
        request_field='<request>',
        request_type_name=u'UpdateMasterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = u'projects_locations_operations'

    def __init__(self, client):
      super(ContainerV1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified operation.

      Args:
        request: (CancelOperationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'container.projects.locations.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:cancel',
        request_field='<request>',
        request_type_name=u'CancelOperationRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified operation.

      Args:
        request: (ContainerProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'container.projects.locations.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'operationId', u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all operations in a project in a specific zone or all zones.

      Args:
        request: (ContainerProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method=u'GET',
        method_id=u'container.projects.locations.operations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+parent}/operations',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(ContainerV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetServerConfig(self, request, global_params=None):
      r"""Returns configuration info about the Kubernetes Engine service.

      Args:
        request: (ContainerProjectsLocationsGetServerConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServerConfig) The response message.
      """
      config = self.GetMethodConfig('GetServerConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetServerConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/serverConfig',
        http_method=u'GET',
        method_id=u'container.projects.locations.getServerConfig',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'projectId', u'version', u'zone'],
        relative_path=u'v1/{+name}/serverConfig',
        request_field='',
        request_type_name=u'ContainerProjectsLocationsGetServerConfigRequest',
        response_type_name=u'ServerConfig',
        supports_download=False,
    )

  class ProjectsZonesClustersNodePoolsService(base_api.BaseApiService):
    """Service class for the projects_zones_clusters_nodePools resource."""

    _NAME = u'projects_zones_clusters_nodePools'

    def __init__(self, client):
      super(ContainerV1.ProjectsZonesClustersNodePoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def Autoscaling(self, request, global_params=None):
      r"""Sets the autoscaling settings of a specific node pool.

      Args:
        request: (SetNodePoolAutoscalingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Autoscaling')
      return self._RunMethod(
          config, request, global_params=global_params)

    Autoscaling.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.autoscaling',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling',
        request_field='<request>',
        request_type_name=u'SetNodePoolAutoscalingRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a node pool for a cluster.

      Args:
        request: (CreateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.create',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools',
        request_field='<request>',
        request_type_name=u'CreateNodePoolRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a node pool from a cluster.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'container.projects.zones.clusters.nodePools.delete',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersNodePoolsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the node pool requested.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodePool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.clusters.nodePools.get',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersNodePoolsGetRequest',
        response_type_name=u'NodePool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the node pools for a cluster.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNodePoolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.clusters.nodePools.list',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[u'parent', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersNodePoolsListRequest',
        response_type_name=u'ListNodePoolsResponse',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Roll back the previously Aborted or Failed NodePool upgrade.
This will be an no-op if the last upgrade successfully completed.

      Args:
        request: (RollbackNodePoolUpgradeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.rollback',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback',
        request_field='<request>',
        request_type_name=u'RollbackNodePoolUpgradeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetManagement(self, request, global_params=None):
      r"""Sets the NodeManagement options for a node pool.

      Args:
        request: (SetNodePoolManagementRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetManagement')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetManagement.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.setManagement',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement',
        request_field='<request>',
        request_type_name=u'SetNodePoolManagementRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSize(self, request, global_params=None):
      r"""Sets the size of a specific node pool.

      Args:
        request: (SetNodePoolSizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSize')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.setSize',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize',
        request_field='<request>',
        request_type_name=u'SetNodePoolSizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the version and/or image type of a specific node pool.

      Args:
        request: (UpdateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.nodePools.update',
        ordered_params=[u'projectId', u'zone', u'clusterId', u'nodePoolId'],
        path_params=[u'clusterId', u'nodePoolId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update',
        request_field='<request>',
        request_type_name=u'UpdateNodePoolRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsZonesClustersService(base_api.BaseApiService):
    """Service class for the projects_zones_clusters resource."""

    _NAME = u'projects_zones_clusters'

    def __init__(self, client):
      super(ContainerV1.ProjectsZonesClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def Addons(self, request, global_params=None):
      r"""Sets the addons of a specific cluster.

      Args:
        request: (SetAddonsConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Addons')
      return self._RunMethod(
          config, request, global_params=global_params)

    Addons.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.addons',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons',
        request_field='<request>',
        request_type_name=u'SetAddonsConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def CompleteIpRotation(self, request, global_params=None):
      r"""Completes master IP rotation.

      Args:
        request: (CompleteIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CompleteIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.completeIpRotation',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation',
        request_field='<request>',
        request_type_name=u'CompleteIPRotationRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a cluster, consisting of the specified number and type of Google.
Compute Engine instances.

By default, the cluster is created in the project's
[default network](/compute/docs/networks-and-firewalls#networks).

One firewall is added for the cluster. After cluster creation,
the cluster creates routes for each node to allow the containers
on that node to communicate with all other instances in the
cluster.

Finally, an entry is added to the project's global metadata indicating
which CIDR range is being used by the cluster.

      Args:
        request: (CreateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.create',
        ordered_params=[u'projectId', u'zone'],
        path_params=[u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters',
        request_field='<request>',
        request_type_name=u'CreateClusterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the cluster, including the Kubernetes endpoint and all worker.
nodes.

Firewalls and routes that were configured during cluster creation
are also deleted.

Other Google Compute Engine resources that might be in use by the cluster
(e.g. load balancer resources) will not be deleted if they weren't present
at the initial create time.

      Args:
        request: (ContainerProjectsZonesClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'container.projects.zones.clusters.delete',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details of a specific cluster.

      Args:
        request: (ContainerProjectsZonesClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.clusters.get',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersGetRequest',
        response_type_name=u'Cluster',
        supports_download=False,
    )

    def LegacyAbac(self, request, global_params=None):
      r"""Enables or disables the ABAC authorization mechanism on a cluster.

      Args:
        request: (SetLegacyAbacRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('LegacyAbac')
      return self._RunMethod(
          config, request, global_params=global_params)

    LegacyAbac.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.legacyAbac',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac',
        request_field='<request>',
        request_type_name=u'SetLegacyAbacRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all clusters owned by a project in either the specified zone or all.
zones.

      Args:
        request: (ContainerProjectsZonesClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.clusters.list',
        ordered_params=[u'projectId', u'zone'],
        path_params=[u'projectId', u'zone'],
        query_params=[u'parent', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters',
        request_field='',
        request_type_name=u'ContainerProjectsZonesClustersListRequest',
        response_type_name=u'ListClustersResponse',
        supports_download=False,
    )

    def Locations(self, request, global_params=None):
      r"""Sets the locations of a specific cluster.

      Args:
        request: (SetLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Locations')
      return self._RunMethod(
          config, request, global_params=global_params)

    Locations.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.locations',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations',
        request_field='<request>',
        request_type_name=u'SetLocationsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Logging(self, request, global_params=None):
      r"""Sets the logging service of a specific cluster.

      Args:
        request: (SetLoggingServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Logging')
      return self._RunMethod(
          config, request, global_params=global_params)

    Logging.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.logging',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging',
        request_field='<request>',
        request_type_name=u'SetLoggingServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Master(self, request, global_params=None):
      r"""Updates the master of a specific cluster.

      Args:
        request: (UpdateMasterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Master')
      return self._RunMethod(
          config, request, global_params=global_params)

    Master.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.master',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master',
        request_field='<request>',
        request_type_name=u'UpdateMasterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Monitoring(self, request, global_params=None):
      r"""Sets the monitoring service of a specific cluster.

      Args:
        request: (SetMonitoringServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Monitoring')
      return self._RunMethod(
          config, request, global_params=global_params)

    Monitoring.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.monitoring',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring',
        request_field='<request>',
        request_type_name=u'SetMonitoringServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ResourceLabels(self, request, global_params=None):
      r"""Sets labels on a cluster.

      Args:
        request: (SetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResourceLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResourceLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.resourceLabels',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels',
        request_field='<request>',
        request_type_name=u'SetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMaintenancePolicy(self, request, global_params=None):
      r"""Sets the maintenance policy for a cluster.

      Args:
        request: (SetMaintenancePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMaintenancePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMaintenancePolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.setMaintenancePolicy',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy',
        request_field='<request>',
        request_type_name=u'SetMaintenancePolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMasterAuth(self, request, global_params=None):
      r"""Used to set master auth materials. Currently supports :-.
Changing the admin password of a specific cluster.
This can be either via password generation or explicitly set the password.

      Args:
        request: (SetMasterAuthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMasterAuth')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMasterAuth.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.setMasterAuth',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth',
        request_field='<request>',
        request_type_name=u'SetMasterAuthRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetNetworkPolicy(self, request, global_params=None):
      r"""Enables/Disables Network Policy for a cluster.

      Args:
        request: (SetNetworkPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNetworkPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNetworkPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.setNetworkPolicy',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy',
        request_field='<request>',
        request_type_name=u'SetNetworkPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StartIpRotation(self, request, global_params=None):
      r"""Start master IP rotation.

      Args:
        request: (StartIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.clusters.startIpRotation',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation',
        request_field='<request>',
        request_type_name=u'StartIPRotationRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the settings of a specific cluster.

      Args:
        request: (UpdateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'container.projects.zones.clusters.update',
        ordered_params=[u'projectId', u'zone', u'clusterId'],
        path_params=[u'clusterId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='<request>',
        request_type_name=u'UpdateClusterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsZonesOperationsService(base_api.BaseApiService):
    """Service class for the projects_zones_operations resource."""

    _NAME = u'projects_zones_operations'

    def __init__(self, client):
      super(ContainerV1.ProjectsZonesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified operation.

      Args:
        request: (CancelOperationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'container.projects.zones.operations.cancel',
        ordered_params=[u'projectId', u'zone', u'operationId'],
        path_params=[u'operationId', u'projectId', u'zone'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel',
        request_field='<request>',
        request_type_name=u'CancelOperationRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified operation.

      Args:
        request: (ContainerProjectsZonesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.operations.get',
        ordered_params=[u'projectId', u'zone', u'operationId'],
        path_params=[u'operationId', u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/operations/{operationId}',
        request_field='',
        request_type_name=u'ContainerProjectsZonesOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all operations in a project in a specific zone or all zones.

      Args:
        request: (ContainerProjectsZonesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.operations.list',
        ordered_params=[u'projectId', u'zone'],
        path_params=[u'projectId', u'zone'],
        query_params=[u'parent', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/operations',
        request_field='',
        request_type_name=u'ContainerProjectsZonesOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsZonesService(base_api.BaseApiService):
    """Service class for the projects_zones resource."""

    _NAME = u'projects_zones'

    def __init__(self, client):
      super(ContainerV1.ProjectsZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetServerconfig(self, request, global_params=None):
      r"""Returns configuration info about the Kubernetes Engine service.

      Args:
        request: (ContainerProjectsZonesGetServerconfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServerConfig) The response message.
      """
      config = self.GetMethodConfig('GetServerconfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetServerconfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'container.projects.zones.getServerconfig',
        ordered_params=[u'projectId', u'zone'],
        path_params=[u'projectId', u'zone'],
        query_params=[u'name', u'version'],
        relative_path=u'v1/projects/{projectId}/zones/{zone}/serverconfig',
        request_field='',
        request_type_name=u'ContainerProjectsZonesGetServerconfigRequest',
        response_type_name=u'ServerConfig',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ContainerV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
