"""Generated message classes for storage version v1.

Stores and retrieves potentially large, immutable data objects.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import message_types as _message_types
from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'storage'


class Bucket(_messages.Message):
  """A bucket.

  Messages:
    CorsValueListEntry: A CorsValueListEntry object.
    LabelsValue: User-provided labels, in key/value pairs.
    LifecycleValue: The bucket's lifecycle configuration. See lifecycle
      management for more information.
    LoggingValue: The bucket's logging configuration, which defines the
      destination bucket and optional name prefix for the current bucket's
      logs.
    OwnerValue: The owner of the bucket. This is always the project team's
      owner group.
    VersioningValue: The bucket's versioning configuration.
    WebsiteValue: The bucket's website configuration, controlling how the
      service behaves when accessing bucket contents as a web site. See the
      Static Website Examples for more information.

  Fields:
    acl: Access controls on the bucket.
    cors: The bucket's Cross-Origin Resource Sharing (CORS) configuration.
    defaultObjectAcl: Default access controls to apply to new objects when no
      ACL is provided.
    etag: HTTP 1.1 Entity tag for the bucket.
    id: The ID of the bucket. For buckets, the id and name properities are the
      same.
    kind: The kind of item this is. For buckets, this is always
      storage#bucket.
    labels: User-provided labels, in key/value pairs.
    lifecycle: The bucket's lifecycle configuration. See lifecycle management
      for more information.
    location: The location of the bucket. Object data for objects in the
      bucket resides in physical storage within this region. Defaults to US.
      See the developer's guide for the authoritative list.
    logging: The bucket's logging configuration, which defines the destination
      bucket and optional name prefix for the current bucket's logs.
    metageneration: The metadata generation of this bucket.
    name: The name of the bucket.
    owner: The owner of the bucket. This is always the project team's owner
      group.
    projectNumber: The project number of the project the bucket belongs to.
    selfLink: The URI of this bucket.
    storageClass: The bucket's default storage class, used whenever no
      storageClass is specified for a newly-created object. This defines how
      objects in the bucket are stored and determines the SLA and the cost of
      storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE,
      COLDLINE, and DURABLE_REDUCED_AVAILABILITY. If this value is not
      specified when the bucket is created, it will default to STANDARD. For
      more information, see storage classes.
    timeCreated: The creation time of the bucket in RFC 3339 format.
    updated: The modification time of the bucket in RFC 3339 format.
    versioning: The bucket's versioning configuration.
    website: The bucket's website configuration, controlling how the service
      behaves when accessing bucket contents as a web site. See the Static
      Website Examples for more information.
  """

  class CorsValueListEntry(_messages.Message):
    """A CorsValueListEntry object.

    Fields:
      maxAgeSeconds: The value, in seconds, to return in the  Access-Control-
        Max-Age header used in preflight responses.
      method: The list of HTTP methods on which to include CORS response
        headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list
        of methods, and means "any method".
      origin: The list of Origins eligible to receive CORS response headers.
        Note: "*" is permitted in the list of origins, and means "any Origin".
      responseHeader: The list of HTTP headers other than the simple response
        headers to give permission for the user-agent to share across domains.
    """

    maxAgeSeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)
    method = _messages.StringField(2, repeated=True)
    origin = _messages.StringField(3, repeated=True)
    responseHeader = _messages.StringField(4, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """User-provided labels, in key/value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: An individual label entry.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class LifecycleValue(_messages.Message):
    """The bucket's lifecycle configuration. See lifecycle management for more
    information.

    Messages:
      RuleValueListEntry: A RuleValueListEntry object.

    Fields:
      rule: A lifecycle management rule, which is made of an action to take
        and the condition(s) under which the action will be taken.
    """

    class RuleValueListEntry(_messages.Message):
      """A RuleValueListEntry object.

      Messages:
        ActionValue: The action to take.
        ConditionValue: The condition(s) under which the action will be taken.

      Fields:
        action: The action to take.
        condition: The condition(s) under which the action will be taken.
      """

      class ActionValue(_messages.Message):
        """The action to take.

        Fields:
          storageClass: Target storage class. Required iff the type of the
            action is SetStorageClass.
          type: Type of the action. Currently, only Delete and SetStorageClass
            are supported.
        """

        storageClass = _messages.StringField(1)
        type = _messages.StringField(2)

      class ConditionValue(_messages.Message):
        """The condition(s) under which the action will be taken.

        Fields:
          age: Age of an object (in days). This condition is satisfied when an
            object reaches the specified age.
          createdBefore: A date in RFC 3339 format with only the date part
            (for instance, "2013-01-15"). This condition is satisfied when an
            object is created before midnight of the specified date in UTC.
          isLive: Relevant only for versioned objects. If the value is true,
            this condition matches live objects; if the value is false, it
            matches archived objects.
          matchesStorageClass: Objects having any of the storage classes
            specified by this condition will be matched. Values include
            MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, STANDARD, and
            DURABLE_REDUCED_AVAILABILITY.
          numNewerVersions: Relevant only for versioned objects. If the value
            is N, this condition is satisfied when there are at least N
            versions (including the live version) newer than this version of
            the object.
        """

        age = _messages.IntegerField(1, variant=_messages.Variant.INT32)
        createdBefore = extra_types.DateField(2)
        isLive = _messages.BooleanField(3)
        matchesStorageClass = _messages.StringField(4, repeated=True)
        numNewerVersions = _messages.IntegerField(5, variant=_messages.Variant.INT32)

      action = _messages.MessageField('ActionValue', 1)
      condition = _messages.MessageField('ConditionValue', 2)

    rule = _messages.MessageField('RuleValueListEntry', 1, repeated=True)

  class LoggingValue(_messages.Message):
    """The bucket's logging configuration, which defines the destination
    bucket and optional name prefix for the current bucket's logs.

    Fields:
      logBucket: The destination bucket where the current bucket's logs should
        be placed.
      logObjectPrefix: A prefix for log object names.
    """

    logBucket = _messages.StringField(1)
    logObjectPrefix = _messages.StringField(2)

  class OwnerValue(_messages.Message):
    """The owner of the bucket. This is always the project team's owner group.

    Fields:
      entity: The entity, in the form project-owner-projectId.
      entityId: The ID for the entity.
    """

    entity = _messages.StringField(1)
    entityId = _messages.StringField(2)

  class VersioningValue(_messages.Message):
    """The bucket's versioning configuration.

    Fields:
      enabled: While set to true, versioning is fully enabled for this bucket.
    """

    enabled = _messages.BooleanField(1)

  class WebsiteValue(_messages.Message):
    """The bucket's website configuration, controlling how the service behaves
    when accessing bucket contents as a web site. See the Static Website
    Examples for more information.

    Fields:
      mainPageSuffix: If the requested object path is missing, the service
        will ensure the path has a trailing '/', append this suffix, and
        attempt to retrieve the resulting object. This allows the creation of
        index.html objects to represent directory pages.
      notFoundPage: If the requested object path is missing, and any
        mainPageSuffix object is missing, if applicable, the service will
        return the named object from this bucket as the content for a 404 Not
        Found result.
    """

    mainPageSuffix = _messages.StringField(1)
    notFoundPage = _messages.StringField(2)

  acl = _messages.MessageField('BucketAccessControl', 1, repeated=True)
  cors = _messages.MessageField('CorsValueListEntry', 2, repeated=True)
  defaultObjectAcl = _messages.MessageField('ObjectAccessControl', 3, repeated=True)
  etag = _messages.StringField(4)
  id = _messages.StringField(5)
  kind = _messages.StringField(6, default=u'storage#bucket')
  labels = _messages.MessageField('LabelsValue', 7)
  lifecycle = _messages.MessageField('LifecycleValue', 8)
  location = _messages.StringField(9)
  logging = _messages.MessageField('LoggingValue', 10)
  metageneration = _messages.IntegerField(11)
  name = _messages.StringField(12)
  owner = _messages.MessageField('OwnerValue', 13)
  projectNumber = _messages.IntegerField(14, variant=_messages.Variant.UINT64)
  selfLink = _messages.StringField(15)
  storageClass = _messages.StringField(16)
  timeCreated = _message_types.DateTimeField(17)
  updated = _message_types.DateTimeField(18)
  versioning = _messages.MessageField('VersioningValue', 19)
  website = _messages.MessageField('WebsiteValue', 20)


class BucketAccessControl(_messages.Message):
  """An access-control entry.

  Messages:
    ProjectTeamValue: The project team associated with the entity, if any.

  Fields:
    bucket: The name of the bucket.
    domain: The domain associated with the entity, if any.
    email: The email address associated with the entity, if any.
    entity: The entity holding the permission, in one of the following forms:
      - user-userId  - user-email  - group-groupId  - group-email  - domain-
      domain  - project-team-projectId  - allUsers  - allAuthenticatedUsers
      Examples:  - The user liz@example.com would be user-liz@example.com.  -
      The group example@googlegroups.com would be group-
      example@googlegroups.com.  - To refer to all members of the Google Apps
      for Business domain example.com, the entity would be domain-example.com.
    entityId: The ID for the entity, if any.
    etag: HTTP 1.1 Entity tag for the access-control entry.
    id: The ID of the access-control entry.
    kind: The kind of item this is. For bucket access control entries, this is
      always storage#bucketAccessControl.
    projectTeam: The project team associated with the entity, if any.
    role: The access permission for the entity.
    selfLink: The link to this access-control entry.
  """

  class ProjectTeamValue(_messages.Message):
    """The project team associated with the entity, if any.

    Fields:
      projectNumber: The project number.
      team: The team.
    """

    projectNumber = _messages.StringField(1)
    team = _messages.StringField(2)

  bucket = _messages.StringField(1)
  domain = _messages.StringField(2)
  email = _messages.StringField(3)
  entity = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  id = _messages.StringField(7)
  kind = _messages.StringField(8, default=u'storage#bucketAccessControl')
  projectTeam = _messages.MessageField('ProjectTeamValue', 9)
  role = _messages.StringField(10)
  selfLink = _messages.StringField(11)


class BucketAccessControls(_messages.Message):
  """An access-control list.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of bucket access control
      entries, this is always storage#bucketAccessControls.
  """

  items = _messages.MessageField('BucketAccessControl', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#bucketAccessControls')


class Buckets(_messages.Message):
  """A list of buckets.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of buckets, this is always
      storage#buckets.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('Bucket', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#buckets')
  nextPageToken = _messages.StringField(3)


class Channel(_messages.Message):
  """An notification channel used to watch for resource changes.

  Messages:
    ParamsValue: Additional parameters controlling delivery channel behavior.
      Optional.

  Fields:
    address: The address where notifications are delivered for this channel.
    expiration: Date and time of notification channel expiration, expressed as
      a Unix timestamp, in milliseconds. Optional.
    id: A UUID or similar unique string that identifies this channel.
    kind: Identifies this as a notification channel used to watch for changes
      to a resource. Value: the fixed string "api#channel".
    params: Additional parameters controlling delivery channel behavior.
      Optional.
    payload: A Boolean value to indicate whether payload is wanted. Optional.
    resourceId: An opaque ID that identifies the resource being watched on
      this channel. Stable across different API versions.
    resourceUri: A version-specific identifier for the watched resource.
    token: An arbitrary string delivered to the target address with each
      notification delivered over this channel. Optional.
    type: The type of delivery mechanism used for this channel.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    """Additional parameters controlling delivery channel behavior. Optional.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Declares a new parameter by name.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  expiration = _messages.IntegerField(2)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'api#channel')
  params = _messages.MessageField('ParamsValue', 5)
  payload = _messages.BooleanField(6)
  resourceId = _messages.StringField(7)
  resourceUri = _messages.StringField(8)
  token = _messages.StringField(9)
  type = _messages.StringField(10)


class ComposeRequest(_messages.Message):
  """A Compose request.

  Messages:
    SourceObjectsValueListEntry: A SourceObjectsValueListEntry object.

  Fields:
    destination: Properties of the resulting object.
    kind: The kind of item this is.
    sourceObjects: The list of source objects that will be concatenated into a
      single object.
  """

  class SourceObjectsValueListEntry(_messages.Message):
    """A SourceObjectsValueListEntry object.

    Messages:
      ObjectPreconditionsValue: Conditions that must be met for this operation
        to execute.

    Fields:
      generation: The generation of this object to use as the source.
      name: The source object's name. The source object's bucket is implicitly
        the destination bucket.
      objectPreconditions: Conditions that must be met for this operation to
        execute.
    """

    class ObjectPreconditionsValue(_messages.Message):
      """Conditions that must be met for this operation to execute.

      Fields:
        ifGenerationMatch: Only perform the composition if the generation of
          the source object that would be used matches this value. If this
          value and a generation are both specified, they must be the same
          value or the call will fail.
      """

      ifGenerationMatch = _messages.IntegerField(1)

    generation = _messages.IntegerField(1)
    name = _messages.StringField(2)
    objectPreconditions = _messages.MessageField('ObjectPreconditionsValue', 3)

  destination = _messages.MessageField('Object', 1)
  kind = _messages.StringField(2, default=u'storage#composeRequest')
  sourceObjects = _messages.MessageField('SourceObjectsValueListEntry', 3, repeated=True)


class Notification(_messages.Message):
  """A subscription to receive Google PubSub notifications.

  Messages:
    CustomAttributesValue: An optional list of additional attributes to attach
      to each Cloud PubSub message published for this notification
      subscription.

  Fields:
    custom_attributes: An optional list of additional attributes to attach to
      each Cloud PubSub message published for this notification subscription.
    etag: HTTP 1.1 Entity tag for this subscription notification.
    event_types: If present, only send notifications about listed event types.
      If empty, sent notifications for all event types.
    id: The ID of the notification.
    kind: The kind of item this is. For notifications, this is always
      storage#notification.
    object_name_prefix: If present, only apply this notification configuration
      to object names that begin with this prefix.
    payload_format: The desired content of the Payload.
    selfLink: The canonical URL of this notification.
    topic: The Cloud PubSub topic to which this subscription publishes.
      Formatted as: '//pubsub.googleapis.com/projects/{project-
      identifier}/topics/{my-topic}'
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CustomAttributesValue(_messages.Message):
    """An optional list of additional attributes to attach to each Cloud
    PubSub message published for this notification subscription.

    Messages:
      AdditionalProperty: An additional property for a CustomAttributesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        CustomAttributesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a CustomAttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  custom_attributes = _messages.MessageField('CustomAttributesValue', 1)
  etag = _messages.StringField(2)
  event_types = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'storage#notification')
  object_name_prefix = _messages.StringField(6)
  payload_format = _messages.StringField(7, default=u'JSON_API_V1')
  selfLink = _messages.StringField(8)
  topic = _messages.StringField(9)


class Notifications(_messages.Message):
  """A list of notification subscriptions.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of notifications, this is always
      storage#notifications.
  """

  items = _messages.MessageField('Notification', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#notifications')


class Object(_messages.Message):
  """An object.

  Messages:
    CustomerEncryptionValue: Metadata of customer-supplied encryption key, if
      the object is encrypted by such a key.
    MetadataValue: User-provided metadata, in key/value pairs.
    OwnerValue: The owner of the object. This will always be the uploader of
      the object.

  Fields:
    acl: Access controls on the object.
    bucket: The name of the bucket containing this object.
    cacheControl: Cache-Control directive for the object data. If omitted, and
      the object is accessible to all anonymous users, the default will be
      public, max-age=3600.
    componentCount: Number of underlying components that make up this object.
      Components are accumulated by compose operations.
    contentDisposition: Content-Disposition of the object data.
    contentEncoding: Content-Encoding of the object data.
    contentLanguage: Content-Language of the object data.
    contentType: Content-Type of the object data. If contentType is not
      specified, object downloads will be served as application/octet-stream.
    crc32c: CRC32c checksum, as described in RFC 4960, Appendix B; encoded
      using base64 in big-endian byte order. For more information about using
      the CRC32c checksum, see Hashes and ETags: Best Practices.
    customerEncryption: Metadata of customer-supplied encryption key, if the
      object is encrypted by such a key.
    etag: HTTP 1.1 Entity tag for the object.
    generation: The content generation of this object. Used for object
      versioning.
    id: The ID of the object, including the bucket name, object name, and
      generation number.
    kind: The kind of item this is. For objects, this is always
      storage#object.
    md5Hash: MD5 hash of the data; encoded using base64. For more information
      about using the MD5 hash, see Hashes and ETags: Best Practices.
    mediaLink: Media download link.
    metadata: User-provided metadata, in key/value pairs.
    metageneration: The version of the metadata for this object at this
      generation. Used for preconditions and for detecting changes in
      metadata. A metageneration number is only meaningful in the context of a
      particular generation of a particular object.
    name: The name of the object. Required if not specified by URL parameter.
    owner: The owner of the object. This will always be the uploader of the
      object.
    selfLink: The link to this object.
    size: Content-Length of the data in bytes.
    storageClass: Storage class of the object.
    timeCreated: The creation time of the object in RFC 3339 format.
    timeDeleted: The deletion time of the object in RFC 3339 format. Will be
      returned if and only if this version of the object has been deleted.
    timeStorageClassUpdated: The time at which the object's storage class was
      last changed. When the object is initially created, it will be set to
      timeCreated.
    updated: The modification time of the object metadata in RFC 3339 format.
  """

  class CustomerEncryptionValue(_messages.Message):
    """Metadata of customer-supplied encryption key, if the object is
    encrypted by such a key.

    Fields:
      encryptionAlgorithm: The encryption algorithm.
      keySha256: SHA256 hash value of the encryption key.
    """

    encryptionAlgorithm = _messages.StringField(1)
    keySha256 = _messages.StringField(2)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """User-provided metadata, in key/value pairs.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: An individual metadata entry.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class OwnerValue(_messages.Message):
    """The owner of the object. This will always be the uploader of the
    object.

    Fields:
      entity: The entity, in the form user-userId.
      entityId: The ID for the entity.
    """

    entity = _messages.StringField(1)
    entityId = _messages.StringField(2)

  acl = _messages.MessageField('ObjectAccessControl', 1, repeated=True)
  bucket = _messages.StringField(2)
  cacheControl = _messages.StringField(3)
  componentCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  contentDisposition = _messages.StringField(5)
  contentEncoding = _messages.StringField(6)
  contentLanguage = _messages.StringField(7)
  contentType = _messages.StringField(8)
  crc32c = _messages.StringField(9)
  customerEncryption = _messages.MessageField('CustomerEncryptionValue', 10)
  etag = _messages.StringField(11)
  generation = _messages.IntegerField(12)
  id = _messages.StringField(13)
  kind = _messages.StringField(14, default=u'storage#object')
  md5Hash = _messages.StringField(15)
  mediaLink = _messages.StringField(16)
  metadata = _messages.MessageField('MetadataValue', 17)
  metageneration = _messages.IntegerField(18)
  name = _messages.StringField(19)
  owner = _messages.MessageField('OwnerValue', 20)
  selfLink = _messages.StringField(21)
  size = _messages.IntegerField(22, variant=_messages.Variant.UINT64)
  storageClass = _messages.StringField(23)
  timeCreated = _message_types.DateTimeField(24)
  timeDeleted = _message_types.DateTimeField(25)
  timeStorageClassUpdated = _message_types.DateTimeField(26)
  updated = _message_types.DateTimeField(27)


class ObjectAccessControl(_messages.Message):
  """An access-control entry.

  Messages:
    ProjectTeamValue: The project team associated with the entity, if any.

  Fields:
    bucket: The name of the bucket.
    domain: The domain associated with the entity, if any.
    email: The email address associated with the entity, if any.
    entity: The entity holding the permission, in one of the following forms:
      - user-userId  - user-email  - group-groupId  - group-email  - domain-
      domain  - project-team-projectId  - allUsers  - allAuthenticatedUsers
      Examples:  - The user liz@example.com would be user-liz@example.com.  -
      The group example@googlegroups.com would be group-
      example@googlegroups.com.  - To refer to all members of the Google Apps
      for Business domain example.com, the entity would be domain-example.com.
    entityId: The ID for the entity, if any.
    etag: HTTP 1.1 Entity tag for the access-control entry.
    generation: The content generation of the object, if applied to an object.
    id: The ID of the access-control entry.
    kind: The kind of item this is. For object access control entries, this is
      always storage#objectAccessControl.
    object: The name of the object, if applied to an object.
    projectTeam: The project team associated with the entity, if any.
    role: The access permission for the entity.
    selfLink: The link to this access-control entry.
  """

  class ProjectTeamValue(_messages.Message):
    """The project team associated with the entity, if any.

    Fields:
      projectNumber: The project number.
      team: The team.
    """

    projectNumber = _messages.StringField(1)
    team = _messages.StringField(2)

  bucket = _messages.StringField(1)
  domain = _messages.StringField(2)
  email = _messages.StringField(3)
  entity = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  generation = _messages.IntegerField(7)
  id = _messages.StringField(8)
  kind = _messages.StringField(9, default=u'storage#objectAccessControl')
  object = _messages.StringField(10)
  projectTeam = _messages.MessageField('ProjectTeamValue', 11)
  role = _messages.StringField(12)
  selfLink = _messages.StringField(13)


class ObjectAccessControls(_messages.Message):
  """An access-control list.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of object access control
      entries, this is always storage#objectAccessControls.
  """

  items = _messages.MessageField('ObjectAccessControl', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#objectAccessControls')


class Objects(_messages.Message):
  """A list of objects.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of objects, this is always
      storage#objects.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
    prefixes: The list of prefixes of objects matching-but-not-listed up to
      and including the requested delimiter.
  """

  items = _messages.MessageField('Object', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#objects')
  nextPageToken = _messages.StringField(3)
  prefixes = _messages.StringField(4, repeated=True)


class Policy(_messages.Message):
  """A bucket/object IAM policy.

  Messages:
    BindingsValueListEntry: A BindingsValueListEntry object.

  Fields:
    bindings: An association between a role, which comes with a set of
      permissions, and members who may assume that role.
    etag: HTTP 1.1  Entity tag for the policy.
    kind: The kind of item this is. For policies, this is always
      storage#policy. This field is ignored on input.
    resourceId: The ID of the resource to which this policy belongs. Will be
      of the form buckets/bucket for buckets, and
      buckets/bucket/objects/object for objects. A specific generation may be
      specified by appending #generationNumber to the end of the object name,
      e.g. buckets/my-bucket/objects/data.txt#17. The current generation can
      be denoted with #0. This field is ignored on input.
  """

  class BindingsValueListEntry(_messages.Message):
    """A BindingsValueListEntry object.

    Fields:
      members: A collection of identifiers for members who may assume the
        provided role. Recognized identifiers are as follows:   - allUsers \u2014 A
        special identifier that represents anyone on the internet; with or
        without a Google account.   - allAuthenticatedUsers \u2014 A special
        identifier that represents anyone who is authenticated with a Google
        account or a service account.   - user:emailid \u2014 An email address that
        represents a specific account. For example, user:alice@gmail.com or
        user:joe@example.com.   - serviceAccount:emailid \u2014 An email address
        that represents a service account. For example,  serviceAccount:my-
        other-app@appspot.gserviceaccount.com .   - group:emailid \u2014 An email
        address that represents a Google group. For example,
        group:admins@example.com.   - domain:domain \u2014 A Google Apps domain
        name that represents all the users of that domain. For example,
        domain:google.com or domain:example.com.   - projectOwner:projectid \u2014
        Owners of the given project. For example, projectOwner:my-example-
        project   - projectEditor:projectid \u2014 Editors of the given project.
        For example, projectEditor:my-example-project   -
        projectViewer:projectid \u2014 Viewers of the given project. For example,
        projectViewer:my-example-project
      role: The role to which members belong. Two types of roles are
        supported: new IAM roles, which grant permissions that do not map
        directly to those provided by ACLs, and legacy IAM roles, which do map
        directly to ACL permissions. All roles are of the format
        roles/storage.specificRole. The new IAM roles are:   -
        roles/storage.admin \u2014 Full control of Google Cloud Storage resources.
        - roles/storage.objectViewer \u2014 Read-Only access to Google Cloud
        Storage objects.   - roles/storage.objectCreator \u2014 Access to create
        objects in Google Cloud Storage.   - roles/storage.objectAdmin \u2014 Full
        control of Google Cloud Storage objects.   The legacy IAM roles are:
        - roles/storage.legacyObjectReader \u2014 Read-only access to objects
        without listing. Equivalent to an ACL entry on an object with the
        READER role.   - roles/storage.legacyObjectOwner \u2014 Read/write access
        to existing objects without listing. Equivalent to an ACL entry on an
        object with the OWNER role.   - roles/storage.legacyBucketReader \u2014
        Read access to buckets with object listing. Equivalent to an ACL entry
        on a bucket with the READER role.   - roles/storage.legacyBucketWriter
        \u2014 Read access to buckets with object listing/creation/deletion.
        Equivalent to an ACL entry on a bucket with the WRITER role.   -
        roles/storage.legacyBucketOwner \u2014 Read and write access to existing
        buckets with object listing/creation/deletion. Equivalent to an ACL
        entry on a bucket with the OWNER role.
    """

    members = _messages.StringField(1, repeated=True)
    role = _messages.StringField(2)

  bindings = _messages.MessageField('BindingsValueListEntry', 1, repeated=True)
  etag = _messages.BytesField(2)
  kind = _messages.StringField(3, default=u'storage#policy')
  resourceId = _messages.StringField(4)


class RewriteResponse(_messages.Message):
  """A rewrite response.

  Fields:
    done: true if the copy is finished; otherwise, false if the copy is in
      progress. This property is always present in the response.
    kind: The kind of item this is.
    objectSize: The total size of the object being copied in bytes. This
      property is always present in the response.
    resource: A resource containing the metadata for the copied-to object.
      This property is present in the response only when copying completes.
    rewriteToken: A token to use in subsequent requests to continue copying
      data. This token is present in the response only when there is more data
      to copy.
    totalBytesRewritten: The total bytes written so far, which can be used to
      provide a waiting user with a progress indicator. This property is
      always present in the response.
  """

  done = _messages.BooleanField(1)
  kind = _messages.StringField(2, default=u'storage#rewriteResponse')
  objectSize = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  resource = _messages.MessageField('Object', 4)
  rewriteToken = _messages.StringField(5)
  totalBytesRewritten = _messages.IntegerField(6, variant=_messages.Variant.UINT64)


class ServiceAccount(_messages.Message):
  """A subscription to receive Google PubSub notifications.

  Fields:
    email_address: The ID of the notification.
    kind: The kind of item this is. For notifications, this is always
      storage#notification.
  """

  email_address = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'storage#serviceAccount')


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class StorageBucketAccessControlsDeleteRequest(_messages.Message):
  """A StorageBucketAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageBucketAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageBucketAccessControlsDelete response."""


class StorageBucketAccessControlsGetRequest(_messages.Message):
  """A StorageBucketAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageBucketAccessControlsListRequest(_messages.Message):
  """A StorageBucketAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
  """

  bucket = _messages.StringField(1, required=True)


class StorageBucketsDeleteRequest(_messages.Message):
  """A StorageBucketsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: If set, only deletes the bucket if its
      metageneration matches this value.
    ifMetagenerationNotMatch: If set, only deletes the bucket if its
      metageneration does not match this value.
  """

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)


class StorageBucketsDeleteResponse(_messages.Message):
  """An empty StorageBucketsDelete response."""


class StorageBucketsGetIamPolicyRequest(_messages.Message):
  """A StorageBucketsGetIamPolicyRequest object.

  Fields:
    bucket: Name of a bucket.
  """

  bucket = _messages.StringField(1, required=True)


class StorageBucketsGetRequest(_messages.Message):
  """A StorageBucketsGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit owner, acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 4)


class StorageBucketsInsertRequest(_messages.Message):
  """A StorageBucketsInsertRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the bucket resource specifies acl or defaultObjectAcl properties,
      when it defaults to full.

  Fields:
    bucket: A Bucket resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    project: A valid API project identifier.
    projection: Set of properties to return. Defaults to noAcl, unless the
      bucket resource specifies acl or defaultObjectAcl properties, when it
      defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the bucket
    resource specifies acl or defaultObjectAcl properties, when it defaults to
    full.

    Values:
      full: Include all properties.
      noAcl: Omit owner, acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.MessageField('Bucket', 1)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 2)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 3)
  project = _messages.StringField(4, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 5)


class StorageBucketsListRequest(_messages.Message):
  """A StorageBucketsListRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    maxResults: Maximum number of buckets to return in a single response. The
      service will use this parameter or 1,000 items, whichever is smaller.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to buckets whose names begin with this prefix.
    project: A valid API project identifier.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit owner, acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.UINT32, default=1000)
  pageToken = _messages.StringField(2)
  prefix = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 5)


class StorageBucketsPatchRequest(_messages.Message):
  """A StorageBucketsPatchRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of a bucket.
    bucketResource: A Bucket resource to be passed as the request body.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit owner, acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  bucketResource = _messages.MessageField('Bucket', 2)
  ifMetagenerationMatch = _messages.IntegerField(3)
  ifMetagenerationNotMatch = _messages.IntegerField(4)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 5)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)


class StorageBucketsSetIamPolicyRequest(_messages.Message):
  """A StorageBucketsSetIamPolicyRequest object.

  Fields:
    bucket: Name of a bucket.
    policy: A Policy resource to be passed as the request body.
  """

  bucket = _messages.StringField(1, required=True)
  policy = _messages.MessageField('Policy', 2)


class StorageBucketsTestIamPermissionsRequest(_messages.Message):
  """A StorageBucketsTestIamPermissionsRequest object.

  Fields:
    bucket: Name of a bucket.
    permissions: Permissions to test.
  """

  bucket = _messages.StringField(1, required=True)
  permissions = _messages.StringField(2, required=True)


class StorageBucketsUpdateRequest(_messages.Message):
  """A StorageBucketsUpdateRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of a bucket.
    bucketResource: A Bucket resource to be passed as the request body.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit owner, acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  bucketResource = _messages.MessageField('Bucket', 2)
  ifMetagenerationMatch = _messages.IntegerField(3)
  ifMetagenerationNotMatch = _messages.IntegerField(4)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 5)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)


class StorageChannelsStopResponse(_messages.Message):
  """An empty StorageChannelsStop response."""


class StorageDefaultObjectAccessControlsDeleteRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageDefaultObjectAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageDefaultObjectAccessControlsDelete response."""


class StorageDefaultObjectAccessControlsGetRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageDefaultObjectAccessControlsListRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: If present, only return default ACL listing if the
      bucket's current metageneration matches this value.
    ifMetagenerationNotMatch: If present, only return default ACL listing if
      the bucket's current metageneration does not match the given value.
  """

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)


class StorageNotificationsDeleteRequest(_messages.Message):
  """A StorageNotificationsDeleteRequest object.

  Fields:
    bucket: The parent bucket of the notification.
    notification: ID of the notification to delete.
  """

  bucket = _messages.StringField(1, required=True)
  notification = _messages.StringField(2, required=True)


class StorageNotificationsDeleteResponse(_messages.Message):
  """An empty StorageNotificationsDelete response."""


class StorageNotificationsGetRequest(_messages.Message):
  """A StorageNotificationsGetRequest object.

  Fields:
    bucket: The parent bucket of the notification.
    notification: Notification ID
  """

  bucket = _messages.StringField(1, required=True)
  notification = _messages.StringField(2, required=True)


class StorageNotificationsInsertRequest(_messages.Message):
  """A StorageNotificationsInsertRequest object.

  Fields:
    bucket: The parent bucket of the notification.
    notification: A Notification resource to be passed as the request body.
  """

  bucket = _messages.StringField(1, required=True)
  notification = _messages.MessageField('Notification', 2)


class StorageNotificationsListRequest(_messages.Message):
  """A StorageNotificationsListRequest object.

  Fields:
    bucket: Name of a GCS bucket.
  """

  bucket = _messages.StringField(1, required=True)


class StorageObjectAccessControlsDeleteRequest(_messages.Message):
  """A StorageObjectAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)


class StorageObjectAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageObjectAccessControlsDelete response."""


class StorageObjectAccessControlsGetRequest(_messages.Message):
  """A StorageObjectAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)


class StorageObjectAccessControlsInsertRequest(_messages.Message):
  """A StorageObjectAccessControlsInsertRequest object.

  Fields:
    bucket: Name of a bucket.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 4)


class StorageObjectAccessControlsListRequest(_messages.Message):
  """A StorageObjectAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)


class StorageObjectAccessControlsPatchRequest(_messages.Message):
  """A StorageObjectAccessControlsPatchRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 5)


class StorageObjectAccessControlsUpdateRequest(_messages.Message):
  """A StorageObjectAccessControlsUpdateRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 5)


class StorageObjectsComposeRequest(_messages.Message):
  """A StorageObjectsComposeRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.

  Fields:
    composeRequest: A ComposeRequest resource to be passed as the request
      body.
    destinationBucket: Name of the bucket in which to store the new object.
    destinationObject: Name of the new object. For information about how to
      URL encode object names to be path safe, see Encoding URI Path Parts.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  composeRequest = _messages.MessageField('ComposeRequest', 1)
  destinationBucket = _messages.StringField(2, required=True)
  destinationObject = _messages.StringField(3, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 4)
  ifGenerationMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)


class StorageObjectsCopyRequest(_messages.Message):
  """A StorageObjectsCopyRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    destinationBucket: Name of the bucket in which to store the new object.
      Overrides the provided object metadata's bucket value, if any.For
      information about how to URL encode object names to be path safe, see
      Encoding URI Path Parts.
    destinationObject: Name of the new object. Required when the object
      metadata is not otherwise provided. Overrides the object metadata's name
      value, if any.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the
      destination object's current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      destination object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      destination object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      destination object's current metageneration does not match the given
      value.
    ifSourceGenerationMatch: Makes the operation conditional on whether the
      source object's generation matches the given value.
    ifSourceGenerationNotMatch: Makes the operation conditional on whether the
      source object's generation does not match the given value.
    ifSourceMetagenerationMatch: Makes the operation conditional on whether
      the source object's current metageneration matches the given value.
    ifSourceMetagenerationNotMatch: Makes the operation conditional on whether
      the source object's current metageneration does not match the given
      value.
    object: A Object resource to be passed as the request body.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
    sourceBucket: Name of the bucket in which to find the source object.
    sourceGeneration: If present, selects a specific revision of the source
      object (as opposed to the latest version, the default).
    sourceObject: Name of the source object. For information about how to URL
      encode object names to be path safe, see Encoding URI Path Parts.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  destinationBucket = _messages.StringField(1, required=True)
  destinationObject = _messages.StringField(2, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 3)
  ifGenerationMatch = _messages.IntegerField(4)
  ifGenerationNotMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)
  ifMetagenerationNotMatch = _messages.IntegerField(7)
  ifSourceGenerationMatch = _messages.IntegerField(8)
  ifSourceGenerationNotMatch = _messages.IntegerField(9)
  ifSourceMetagenerationMatch = _messages.IntegerField(10)
  ifSourceMetagenerationNotMatch = _messages.IntegerField(11)
  object = _messages.MessageField('Object', 12)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 13)
  sourceBucket = _messages.StringField(14, required=True)
  sourceGeneration = _messages.IntegerField(15)
  sourceObject = _messages.StringField(16, required=True)


class StorageObjectsDeleteRequest(_messages.Message):
  """A StorageObjectsDeleteRequest object.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, permanently deletes a specific revision of this
      object (as opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)


class StorageObjectsDeleteResponse(_messages.Message):
  """An empty StorageObjectsDelete response."""


class StorageObjectsGetIamPolicyRequest(_messages.Message):
  """A StorageObjectsGetIamPolicyRequest object.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)


class StorageObjectsGetRequest(_messages.Message):
  """A StorageObjectsGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 8)


class StorageObjectsInsertRequest(_messages.Message):
  """A StorageObjectsInsertRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    bucket: Name of the bucket in which to store the new object. Overrides the
      provided object metadata's bucket value, if any.
    contentEncoding: If set, sets the contentEncoding property of the final
      object to this value. Setting this parameter is equivalent to setting
      the contentEncoding metadata property. This can be useful when uploading
      an object with uploadType=media to indicate the encoding of the content
      being uploaded.
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    name: Name of the object. Required when the object metadata is not
      otherwise provided. Overrides the object metadata's name value, if any.
      For information about how to URL encode object names to be path safe,
      see Encoding URI Path Parts.
    object: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  contentEncoding = _messages.StringField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  name = _messages.StringField(7)
  object = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsListRequest(_messages.Message):
  """A StorageObjectsListRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which to look for objects.
    delimiter: Returns results in a directory-like mode. items will contain
      only objects whose names, aside from the prefix, do not contain
      delimiter. Objects whose names, aside from the prefix, contain delimiter
      will have their name, truncated after the delimiter, returned in
      prefixes. Duplicate prefixes are omitted.
    maxResults: Maximum number of items plus prefixes to return in a single
      page of responses. As duplicate prefixes are omitted, fewer total
      results may be returned than requested. The service will use this
      parameter or 1,000 items, whichever is smaller.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to objects whose names begin with this prefix.
    projection: Set of properties to return. Defaults to noAcl.
    versions: If true, lists all versions of an object as distinct results.
      The default is false. For more information, see Object Versioning.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  delimiter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=1000)
  pageToken = _messages.StringField(4)
  prefix = _messages.StringField(5)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 6)
  versions = _messages.BooleanField(7)


class StorageObjectsPatchRequest(_messages.Message):
  """A StorageObjectsPatchRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectResource: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  objectResource = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsRewriteRequest(_messages.Message):
  """A StorageObjectsRewriteRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    destinationBucket: Name of the bucket in which to store the new object.
      Overrides the provided object metadata's bucket value, if any.
    destinationObject: Name of the new object. Required when the object
      metadata is not otherwise provided. Overrides the object metadata's name
      value, if any. For information about how to URL encode object names to
      be path safe, see Encoding URI Path Parts.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the
      destination object's current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      destination object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      destination object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      destination object's current metageneration does not match the given
      value.
    ifSourceGenerationMatch: Makes the operation conditional on whether the
      source object's generation matches the given value.
    ifSourceGenerationNotMatch: Makes the operation conditional on whether the
      source object's generation does not match the given value.
    ifSourceMetagenerationMatch: Makes the operation conditional on whether
      the source object's current metageneration matches the given value.
    ifSourceMetagenerationNotMatch: Makes the operation conditional on whether
      the source object's current metageneration does not match the given
      value.
    maxBytesRewrittenPerCall: The maximum number of bytes that will be
      rewritten per rewrite request. Most callers shouldn't need to specify
      this parameter - it is primarily in place to support testing. If
      specified the value must be an integral multiple of 1 MiB (1048576).
      Also, this only applies to requests where the source and destination
      span locations and/or storage classes. Finally, this value must not
      change across rewrite calls else you'll get an error that the
      rewriteToken is invalid.
    object: A Object resource to be passed as the request body.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
    rewriteToken: Include this field (from the previous rewrite response) on
      each rewrite request after the first one, until the rewrite response
      'done' flag is true. Calls that provide a rewriteToken can omit all
      other request fields, but if included those fields must match the values
      provided in the first rewrite request.
    sourceBucket: Name of the bucket in which to find the source object.
    sourceGeneration: If present, selects a specific revision of the source
      object (as opposed to the latest version, the default).
    sourceObject: Name of the source object. For information about how to URL
      encode object names to be path safe, see Encoding URI Path Parts.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  destinationBucket = _messages.StringField(1, required=True)
  destinationObject = _messages.StringField(2, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 3)
  ifGenerationMatch = _messages.IntegerField(4)
  ifGenerationNotMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)
  ifMetagenerationNotMatch = _messages.IntegerField(7)
  ifSourceGenerationMatch = _messages.IntegerField(8)
  ifSourceGenerationNotMatch = _messages.IntegerField(9)
  ifSourceMetagenerationMatch = _messages.IntegerField(10)
  ifSourceMetagenerationNotMatch = _messages.IntegerField(11)
  maxBytesRewrittenPerCall = _messages.IntegerField(12)
  object = _messages.MessageField('Object', 13)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 14)
  rewriteToken = _messages.StringField(15)
  sourceBucket = _messages.StringField(16, required=True)
  sourceGeneration = _messages.IntegerField(17)
  sourceObject = _messages.StringField(18, required=True)


class StorageObjectsSetIamPolicyRequest(_messages.Message):
  """A StorageObjectsSetIamPolicyRequest object.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    policy: A Policy resource to be passed as the request body.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)
  policy = _messages.MessageField('Policy', 4)


class StorageObjectsTestIamPermissionsRequest(_messages.Message):
  """A StorageObjectsTestIamPermissionsRequest object.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    permissions: Permissions to test.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)
  permissions = _messages.StringField(4, required=True)


class StorageObjectsUpdateRequest(_messages.Message):
  """A StorageObjectsUpdateRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectResource: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  objectResource = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsWatchAllRequest(_messages.Message):
  """A StorageObjectsWatchAllRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which to look for objects.
    channel: A Channel resource to be passed as the request body.
    delimiter: Returns results in a directory-like mode. items will contain
      only objects whose names, aside from the prefix, do not contain
      delimiter. Objects whose names, aside from the prefix, contain delimiter
      will have their name, truncated after the delimiter, returned in
      prefixes. Duplicate prefixes are omitted.
    maxResults: Maximum number of items plus prefixes to return in a single
      page of responses. As duplicate prefixes are omitted, fewer total
      results may be returned than requested. The service will use this
      parameter or 1,000 items, whichever is smaller.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to objects whose names begin with this prefix.
    projection: Set of properties to return. Defaults to noAcl.
    versions: If true, lists all versions of an object as distinct results.
      The default is false. For more information, see Object Versioning.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the owner, acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  channel = _messages.MessageField('Channel', 2)
  delimiter = _messages.StringField(3)
  maxResults = _messages.IntegerField(4, variant=_messages.Variant.UINT32, default=1000)
  pageToken = _messages.StringField(5)
  prefix = _messages.StringField(6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)
  versions = _messages.BooleanField(8)


class StorageProjectsServiceAccountGetRequest(_messages.Message):
  """A StorageProjectsServiceAccountGetRequest object.

  Fields:
    projectId: Project ID
  """

  projectId = _messages.StringField(1, required=True)


class TestIamPermissionsResponse(_messages.Message):
  """A storage.(buckets|objects).testIamPermissions response.

  Fields:
    kind: The kind of item this is.
    permissions: The permissions held by the caller. Permissions are always of
      the format storage.resource.capability, where resource is one of buckets
      or objects. The supported permissions are as follows:   -
      storage.buckets.delete \u2014 Delete bucket.   - storage.buckets.get \u2014 Read
      bucket metadata.   - storage.buckets.getIamPolicy \u2014 Read bucket IAM
      policy.   - storage.buckets.create \u2014 Create bucket.   -
      storage.buckets.list \u2014 List buckets.   - storage.buckets.setIamPolicy \u2014
      Update bucket IAM policy.   - storage.buckets.update \u2014 Update bucket
      metadata.   - storage.objects.delete \u2014 Delete object.   -
      storage.objects.get \u2014 Read object data and metadata.   -
      storage.objects.getIamPolicy \u2014 Read object IAM policy.   -
      storage.objects.create \u2014 Create object.   - storage.objects.list \u2014 List
      objects.   - storage.objects.setIamPolicy \u2014 Update object IAM policy.
      - storage.objects.update \u2014 Update object metadata.
  """

  kind = _messages.StringField(1, default=u'storage#testIamPermissionsResponse')
  permissions = _messages.StringField(2, repeated=True)


