"""Generated message classes for servicemanagement version v1.

Google Service Management allows service producers to publish their services
on Google Cloud Platform so that they can be discovered and used by service
consumers.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'servicemanagement'


class Advice(_messages.Message):
  """Generated advice about this change, used for providing more information
  about how a change will affect the existing service.

  Fields:
    description: Useful description for why this advice was applied and what
      actions should be taken to mitigate any implied risks.
  """

  description = _messages.StringField(1)


class Api(_messages.Message):
  """Api is a light-weight descriptor for a protocol buffer service.

  Enums:
    SyntaxValueValuesEnum: The source syntax of the service.

  Fields:
    methods: The methods of this api, in unspecified order.
    mixins: Included APIs. See Mixin.
    name: The fully qualified name of this api, including package name
      followed by the api's simple name.
    options: Any metadata attached to the API.
    sourceContext: Source context for the protocol buffer service represented
      by this message.
    syntax: The source syntax of the service.
    version: A version string for this api. If specified, must have the form
      `major-version.minor-version`, as in `1.10`. If the minor version is
      omitted, it defaults to zero. If the entire version field is empty, the
      major version is derived from the package name, as outlined below. If
      the field is not empty, the version in the package name will be verified
      to be consistent with what is provided here.  The versioning schema uses
      [semantic versioning](http://semver.org) where the major version number
      indicates a breaking change and the minor version an additive, non-
      breaking change. Both version numbers are signals to users what to
      expect from different versions, and should be carefully chosen based on
      the product plan.  The major version is also reflected in the package
      name of the API, which must end in `v<major-version>`, as in
      `google.feature.v1`. For major versions 0 and 1, the suffix can be
      omitted. Zero major versions must only be used for experimental, none-GA
      apis.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    """The source syntax of the service.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  methods = _messages.MessageField('Method', 1, repeated=True)
  mixins = _messages.MessageField('Mixin', 2, repeated=True)
  name = _messages.StringField(3)
  options = _messages.MessageField('Option', 4, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 5)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 6)
  version = _messages.StringField(7)


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConifg must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted. Example Policy with
  multiple AuditConfigs: {   "audit_configs": [     {       "service":
  "allServices"       "audit_log_configs": [         {           "log_type":
  "DATA_READ",           "exempted_members": [
  "user:foo@gmail.com"           ]         },         {           "log_type":
  "DATA_WRITE",         },         {           "log_type": "ADMIN_READ",
  }       ]     },     {       "service": "fooservice@googleapis.com"
  "audit_log_configs": [         {           "log_type": "DATA_READ",
  },         {           "log_type": "DATA_WRITE",
  "exempted_members": [             "user:bar@gmail.com"           ]         }
  ]     }   ] } For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
      Next ID: 4
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    """The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthProvider(_messages.Message):
  """Configuration for an anthentication provider, including support for [JSON
  Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-
  token-32).

  Fields:
    audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-
      ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access.
      A JWT containing any of these audiences will be accepted. When this
      setting is absent, only JWTs with audience
      "https://Service_name/API_name" will be accepted. For example, if no
      audiences are in the setting, LibraryService API will only accept JWTs
      with the following audience "https://library-
      example.googleapis.com/google.example.library.v1.LibraryService".
      Example:      audiences: bookstore_android.apps.googleusercontent.com,
      bookstore_web.apps.googleusercontent.com
    id: The unique identifier of the auth provider. It will be referred to by
      `AuthRequirement.provider_id`.  Example: "bookstore_auth".
    issuer: Identifies the principal that issued the JWT. See
      https://tools.ietf.org/html/draft-ietf-oauth-json-web-
      token-32#section-4.1.1 Usually a URL or an email address.  Example:
      https://securetoken.google.com Example:
      1234567-compute@developer.gserviceaccount.com
    jwksUri: URL of the provider's public key set to validate signature of the
      JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-
      discovery-1_0.html#ProviderMetadata). Optional if the key set document:
      - can be retrieved from    [OpenID Discovery](https://openid.net/specs
      /openid-connect-discovery-1_0.html    of the issuer.  - can be inferred
      from the email domain of the issuer (e.g. a Google service account).
      Example: https://www.googleapis.com/oauth2/v1/certs
  """

  audiences = _messages.StringField(1)
  id = _messages.StringField(2)
  issuer = _messages.StringField(3)
  jwksUri = _messages.StringField(4)


class AuthRequirement(_messages.Message):
  """User-defined authentication requirements, including support for [JSON Web
  Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-
  token-32).

  Fields:
    audiences: NOTE: This will be deprecated soon, once AuthProvider.audiences
      is implemented and accepted in all the runtime components.  The list of
      JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-
      token-32#section-4.1.3). that are allowed to access. A JWT containing
      any of these audiences will be accepted. When this setting is absent,
      only JWTs with audience "https://Service_name/API_name" will be
      accepted. For example, if no audiences are in the setting,
      LibraryService API will only accept JWTs with the following audience
      "https://library-
      example.googleapis.com/google.example.library.v1.LibraryService".
      Example:      audiences: bookstore_android.apps.googleusercontent.com,
      bookstore_web.apps.googleusercontent.com
    providerId: id from authentication provider.  Example:      provider_id:
      bookstore_auth
  """

  audiences = _messages.StringField(1)
  providerId = _messages.StringField(2)


class Authentication(_messages.Message):
  """`Authentication` defines the authentication configuration for an API.
  Example for an API targeted for external use:      name:
  calendar.googleapis.com     authentication:       providers:       - id:
  google_calendar_auth         jwks_uri:
  https://www.googleapis.com/oauth2/v1/certs         issuer:
  https://securetoken.google.com       rules:       - selector: "*"
  requirements:           provider_id: google_calendar_auth

  Fields:
    providers: Defines a set of authentication providers that a service
      supports.
    rules: A list of authentication rules that apply to individual API
      methods.  **NOTE:** All service configuration rules follow "last one
      wins" order.
  """

  providers = _messages.MessageField('AuthProvider', 1, repeated=True)
  rules = _messages.MessageField('AuthenticationRule', 2, repeated=True)


class AuthenticationRule(_messages.Message):
  """Authentication rules for the service.  By default, if a method has any
  authentication requirements, every request must include a valid credential
  matching one of the requirements. It's an error to include more than one
  kind of credential in a single request.  If a method doesn't have any auth
  requirements, request credentials will be ignored.

  Fields:
    allowWithoutCredential: Whether to allow requests without a credential.
      The credential can be an OAuth token, Google cookies (first-party auth)
      or EndUserCreds.  For requests without credentials, if the service
      control environment is specified, each incoming request **must** be
      associated with a service consumer. This can be done by passing an API
      key that belongs to a consumer project.
    oauth: The requirements for OAuth credentials.
    requirements: Requirements for additional authentication providers.
    selector: Selects the methods to which this rule applies.  Refer to
      selector for syntax details.
  """

  allowWithoutCredential = _messages.BooleanField(1)
  oauth = _messages.MessageField('OAuthRequirements', 2)
  requirements = _messages.MessageField('AuthRequirement', 3, repeated=True)
  selector = _messages.StringField(4)


class AuthorizationConfig(_messages.Message):
  """Configuration of authorization.  This section determines the
  authorization provider, if unspecified, then no authorization check will be
  done.  Example:      experimental:       authorization:         provider:
  firebaserules.googleapis.com

  Fields:
    provider: The name of the authorization provider, such as
      firebaserules.googleapis.com.
  """

  provider = _messages.StringField(1)


class Backend(_messages.Message):
  """`Backend` defines the backend configuration for a service.

  Fields:
    rules: A list of API backend rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('BackendRule', 1, repeated=True)


class BackendRule(_messages.Message):
  """A backend rule provides configuration for an individual API element.

  Fields:
    address: The address of the API backend.
    deadline: The number of seconds to wait for a response from a request.
      The default depends on the deployment context.
    selector: Selects the methods to which this rule applies.  Refer to
      selector for syntax details.
  """

  address = _messages.StringField(1)
  deadline = _messages.FloatField(2)
  selector = _messages.StringField(3)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class ChangeReport(_messages.Message):
  """Change report associated with a particular service configuration.  It
  contains a list of ConfigChanges based on the comparison between two service
  configurations.

  Fields:
    configChanges: List of changes between two service configurations. The
      changes will be alphabetically sorted based on the identifier of each
      change. A ConfigChange identifier is a dot separated path to the
      configuration. Example:
      visibility.rules[selector='LibraryService.CreateBook'].restriction
  """

  configChanges = _messages.MessageField('ConfigChange', 1, repeated=True)


class CloudAuditOptions(_messages.Message):
  """Write a Cloud Audit log"""


class CompositeOperationMetadata(_messages.Message):
  """Metadata for composite operations.

  Messages:
    OriginalRequestValue: Original request that triggered this operation.
    ResponseFieldMasksValue: Defines which part of the response a child
      operation will contribute. Each key of the map is the name of a child
      operation. Each value is a field mask that identifies what that child
      operation contributes to the response, for example, "quota_settings",
      "visiblity_settings", etc.

  Fields:
    childOperations: The child operations. The details of the asynchronous
      child operations are stored in a separate row and not in this metadata.
      Only the operation name is stored here.
    originalRequest: Original request that triggered this operation.
    persisted: Indicates whether the requested state change has been
      persisted. Once this field is set, it is guaranteed to propagate to all
      backends eventually, but it may not be visible immediately. Clients that
      are not concerned with waiting on propagation can stop polling the
      operation once the persisted field is set
    responseFieldMasks: Defines which part of the response a child operation
      will contribute. Each key of the map is the name of a child operation.
      Each value is a field mask that identifies what that child operation
      contributes to the response, for example, "quota_settings",
      "visiblity_settings", etc.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OriginalRequestValue(_messages.Message):
    """Original request that triggered this operation.

    Messages:
      AdditionalProperty: An additional property for a OriginalRequestValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a OriginalRequestValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseFieldMasksValue(_messages.Message):
    """Defines which part of the response a child operation will contribute.
    Each key of the map is the name of a child operation. Each value is a
    field mask that identifies what that child operation contributes to the
    response, for example, "quota_settings", "visiblity_settings", etc.

    Messages:
      AdditionalProperty: An additional property for a ResponseFieldMasksValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ResponseFieldMasksValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseFieldMasksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  childOperations = _messages.MessageField('Operation', 1, repeated=True)
  originalRequest = _messages.MessageField('OriginalRequestValue', 2)
  persisted = _messages.BooleanField(3)
  responseFieldMasks = _messages.MessageField('ResponseFieldMasksValue', 4)


class Condition(_messages.Message):
  """A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN). See: go/rpc-security-policy-
        dynamicauth.
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    APPROVER = 3
    JUSTIFICATION_TYPE = 4

  class OpValueValuesEnum(_messages.Enum):
    """An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by any service that owns resources and uses
    the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class ConfigChange(_messages.Message):
  """Output generated from semantically comparing two versions of a service
  configuration.  Includes detailed information about a field that have
  changed with applicable advice about potential consequences for the change,
  such as backwards-incompatibility.

  Enums:
    ChangeTypeValueValuesEnum: The type for this change, either ADDED,
      REMOVED, or MODIFIED.

  Fields:
    advices: Collection of advice provided for this change, useful for
      determining the possible impact of this change.
    changeType: The type for this change, either ADDED, REMOVED, or MODIFIED.
    element: Object hierarchy path to the change, with levels separated by a
      '.' character. For repeated fields, an applicable unique identifier
      field is used for the index (usually selector, name, or id). For maps,
      the term 'key' is used. If the field has no unique identifier, the
      numeric index is used. Examples: - visibility.rules[selector=="google.Li
      braryService.CreateBook"].restriction -
      quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
      - logging.producer_destinations[0]
    newValue: Value of the changed object in the new Service configuration, in
      JSON format. This field will not be populated if ChangeType == REMOVED.
    oldValue: Value of the changed object in the old Service configuration, in
      JSON format. This field will not be populated if ChangeType == ADDED.
  """

  class ChangeTypeValueValuesEnum(_messages.Enum):
    """The type for this change, either ADDED, REMOVED, or MODIFIED.

    Values:
      CHANGE_TYPE_UNSPECIFIED: No value was provided.
      ADDED: The changed object exists in the 'new' service configuration, but
        not in the 'old' service configuration.
      REMOVED: The changed object exists in the 'old' service configuration,
        but not in the 'new' service configuration.
      MODIFIED: The changed object exists in both service configurations, but
        its value is different.
    """
    CHANGE_TYPE_UNSPECIFIED = 0
    ADDED = 1
    REMOVED = 2
    MODIFIED = 3

  advices = _messages.MessageField('Advice', 1, repeated=True)
  changeType = _messages.EnumField('ChangeTypeValueValuesEnum', 2)
  element = _messages.StringField(3)
  newValue = _messages.StringField(4)
  oldValue = _messages.StringField(5)


class ConfigFile(_messages.Message):
  """Generic specification of a source configuration file

  Enums:
    FileTypeValueValuesEnum: The type of configuration file this represents.

  Fields:
    contents: DEPRECATED. The contents of the configuration file. Use
      file_contents moving forward.
    fileContents: The bytes that constitute the file.
    filePath: The file name of the configuration file (full or relative path).
    fileType: The type of configuration file this represents.
  """

  class FileTypeValueValuesEnum(_messages.Enum):
    """The type of configuration file this represents.

    Values:
      FILE_TYPE_UNSPECIFIED: Unknown file type.
      SERVICE_CONFIG_YAML: YAML-specification of service.
      OPEN_API_JSON: OpenAPI specification, serialized in JSON.
      OPEN_API_YAML: OpenAPI specification, serialized in YAML.
      FILE_DESCRIPTOR_SET_PROTO: FileDescriptorSet, generated by protoc.  To
        generate, use protoc with imports and source info included. For an
        example test.proto file, the following command would put the value in
        a new file named out.pb.  $protoc --include_imports
        --include_source_info test.proto -o out.pb
    """
    FILE_TYPE_UNSPECIFIED = 0
    SERVICE_CONFIG_YAML = 1
    OPEN_API_JSON = 2
    OPEN_API_YAML = 3
    FILE_DESCRIPTOR_SET_PROTO = 4

  contents = _messages.StringField(1)
  fileContents = _messages.BytesField(2)
  filePath = _messages.StringField(3)
  fileType = _messages.EnumField('FileTypeValueValuesEnum', 4)


class ConfigRef(_messages.Message):
  """Represents a service configuration with its name and id.

  Fields:
    name: Resource name of a service config. It must have the following
      format: "services/{service name}/configs/{config id}".
  """

  name = _messages.StringField(1)


class ConfigSource(_messages.Message):
  """Represents a source file which is used to generate the service
  configuration defined by `google.api.Service`.

  Fields:
    files: Set of source configuration files that are used to generate a
      service configuration (`google.api.Service`).
    id: A unique ID for a specific instance of this message, typically
      assigned by the client for tracking purpose. If empty, the server may
      choose to generate one instead.
  """

  files = _messages.MessageField('ConfigFile', 1, repeated=True)
  id = _messages.StringField(2)


class Context(_messages.Message):
  """`Context` defines which contexts an API requests.  Example:      context:
  rules:       - selector: "*"         requested:         -
  google.rpc.context.ProjectContext         - google.rpc.context.OriginContext
  The above specifies that all methods in the API request
  `google.rpc.context.ProjectContext` and `google.rpc.context.OriginContext`.
  Available context types are defined in package `google.rpc.context`.

  Fields:
    rules: A list of RPC context rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('ContextRule', 1, repeated=True)


class ContextRule(_messages.Message):
  """A context rule provides information about the context for an individual
  API element.

  Fields:
    provided: A list of full type names of provided contexts.
    requested: A list of full type names of requested contexts.
    selector: Selects the methods to which this rule applies.  Refer to
      selector for syntax details.
  """

  provided = _messages.StringField(1, repeated=True)
  requested = _messages.StringField(2, repeated=True)
  selector = _messages.StringField(3)


class Control(_messages.Message):
  """Selects and configures the service controller used by the service.  The
  service controller handles features like abuse, quota, billing, logging,
  monitoring, etc.

  Fields:
    environment: The service control environment to use. If empty, no control
      plane feature (like quota and billing) will be enabled.
  """

  environment = _messages.StringField(1)


class ConvertConfigRequest(_messages.Message):
  """Request message for `ConvertConfig` method.

  Messages:
    ConfigSpecValue: Input configuration For this version of API, the
      supported type is OpenApiSpec

  Fields:
    configSpec: Input configuration For this version of API, the supported
      type is OpenApiSpec
    openApiSpec: The OpenAPI specification for an API.
    serviceName: The service name to use for constructing the normalized
      service configuration equivalent of the provided configuration
      specification.
    swaggerSpec: The swagger specification for an API.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigSpecValue(_messages.Message):
    """Input configuration For this version of API, the supported type is
    OpenApiSpec

    Messages:
      AdditionalProperty: An additional property for a ConfigSpecValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ConfigSpecValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configSpec = _messages.MessageField('ConfigSpecValue', 1)
  openApiSpec = _messages.MessageField('OpenApiSpec', 2)
  serviceName = _messages.StringField(3)
  swaggerSpec = _messages.MessageField('SwaggerSpec', 4)


class ConvertConfigResponse(_messages.Message):
  """Response message for `ConvertConfig` method.

  Fields:
    diagnostics: Any errors or warnings that occured during config conversion.
    serviceConfig: The service configuration. Not set if errors occured during
      conversion.
  """

  diagnostics = _messages.MessageField('Diagnostic', 1, repeated=True)
  serviceConfig = _messages.MessageField('Service', 2)


class CounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class CustomError(_messages.Message):
  """Customize service error responses.  For example, list any service
  specific protobuf types that can appear in error detail lists of error
  responses.  Example:      custom_error:       types:       -
  google.foo.v1.CustomError       - google.foo.v1.AnotherError

  Fields:
    rules: The list of custom error rules that apply to individual API
      messages.  **NOTE:** All service configuration rules follow "last one
      wins" order.
    types: The list of custom error detail types, e.g.
      'google.foo.v1.CustomError'.
  """

  rules = _messages.MessageField('CustomErrorRule', 1, repeated=True)
  types = _messages.StringField(2, repeated=True)


class CustomErrorRule(_messages.Message):
  """A custom error rule.

  Fields:
    isErrorType: Mark this message as possible payload in error response.
      Otherwise, objects of this type will be filtered when they appear in
      error payload.
    selector: Selects messages to which this rule applies.  Refer to selector
      for syntax details.
  """

  isErrorType = _messages.BooleanField(1)
  selector = _messages.StringField(2)


class CustomHttpPattern(_messages.Message):
  """A custom pattern is used for defining custom HTTP verb.

  Fields:
    kind: The name of this custom HTTP verb.
    path: The path matched by this custom verb.
  """

  kind = _messages.StringField(1)
  path = _messages.StringField(2)


class CustomerSettings(_messages.Message):
  """Settings that control how a customer (organization or folder) uses a
  service.

  Fields:
    customerId: ID for the customer that consumes the service (see above).
      Customer id is always in the format of a Gaia id.
    quotaSettings: Settings that control how much or how fast the service can
      be used by the consumer projects under the organization or folder
      collectively.
    serviceName: The name of the service.  See the `ServiceManager` overview
      for naming requirements.
  """

  customerId = _messages.StringField(1)
  quotaSettings = _messages.MessageField('QuotaSettings', 2)
  serviceName = _messages.StringField(3)


class DataAccessOptions(_messages.Message):
  """Write a Data Access (Gin) log"""


class DeleteServiceStrategy(_messages.Message):
  """Strategy used to delete a service. This strategy is a placeholder only
  used by the system generated rollout to delete a service.
  """



class Diagnostic(_messages.Message):
  """Represents a diagnostic message (error or warning)

  Enums:
    KindValueValuesEnum: The kind of diagnostic information provided.

  Fields:
    kind: The kind of diagnostic information provided.
    location: File name and line number of the error or warning.
    message: Message describing the error or warning.
  """

  class KindValueValuesEnum(_messages.Enum):
    """The kind of diagnostic information provided.

    Values:
      WARNING: Warnings and errors
      ERROR: Only errors
    """
    WARNING = 0
    ERROR = 1

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  location = _messages.StringField(2)
  message = _messages.StringField(3)


class DisableServiceRequest(_messages.Message):
  """Request message for DisableService method.

  Fields:
    consumerId: The identity of consumer resource which service disablement
      will be applied to.  The Google Service Management implementation
      accepts the following forms: - "project:<project_id>"  Note: this is
      made compatible with google.api.servicecontrol.v1.Operation.consumer_id.
  """

  consumerId = _messages.StringField(1)


class Documentation(_messages.Message):
  """`Documentation` provides the information for describing a service.
  Example: <pre><code>documentation:   summary: >     The Google Calendar API
  gives access     to most calendar features.   pages:   - name: Overview
  content: &#40;== include google/foo/overview.md ==&#41;   - name: Tutorial
  content: &#40;== include google/foo/tutorial.md ==&#41;     subpages;     -
  name: Java       content: &#40;== include google/foo/tutorial_java.md
  ==&#41;   rules:   - selector: google.calendar.Calendar.Get     description:
  >       ...   - selector: google.calendar.Calendar.Put     description: >
  ... </code></pre> Documentation is provided in markdown syntax. In addition
  to standard markdown features, definition lists, tables and fenced code
  blocks are supported. Section headers can be provided and are interpreted
  relative to the section nesting of the context where a documentation
  fragment is embedded.  Documentation from the IDL is merged with
  documentation defined via the config at normalization time, where
  documentation provided by config rules overrides IDL provided.  A number of
  constructs specific to the API platform are supported in documentation text.
  In order to reference a proto element, the following notation can be used:
  <pre><code>&#91;fully.qualified.proto.name]&#91;]</code></pre> To override
  the display text used for the link, this can be used:
  <pre><code>&#91;display text]&#91;fully.qualified.proto.name]</code></pre>
  Text can be excluded from doc using the following notation:
  <pre><code>&#40;-- internal comment --&#41;</code></pre> Comments can be
  made conditional using a visibility label. The below text will be only
  rendered if the `BETA` label is available: <pre><code>&#40;--BETA: comment
  for BETA users --&#41;</code></pre> A few directives are available in
  documentation. Note that directives must appear on a single line to be
  properly identified. The `include` directive includes a markdown file from
  an external source: <pre><code>&#40;== include path/to/file
  ==&#41;</code></pre> The `resource_for` directive marks a message to be the
  resource of a collection in REST view. If it is not specified, tools attempt
  to infer the resource from the operations in a collection:
  <pre><code>&#40;== resource_for v1.shelves.books ==&#41;</code></pre> The
  directive `suppress_warning` does not directly affect documentation and is
  documented together with service config validation.

  Fields:
    documentationRootUrl: The URL to the root of documentation.
    overview: Declares a single overview page. For example:
      <pre><code>documentation:   summary: ...   overview: &#40;== include
      overview.md ==&#41; </code></pre> This is a shortcut for the following
      declaration (using pages style): <pre><code>documentation:   summary:
      ...   pages:   - name: Overview     content: &#40;== include overview.md
      ==&#41; </code></pre> Note: you cannot specify both `overview` field and
      `pages` field.
    pages: The top level pages for the documentation set.
    rules: A list of documentation rules that apply to individual API
      elements.  **NOTE:** All service configuration rules follow "last one
      wins" order.
    summary: A short summary of what the service does. Can only be provided by
      plain text.
  """

  documentationRootUrl = _messages.StringField(1)
  overview = _messages.StringField(2)
  pages = _messages.MessageField('Page', 3, repeated=True)
  rules = _messages.MessageField('DocumentationRule', 4, repeated=True)
  summary = _messages.StringField(5)


class DocumentationRule(_messages.Message):
  """A documentation rule provides information about individual API elements.

  Fields:
    deprecationDescription: Deprecation description of the selected
      element(s). It can be provided if an element is marked as `deprecated`.
    description: Description of the selected API(s).
    selector: The selector is a comma-separated list of patterns. Each pattern
      is a qualified name of the element which may end in "*", indicating a
      wildcard. Wildcards are only allowed at the end and for a whole
      component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or
      "foo.*.bar". To specify a default for all applicable elements, the whole
      pattern "*" is used.
  """

  deprecationDescription = _messages.StringField(1)
  description = _messages.StringField(2)
  selector = _messages.StringField(3)


class EffectiveQuotaGroup(_messages.Message):
  """An effective quota group contains both the metadata for a quota group as
  derived from the service config, and the effective limits in that group as
  calculated from producer and consumer overrides together with service
  defaults.

  Enums:
    BillingInteractionValueValuesEnum:

  Fields:
    baseGroup: The service configuration for this quota group, minus the quota
      limits, which are replaced by the effective limits below.
    billingInteraction: A BillingInteractionValueValuesEnum attribute.
    quotas: The usage and limit information for each limit within this quota
      group.
  """

  class BillingInteractionValueValuesEnum(_messages.Enum):
    """BillingInteractionValueValuesEnum enum type.

    Values:
      BILLING_INTERACTION_UNSPECIFIED: The interaction between this quota
        group and the project billing status is unspecified.
      NONBILLABLE_ONLY: This quota group is enforced only when the consumer
        project is not billable.
      BILLABLE_ONLY: This quota group is enforced only when the consumer
        project is billable.
      ANY_BILLING_STATUS: This quota group is enforced regardless of the
        consumer project's billing status.
    """
    BILLING_INTERACTION_UNSPECIFIED = 0
    NONBILLABLE_ONLY = 1
    BILLABLE_ONLY = 2
    ANY_BILLING_STATUS = 3

  baseGroup = _messages.MessageField('QuotaGroup', 1)
  billingInteraction = _messages.EnumField('BillingInteractionValueValuesEnum', 2)
  quotas = _messages.MessageField('QuotaInfo', 3, repeated=True)


class EffectiveQuotaLimit(_messages.Message):
  """An effective quota limit contains the metadata for a quota limit as
  derived from the service config, together with fields that describe the
  effective limit value and what overrides can be applied to it.

  Fields:
    baseLimit: The service's configuration for this quota limit.
    effectiveLimit: The effective limit value, based on the stored producer
      and consumer overrides and the service defaults.
    key: The key used to identify this limit when applying overrides. The
      consumer_overrides and producer_overrides maps are keyed by strings of
      the form "QuotaGroupName/QuotaLimitName".
    maxConsumerOverrideAllowed: The maximum override value that a consumer may
      specify.
  """

  baseLimit = _messages.MessageField('QuotaLimit', 1)
  effectiveLimit = _messages.IntegerField(2)
  key = _messages.StringField(3)
  maxConsumerOverrideAllowed = _messages.IntegerField(4)


class EffectiveQuotaLimit2(_messages.Message):
  """An effective quota limit contains the metadata for a quota limit as
  derived from the service config, together with fields that describe the
  effective limit value and what overrides can be applied to it. This is used
  only for quota limits that are grouped by metrics instead of quota groups.

  Fields:
    baseLimit: The service's configuration for this quota limit.
    quotaBuckets: Effective quota limit, maximum override allowed, and usage
      for each quota bucket.
  """

  baseLimit = _messages.MessageField('QuotaLimit', 1)
  quotaBuckets = _messages.MessageField('QuotaBucket', 2, repeated=True)


class EffectiveQuotasForMetric(_messages.Message):
  """Effective quotas for a metric. It contains both the metadata for the
  metric as defined in the service config, and the effective limits for quota
  limits defined on the metric as calculated from service default, producer
  and consumer overrides, and adjusted by the reputation tier of the user.
  This is used only for quota limits that are grouped by metrics instead of
  quota groups.

  Messages:
    EffectiveLimitsValue: Effective limit values for all quota limits defined
      on the metric. The keys of the map are the name of the quota limits.

  Fields:
    effectiveLimits: Effective limit values for all quota limits defined on
      the metric. The keys of the map are the name of the quota limits.
    metric: The metric descriptor in service config.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EffectiveLimitsValue(_messages.Message):
    """Effective limit values for all quota limits defined on the metric. The
    keys of the map are the name of the quota limits.

    Messages:
      AdditionalProperty: An additional property for a EffectiveLimitsValue
        object.

    Fields:
      additionalProperties: Additional properties of type EffectiveLimitsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a EffectiveLimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A EffectiveQuotaLimit2 attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('EffectiveQuotaLimit2', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  effectiveLimits = _messages.MessageField('EffectiveLimitsValue', 1)
  metric = _messages.MessageField('MetricDescriptor', 2)


class EnableServiceRequest(_messages.Message):
  """Request message for EnableService method.

  Fields:
    consumerId: The identity of consumer resource which service enablement
      will be applied to.  The Google Service Management implementation
      accepts the following forms: - "project:<project_id>"  Note: this is
      made compatible with google.api.servicecontrol.v1.Operation.consumer_id.
  """

  consumerId = _messages.StringField(1)


class Endpoint(_messages.Message):
  """`Endpoint` describes a network endpoint that serves a set of APIs. A
  service may expose any number of endpoints, and all endpoints share the same
  service configuration, such as quota configuration and monitoring
  configuration.  Example service configuration:      name: library-
  example.googleapis.com     endpoints:       # Below entry makes
  'google.example.library.v1.Library'       # API be served from endpoint
  address library-example.googleapis.com.       # It also allows HTTP OPTIONS
  calls to be passed to the backend, for       # it to decide whether the
  subsequent cross-origin request is       # allowed to proceed.     - name:
  library-example.googleapis.com       allow_cors: true

  Fields:
    aliases: DEPRECATED: This field is no longer supported. Instead of using
      aliases, please specify multiple google.api.Endpoint for each of the
      intented alias.  Additional names that this endpoint will be hosted on.
    allowCors: Allowing [CORS](https://en.wikipedia.org/wiki/Cross-
      origin_resource_sharing), aka cross-domain traffic, would allow the
      backends served from this endpoint to receive and respond to HTTP
      OPTIONS requests. The response will be used by the browser to determine
      whether the subsequent cross-origin request is allowed to proceed.
    apis: The list of APIs served by this endpoint.
    features: The list of features enabled on this endpoint.
    name: The canonical name of this endpoint.
  """

  aliases = _messages.StringField(1, repeated=True)
  allowCors = _messages.BooleanField(2)
  apis = _messages.StringField(3, repeated=True)
  features = _messages.StringField(4, repeated=True)
  name = _messages.StringField(5)


class Enum(_messages.Message):
  """Enum type definition.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    enumvalue: Enum value definitions.
    name: Enum type name.
    options: Protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    """The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  enumvalue = _messages.MessageField('EnumValue', 1, repeated=True)
  name = _messages.StringField(2)
  options = _messages.MessageField('Option', 3, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 4)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 5)


class EnumValue(_messages.Message):
  """Enum value definition.

  Fields:
    name: Enum value name.
    number: Enum value number.
    options: Protocol buffer options.
  """

  name = _messages.StringField(1)
  number = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 3, repeated=True)


class Experimental(_messages.Message):
  """Experimental service configuration. These configuration options can only
  be used by whitelisted users.

  Fields:
    authorization: Authorization configuration.
  """

  authorization = _messages.MessageField('AuthorizationConfig', 1)


class Field(_messages.Message):
  """A single field of a message type.

  Enums:
    CardinalityValueValuesEnum: The field cardinality.
    KindValueValuesEnum: The field type.

  Fields:
    cardinality: The field cardinality.
    defaultValue: The string value of the default value of this field. Proto2
      syntax only.
    jsonName: The field JSON name.
    kind: The field type.
    name: The field name.
    number: The field number.
    oneofIndex: The index of the field type in `Type.oneofs`, for message or
      enumeration types. The first type has index 1; zero means the type is
      not in the list.
    options: The protocol buffer options.
    packed: Whether to use alternative packed wire representation.
    typeUrl: The field type URL, without the scheme, for message or
      enumeration types. Example:
      `"type.googleapis.com/google.protobuf.Timestamp"`.
  """

  class CardinalityValueValuesEnum(_messages.Enum):
    """The field cardinality.

    Values:
      CARDINALITY_UNKNOWN: For fields with unknown cardinality.
      CARDINALITY_OPTIONAL: For optional fields.
      CARDINALITY_REQUIRED: For required fields. Proto2 syntax only.
      CARDINALITY_REPEATED: For repeated fields.
    """
    CARDINALITY_UNKNOWN = 0
    CARDINALITY_OPTIONAL = 1
    CARDINALITY_REQUIRED = 2
    CARDINALITY_REPEATED = 3

  class KindValueValuesEnum(_messages.Enum):
    """The field type.

    Values:
      TYPE_UNKNOWN: Field type unknown.
      TYPE_DOUBLE: Field type double.
      TYPE_FLOAT: Field type float.
      TYPE_INT64: Field type int64.
      TYPE_UINT64: Field type uint64.
      TYPE_INT32: Field type int32.
      TYPE_FIXED64: Field type fixed64.
      TYPE_FIXED32: Field type fixed32.
      TYPE_BOOL: Field type bool.
      TYPE_STRING: Field type string.
      TYPE_GROUP: Field type group. Proto2 syntax only, and deprecated.
      TYPE_MESSAGE: Field type message.
      TYPE_BYTES: Field type bytes.
      TYPE_UINT32: Field type uint32.
      TYPE_ENUM: Field type enum.
      TYPE_SFIXED32: Field type sfixed32.
      TYPE_SFIXED64: Field type sfixed64.
      TYPE_SINT32: Field type sint32.
      TYPE_SINT64: Field type sint64.
    """
    TYPE_UNKNOWN = 0
    TYPE_DOUBLE = 1
    TYPE_FLOAT = 2
    TYPE_INT64 = 3
    TYPE_UINT64 = 4
    TYPE_INT32 = 5
    TYPE_FIXED64 = 6
    TYPE_FIXED32 = 7
    TYPE_BOOL = 8
    TYPE_STRING = 9
    TYPE_GROUP = 10
    TYPE_MESSAGE = 11
    TYPE_BYTES = 12
    TYPE_UINT32 = 13
    TYPE_ENUM = 14
    TYPE_SFIXED32 = 15
    TYPE_SFIXED64 = 16
    TYPE_SINT32 = 17
    TYPE_SINT64 = 18

  cardinality = _messages.EnumField('CardinalityValueValuesEnum', 1)
  defaultValue = _messages.StringField(2)
  jsonName = _messages.StringField(3)
  kind = _messages.EnumField('KindValueValuesEnum', 4)
  name = _messages.StringField(5)
  number = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  oneofIndex = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 8, repeated=True)
  packed = _messages.BooleanField(9)
  typeUrl = _messages.StringField(10)


class File(_messages.Message):
  """A single swagger specification file.

  Fields:
    contents: The contents of the swagger spec file.
    path: The relative path of the swagger spec file.
  """

  contents = _messages.StringField(1)
  path = _messages.StringField(2)


class FlowOperationMetadata(_messages.Message):
  """The metadata associated with a long running operation resource.

  Enums:
    CancelStateValueValuesEnum: The state of the operation with respect to
      cancellation.

  Fields:
    cancelState: The state of the operation with respect to cancellation.
    deadline: Deadline for the flow to complete, to prevent orphaned
      Operations.  If the flow has not completed by this time, it may be
      terminated by the engine, or force-failed by Operation lookup.  Note
      that this is not a hard deadline after which the Flow will definitely be
      failed, rather it is a deadline after which it is reasonable to suspect
      a problem and other parts of the system may kill operation to ensure we
      don't have orphans. see also: go/prevent-orphaned-operations
    flowName: The name of the top-level flow corresponding to this operation.
      Must be equal to the "name" field for a FlowName enum.
    isPersisted: Is the update for the operation persisted?
    resourceNames: The full name of the resources that this flow is directly
      associated with.
    startTime: The start time of the operation.
  """

  class CancelStateValueValuesEnum(_messages.Enum):
    """The state of the operation with respect to cancellation.

    Values:
      RUNNING: Default state, cancellable but not cancelled.
      UNCANCELLABLE: The operation has proceeded past the point of no return
        and cannot be cancelled.
      CANCELLED: The operation has been cancelled, work should cease and any
        needed rollback steps executed.
    """
    RUNNING = 0
    UNCANCELLABLE = 1
    CANCELLED = 2

  cancelState = _messages.EnumField('CancelStateValueValuesEnum', 1)
  deadline = _messages.StringField(2)
  flowName = _messages.StringField(3)
  isPersisted = _messages.BooleanField(4)
  resourceNames = _messages.StringField(5, repeated=True)
  startTime = _messages.StringField(6)


class GenerateConfigReportRequest(_messages.Message):
  """Request message for GenerateConfigReport method.

  Messages:
    NewConfigValue: Service configuration for which we want to generate the
      report. For this version of API, the supported types are
      google.api.servicemanagement.v1.ConfigRef,
      google.api.servicemanagement.v1.ConfigSource, and google.api.Service
    OldConfigValue: Service configuration against which the comparison will be
      done. For this version of API, the supported types are
      google.api.servicemanagement.v1.ConfigRef,
      google.api.servicemanagement.v1.ConfigSource, and google.api.Service

  Fields:
    newConfig: Service configuration for which we want to generate the report.
      For this version of API, the supported types are
      google.api.servicemanagement.v1.ConfigRef,
      google.api.servicemanagement.v1.ConfigSource, and google.api.Service
    oldConfig: Service configuration against which the comparison will be
      done. For this version of API, the supported types are
      google.api.servicemanagement.v1.ConfigRef,
      google.api.servicemanagement.v1.ConfigSource, and google.api.Service
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NewConfigValue(_messages.Message):
    """Service configuration for which we want to generate the report. For
    this version of API, the supported types are
    google.api.servicemanagement.v1.ConfigRef,
    google.api.servicemanagement.v1.ConfigSource, and google.api.Service

    Messages:
      AdditionalProperty: An additional property for a NewConfigValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a NewConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OldConfigValue(_messages.Message):
    """Service configuration against which the comparison will be done. For
    this version of API, the supported types are
    google.api.servicemanagement.v1.ConfigRef,
    google.api.servicemanagement.v1.ConfigSource, and google.api.Service

    Messages:
      AdditionalProperty: An additional property for a OldConfigValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a OldConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  newConfig = _messages.MessageField('NewConfigValue', 1)
  oldConfig = _messages.MessageField('OldConfigValue', 2)


class GenerateConfigReportResponse(_messages.Message):
  """Response message for GenerateConfigReport method.

  Fields:
    changeReports: list of ChangeReport, each corresponding to comparison
      between two service configurations.
    diagnostics: Errors / Linter warnings associated with the service
      definition this report belongs to.
    id: ID of the service configuration this report belongs to.
    serviceName: Name of the service this report belongs to.
  """

  changeReports = _messages.MessageField('ChangeReport', 1, repeated=True)
  diagnostics = _messages.MessageField('Diagnostic', 2, repeated=True)
  id = _messages.StringField(3)
  serviceName = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class Http(_messages.Message):
  """Defines the HTTP configuration for a service. It contains a list of
  HttpRule, each specifying the mapping of an RPC method to one or more HTTP
  REST API methods.

  Fields:
    rules: A list of HTTP configuration rules that apply to individual API
      methods.  **NOTE:** All service configuration rules follow "last one
      wins" order.
  """

  rules = _messages.MessageField('HttpRule', 1, repeated=True)


class HttpRule(_messages.Message):
  """`HttpRule` defines the mapping of an RPC method to one or more HTTP REST
  APIs.  The mapping determines what portions of the request message are
  populated from the path, query parameters, or body of the HTTP request.  The
  mapping is typically specified as an `google.api.http` annotation, see
  "google/api/annotations.proto" for details.  The mapping consists of a field
  specifying the path template and method kind.  The path template can refer
  to fields in the request message, as in the example below which describes a
  REST GET operation on a resource collection of messages:       service
  Messaging {       rpc GetMessage(GetMessageRequest) returns (Message) {
  option (google.api.http).get = "/v1/messages/{message_id}/{sub.subfield}";
  }     }     message GetMessageRequest {       message SubMessage {
  string subfield = 1;       }       string message_id = 1; // mapped to the
  URL       SubMessage sub = 2;    // `sub.subfield` is url-mapped     }
  message Message {       string text = 1; // content of the resource     }
  The same http annotation can alternatively be expressed inside the `GRPC API
  Configuration` YAML file.      http:       rules:         - selector:
  <proto_package_name>.Messaging.GetMessage           get:
  /v1/messages/{message_id}/{sub.subfield}  This definition enables an
  automatic, bidrectional mapping of HTTP JSON to RPC. Example:  HTTP | RPC
  -----|----- `GET /v1/messages/123456/foo`  | `GetMessage(message_id:
  "123456" sub: SubMessage(subfield: "foo"))`  In general, not only fields but
  also field paths can be referenced from a path pattern. Fields mapped to the
  path pattern cannot be repeated and must have a primitive (non-message)
  type.  Any fields in the request message which are not bound by the path
  pattern automatically become (optional) HTTP query parameters. Assume the
  following definition of the request message:       message GetMessageRequest
  {       message SubMessage {         string subfield = 1;       }
  string message_id = 1; // mapped to the URL       int64 revision = 2;    //
  becomes a parameter       SubMessage sub = 3;    // `sub.subfield` becomes a
  parameter     }   This enables a HTTP JSON to RPC mapping as below:  HTTP |
  RPC -----|----- `GET /v1/messages/123456?revision=2&sub.subfield=foo` |
  `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield:
  "foo"))`  Note that fields which are mapped to HTTP parameters must have a
  primitive type or a repeated primitive type. Message types are not allowed.
  In the case of a repeated type, the parameter can be repeated in the URL, as
  in `...?param=A&param=B`.  For HTTP method kinds which allow a request body,
  the `body` field specifies the mapping. Consider a REST update method on the
  message resource collection:       service Messaging {       rpc
  UpdateMessage(UpdateMessageRequest) returns (Message) {         option
  (google.api.http) = {           put: "/v1/messages/{message_id}"
  body: "message"         };       }     }     message UpdateMessageRequest {
  string message_id = 1; // mapped to the URL       Message message = 2;   //
  mapped to the body     }   The following HTTP JSON to RPC mapping is
  enabled, where the representation of the JSON in the request body is
  determined by protos JSON encoding:  HTTP | RPC -----|----- `PUT
  /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456"
  message { text: "Hi!" })`  The special name `*` can be used in the body
  mapping to define that every field not bound by the path template should be
  mapped to the request body.  This enables the following alternative
  definition of the update method:      service Messaging {       rpc
  UpdateMessage(Message) returns (Message) {         option (google.api.http)
  = {           put: "/v1/messages/{message_id}"           body: "*"
  };       }     }     message Message {       string message_id = 1;
  string text = 2;     }   The following HTTP JSON to RPC mapping is enabled:
  HTTP | RPC -----|----- `PUT /v1/messages/123456 { "text": "Hi!" }` |
  `UpdateMessage(message_id: "123456" text: "Hi!")`  Note that when using `*`
  in the body mapping, it is not possible to have HTTP parameters, as all
  fields not bound by the path end in the body. This makes this option more
  rarely used in practice of defining REST APIs. The common usage of `*` is in
  custom methods which don't use the URL at all for transferring data.  It is
  possible to define multiple HTTP methods for one RPC by using the
  `additional_bindings` option. Example:      service Messaging {       rpc
  GetMessage(GetMessageRequest) returns (Message) {         option
  (google.api.http) = {           get: "/v1/messages/{message_id}"
  additional_bindings {             get:
  "/v1/users/{user_id}/messages/{message_id}"           }         };       }
  }     message GetMessageRequest {       string message_id = 1;       string
  user_id = 2;     }   This enables the following two alternative HTTP JSON to
  RPC mappings:  HTTP | RPC -----|----- `GET /v1/messages/123456` |
  `GetMessage(message_id: "123456")` `GET /v1/users/me/messages/123456` |
  `GetMessage(user_id: "me" message_id: "123456")`  # Rules for HTTP mapping
  The rules for mapping HTTP path, query parameters, and body fields to the
  request message are as follows:  1. The `body` field specifies either `*` or
  a field path, or is    omitted. If omitted, it assumes there is no HTTP
  body. 2. Leaf fields (recursive expansion of nested messages in the
  request) can be classified into three types:     (a) Matched in the URL
  template.     (b) Covered by body (if body is `*`, everything except (a)
  fields;         else everything under the body field)     (c) All other
  fields. 3. URL query parameters found in the HTTP request are mapped to (c)
  fields. 4. Any body sent with an HTTP request can contain only (b) fields.
  The syntax of the path template is as follows:      Template = "/" Segments
  [ Verb ] ;     Segments = Segment { "/" Segment } ;     Segment  = "*" |
  "**" | LITERAL | Variable ;     Variable = "{" FieldPath [ "=" Segments ]
  "}" ;     FieldPath = IDENT { "." IDENT } ;     Verb     = ":" LITERAL ;
  The syntax `*` matches a single path segment. It follows the semantics of
  [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
  Expansion.  The syntax `**` matches zero or more path segments. It follows
  the semantics of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section
  3.2.3 Reserved Expansion. NOTE: it must be the last segment in the path
  except the Verb.  The syntax `LITERAL` matches literal text in the URL path.
  The syntax `Variable` matches the entire path as specified by its template;
  this nested template must not contain further variables. If a variable
  matches a single path segment, its template may be omitted, e.g. `{var}` is
  equivalent to `{var=*}`.  NOTE: the field paths in variables and in the
  `body` must not refer to repeated fields or map fields.  Use
  CustomHttpPattern to specify any HTTP method that is not included in the
  `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified
  for a given URL path rule. The wild-card rule is useful for services that
  provide content to Web (HTML) clients.

  Fields:
    additionalBindings: Additional HTTP bindings for the selector. Nested
      bindings must not contain an `additional_bindings` field themselves
      (that is, the nesting may only be one level deep).
    body: The name of the request field whose value is mapped to the HTTP
      body, or `*` for mapping all fields not captured by the path pattern to
      the HTTP body. NOTE: the referred field must not be a repeated field and
      must be present at the top-level of request message type.
    custom: Custom pattern is used for defining custom verbs.
    delete: Used for deleting a resource.
    get: Used for listing and getting information about resources.
    mediaDownload: Use this only for Scotty Requests. Do not use this for
      bytestream methods. For media support, add instead
      [][google.bytestream.RestByteStream] as an API to your configuration.
    mediaUpload: Use this only for Scotty Requests. Do not use this for media
      support using Bytestream, add instead
      [][google.bytestream.RestByteStream] as an API to your configuration for
      Bytestream methods.
    patch: Used for updating a resource.
    post: Used for creating a resource.
    put: Used for updating a resource.
    responseBody: The name of the response field whose value is mapped to the
      HTTP body of response. Other response fields are ignored. This field is
      optional. When not set, the response message will be used as HTTP body
      of response. NOTE: the referred field must be not a repeated field and
      must be present at the top-level of response message type.
    selector: Selects methods to which this rule applies.  Refer to selector
      for syntax details.
  """

  additionalBindings = _messages.MessageField('HttpRule', 1, repeated=True)
  body = _messages.StringField(2)
  custom = _messages.MessageField('CustomHttpPattern', 3)
  delete = _messages.StringField(4)
  get = _messages.StringField(5)
  mediaDownload = _messages.MessageField('MediaDownload', 6)
  mediaUpload = _messages.MessageField('MediaUpload', 7)
  patch = _messages.StringField(8)
  post = _messages.StringField(9)
  put = _messages.StringField(10)
  responseBody = _messages.StringField(11)
  selector = _messages.StringField(12)


class LabelDescriptor(_messages.Message):
  """A description of a label.

  Enums:
    ValueTypeValueValuesEnum: The type of data that can be assigned to the
      label.

  Fields:
    description: A human-readable description for the label.
    key: The label key.
    valueType: The type of data that can be assigned to the label.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    """The type of data that can be assigned to the label.

    Values:
      STRING: A variable-length string. This is the default.
      BOOL: Boolean; true or false.
      INT64: A 64-bit signed integer.
    """
    STRING = 0
    BOOL = 1
    INT64 = 2

  description = _messages.StringField(1)
  key = _messages.StringField(2)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 3)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServiceConfigsResponse(_messages.Message):
  """Response message for ListServiceConfigs method.

  Fields:
    nextPageToken: The token of the next page of results.
    serviceConfigs: The list of service configuration resources.
  """

  nextPageToken = _messages.StringField(1)
  serviceConfigs = _messages.MessageField('Service', 2, repeated=True)


class ListServiceConsumersResponse(_messages.Message):
  """Response message for `ListServiceConsumers` method.

  Fields:
    customerSettings: The organization/folder-level results of the query.
    nextPageToken: Token that can be passed to `ListServiceConsumers` to
      resume a paginated query.
    projectSettings: The project-level results of the query.
  """

  customerSettings = _messages.MessageField('CustomerSettings', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  projectSettings = _messages.MessageField('ProjectSettings', 3, repeated=True)


class ListServiceRolloutsResponse(_messages.Message):
  """Response message for ListServiceRollouts method.

  Fields:
    nextPageToken: The token of the next page of results.
    rollouts: The list of rollout resources.
  """

  nextPageToken = _messages.StringField(1)
  rollouts = _messages.MessageField('Rollout', 2, repeated=True)


class ListServicesResponse(_messages.Message):
  """Response message for `ListServices` method.

  Fields:
    nextPageToken: Token that can be passed to `ListServices` to resume a
      paginated query.
    services: The returned services will only have the name field set.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('ManagedService', 2, repeated=True)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class LogDescriptor(_messages.Message):
  """A description of a log type. Example in YAML format:      - name:
  library.googleapis.com/activity_history       description: The history of
  borrowing and returning library items.       display_name: Activity
  labels:       - key: /customer_id         description: Identifier of a
  library customer

  Fields:
    description: A human-readable description of this log. This information
      appears in the documentation and can contain details.
    displayName: The human-readable name for this log. This information
      appears on the user interface and should be concise.
    labels: The set of labels that are available to describe a specific log
      entry. Runtime requests that contain labels not specified here are
      considered invalid.
    name: The name of the log. It must be less than 512 characters long and
      can include the following characters: upper- and lower-case alphanumeric
      characters [A-Za-z0-9], and punctuation characters including slash,
      underscore, hyphen, period [/_-.].
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)


class Logging(_messages.Message):
  """Logging configuration of the service.  The following example shows how to
  configure logs to be sent to the producer and consumer projects. In the
  example, the `activity_history` log is sent to both the producer and
  consumer projects, whereas the `purchase_history` log is only sent to the
  producer project.      monitored_resources:     - type:
  library.googleapis.com/branch       labels:       - key: /city
  description: The city where the library branch is located in.       - key:
  /name         description: The name of the branch.     logs:     - name:
  activity_history       labels:       - key: /customer_id     - name:
  purchase_history     logging:       producer_destinations:       -
  monitored_resource: library.googleapis.com/branch         logs:         -
  activity_history         - purchase_history       consumer_destinations:
  - monitored_resource: library.googleapis.com/branch         logs:         -
  activity_history

  Fields:
    consumerDestinations: Logging configurations for sending logs to the
      consumer project. There can be multiple consumer destinations, each one
      must have a different monitored resource type. A log can be used in at
      most one consumer destination.
    producerDestinations: Logging configurations for sending logs to the
      producer project. There can be multiple producer destinations, each one
      must have a different monitored resource type. A log can be used in at
      most one producer destination.
  """

  consumerDestinations = _messages.MessageField('LoggingDestination', 1, repeated=True)
  producerDestinations = _messages.MessageField('LoggingDestination', 2, repeated=True)


class LoggingDestination(_messages.Message):
  """Configuration of a specific logging destination (the producer project or
  the consumer project).

  Fields:
    logs: Names of the logs to be sent to this destination. Each name must be
      defined in the Service.logs section. If the log name is not a domain
      scoped name, it will be automatically prefixed with the service name
      followed by "/".
    monitoredResource: The monitored resource type. The type must be defined
      in the Service.monitored_resources section.
  """

  logs = _messages.StringField(1, repeated=True)
  monitoredResource = _messages.StringField(2)


class ManagedService(_messages.Message):
  """The full representation of a Service that is managed by Google Service
  Management.

  Fields:
    generation: A server-assigned monotonically increasing number that changes
      whenever a mutation is made to the `ManagedService` or any of its
      components via Google Service Management.
    operations: Read-only view of pending operations affecting this resource,
      if requested.
    producerProjectId: ID of the project that produces and owns this service.
    projectSettings: Read-only view of settings for a particular consumer
      project, if requested.
    serviceConfig: The service's generated configuration.
    serviceName: The name of the service. See the [overview](/service-
      management/overview) for naming requirements.
  """

  generation = _messages.IntegerField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  producerProjectId = _messages.StringField(3)
  projectSettings = _messages.MessageField('ProjectSettings', 4)
  serviceConfig = _messages.MessageField('Service', 5)
  serviceName = _messages.StringField(6)


class MediaDownload(_messages.Message):
  """Use this only for Scotty Requests. Do not use this for media support
  using Bytestream, add instead [][google.bytestream.RestByteStream] as an API
  to your configuration for Bytestream methods.

  Fields:
    downloadService: DO NOT USE THIS FIELD UNTIL THIS WARNING IS REMOVED.
      Specify name of the download service if one is used for download.
    enabled: Whether download is enabled.
  """

  downloadService = _messages.StringField(1)
  enabled = _messages.BooleanField(2)


class MediaUpload(_messages.Message):
  """Use this only for Scotty Requests. Do not use this for media support
  using Bytestream, add instead [][google.bytestream.RestByteStream] as an API
  to your configuration for Bytestream methods.

  Fields:
    enabled: Whether upload is enabled.
    uploadService: DO NOT USE THIS FIELD UNTIL THIS WARNING IS REMOVED.
      Specify name of the upload service if one is used for upload.
  """

  enabled = _messages.BooleanField(1)
  uploadService = _messages.StringField(2)


class Method(_messages.Message):
  """Method represents a method of an api.

  Enums:
    SyntaxValueValuesEnum: The source syntax of this method.

  Fields:
    name: The simple name of this method.
    options: Any metadata attached to the method.
    requestStreaming: If true, the request is streamed.
    requestTypeUrl: A URL of the input message type.
    responseStreaming: If true, the response is streamed.
    responseTypeUrl: The URL of the output message type.
    syntax: The source syntax of this method.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    """The source syntax of this method.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  name = _messages.StringField(1)
  options = _messages.MessageField('Option', 2, repeated=True)
  requestStreaming = _messages.BooleanField(3)
  requestTypeUrl = _messages.StringField(4)
  responseStreaming = _messages.BooleanField(5)
  responseTypeUrl = _messages.StringField(6)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 7)


class MetricDescriptor(_messages.Message):
  """Defines a metric type and its schema. Once a metric descriptor is
  created, deleting or altering it stops data collection and makes the metric
  type's existing data unusable.

  Enums:
    MetricKindValueValuesEnum: Whether the metric records instantaneous
      values, changes to a value, etc. Some combinations of `metric_kind` and
      `value_type` might not be supported.
    ValueTypeValueValuesEnum: Whether the measurement is an integer, a
      floating-point number, etc. Some combinations of `metric_kind` and
      `value_type` might not be supported.

  Fields:
    description: A detailed description of the metric, which can be used in
      documentation.
    displayName: A concise name for the metric, which can be displayed in user
      interfaces. Use sentence case without an ending period, for example
      "Request count".
    labels: The set of labels that can be used to describe a specific instance
      of this metric type. For example, the
      `appengine.googleapis.com/http/server/response_latencies` metric type
      has a label for the HTTP response code, `response_code`, so you can look
      at latencies for successful responses or just for responses that failed.
    metricKind: Whether the metric records instantaneous values, changes to a
      value, etc. Some combinations of `metric_kind` and `value_type` might
      not be supported.
    name: The resource name of the metric descriptor. Depending on the
      implementation, the name typically includes: (1) the parent resource
      name that defines the scope of the metric type or of its data; and (2)
      the metric's URL-encoded type, which also appears in the `type` field of
      this descriptor. For example, following is the resource name of a custom
      metric within the GCP project `my-project-id`:      "projects/my-
      project-
      id/metricDescriptors/custom.googleapis.com%2Finvoice%2Fpaid%2Famount"
    type: The metric type, including its DNS name prefix. The type is not URL-
      encoded.  All user-defined custom metric types have the DNS name
      `custom.googleapis.com`.  Metric types should use a natural hierarchical
      grouping. For example:      "custom.googleapis.com/invoice/paid/amount"
      "appengine.googleapis.com/http/server/response_latencies"
    unit: The unit in which the metric value is reported. It is only
      applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`.
      The supported units are a subset of [The Unified Code for Units of
      Measure](http://unitsofmeasure.org/ucum.html) standard:  **Basic units
      (UNIT)**  * `bit`   bit * `By`    byte * `s`     second * `min`   minute
      * `h`     hour * `d`     day  **Prefixes (PREFIX)**  * `k`     kilo
      (10**3) * `M`     mega    (10**6) * `G`     giga    (10**9) * `T`
      tera    (10**12) * `P`     peta    (10**15) * `E`     exa     (10**18) *
      `Z`     zetta   (10**21) * `Y`     yotta   (10**24) * `m`     milli
      (10**-3) * `u`     micro   (10**-6) * `n`     nano    (10**-9) * `p`
      pico    (10**-12) * `f`     femto   (10**-15) * `a`     atto
      (10**-18) * `z`     zepto   (10**-21) * `y`     yocto   (10**-24) * `Ki`
      kibi    (2**10) * `Mi`    mebi    (2**20) * `Gi`    gibi    (2**30) *
      `Ti`    tebi    (2**40)  **Grammar**  The grammar includes the
      dimensionless unit `1`, such as `1/s`.  The grammar also includes these
      connectors:  * `/`    division (as an infix operator, e.g. `1/s`). * `.`
      multiplication (as an infix operator, e.g. `GBy.d`)  The grammar for a
      unit is as follows:      Expression = Component { "." Component } { "/"
      Component } ;      Component = [ PREFIX ] UNIT [ Annotation ]
      | Annotation               | "1"               ;      Annotation = "{"
      NAME "}" ;  Notes:  * `Annotation` is just a comment if it follows a
      `UNIT` and is    equivalent to `1` if it is used alone. For examples,
      `{requests}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a
      sequence of non-blank printable ASCII characters not    containing '{'
      or '}'.
    valueType: Whether the measurement is an integer, a floating-point number,
      etc. Some combinations of `metric_kind` and `value_type` might not be
      supported.
  """

  class MetricKindValueValuesEnum(_messages.Enum):
    """Whether the metric records instantaneous values, changes to a value,
    etc. Some combinations of `metric_kind` and `value_type` might not be
    supported.

    Values:
      METRIC_KIND_UNSPECIFIED: Do not use this default value.
      GAUGE: An instantaneous measurement of a value.
      DELTA: The change in a value during a time interval.
      CUMULATIVE: A value accumulated over a time interval.  Cumulative
        measurements in a time series should have the same start time and
        increasing end times, until an event resets the cumulative value to
        zero and sets a new start time for the following points.
    """
    METRIC_KIND_UNSPECIFIED = 0
    GAUGE = 1
    DELTA = 2
    CUMULATIVE = 3

  class ValueTypeValueValuesEnum(_messages.Enum):
    """Whether the measurement is an integer, a floating-point number, etc.
    Some combinations of `metric_kind` and `value_type` might not be
    supported.

    Values:
      VALUE_TYPE_UNSPECIFIED: Do not use this default value.
      BOOL: The value is a boolean. This value type can be used only if the
        metric kind is `GAUGE`.
      INT64: The value is a signed 64-bit integer.
      DOUBLE: The value is a double precision floating point number.
      STRING: The value is a text string. This value type can be used only if
        the metric kind is `GAUGE`.
      DISTRIBUTION: The value is a `Distribution`.
      MONEY: The value is money.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    DOUBLE = 3
    STRING = 4
    DISTRIBUTION = 5
    MONEY = 6

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  metricKind = _messages.EnumField('MetricKindValueValuesEnum', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)
  unit = _messages.StringField(7)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 8)


class Mixin(_messages.Message):
  """Declares an API to be included in this API. The including API must
  redeclare all the methods from the included API, but documentation and
  options are inherited as follows:  - If after comment and whitespace
  stripping, the documentation   string of the redeclared method is empty, it
  will be inherited   from the original method.  - Each annotation belonging
  to the service config (http,   visibility) which is not set in the
  redeclared method will be   inherited.  - If an http annotation is
  inherited, the path pattern will be   modified as follows. Any version
  prefix will be replaced by the   version of the including API plus the root
  path if specified.  Example of a simple mixin:      package google.acl.v1;
  service AccessControl {       // Get the underlying ACL object.       rpc
  GetAcl(GetAclRequest) returns (Acl) {         option (google.api.http).get =
  "/v1/{resource=**}:getAcl";       }     }      package google.storage.v2;
  service Storage {       //       rpc GetAcl(GetAclRequest) returns (Acl);
  // Get a data record.       rpc GetData(GetDataRequest) returns (Data) {
  option (google.api.http).get = "/v2/{resource=**}";       }     }  Example
  of a mixin configuration:      apis:     - name: google.storage.v2.Storage
  mixins:       - name: google.acl.v1.AccessControl  The mixin construct
  implies that all methods in `AccessControl` are also declared with same name
  and request/response types in `Storage`. A documentation generator or
  annotation processor will see the effective `Storage.GetAcl` method after
  inherting documentation and annotations as follows:      service Storage {
  // Get the underlying ACL object.       rpc GetAcl(GetAclRequest) returns
  (Acl) {         option (google.api.http).get = "/v2/{resource=**}:getAcl";
  }       ...     }  Note how the version in the path pattern changed from
  `v1` to `v2`.  If the `root` field in the mixin is specified, it should be a
  relative path under which inherited HTTP paths are placed. Example:
  apis:     - name: google.storage.v2.Storage       mixins:       - name:
  google.acl.v1.AccessControl         root: acls  This implies the following
  inherited HTTP annotation:      service Storage {       // Get the
  underlying ACL object.       rpc GetAcl(GetAclRequest) returns (Acl) {
  option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";       }
  ...     }

  Fields:
    name: The fully qualified name of the API which is included.
    root: If non-empty specifies a path under which inherited HTTP paths are
      rooted.
  """

  name = _messages.StringField(1)
  root = _messages.StringField(2)


class MonitoredResourceDescriptor(_messages.Message):
  """An object that describes the schema of a MonitoredResource object using a
  type name and a set of labels.  For example, the monitored resource
  descriptor for Google Compute Engine VM instances has a type of
  `"gce_instance"` and specifies the use of the labels `"instance_id"` and
  `"zone"` to identify particular VM instances.  Different APIs can support
  different monitored resource types. APIs generally provide a `list` method
  that returns the monitored resource descriptors used by the API.

  Fields:
    description: Optional. A detailed description of the monitored resource
      type that might be used in documentation.
    displayName: Optional. A concise name for the monitored resource type that
      might be displayed in user interfaces. It should be a Title Cased Noun
      Phrase, without any article or other determiners. For example, `"Google
      Cloud SQL Database"`.
    labels: Required. A set of labels used to describe instances of this
      monitored resource type. For example, an individual Google Cloud SQL
      database is identified by values for the labels `"database_id"` and
      `"zone"`.
    name: Optional. The resource name of the monitored resource descriptor:
      `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
      {type} is the value of the `type` field in this object and {project_id}
      is a project ID that provides API-specific context for accessing the
      type.  APIs that do not use project information can use the resource
      name format `"monitoredResourceDescriptors/{type}"`.
    type: Required. The monitored resource type. For example, the type
      `"cloudsql_database"` represents databases in Google Cloud SQL. The
      maximum length of this value is 256 characters.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)
  type = _messages.StringField(5)


class Monitoring(_messages.Message):
  """Monitoring configuration of the service.  The example below shows how to
  configure monitored resources and metrics for monitoring. In the example, a
  monitored resource and two metrics are defined. The
  `library.googleapis.com/book/returned_count` metric is sent to both producer
  and consumer projects, whereas the
  `library.googleapis.com/book/overdue_count` metric is only sent to the
  consumer project.      monitored_resources:     - type:
  library.googleapis.com/branch       labels:       - key: /city
  description: The city where the library branch is located in.       - key:
  /name         description: The name of the branch.     metrics:     - name:
  library.googleapis.com/book/returned_count       metric_kind: DELTA
  value_type: INT64       labels:       - key: /customer_id     - name:
  library.googleapis.com/book/overdue_count       metric_kind: GAUGE
  value_type: INT64       labels:       - key: /customer_id     monitoring:
  producer_destinations:       - monitored_resource:
  library.googleapis.com/branch         metrics:         -
  library.googleapis.com/book/returned_count       consumer_destinations:
  - monitored_resource: library.googleapis.com/branch         metrics:
  - library.googleapis.com/book/returned_count         -
  library.googleapis.com/book/overdue_count

  Fields:
    consumerDestinations: Monitoring configurations for sending metrics to the
      consumer project. There can be multiple consumer destinations, each one
      must have a different monitored resource type. A metric can be used in
      at most one consumer destination.
    producerDestinations: Monitoring configurations for sending metrics to the
      producer project. There can be multiple producer destinations, each one
      must have a different monitored resource type. A metric can be used in
      at most one producer destination.
  """

  consumerDestinations = _messages.MessageField('MonitoringDestination', 1, repeated=True)
  producerDestinations = _messages.MessageField('MonitoringDestination', 2, repeated=True)


class MonitoringDestination(_messages.Message):
  """Configuration of a specific monitoring destination (the producer project
  or the consumer project).

  Fields:
    metrics: Names of the metrics to report to this monitoring destination.
      Each name must be defined in Service.metrics section.
    monitoredResource: The monitored resource type. The type must be defined
      in Service.monitored_resources section.
  """

  metrics = _messages.StringField(1, repeated=True)
  monitoredResource = _messages.StringField(2)


class OAuthRequirements(_messages.Message):
  """OAuth scopes are a way to define data and permissions on data. For
  example, there are scopes defined for "Read-only access to Google Calendar"
  and "Access to Cloud Platform". Users can consent to a scope for an
  application, giving it permission to access that data on their behalf.
  OAuth scope specifications should be fairly coarse grained; a user will need
  to see and understand the text description of what your scope means.  In
  most cases: use one or at most two OAuth scopes for an entire family of
  products. If your product has multiple APIs, you should probably be sharing
  the OAuth scope across all of those APIs.  When you need finer grained OAuth
  consent screens: talk with your product management about how developers will
  use them in practice.  Please note that even though each of the canonical
  scopes is enough for a request to be accepted and passed to the backend, a
  request can still fail due to the backend requiring additional scopes or
  permissions.

  Fields:
    canonicalScopes: The list of publicly documented OAuth scopes that are
      allowed access. An OAuth token containing any of these scopes will be
      accepted.  Example:       canonical_scopes:
      https://www.googleapis.com/auth/calendar,
      https://www.googleapis.com/auth/calendar.read
  """

  canonicalScopes = _messages.StringField(1)


class OpenApiSpec(_messages.Message):
  """A collection of OpenAPI specification files.

  Fields:
    openApiFiles: Individual files.
  """

  openApiFiles = _messages.MessageField('ConfigFile', 1, repeated=True)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  """The metadata associated with a long running operation resource.

  Fields:
    progressPercentage: Percentage of completion of this operation, ranging
      from 0 to 100.
    resourceNames: The full name of the resources that this operation is
      directly associated with.
    startTime: The start time of the operation.
    steps: Detailed status information for each step. The order is
      undetermined.
  """

  progressPercentage = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resourceNames = _messages.StringField(2, repeated=True)
  startTime = _messages.StringField(3)
  steps = _messages.MessageField('Step', 4, repeated=True)


class Option(_messages.Message):
  """A protocol buffer option, which can be attached to a message, field,
  enumeration, etc.

  Messages:
    ValueValue: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.

  Fields:
    name: The option's name. For protobuf built-in options (options defined in
      descriptor.proto), this is the short name. For example, `"map_entry"`.
      For custom options, it should be the fully-qualified name. For example,
      `"google.api.http"`.
    value: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    """The option's value packed in an Any message. If the value is a
    primitive, the corresponding wrapper type defined in
    google/protobuf/wrappers.proto should be used. If the value is an enum, it
    should be stored as an int32 value using the google.protobuf.Int32Value
    type.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  value = _messages.MessageField('ValueValue', 2)


class Page(_messages.Message):
  """Represents a documentation page. A page can contain subpages to represent
  nested documentation set structure.

  Fields:
    content: The Markdown content of the page. You can use <code>&#40;==
      include {path} ==&#41;</code> to include content from a Markdown file.
    name: The name of the page. It will be used as an identity of the page to
      generate URI of the page, text of the link to this page in navigation,
      etc. The full page name (start from the root page name to this page
      concatenated with `.`) can be used as reference to the page in your
      documentation. For example: <pre><code>pages: - name: Tutorial
      content: &#40;== include tutorial.md ==&#41;   subpages:   - name: Java
      content: &#40;== include tutorial_java.md ==&#41; </code></pre> You can
      reference `Java` page using Markdown reference link syntax: `Java`.
    subpages: Subpages of this page. The order of subpages specified here will
      be honored in the generated docset.
  """

  content = _messages.StringField(1)
  name = _messages.StringField(2)
  subpages = _messages.MessageField('Page', 3, repeated=True)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com",           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class ProjectSettings(_messages.Message):
  """Settings that control how a consumer project uses a service.

  Messages:
    PropertiesValue: Service-defined per-consumer properties.  A key-value
      mapping a string key to a google.protobuf.ListValue proto. Values in the
      list are typed as defined in the Service configuration's
      consumer.properties field.

  Fields:
    consumerProjectId: ID for the project consuming this service.
    operations: Read-only view of pending operations affecting this resource,
      if requested.
    properties: Service-defined per-consumer properties.  A key-value mapping
      a string key to a google.protobuf.ListValue proto. Values in the list
      are typed as defined in the Service configuration's consumer.properties
      field.
    quotaSettings: Settings that control how much or how fast the service can
      be used by the consumer project.
    serviceName: The name of the service.  See the `ServiceManager` overview
      for naming requirements.
    usageSettings: Settings that control whether this service is usable by the
      consumer project.
    visibilitySettings: Settings that control which features of the service
      are visible to the consumer project.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """Service-defined per-consumer properties.  A key-value mapping a string
    key to a google.protobuf.ListValue proto. Values in the list are typed as
    defined in the Service configuration's consumer.properties field.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerProjectId = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)
  quotaSettings = _messages.MessageField('QuotaSettings', 4)
  serviceName = _messages.StringField(5)
  usageSettings = _messages.MessageField('UsageSettings', 6)
  visibilitySettings = _messages.MessageField('VisibilitySettings', 7)


class QueryUserAccessResponse(_messages.Message):
  """Request message for QueryUserAccess method.

  Fields:
    accessibleVisibilityLabels: Any visibility labels on the service that are
      accessible by the user.
    canAccessService: True if the user can access the service and any
      unrestricted API surface.
  """

  accessibleVisibilityLabels = _messages.StringField(1, repeated=True)
  canAccessService = _messages.BooleanField(2)


class QuotaBucket(_messages.Message):
  """The quota limit value and current usage for a quota bucket.

  Fields:
    bucketId: The quota bucket id
    limitValue: Limit value of the bucket, i.e., the maximum number of tokens
      in the bucket.
    maxConsumerOverrideAllowed: The maximum overrides value that a consumer
      may specify on the bucket.
    usage: The usage data for the bucket.
  """

  bucketId = _messages.MessageField('QuotaBucketId', 1)
  limitValue = _messages.IntegerField(2)
  maxConsumerOverrideAllowed = _messages.IntegerField(3)
  usage = _messages.MessageField('QuotaUsage', 4)


class QuotaBucketId(_messages.Message):
  """A quota bucket is an instance of a quota limit.

  Fields:
    containerId: A Quota limit is defined at container level ORGANIZATION,
      PROJECT. The container of a quota bucket for a quota limit is identified
      by organization id, or project id respectively.
    region: If a quota limit is defined on PER_REGION dimension, then each
      region will have its own quota bucket. This field is non-empty only if
      the quota limit is defined on PER_REGION dimension.
  """

  containerId = _messages.StringField(1)
  region = _messages.StringField(2)


class QuotaGroup(_messages.Message):
  """`QuotaGroup` defines a set of quota limits to enforce.  Used by group-
  based quotas only.

  Fields:
    billable: Indicates if the quota limits defined in this quota group apply
      to consumers who have active billing. Quota limits defined in billable
      groups will be applied only to consumers who have active billing. The
      amount of tokens consumed from billable quota group will also be
      reported for billing. Quota limits defined in non-billable groups will
      be applied only to consumers who have no active billing.
    description: User-visible description of this quota group.
    limits: Quota limits to be enforced when this quota group is used. A
      request must satisfy all the limits in a group for it to be permitted.
    name: Name of this quota group. Must be unique within the service.  Quota
      group name is used as part of the id for quota limits. Once the quota
      group has been put into use, the name of the quota group should be
      immutable.
  """

  billable = _messages.BooleanField(1)
  description = _messages.StringField(2)
  limits = _messages.MessageField('QuotaLimit', 3, repeated=True)
  name = _messages.StringField(4)


class QuotaInfo(_messages.Message):
  """Metadata about an individual quota, containing usage and limit
  information.

  Fields:
    currentUsage: The usage data for this quota as it applies to the current
      limit.
    historicalUsage: The historical usage data of this quota limit. Currently
      it is only available for daily quota limit, that is, base_limit.duration
      = "1d".
    limit: The effective limit for this quota.
  """

  currentUsage = _messages.MessageField('QuotaUsage', 1)
  historicalUsage = _messages.MessageField('QuotaUsage', 2, repeated=True)
  limit = _messages.MessageField('EffectiveQuotaLimit', 3)


class QuotaLimit(_messages.Message):
  """`QuotaLimit` defines a specific limit that applies over a specified
  duration for a limit type. There can be at most one limit for a duration and
  limit type combination defined within a `QuotaGroup`.

  Enums:
    LimitByValueValuesEnum: Limit type to use for enforcing this quota limit.
      Each unique value gets the defined number of tokens to consume from. For
      a quota limit that uses user type, each user making requests through the
      same client application project will get his/her own pool of tokens to
      consume, whereas for a limit that uses client project type, all users
      making requests through the same client application project share a
      single pool of tokens.  Used by group-based quotas only.

  Messages:
    ValuesValue: Tiered limit values. Also allows for regional or zone
      overrides for these values if "/{region}" or "/{zone}" is specified in
      the unit field.  Currently supported tiers from low to high: VERY_LOW,
      LOW, STANDARD, HIGH, VERY_HIGH  To apply different limit values for
      users according to their tiers, specify the values for the tiers you
      want to differentiate. For example: {LOW:100, STANDARD:500, HIGH:1000,
      VERY_HIGH:5000}  The limit value for each tier is optional except for
      the tier STANDARD. The limit value for an unspecified tier falls to the
      value of its next tier towards tier STANDARD. For the above example, the
      limit value for tier STANDARD is 500.  To apply the same limit value for
      all users, just specify limit value for tier STANDARD. For example:
      {STANDARD:500}.  To apply a regional overide for a tier, add a map entry
      with key "<TIER>/<region>", where <region> is a region name. Similarly,
      for a zone override, add a map entry with key "<TIER>/{zone}". Further,
      a wildcard can be used at the end of a zone name in order to specify
      zone level overrides. For example: LOW: 10, STANDARD: 50, HIGH: 100, LOW
      /us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200, LOW
      /us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
      The regional overrides tier set for each region must be the same as the
      tier set for default limit values. Same rule applies for zone overrides
      tier as well.  Used by metric-based quotas only.

  Fields:
    defaultLimit: Default number of tokens that can be consumed during the
      specified duration. This is the number of tokens assigned when a client
      application developer activates the service for his/her project.
      Specifying a value of 0 will block all requests. This can be used if you
      are provisioning quota to selected consumers and blocking others.
      Similarly, a value of -1 will indicate an unlimited quota. No other
      negative values are allowed.  Used by group-based quotas only.
    description: Optional. User-visible, extended description for this quota
      limit. Should be used only when more context is needed to understand
      this limit than provided by the limit's display name (see:
      `display_name`).
    displayName: User-visible display name for this limit. Optional. If not
      set, the UI will provide a default display name based on the quota
      configuration. This field can be used to override the default display
      name generated from the configuration.
    duration: Duration of this limit in textual notation. Example: "100s",
      "24h", "1d". For duration longer than a day, only multiple of days is
      supported. We support only "100s" and "1d" for now. Additional support
      will be added in the future. "0" indicates indefinite duration.  Used by
      group-based quotas only.
    freeTier: Free tier value displayed in the Developers Console for this
      limit. The free tier is the number of tokens that will be subtracted
      from the billed amount when billing is enabled. This field can only be
      set on a limit with duration "1d", in a billable group; it is invalid on
      any other limit. If this field is not set, it defaults to 0, indicating
      that there is no free tier for this service.  Used by group-based quotas
      only.
    isPrecise: Whether the quota limit needs to be enforced precisely.  Note
      that precise quota limits are more expensive to enforce. Make a quota
      limit precise only if it is necessary.  Precise rate quota is not
      currently supported. An error will be raised if a rate quota is
      specified to be precise. Imprecise allocation quota is not currently
      supported.  Used by metric-based quotas only.
    limitBy: Limit type to use for enforcing this quota limit. Each unique
      value gets the defined number of tokens to consume from. For a quota
      limit that uses user type, each user making requests through the same
      client application project will get his/her own pool of tokens to
      consume, whereas for a limit that uses client project type, all users
      making requests through the same client application project share a
      single pool of tokens.  Used by group-based quotas only.
    maxLimit: Maximum number of tokens that can be consumed during the
      specified duration. Client application developers can override the
      default limit up to this maximum. If specified, this value cannot be set
      to a value less than the default limit. If not specified, it is set to
      the default limit.  To allow clients to apply overrides with no upper
      bound, set this to -1, indicating unlimited maximum quota.  Used by
      group-based quotas only.
    metric: The name of the metric this quota limit applies to. The quota
      limits with the same metric will be checked together during runtime. The
      metric must be defined within the service config.  Used by metric-based
      quotas only.
    name: Name of the quota limit. The name is used to refer to the limit when
      overriding the default limit on per-consumer basis.  For group-based
      quota limits, the name must be unique within the quota group. If a name
      is not provided, it will be generated from the limit_by and duration
      fields.  For metric-based quota limits, the name must be provided, and
      it must be unique within the service. The name can only include
      alphanumeric characters as well as '-'.  The maximum length of the limit
      name is 64 characters.  The name of a limit is used as a unique
      identifier for this limit. Therefore, once a limit has been put into
      use, its name should be immutable. You can use the display_name field to
      provide a user-friendly name for the limit. The display name can be
      evolved over time without affecting the identity of the limit.
    unit: Specify the unit of the quota limit. It uses the same syntax as
      Metric.unit. The supported unit kinds are determined by the quota
      backend system.  The [Google Service Control](https://cloud.google.com
      /service-control) supports the following unit components: * One of the
      time intevals:   * "/min"  for quota every minute.   * "/d"  for quota
      every 24 hours, starting 00:00 US Pacific Time.   * Otherwise the quota
      won't be reset by time, such as storage limit. * One and only one of the
      granted containers:   * "/{organization}" quota for an organization.   *
      "/{project}" quota for a project.   * "/{folder}" quota for a folder.
      * "/{resource}" quota for a universal resource. * Zero or more quota
      segmentation dimension. Not all combos are valid.   * "/{user}" quota
      for every user GAIA ID or client ip address.     User GAIA ID has
      precedence over client ip address.   * "/{region}" quota for every
      region. Not to be used with time intervals.   * Otherwise the resources
      granted on the target is not segmented.   * "/{zone}" quota for every
      zone. Not to be used with time intervals.   * Otherwise the resources
      granted on the target is not segmented.   * "/{resource}" quota for a
      resource associated with a project or org.  Here are some examples: *
      "1/min/{project}" for quota per minute per project. * "1/min/{user}" for
      quota per minute per user. * "1/min/{organization}" for quota per minute
      per organization.  Note: the order of unit components is insignificant.
      The "1" at the beginning is required to follow the metric unit syntax.
      Used by metric-based quotas only.
    values: Tiered limit values. Also allows for regional or zone overrides
      for these values if "/{region}" or "/{zone}" is specified in the unit
      field.  Currently supported tiers from low to high: VERY_LOW, LOW,
      STANDARD, HIGH, VERY_HIGH  To apply different limit values for users
      according to their tiers, specify the values for the tiers you want to
      differentiate. For example: {LOW:100, STANDARD:500, HIGH:1000,
      VERY_HIGH:5000}  The limit value for each tier is optional except for
      the tier STANDARD. The limit value for an unspecified tier falls to the
      value of its next tier towards tier STANDARD. For the above example, the
      limit value for tier STANDARD is 500.  To apply the same limit value for
      all users, just specify limit value for tier STANDARD. For example:
      {STANDARD:500}.  To apply a regional overide for a tier, add a map entry
      with key "<TIER>/<region>", where <region> is a region name. Similarly,
      for a zone override, add a map entry with key "<TIER>/{zone}". Further,
      a wildcard can be used at the end of a zone name in order to specify
      zone level overrides. For example: LOW: 10, STANDARD: 50, HIGH: 100, LOW
      /us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200, LOW
      /us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
      The regional overrides tier set for each region must be the same as the
      tier set for default limit values. Same rule applies for zone overrides
      tier as well.  Used by metric-based quotas only.
  """

  class LimitByValueValuesEnum(_messages.Enum):
    """Limit type to use for enforcing this quota limit. Each unique value
    gets the defined number of tokens to consume from. For a quota limit that
    uses user type, each user making requests through the same client
    application project will get his/her own pool of tokens to consume,
    whereas for a limit that uses client project type, all users making
    requests through the same client application project share a single pool
    of tokens.  Used by group-based quotas only.

    Values:
      CLIENT_PROJECT: ID of the project owned by the client application
        developer making the request.
      USER: ID of the end user making the request using the client
        application.
    """
    CLIENT_PROJECT = 0
    USER = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValuesValue(_messages.Message):
    """Tiered limit values. Also allows for regional or zone overrides for
    these values if "/{region}" or "/{zone}" is specified in the unit field.
    Currently supported tiers from low to high: VERY_LOW, LOW, STANDARD, HIGH,
    VERY_HIGH  To apply different limit values for users according to their
    tiers, specify the values for the tiers you want to differentiate. For
    example: {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}  The limit
    value for each tier is optional except for the tier STANDARD. The limit
    value for an unspecified tier falls to the value of its next tier towards
    tier STANDARD. For the above example, the limit value for tier STANDARD is
    500.  To apply the same limit value for all users, just specify limit
    value for tier STANDARD. For example: {STANDARD:500}.  To apply a regional
    overide for a tier, add a map entry with key "<TIER>/<region>", where
    <region> is a region name. Similarly, for a zone override, add a map entry
    with key "<TIER>/{zone}". Further, a wildcard can be used at the end of a
    zone name in order to specify zone level overrides. For example: LOW: 10,
    STANDARD: 50, HIGH: 100, LOW/us-central1: 20, STANDARD/us-central1: 60,
    HIGH/us-central1: 200, LOW/us-central1-*: 10, STANDARD/us-central1-*: 20,
    HIGH/us-central1-*: 80  The regional overrides tier set for each region
    must be the same as the tier set for default limit values. Same rule
    applies for zone overrides tier as well.  Used by metric-based quotas
    only.

    Messages:
      AdditionalProperty: An additional property for a ValuesValue object.

    Fields:
      additionalProperties: Additional properties of type ValuesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultLimit = _messages.IntegerField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  duration = _messages.StringField(4)
  freeTier = _messages.IntegerField(5)
  isPrecise = _messages.BooleanField(6)
  limitBy = _messages.EnumField('LimitByValueValuesEnum', 7)
  maxLimit = _messages.IntegerField(8)
  metric = _messages.StringField(9)
  name = _messages.StringField(10)
  unit = _messages.StringField(11)
  values = _messages.MessageField('ValuesValue', 12)


class QuotaLimitOverride(_messages.Message):
  """Specifies a custom quota limit that is applied for this consumer project.
  This overrides the default value in google.api.QuotaLimit.

  Fields:
    limit: The new limit for this project. May be -1 (unlimited), 0 (block),
      or any positive integer.
    unlimited: Indicates the override is to provide unlimited quota.  If true,
      any value set for limit will be ignored. DEPRECATED. Use a limit value
      of -1 instead.
  """

  limit = _messages.IntegerField(1)
  unlimited = _messages.BooleanField(2)


class QuotaSettings(_messages.Message):
  """Per-consumer overrides for quota settings. See google/api/quota.proto for
  the corresponding service configuration which provides the default values.

  Messages:
    ConsumerOverridesValue: Quota overrides set by the consumer. Consumer
      overrides will only have an effect up to the max_limit specified in the
      service config, or the the producer override, if one exists.  The key
      for this map is one of the following:  - '<GROUP_NAME>/<LIMIT_NAME>' for
      group-based quotas, where GROUP_NAME is the google.api.QuotaGroup.name
      field and LIMIT_NAME is the google.api.QuotaLimit.name field from the
      service config.  For example: 'ReadGroup/ProjectDaily'.  -
      '<LIMIT_NAME>' for metric-based quotas, where LIMIT_NAME is the
      google.api.QuotaLimit.name field from the service config. For example:
      'borrowedCountPerOrganization'.  - '<LIMIT_NAME>[@DIMENSION_SETTINGS]+
      for dimensional set overrides   Where DIMENSION_SETTING is
      <dimension_name>:<dimension_value>.   For example   Limit1@region:us-
      central1      is an override for limit 1, for region us-central1
      limit1@zone:us-central1-a      is an override for limit 1, for zone us-
      central1-a.  NOTE that for      backwards compatibility, this is the
      same as region:us-central1-a   limit2@region:us-east1@user:12345      is
      an override for region us-east1, and user set to 12345. Only metric-
      based quotas can have these overrides. Per-region override takes effect
      if both per-region override and global override are defined.
    EffectiveQuotasValue: The effective quota limits for each group, derived
      from the service defaults together with any producer or consumer
      overrides. For each limit, the effective value is the minimum of the
      producer and consumer overrides if either is present, or else the
      service default if neither is present. DEPRECATED. Use
      effective_quota_groups instead.
    ProducerOverridesValue: Quota overrides set by the producer. Note that if
      a consumer override is also specified, then the minimum of the two will
      be used. This allows consumers to cap their usage voluntarily.  The key
      for this map is the same as the key for consumer_overrides.

  Fields:
    consumerOverrides: Quota overrides set by the consumer. Consumer overrides
      will only have an effect up to the max_limit specified in the service
      config, or the the producer override, if one exists.  The key for this
      map is one of the following:  - '<GROUP_NAME>/<LIMIT_NAME>' for group-
      based quotas, where GROUP_NAME is the google.api.QuotaGroup.name field
      and LIMIT_NAME is the google.api.QuotaLimit.name field from the service
      config.  For example: 'ReadGroup/ProjectDaily'.  - '<LIMIT_NAME>' for
      metric-based quotas, where LIMIT_NAME is the google.api.QuotaLimit.name
      field from the service config. For example:
      'borrowedCountPerOrganization'.  - '<LIMIT_NAME>[@DIMENSION_SETTINGS]+
      for dimensional set overrides   Where DIMENSION_SETTING is
      <dimension_name>:<dimension_value>.   For example   Limit1@region:us-
      central1      is an override for limit 1, for region us-central1
      limit1@zone:us-central1-a      is an override for limit 1, for zone us-
      central1-a.  NOTE that for      backwards compatibility, this is the
      same as region:us-central1-a   limit2@region:us-east1@user:12345      is
      an override for region us-east1, and user set to 12345. Only metric-
      based quotas can have these overrides. Per-region override takes effect
      if both per-region override and global override are defined.
    effectiveQuotaForMetrics: Use this field for metric-based quota limits.
      Combines service quota configuration and project-specific settings, as a
      map from metric name to the effective quota information for quota limits
      on that metric. Output-only
    effectiveQuotaGroups: Use this field for group-based quota limits.
      Combines service quota configuration and project-specific settings, as a
      map from quota group name to the effective quota information for that
      group. Output-only.
    effectiveQuotas: The effective quota limits for each group, derived from
      the service defaults together with any producer or consumer overrides.
      For each limit, the effective value is the minimum of the producer and
      consumer overrides if either is present, or else the service default if
      neither is present. DEPRECATED. Use effective_quota_groups instead.
    producerOverrides: Quota overrides set by the producer. Note that if a
      consumer override is also specified, then the minimum of the two will be
      used. This allows consumers to cap their usage voluntarily.  The key for
      this map is the same as the key for consumer_overrides.
    variableTermQuotas: Quotas that are active over a specified time period.
      Only writeable by the producer.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConsumerOverridesValue(_messages.Message):
    """Quota overrides set by the consumer. Consumer overrides will only have
    an effect up to the max_limit specified in the service config, or the the
    producer override, if one exists.  The key for this map is one of the
    following:  - '<GROUP_NAME>/<LIMIT_NAME>' for group-based quotas, where
    GROUP_NAME is the google.api.QuotaGroup.name field and LIMIT_NAME is the
    google.api.QuotaLimit.name field from the service config.  For example:
    'ReadGroup/ProjectDaily'.  - '<LIMIT_NAME>' for metric-based quotas, where
    LIMIT_NAME is the google.api.QuotaLimit.name field from the service
    config. For example: 'borrowedCountPerOrganization'.  -
    '<LIMIT_NAME>[@DIMENSION_SETTINGS]+ for dimensional set overrides   Where
    DIMENSION_SETTING is <dimension_name>:<dimension_value>.   For example
    Limit1@region:us-central1      is an override for limit 1, for region us-
    central1   limit1@zone:us-central1-a      is an override for limit 1, for
    zone us-central1-a.  NOTE that for      backwards compatibility, this is
    the same as region:us-central1-a   limit2@region:us-east1@user:12345
    is an override for region us-east1, and user set to 12345. Only metric-
    based quotas can have these overrides. Per-region override takes effect if
    both per-region override and global override are defined.

    Messages:
      AdditionalProperty: An additional property for a ConsumerOverridesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ConsumerOverridesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ConsumerOverridesValue object.

      Fields:
        key: Name of the additional property.
        value: A QuotaLimitOverride attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('QuotaLimitOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EffectiveQuotasValue(_messages.Message):
    """The effective quota limits for each group, derived from the service
    defaults together with any producer or consumer overrides. For each limit,
    the effective value is the minimum of the producer and consumer overrides
    if either is present, or else the service default if neither is present.
    DEPRECATED. Use effective_quota_groups instead.

    Messages:
      AdditionalProperty: An additional property for a EffectiveQuotasValue
        object.

    Fields:
      additionalProperties: Additional properties of type EffectiveQuotasValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a EffectiveQuotasValue object.

      Fields:
        key: Name of the additional property.
        value: A QuotaLimitOverride attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('QuotaLimitOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProducerOverridesValue(_messages.Message):
    """Quota overrides set by the producer. Note that if a consumer override
    is also specified, then the minimum of the two will be used. This allows
    consumers to cap their usage voluntarily.  The key for this map is the
    same as the key for consumer_overrides.

    Messages:
      AdditionalProperty: An additional property for a ProducerOverridesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ProducerOverridesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ProducerOverridesValue object.

      Fields:
        key: Name of the additional property.
        value: A QuotaLimitOverride attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('QuotaLimitOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerOverrides = _messages.MessageField('ConsumerOverridesValue', 1)
  effectiveQuotaForMetrics = _messages.MessageField('EffectiveQuotasForMetric', 2, repeated=True)
  effectiveQuotaGroups = _messages.MessageField('EffectiveQuotaGroup', 3, repeated=True)
  effectiveQuotas = _messages.MessageField('EffectiveQuotasValue', 4)
  producerOverrides = _messages.MessageField('ProducerOverridesValue', 5)
  variableTermQuotas = _messages.MessageField('VariableTermQuota', 6, repeated=True)


class QuotaUsage(_messages.Message):
  """Specifies the used quota amount for a quota limit at a particular time.

  Enums:
    HierarchyLimitWarningValueValuesEnum: Somewhere in hierarchy a limit is
      close to full.  Readonly

  Fields:
    endTime: The time the quota duration ended.
    hierarchyLimitWarning: Somewhere in hierarchy a limit is close to full.
      Readonly
    queryTime: The time the quota usage data was queried.
    startTime: The time the quota duration started.
    usage: The used quota value at the "query_time".
  """

  class HierarchyLimitWarningValueValuesEnum(_messages.Enum):
    """Somewhere in hierarchy a limit is close to full.  Readonly

    Values:
      HIERARCHY_LIMIT_WARNING_UNSPECIFIED: <no description>
      NO_WARNING: <no description>
      WARNING: <no description>
    """
    HIERARCHY_LIMIT_WARNING_UNSPECIFIED = 0
    NO_WARNING = 1
    WARNING = 2

  endTime = _messages.StringField(1)
  hierarchyLimitWarning = _messages.EnumField('HierarchyLimitWarningValueValuesEnum', 2)
  queryTime = _messages.StringField(3)
  startTime = _messages.StringField(4)
  usage = _messages.IntegerField(5)


class Rollout(_messages.Message):
  """A rollout resource that defines how service configuration versions are
  pushed to control plane systems. Typically, you create a new version of the
  service config, and then create a Rollout to push the service config.

  Enums:
    StatusValueValuesEnum: The status of this rollout. Readonly. In case of a
      failed rollout, the system will automatically rollback to the current
      Rollout version. Readonly.

  Fields:
    createTime: Creation time of the rollout. Readonly.
    createdBy: The user who created the Rollout. Readonly.
    deleteServiceStrategy: The strategy associated with a rollout to delete a
      `ManagedService`. Readonly.
    rolloutId: Optional unique identifier of this Rollout. Only lower case
      letters, digits  and '-' are allowed.  If not specified by client, the
      server will generate one. The generated id will have the form of
      <date><revision number>, where "date" is the create date in ISO 8601
      format.  "revision number" is a monotonically increasing positive number
      that is reset every day for each service. An example of the generated
      rollout_id is '2016-02-16r1'
    serviceName: The name of the service associated with this Rollout.
    status: The status of this rollout. Readonly. In case of a failed rollout,
      the system will automatically rollback to the current Rollout version.
      Readonly.
    trafficPercentStrategy: Google Service Control selects service
      configurations based on traffic percentage.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """The status of this rollout. Readonly. In case of a failed rollout, the
    system will automatically rollback to the current Rollout version.
    Readonly.

    Values:
      ROLLOUT_STATUS_UNSPECIFIED: No status specified.
      IN_PROGRESS: The Rollout is in progress.
      SUCCESS: The Rollout has completed successfully.
      CANCELLED: The Rollout has been cancelled. This can happen if you have
        overlapping Rollout pushes, and the previous ones will be cancelled.
      FAILED: The Rollout has failed. It is typically caused by configuration
        errors.
      PENDING: The Rollout has not started yet and is pending for execution.
    """
    ROLLOUT_STATUS_UNSPECIFIED = 0
    IN_PROGRESS = 1
    SUCCESS = 2
    CANCELLED = 3
    FAILED = 4
    PENDING = 5

  createTime = _messages.StringField(1)
  createdBy = _messages.StringField(2)
  deleteServiceStrategy = _messages.MessageField('DeleteServiceStrategy', 3)
  rolloutId = _messages.StringField(4)
  serviceName = _messages.StringField(5)
  status = _messages.EnumField('StatusValueValuesEnum', 6)
  trafficPercentStrategy = _messages.MessageField('TrafficPercentStrategy', 7)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries is the same as for members in a Binding (see
      google/iam/v1/policy.proto).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class Service(_messages.Message):
  """`Service` is the root object of Google service configuration schema. It
  describes basic information about a service, such as the name and the title,
  and delegates other aspects to sub-sections. Each sub-section is either a
  proto message or a repeated proto message that configures a specific aspect,
  such as auth. See each proto message definition for details.  Example:
  type: google.api.Service     config_version: 3     name:
  calendar.googleapis.com     title: Google Calendar API     apis:     - name:
  google.calendar.v3.Calendar     authentication:       providers:       - id:
  google_calendar_auth         jwks_uri:
  https://www.googleapis.com/oauth2/v1/certs         issuer:
  https://securetoken.google.com       rules:       - selector: "*"
  requirements:           provider_id: google_calendar_auth

  Fields:
    apis: A list of API interfaces exported by this service. Only the `name`
      field of the google.protobuf.Api needs to be provided by the
      configuration author, as the remaining fields will be derived from the
      IDL during the normalization process. It is an error to specify an API
      interface here which cannot be resolved against the associated IDL
      files.
    authentication: Auth configuration.
    backend: API backend configuration.
    configVersion: The version of the service configuration. The config
      version may influence interpretation of the configuration, for example,
      to determine defaults. This is documented together with applicable
      options. The current default for the config version itself is `3`.
    context: Context configuration.
    control: Configuration for the service control plane.
    customError: Custom error configuration.
    documentation: Additional API documentation.
    endpoints: Configuration for network endpoints.  If this is empty, then an
      endpoint with the same name as the service is automatically generated to
      service all defined APIs.
    enums: A list of all enum types included in this API service.  Enums
      referenced directly or indirectly by the `apis` are automatically
      included.  Enums which are not referenced but shall be included should
      be listed here by name. Example:      enums:     - name:
      google.someapi.v1.SomeEnum
    experimental: Experimental configuration.
    http: HTTP configuration.
    id: A unique ID for a specific instance of this message, typically
      assigned by the client for tracking purpose. If empty, the server may
      choose to generate one instead.
    logging: Logging configuration.
    logs: Defines the logs used by this service.
    metrics: Defines the metrics used by this service.
    monitoredResources: Defines the monitored resources used by this service.
      This is required by the Service.monitoring and Service.logging
      configurations.
    monitoring: Monitoring configuration.
    name: The DNS address at which this service is available, e.g.
      `calendar.googleapis.com`.
    producerProjectId: The id of the Google developer project that owns the
      service. Members of this project can manage the service configuration,
      manage consumption of the service, etc.
    sourceInfo: Output only. The source information for this configuration if
      available.
    systemParameters: System parameter configuration.
    systemTypes: A list of all proto message types included in this API
      service. It serves similar purpose as [google.api.Service.types], except
      that these types are not needed by user-defined APIs. Therefore, they
      will not show up in the generated discovery doc. This field should only
      be used to define system APIs in ESF.
    title: The product title associated with this service.
    types: A list of all proto message types included in this API service.
      Types referenced directly or indirectly by the `apis` are automatically
      included.  Messages which are not referenced but shall be included, such
      as types used by the `google.protobuf.Any` type, should be listed here
      by name. Example:      types:     - name: google.protobuf.Int32
    usage: Configuration controlling usage of this service.
    visibility: API visibility configuration.
  """

  apis = _messages.MessageField('Api', 1, repeated=True)
  authentication = _messages.MessageField('Authentication', 2)
  backend = _messages.MessageField('Backend', 3)
  configVersion = _messages.IntegerField(4, variant=_messages.Variant.UINT32)
  context = _messages.MessageField('Context', 5)
  control = _messages.MessageField('Control', 6)
  customError = _messages.MessageField('CustomError', 7)
  documentation = _messages.MessageField('Documentation', 8)
  endpoints = _messages.MessageField('Endpoint', 9, repeated=True)
  enums = _messages.MessageField('Enum', 10, repeated=True)
  experimental = _messages.MessageField('Experimental', 11)
  http = _messages.MessageField('Http', 12)
  id = _messages.StringField(13)
  logging = _messages.MessageField('Logging', 14)
  logs = _messages.MessageField('LogDescriptor', 15, repeated=True)
  metrics = _messages.MessageField('MetricDescriptor', 16, repeated=True)
  monitoredResources = _messages.MessageField('MonitoredResourceDescriptor', 17, repeated=True)
  monitoring = _messages.MessageField('Monitoring', 18)
  name = _messages.StringField(19)
  producerProjectId = _messages.StringField(20)
  sourceInfo = _messages.MessageField('SourceInfo', 21)
  systemParameters = _messages.MessageField('SystemParameters', 22)
  systemTypes = _messages.MessageField('Type', 23, repeated=True)
  title = _messages.StringField(24)
  types = _messages.MessageField('Type', 25, repeated=True)
  usage = _messages.MessageField('Usage', 26)
  visibility = _messages.MessageField('Visibility', 27)


class ServicemanagementOperationsGetRequest(_messages.Message):
  """A ServicemanagementOperationsGetRequest object.

  Fields:
    operationsId: Part of `name`. The name of the operation resource.
  """

  operationsId = _messages.StringField(1, required=True)


class ServicemanagementOperationsListRequest(_messages.Message):
  """A ServicemanagementOperationsListRequest object.

  Fields:
    filter: A string for filtering Operations.   The following filter fields
      are supported&#58;    * serviceName&#58; Required. Only `=` operator is
      allowed.   * startTime&#58; The time this job was started, in ISO 8601
      format.     Allowed operators are `>=`,  `>`, `<=`, and `<`.   *
      status&#58; Can be `done`, `in_progress`, or `failed`. Allowed
      operators are `=`, and `!=`.    Filter expression supports conjunction
      (AND) and disjunction (OR)   logical operators. However, the serviceName
      restriction must be at the   top-level and can only be combined with
      other restrictions via the AND   logical operator.    Examples&#58;    *
      `serviceName={some-service}.googleapis.com`   * `serviceName={some-
      service}.googleapis.com AND startTime>="2017-02-01"`   * `serviceName
      ={some-service}.googleapis.com AND status=done`   * `serviceName={some-
      service}.googleapis.com AND (status=done OR startTime>="2017-02-01")`
    name: Not used.
    pageSize: The maximum number of operations to return. If unspecified,
      defaults to 50. The maximum value is 100.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ServicemanagementServicesAccessPolicyQueryRequest(_messages.Message):
  """A ServicemanagementServicesAccessPolicyQueryRequest object.

  Fields:
    serviceName: The service to query access for.
    userEmail: The user to query access for.
  """

  serviceName = _messages.StringField(1, required=True)
  userEmail = _messages.StringField(2)


class ServicemanagementServicesConfigsCreateRequest(_messages.Message):
  """A ServicemanagementServicesConfigsCreateRequest object.

  Fields:
    service: A Service resource to be passed as the request body.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
  """

  service = _messages.MessageField('Service', 1)
  serviceName = _messages.StringField(2, required=True)


class ServicemanagementServicesConfigsGetRequest(_messages.Message):
  """A ServicemanagementServicesConfigsGetRequest object.

  Enums:
    ViewValueValuesEnum: Specifies which parts of the Service Config should be
      returned in the response.

  Fields:
    configId: The id of the service configuration resource.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    view: Specifies which parts of the Service Config should be returned in
      the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Specifies which parts of the Service Config should be returned in the
    response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  configId = _messages.StringField(1, required=True)
  serviceName = _messages.StringField(2, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class ServicemanagementServicesConfigsListRequest(_messages.Message):
  """A ServicemanagementServicesConfigsListRequest object.

  Fields:
    pageSize: The max number of items to include in the response list.
    pageToken: The token of the page to retrieve.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  serviceName = _messages.StringField(3, required=True)


class ServicemanagementServicesConfigsSubmitRequest(_messages.Message):
  """A ServicemanagementServicesConfigsSubmitRequest object.

  Fields:
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    submitConfigSourceRequest: A SubmitConfigSourceRequest resource to be
      passed as the request body.
  """

  serviceName = _messages.StringField(1, required=True)
  submitConfigSourceRequest = _messages.MessageField('SubmitConfigSourceRequest', 2)


class ServicemanagementServicesConsumersListRequest(_messages.Message):
  """A ServicemanagementServicesConsumersListRequest object.

  Fields:
    consumerId: Include services consumed by the specified consumer.  The
      Google Service Management implementation accepts the following forms: -
      project:<project_id> - organization:<organization number> -
      folder:<folder number>  In this version of the API, the only supported
      consumer type is "organization".
    consumerIds: A string attribute.
    pageSize: Requested size of the next page of data.
    pageToken: Token identifying which result to start with; returned by a
      previous list call.
    serviceName: If service_name is specified, return only consumer settings
      for the specified service.  If not specified, for organizations or
      folders this will return consumer settings for all services that have
      defined org-level quotas in the service configuration. For projects,
      this will return consumer project settings for all services activated by
      the consumer project.  In this version of the API, the only supported
      consumer type is "organization".
  """

  consumerId = _messages.StringField(1)
  consumerIds = _messages.StringField(2, repeated=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  serviceName = _messages.StringField(5, required=True)


class ServicemanagementServicesCustomerSettingsGetRequest(_messages.Message):
  """A ServicemanagementServicesCustomerSettingsGetRequest object.

  Enums:
    ViewValueValuesEnum: Request only fields for the specified view.

  Fields:
    customerId: ID for the customer. See the comment for
      `CustomerSettings.customer_id` field of message for its format. This
      field is required.
    expand: Fields to expand in any results.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`. This field is required.
    view: Request only fields for the specified view.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Request only fields for the specified view.

    Values:
      PROJECT_SETTINGS_VIEW_UNSPECIFIED: <no description>
      CONSUMER_VIEW: <no description>
      PRODUCER_VIEW: <no description>
      ALL: <no description>
    """
    PROJECT_SETTINGS_VIEW_UNSPECIFIED = 0
    CONSUMER_VIEW = 1
    PRODUCER_VIEW = 2
    ALL = 3

  customerId = _messages.StringField(1, required=True)
  expand = _messages.StringField(2)
  serviceName = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class ServicemanagementServicesCustomerSettingsPatchRequest(_messages.Message):
  """A ServicemanagementServicesCustomerSettingsPatchRequest object.

  Fields:
    customerId: ID for the customer. See the comment for
      `CustomerSettings.customer_id` field of message for its format. This
      field is required.
    customerSettings: A CustomerSettings resource to be passed as the request
      body.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`. This field is required.
    updateMask: The field mask specifying which fields are to be updated.
  """

  customerId = _messages.StringField(1, required=True)
  customerSettings = _messages.MessageField('CustomerSettings', 2)
  serviceName = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ServicemanagementServicesDeleteRequest(_messages.Message):
  """A ServicemanagementServicesDeleteRequest object.

  Fields:
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
  """

  serviceName = _messages.StringField(1, required=True)


class ServicemanagementServicesDisableRequest(_messages.Message):
  """A ServicemanagementServicesDisableRequest object.

  Fields:
    disableServiceRequest: A DisableServiceRequest resource to be passed as
      the request body.
    serviceName: Name of the service to disable. Specifying an unknown service
      name will cause the request to fail.
  """

  disableServiceRequest = _messages.MessageField('DisableServiceRequest', 1)
  serviceName = _messages.StringField(2, required=True)


class ServicemanagementServicesEnableRequest(_messages.Message):
  """A ServicemanagementServicesEnableRequest object.

  Fields:
    enableServiceRequest: A EnableServiceRequest resource to be passed as the
      request body.
    serviceName: Name of the service to enable. Specifying an unknown service
      name will cause the request to fail.
  """

  enableServiceRequest = _messages.MessageField('EnableServiceRequest', 1)
  serviceName = _messages.StringField(2, required=True)


class ServicemanagementServicesGetConfigRequest(_messages.Message):
  """A ServicemanagementServicesGetConfigRequest object.

  Enums:
    ViewValueValuesEnum: Specifies which parts of the Service Config should be
      returned in the response.

  Fields:
    configId: The id of the service configuration resource.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    view: Specifies which parts of the Service Config should be returned in
      the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Specifies which parts of the Service Config should be returned in the
    response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  configId = _messages.StringField(1)
  serviceName = _messages.StringField(2, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class ServicemanagementServicesGetIamPolicyRequest(_messages.Message):
  """A ServicemanagementServicesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    servicesId: Part of `resource`. REQUIRED: The resource for which the
      policy is being requested. See the operation documentation for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  servicesId = _messages.StringField(2, required=True)


class ServicemanagementServicesGetRequest(_messages.Message):
  """A ServicemanagementServicesGetRequest object.

  Enums:
    ViewValueValuesEnum: If project_settings is expanded, request only fields
      for the specified view.

  Fields:
    consumerProjectId: If project_settings is expanded, return settings for
      the specified consumer project.
    expand: Fields to expand in any results.  By default, the following fields
      are not present in the result: - `operations` - `project_settings` -
      `project_settings.operations` - `quota_usage` (It requires
      `project_settings`) - `historical_quota_usage` (It requires
      `project_settings`)
    serviceName: The name of the service.  See the `ServiceManager` overview
      for naming requirements.  For example: `example.googleapis.com`.
    view: If project_settings is expanded, request only fields for the
      specified view.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """If project_settings is expanded, request only fields for the specified
    view.

    Values:
      PROJECT_SETTINGS_VIEW_UNSPECIFIED: <no description>
      CONSUMER_VIEW: <no description>
      PRODUCER_VIEW: <no description>
      ALL: <no description>
    """
    PROJECT_SETTINGS_VIEW_UNSPECIFIED = 0
    CONSUMER_VIEW = 1
    PRODUCER_VIEW = 2
    ALL = 3

  consumerProjectId = _messages.StringField(1)
  expand = _messages.StringField(2)
  serviceName = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class ServicemanagementServicesListRequest(_messages.Message):
  """A ServicemanagementServicesListRequest object.

  Fields:
    category: Include services only in the specified category. Supported
      categories are servicemanagement.googleapis.com/categories/google-
      services or servicemanagement.googleapis.com/categories/play-games.
    consumerId: Include services consumed by the specified consumer.  The
      Google Service Management implementation accepts the following forms: -
      project:<project_id>
    consumerProjectId: Include services consumed by the specified project.  If
      project_settings is expanded, then this field controls which project
      project_settings is populated for.
    expand: Fields to expand in any results.  By default, the following fields
      are not fully included in list results: - `operations` -
      `project_settings` - `project_settings.operations` - `quota_usage` (It
      requires `project_settings`)
    pageSize: Requested size of the next page of data.
    pageToken: Token identifying which result to start with; returned by a
      previous list call.
    producerProjectId: Include services produced by the specified project.
  """

  category = _messages.StringField(1)
  consumerId = _messages.StringField(2)
  consumerProjectId = _messages.StringField(3)
  expand = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  producerProjectId = _messages.StringField(7)


class ServicemanagementServicesPatchRequest(_messages.Message):
  """A ServicemanagementServicesPatchRequest object.

  Fields:
    managedService: A ManagedService resource to be passed as the request
      body.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    updateMask: A mask specifying which field to update - only one should be
      set.
  """

  managedService = _messages.MessageField('ManagedService', 1)
  serviceName = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ServicemanagementServicesProjectSettingsGetRequest(_messages.Message):
  """A ServicemanagementServicesProjectSettingsGetRequest object.

  Enums:
    ViewValueValuesEnum: Request only the fields for the specified view.

  Fields:
    consumerProjectId: The project ID of the consumer.
    expand: Fields to expand in any results.  By default, the following fields
      are not present in the result: - `operations` - `quota_usage`
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    view: Request only the fields for the specified view.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Request only the fields for the specified view.

    Values:
      PROJECT_SETTINGS_VIEW_UNSPECIFIED: <no description>
      CONSUMER_VIEW: <no description>
      PRODUCER_VIEW: <no description>
      ALL: <no description>
    """
    PROJECT_SETTINGS_VIEW_UNSPECIFIED = 0
    CONSUMER_VIEW = 1
    PRODUCER_VIEW = 2
    ALL = 3

  consumerProjectId = _messages.StringField(1, required=True)
  expand = _messages.StringField(2)
  serviceName = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class ServicemanagementServicesProjectSettingsPatchRequest(_messages.Message):
  """A ServicemanagementServicesProjectSettingsPatchRequest object.

  Fields:
    consumerProjectId: The project ID of the consumer.
    projectSettings: A ProjectSettings resource to be passed as the request
      body.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    updateMask: The field mask specifying which fields are to be updated.
  """

  consumerProjectId = _messages.StringField(1, required=True)
  projectSettings = _messages.MessageField('ProjectSettings', 2)
  serviceName = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ServicemanagementServicesRolloutsGetRequest(_messages.Message):
  """A ServicemanagementServicesRolloutsGetRequest object.

  Fields:
    rolloutId: The id of the rollout resource.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
  """

  rolloutId = _messages.StringField(1, required=True)
  serviceName = _messages.StringField(2, required=True)


class ServicemanagementServicesRolloutsListRequest(_messages.Message):
  """A ServicemanagementServicesRolloutsListRequest object.

  Fields:
    pageSize: The max number of items to include in the response list.
    pageToken: The token of the page to retrieve.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  serviceName = _messages.StringField(3, required=True)


class ServicemanagementServicesSetIamPolicyRequest(_messages.Message):
  """A ServicemanagementServicesSetIamPolicyRequest object.

  Fields:
    servicesId: Part of `resource`. REQUIRED: The resource for which the
      policy is being specified. See the operation documentation for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  servicesId = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ServicemanagementServicesTestIamPermissionsRequest(_messages.Message):
  """A ServicemanagementServicesTestIamPermissionsRequest object.

  Fields:
    servicesId: Part of `resource`. REQUIRED: The resource for which the
      policy detail is being requested. See the operation documentation for
      the appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  servicesId = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ServicemanagementServicesUndeleteRequest(_messages.Message):
  """A ServicemanagementServicesUndeleteRequest object.

  Fields:
    serviceName: The name of the service. See the [overview](/service-
      management/overview) for naming requirements. For example:
      `example.googleapis.com`.
  """

  serviceName = _messages.StringField(1, required=True)


class ServicemanagementServicesUpdateRequest(_messages.Message):
  """A ServicemanagementServicesUpdateRequest object.

  Fields:
    managedService: A ManagedService resource to be passed as the request
      body.
    serviceName: The name of the service.  See the [overview](/service-
      management/overview) for naming requirements.  For example:
      `example.googleapis.com`.
    updateMask: A mask specifying which fields to update. Update mask has been
      deprecated on UpdateService service method. Please use PatchService
      method instead to do partial updates.
  """

  managedService = _messages.MessageField('ManagedService', 1)
  serviceName = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SourceContext(_messages.Message):
  """`SourceContext` represents information about the source of a protobuf
  element, like the file in which it is defined.

  Fields:
    fileName: The path-qualified name of the .proto file that contained the
      associated protobuf element.  For example:
      `"google/protobuf/source_context.proto"`.
  """

  fileName = _messages.StringField(1)


class SourceInfo(_messages.Message):
  """Source information used to create a Service Config

  Messages:
    SourceFilesValueListEntry: A SourceFilesValueListEntry object.

  Fields:
    sourceFiles: All files used during config generation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourceFilesValueListEntry(_messages.Message):
    """A SourceFilesValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        SourceFilesValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a SourceFilesValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  sourceFiles = _messages.MessageField('SourceFilesValueListEntry', 1, repeated=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Step(_messages.Message):
  """Represents the status of one operation step.

  Enums:
    StatusValueValuesEnum: The status code.

  Fields:
    description: The short description of the step.
    status: The status code.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """The status code.

    Values:
      STATUS_UNSPECIFIED: Unspecifed code.
      DONE: The operation or step has completed without errors.
      NOT_STARTED: The operation or step has not started yet.
      IN_PROGRESS: The operation or step is in progress.
      FAILED: The operation or step has completed with errors.
      CANCELLED: The operation or step has completed with cancellation.
    """
    STATUS_UNSPECIFIED = 0
    DONE = 1
    NOT_STARTED = 2
    IN_PROGRESS = 3
    FAILED = 4
    CANCELLED = 5

  description = _messages.StringField(1)
  status = _messages.EnumField('StatusValueValuesEnum', 2)


class SubmitConfigSourceRequest(_messages.Message):
  """Request message for SubmitConfigSource method.

  Fields:
    configSource: The source configuration for the service.
    validateOnly: Optional. If set, this will result in the generation of a
      `google.api.Service` configuration based on the `ConfigSource` provided,
      but the generated config and the sources will NOT be persisted.
  """

  configSource = _messages.MessageField('ConfigSource', 1)
  validateOnly = _messages.BooleanField(2)


class SubmitConfigSourceResponse(_messages.Message):
  """Response message for SubmitConfigSource method.

  Fields:
    diagnostics: Diagnostics occured during config conversion.
    serviceConfig: The generated service configuration.
  """

  diagnostics = _messages.MessageField('Diagnostic', 1, repeated=True)
  serviceConfig = _messages.MessageField('Service', 2)


class SwaggerSpec(_messages.Message):
  """A collection of swagger specification files.

  Fields:
    swaggerFiles: The individual files.
  """

  swaggerFiles = _messages.MessageField('File', 1, repeated=True)


class SystemParameter(_messages.Message):
  """Define a parameter's name and location. The parameter may be passed as
  either an HTTP header or a URL query parameter, and if both are passed the
  behavior is implementation-dependent.

  Fields:
    httpHeader: Define the HTTP header name to use for the parameter. It is
      case insensitive.
    name: Define the name of the parameter, such as "api_key" . It is case
      sensitive.
    urlQueryParameter: Define the URL query parameter name to use for the
      parameter. It is case sensitive.
  """

  httpHeader = _messages.StringField(1)
  name = _messages.StringField(2)
  urlQueryParameter = _messages.StringField(3)


class SystemParameterRule(_messages.Message):
  """Define a system parameter rule mapping system parameter definitions to
  methods.

  Fields:
    parameters: Define parameters. Multiple names may be defined for a
      parameter. For a given method call, only one of them should be used. If
      multiple names are used the behavior is implementation-dependent. If
      none of the specified names are present the behavior is parameter-
      dependent.
    selector: Selects the methods to which this rule applies. Use '*' to
      indicate all methods in all APIs.  Refer to selector for syntax details.
  """

  parameters = _messages.MessageField('SystemParameter', 1, repeated=True)
  selector = _messages.StringField(2)


class SystemParameters(_messages.Message):
  """### System parameter configuration  A system parameter is a special kind
  of parameter defined by the API system, not by an individual API. It is
  typically mapped to an HTTP header and/or a URL query parameter. This
  configuration specifies which methods change the names of the system
  parameters.

  Fields:
    rules: Define system parameters.  The parameters defined here will
      override the default parameters implemented by the system. If this field
      is missing from the service config, default system parameters will be
      used. Default system parameters and names is implementation-dependent.
      Example: define api key for all methods      system_parameters
      rules:         - selector: "*"           parameters:             - name:
      api_key               url_query_parameter: api_key   Example: define 2
      api key names for a specific method.      system_parameters       rules:
      - selector: "/ListShelves"           parameters:             - name:
      api_key               http_header: Api-Key1             - name: api_key
      http_header: Api-Key2  **NOTE:** All service configuration rules follow
      "last one wins" order.
  """

  rules = _messages.MessageField('SystemParameterRule', 1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  """Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  """Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TrafficPercentStrategy(_messages.Message):
  """Strategy that specifies how Google Service Control should select
  different versions of service configurations based on traffic percentage.
  One example of how to gradually rollout a new service configuration using
  this strategy: Day 1      Rollout {       id:
  "example.googleapis.com/rollout_20160206"       traffic_percent_strategy {
  percentages: {           "example.googleapis.com/20160201": 70.00
  "example.googleapis.com/20160206": 30.00         }       }     }  Day 2
  Rollout {       id: "example.googleapis.com/rollout_20160207"
  traffic_percent_strategy: {         percentages: {
  "example.googleapis.com/20160206": 100.00         }       }     }

  Messages:
    PercentagesValue: Maps service configuration IDs to their corresponding
      traffic percentage. Key is the service configuration ID, Value is the
      traffic percentage which must be greater than 0.0 and the sum must equal
      to 100.0.

  Fields:
    percentages: Maps service configuration IDs to their corresponding traffic
      percentage. Key is the service configuration ID, Value is the traffic
      percentage which must be greater than 0.0 and the sum must equal to
      100.0.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PercentagesValue(_messages.Message):
    """Maps service configuration IDs to their corresponding traffic
    percentage. Key is the service configuration ID, Value is the traffic
    percentage which must be greater than 0.0 and the sum must equal to 100.0.

    Messages:
      AdditionalProperty: An additional property for a PercentagesValue
        object.

    Fields:
      additionalProperties: Additional properties of type PercentagesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PercentagesValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  percentages = _messages.MessageField('PercentagesValue', 1)


class Type(_messages.Message):
  """A protocol buffer message type.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    fields: The list of fields.
    name: The fully qualified message name.
    oneofs: The list of types appearing in `oneof` definitions in this type.
    options: The protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    """The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  fields = _messages.MessageField('Field', 1, repeated=True)
  name = _messages.StringField(2)
  oneofs = _messages.StringField(3, repeated=True)
  options = _messages.MessageField('Option', 4, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 5)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 6)


class UndeleteServiceResponse(_messages.Message):
  """Response message for UndeleteService method.

  Fields:
    service: Revived service resource.
  """

  service = _messages.MessageField('ManagedService', 1)


class Usage(_messages.Message):
  """Configuration controlling usage of a service.

  Fields:
    producerNotificationChannel: The full resource name of a channel used for
      sending notifications to the service producer.  Google Service
      Management currently only supports [Google Cloud
      Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To
      use Google Cloud Pub/Sub as the channel, this must be the name of a
      Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format
      documented in https://cloud.google.com/pubsub/docs/overview.
    requirements: Requirements that must be satisfied before a consumer
      project can use the service. Each requirement is of the form
      <service.name>/<requirement-id>; for example
      'serviceusage.googleapis.com/billing-enabled'.
    rules: A list of usage rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  producerNotificationChannel = _messages.StringField(1)
  requirements = _messages.StringField(2, repeated=True)
  rules = _messages.MessageField('UsageRule', 3, repeated=True)


class UsageRule(_messages.Message):
  """Usage configuration rules for the service.  NOTE: Under development.
  Use this rule to configure unregistered calls for the service. Unregistered
  calls are calls that do not contain consumer project identity. (Example:
  calls that do not contain an API key). By default, API methods do not allow
  unregistered calls, and each method call must be identified by a consumer
  project identity. Use this rule to allow/disallow unregistered calls.
  Example of an API that wants to allow unregistered calls for entire service.
  usage:       rules:       - selector: "*"         allow_unregistered_calls:
  true  Example of a method that wants to allow unregistered calls.
  usage:       rules:       - selector:
  "google.example.library.v1.LibraryService.CreateBook"
  allow_unregistered_calls: true

  Fields:
    allowUnregisteredCalls: True, if the method allows unregistered calls;
      false otherwise.
    selector: Selects the methods to which this rule applies. Use '*' to
      indicate all methods in all APIs.  Refer to selector for syntax details.
  """

  allowUnregisteredCalls = _messages.BooleanField(1)
  selector = _messages.StringField(2)


class UsageSettings(_messages.Message):
  """Usage settings for a consumer of a service.

  Enums:
    ConsumerEnableStatusValueValuesEnum: Consumer controlled setting to
      enable/disable use of this service by the consumer project. The default
      value of this is controlled by the service configuration.

  Fields:
    consumerEnableStatus: Consumer controlled setting to enable/disable use of
      this service by the consumer project. The default value of this is
      controlled by the service configuration.
  """

  class ConsumerEnableStatusValueValuesEnum(_messages.Enum):
    """Consumer controlled setting to enable/disable use of this service by
    the consumer project. The default value of this is controlled by the
    service configuration.

    Values:
      DISABLED: The service is disabled.
      ENABLED: The service is enabled.
    """
    DISABLED = 0
    ENABLED = 1

  consumerEnableStatus = _messages.EnumField('ConsumerEnableStatusValueValuesEnum', 1)


class VariableTermQuota(_messages.Message):
  """A variable term quota is a bucket of tokens that is consumed over a
  specified (usually long) time period. When present, it overrides any "1d"
  duration per-project quota specified on the group.  Variable terms run from
  midnight to midnight, start_date to end_date (inclusive) in the
  America/Los_Angeles time zone.

  Fields:
    createTime: Time when this variable term quota was created. If multiple
      quotas are simultaneously active, then the quota with the latest
      create_time is the effective one.
    displayEndDate: The displayed end of the active period for the variable
      term quota. This may be before the effective end to give the user a
      grace period. YYYYMMdd date format, e.g. 20140730.
    endDate: The effective end of the active period for the variable term
      quota (inclusive). This must be no more than 5 years after start_date.
      YYYYMMdd date format, e.g. 20140730.
    groupName: The quota group that has the variable term quota applied to it.
      This must be a google.api.QuotaGroup.name specified in the service
      configuration.
    limit: The number of tokens available during the configured term.
    quotaUsage: The usage data of this quota.
    startDate: The beginning of the active period for the variable term quota.
      YYYYMMdd date format, e.g. 20140730.
  """

  createTime = _messages.StringField(1)
  displayEndDate = _messages.StringField(2)
  endDate = _messages.StringField(3)
  groupName = _messages.StringField(4)
  limit = _messages.IntegerField(5)
  quotaUsage = _messages.MessageField('QuotaUsage', 6)
  startDate = _messages.StringField(7)


class Visibility(_messages.Message):
  """`Visibility` defines restrictions for the visibility of service elements.
  Restrictions are specified using visibility labels (e.g., TRUSTED_TESTER)
  that are elsewhere linked to users and projects.  Users and projects can
  have access to more than one visibility label. The effective visibility for
  multiple labels is the union of each label's elements, plus any unrestricted
  elements.  If an element and its parents have no restrictions, visibility is
  unconditionally granted.  Example:      visibility:       rules:       -
  selector: google.calendar.Calendar.EnhancedSearch         restriction:
  TRUSTED_TESTER       - selector: google.calendar.Calendar.Delegate
  restriction: GOOGLE_INTERNAL  Here, all methods are publicly visible except
  for the restricted methods EnhancedSearch and Delegate.

  Fields:
    rules: A list of visibility rules that apply to individual API elements.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('VisibilityRule', 1, repeated=True)


class VisibilityRule(_messages.Message):
  """A visibility rule provides visibility configuration for an individual API
  element.

  Fields:
    restriction: A comma-separated list of visibility labels that apply to the
      `selector`. Any of the listed labels can be used to grant the
      visibility.  If a rule has multiple labels, removing one of the labels
      but not all of them can break clients.  Example:      visibility:
      rules:       - selector: google.calendar.Calendar.EnhancedSearch
      restriction: GOOGLE_INTERNAL, TRUSTED_TESTER  Removing GOOGLE_INTERNAL
      from this restriction will break clients that rely on this method and
      only had access to it through GOOGLE_INTERNAL.
    selector: Selects methods, messages, fields, enums, etc. to which this
      rule applies.  Refer to selector for syntax details.
  """

  restriction = _messages.StringField(1)
  selector = _messages.StringField(2)


class VisibilitySettings(_messages.Message):
  """Settings that control which features of the service are visible to the
  consumer project.

  Fields:
    visibilityLabels: The set of visibility labels that are used to determine
      what API surface is visible to calls made by this project. The visible
      surface is a union of the surface features associated with each label
      listed here, plus the publicly visible (unrestricted) surface.  The
      service producer may add or remove labels at any time. The service
      consumer may add a label if the calling user has been granted permission
      to do so by the producer.  The service consumer may also remove any
      label at any time.
  """

  visibilityLabels = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in',
    package=u'servicemanagement')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'servicemanagement')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'servicemanagement')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'servicemanagement')
