"""Generated message classes for deploymentmanager version v2beta.

The Deployment Manager API allows users to declaratively configure, deploy and
run complex solutions on the Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages


package = 'deploymentmanager'


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConifg must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices"
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:foo@gmail.com" ] }, { "log_type": "DATA_WRITE", }, { "log_type":
  "ADMIN_READ", } ] }, { "service": "fooservice@googleapis.com"
  "audit_log_configs": [ { "log_type": "DATA_READ", }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:bar@gmail.com" ] } ] } ] } For
  fooservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts foo@gmail.com from DATA_READ logging, and
  bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers:
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:  {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:foo@gmail.com" ] }, { "log_type": "DATA_WRITE", } ] }  This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting foo@gmail.com from
  DATA_READ logging.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of [Binding.members][].
    logType: The log type that this config enables.
  """

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.StringField(2)


class BaseType(_messages.Message):
  """BaseType that describes a service-backed Type.

  Fields:
    collectionOverrides: Allows resource handling overrides for specific
      collections
    credential: Credential used when interacting with this type.
    descriptorUrl: Descriptor Url for the this type.
    options: Options to apply when handling any resources in this service.
  """

  collectionOverrides = _messages.MessageField('CollectionOverride', 1, repeated=True)
  credential = _messages.MessageField('Credential', 2)
  descriptorUrl = _messages.StringField(3)
  options = _messages.MessageField('Options', 4)


class BasicAuth(_messages.Message):
  """Basic Auth used as a credential.

  Fields:
    password: A string attribute.
    user: A string attribute.
  """

  password = _messages.StringField(1)
  user = _messages.StringField(2)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@gmail.com` or
      `joe@example.com`.    * `serviceAccount:{emailid}`: An email address
      that represents a service account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group. For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CollectionOverride(_messages.Message):
  """CollectionOverride allows resource handling overrides for specific
  resources within a BaseType

  Fields:
    collection: The collection that identifies this resource within its
      service.
    options: The options to apply to this resource-level override
  """

  collection = _messages.StringField(1)
  options = _messages.MessageField('Options', 2)


class CompositeType(_messages.Message):
  """Holds the composite type.

  Fields:
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the composite type was created,
      in RFC3339 text format.
    labels: Map of labels; provided by the client when the resource is created
      or updated. Specifically: Label keys must be between 1 and 63 characters
      long and must conform to the following regular expression:
      [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63
      characters long and must conform to the regular expression
      ([a-z]([-a-z0-9]*[a-z0-9])?)?
    name: Name of the composite type.
    operation: [Output Only] The Operation that most recently ran, or is
      currently running, on this composite type.
    selfLink: [Output Only] Self link for the type provider.
    status: A string attribute.
    templateContents: Files for the template type.
  """

  description = _messages.StringField(1)
  id = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(3)
  labels = _messages.MessageField('CompositeTypeLabelEntry', 4, repeated=True)
  name = _messages.StringField(5)
  operation = _messages.MessageField('Operation', 6)
  selfLink = _messages.StringField(7)
  status = _messages.StringField(8)
  templateContents = _messages.MessageField('TemplateContents', 9)


class CompositeTypeLabelEntry(_messages.Message):
  """A CompositeTypeLabelEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class CompositeTypesListResponse(_messages.Message):
  """A response that returns all Composite Types supported by Deployment
  Manager

  Fields:
    compositeTypes: [Output Only] A list of resource composite types supported
      by Deployment Manager.
    nextPageToken: A token used to continue a truncated list request.
  """

  compositeTypes = _messages.MessageField('CompositeType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Condition(_messages.Message):
  """A condition to be met.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  iam = _messages.StringField(1)
  op = _messages.StringField(2)
  svc = _messages.StringField(3)
  sys = _messages.StringField(4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class ConfigFile(_messages.Message):
  """ConfigFile message type.

  Fields:
    content: The contents of the file.
  """

  content = _messages.StringField(1)


class Credential(_messages.Message):
  """Credential used by ConfigurableResourceTypes.

  Fields:
    basicAuth: Basic Auth Credentials for this Type.
  """

  basicAuth = _messages.MessageField('BasicAuth', 1)


class Deployment(_messages.Message):
  """Deployment message type.

  Fields:
    description: An optional user-provided description of the deployment.
    fingerprint: Provides a fingerprint to use in requests to modify a
      deployment, such as update(), stop(), and cancelPreview() requests. A
      fingerprint is a randomly generated value that must be provided with
      update(), stop(), and cancelPreview() requests to perform optimistic
      locking. This ensures optimistic concurrency so that only one request
      happens at a time.  The fingerprint is initially generated by Deployment
      Manager and changes after every request to modify data. To get the
      latest fingerprint value, perform a get() request to a deployment.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the deployment was created, in
      RFC3339 text format .
    labels: Map of labels; provided by the client when the resource is created
      or updated. Specifically: Label keys must be between 1 and 63 characters
      long and must conform to the following regular expression:
      [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63
      characters long and must conform to the regular expression
      ([a-z]([-a-z0-9]*[a-z0-9])?)?
    manifest: [Output Only] URL of the manifest representing the last manifest
      that was successfully deployed.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    operation: [Output Only] The Operation that most recently ran, or is
      currently running, on this deployment.
    selfLink: [Output Only] Self link for the deployment.
    target: [Input Only] The parameters that define your deployment, including
      the deployment configuration and relevant templates.
    update: [Output Only] If Deployment Manager is currently updating or
      previewing an update to this deployment, the updated configuration
      appears here.
  """

  description = _messages.StringField(1)
  fingerprint = _messages.BytesField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(4)
  labels = _messages.MessageField('DeploymentLabelEntry', 5, repeated=True)
  manifest = _messages.StringField(6)
  name = _messages.StringField(7)
  operation = _messages.MessageField('Operation', 8)
  selfLink = _messages.StringField(9)
  target = _messages.MessageField('TargetConfiguration', 10)
  update = _messages.MessageField('DeploymentUpdate', 11)


class DeploymentLabelEntry(_messages.Message):
  """A DeploymentLabelEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class DeploymentUpdate(_messages.Message):
  """DeploymentUpdate message type.

  Fields:
    description: [Output Only] An optional user-provided description of the
      deployment after the current update has been applied.
    labels: [Output Only] Map of labels; provided by the client when the
      resource is created or updated. Specifically: Label keys must be between
      1 and 63 characters long and must conform to the following regular
      expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0
      and 63 characters long and must conform to the regular expression
      ([a-z]([-a-z0-9]*[a-z0-9])?)?
    manifest: [Output Only] URL of the manifest representing the update
      configuration of this deployment.
  """

  description = _messages.StringField(1)
  labels = _messages.MessageField('DeploymentUpdateLabelEntry', 2, repeated=True)
  manifest = _messages.StringField(3)


class DeploymentUpdateLabelEntry(_messages.Message):
  """A DeploymentUpdateLabelEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class DeploymentmanagerCompositeTypesDeleteRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesDeleteRequest object.

  Fields:
    compositeType: The name of the type for this request.
    project: The project ID for this request.
  """

  compositeType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerCompositeTypesGetRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesGetRequest object.

  Fields:
    compositeType: The name of the composite type for this request.
    project: The project ID for this request.
  """

  compositeType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerCompositeTypesInsertRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesInsertRequest object.

  Fields:
    compositeType: A CompositeType resource to be passed as the request body.
    project: The project ID for this request.
  """

  compositeType = _messages.MessageField('CompositeType', 1)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerCompositeTypesListRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerCompositeTypesPatchRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesPatchRequest object.

  Fields:
    compositeType: The name of the composite type for this request.
    compositeTypeResource: A CompositeType resource to be passed as the
      request body.
    project: The project ID for this request.
  """

  compositeType = _messages.StringField(1, required=True)
  compositeTypeResource = _messages.MessageField('CompositeType', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerCompositeTypesUpdateRequest(_messages.Message):
  """A DeploymentmanagerCompositeTypesUpdateRequest object.

  Fields:
    compositeType: The name of the composite type for this request.
    compositeTypeResource: A CompositeType resource to be passed as the
      request body.
    project: The project ID for this request.
  """

  compositeType = _messages.StringField(1, required=True)
  compositeTypeResource = _messages.MessageField('CompositeType', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsCancelPreviewRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsCancelPreviewRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    deploymentsCancelPreviewRequest: A DeploymentsCancelPreviewRequest
      resource to be passed as the request body.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  deploymentsCancelPreviewRequest = _messages.MessageField('DeploymentsCancelPreviewRequest', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsDeleteRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsDeleteRequest object.

  Enums:
    DeletePolicyValueValuesEnum: Sets the policy to use for deleting
      resources.

  Fields:
    deletePolicy: Sets the policy to use for deleting resources.
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
  """

  class DeletePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for deleting resources.

    Values:
      ABANDON: <no description>
      DELETE: <no description>
    """
    ABANDON = 0
    DELETE = 1

  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 1, default=u'DELETE')
  deployment = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsGetIamPolicyRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)


class DeploymentmanagerDeploymentsGetRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerDeploymentsInsertRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsInsertRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    preview: If set to true, creates a deployment and creates "shell"
      resources but does not actually instantiate these resources. This allows
      you to preview what your deployment looks like. After previewing a
      deployment, you can deploy your resources by making a request with the
      update() method or you can use the cancelPreview() method to cancel the
      preview altogether. Note that the deployment will still exist after you
      cancel the preview and you must separately delete this deployment if you
      want to remove it.
    project: The project ID for this request.
  """

  deployment = _messages.MessageField('Deployment', 1)
  preview = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsListRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerDeploymentsPatchRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsPatchRequest object.

  Enums:
    CreatePolicyValueValuesEnum: Sets the policy to use for creating new
      resources.
    DeletePolicyValueValuesEnum: Sets the policy to use for deleting
      resources.

  Fields:
    createPolicy: Sets the policy to use for creating new resources.
    deletePolicy: Sets the policy to use for deleting resources.
    deployment: The name of the deployment for this request.
    deploymentResource: A Deployment resource to be passed as the request
      body.
    preview: If set to true, updates the deployment and creates and updates
      the "shell" resources but does not actually alter or instantiate these
      resources. This allows you to preview what your deployment will look
      like. You can use this intent to preview how an update would affect your
      deployment. You must provide a target.config with a configuration if
      this is set to true. After previewing a deployment, you can deploy your
      resources by making a request with the update() or you can
      cancelPreview() to remove the preview altogether. Note that the
      deployment will still exist after you cancel the preview and you must
      separately delete this deployment if you want to remove it.
    project: The project ID for this request.
  """

  class CreatePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for creating new resources.

    Values:
      ACQUIRE: <no description>
      CREATE_OR_ACQUIRE: <no description>
    """
    ACQUIRE = 0
    CREATE_OR_ACQUIRE = 1

  class DeletePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for deleting resources.

    Values:
      ABANDON: <no description>
      DELETE: <no description>
    """
    ABANDON = 0
    DELETE = 1

  createPolicy = _messages.EnumField('CreatePolicyValueValuesEnum', 1, default=u'CREATE_OR_ACQUIRE')
  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 2, default=u'DELETE')
  deployment = _messages.StringField(3, required=True)
  deploymentResource = _messages.MessageField('Deployment', 4)
  preview = _messages.BooleanField(5, default=False)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerDeploymentsSetIamPolicyRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsSetIamPolicyRequest object.

  Fields:
    policy: A Policy resource to be passed as the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  policy = _messages.MessageField('Policy', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsStopRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsStopRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    deploymentsStopRequest: A DeploymentsStopRequest resource to be passed as
      the request body.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  deploymentsStopRequest = _messages.MessageField('DeploymentsStopRequest', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsTestIamPermissionsRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class DeploymentmanagerDeploymentsUpdateRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsUpdateRequest object.

  Enums:
    CreatePolicyValueValuesEnum: Sets the policy to use for creating new
      resources.
    DeletePolicyValueValuesEnum: Sets the policy to use for deleting
      resources.

  Fields:
    createPolicy: Sets the policy to use for creating new resources.
    deletePolicy: Sets the policy to use for deleting resources.
    deployment: The name of the deployment for this request.
    deploymentResource: A Deployment resource to be passed as the request
      body.
    preview: If set to true, updates the deployment and creates and updates
      the "shell" resources but does not actually alter or instantiate these
      resources. This allows you to preview what your deployment will look
      like. You can use this intent to preview how an update would affect your
      deployment. You must provide a target.config with a configuration if
      this is set to true. After previewing a deployment, you can deploy your
      resources by making a request with the update() or you can
      cancelPreview() to remove the preview altogether. Note that the
      deployment will still exist after you cancel the preview and you must
      separately delete this deployment if you want to remove it.
    project: The project ID for this request.
  """

  class CreatePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for creating new resources.

    Values:
      ACQUIRE: <no description>
      CREATE_OR_ACQUIRE: <no description>
    """
    ACQUIRE = 0
    CREATE_OR_ACQUIRE = 1

  class DeletePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for deleting resources.

    Values:
      ABANDON: <no description>
      DELETE: <no description>
    """
    ABANDON = 0
    DELETE = 1

  createPolicy = _messages.EnumField('CreatePolicyValueValuesEnum', 1, default=u'CREATE_OR_ACQUIRE')
  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 2, default=u'DELETE')
  deployment = _messages.StringField(3, required=True)
  deploymentResource = _messages.MessageField('Deployment', 4)
  preview = _messages.BooleanField(5, default=False)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerManifestsGetRequest(_messages.Message):
  """A DeploymentmanagerManifestsGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    manifest: The name of the manifest for this request.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  manifest = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerManifestsListRequest(_messages.Message):
  """A DeploymentmanagerManifestsListRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerOperationsGetRequest(_messages.Message):
  """A DeploymentmanagerOperationsGetRequest object.

  Fields:
    operation: The name of the operation for this request.
    project: The project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerOperationsListRequest(_messages.Message):
  """A DeploymentmanagerOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerResourcesGetRequest(_messages.Message):
  """A DeploymentmanagerResourcesGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
    resource: The name of the resource for this request.
  """

  deployment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class DeploymentmanagerResourcesListRequest(_messages.Message):
  """A DeploymentmanagerResourcesListRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerTypeProvidersDeleteRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersDeleteRequest object.

  Fields:
    project: The project ID for this request.
    typeProvider: The name of the type provider for this request.
  """

  project = _messages.StringField(1, required=True)
  typeProvider = _messages.StringField(2, required=True)


class DeploymentmanagerTypeProvidersGetRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersGetRequest object.

  Fields:
    project: The project ID for this request.
    typeProvider: The name of the type provider for this request.
  """

  project = _messages.StringField(1, required=True)
  typeProvider = _messages.StringField(2, required=True)


class DeploymentmanagerTypeProvidersGetTypeRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersGetTypeRequest object.

  Fields:
    project: The project ID for this request.
    type: The name of the type provider for this request.
    typeProvider: The name of the type provider for this request.
  """

  project = _messages.StringField(1, required=True)
  type = _messages.StringField(2, required=True)
  typeProvider = _messages.StringField(3, required=True)


class DeploymentmanagerTypeProvidersInsertRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersInsertRequest object.

  Fields:
    project: The project ID for this request.
    typeProvider: A TypeProvider resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  typeProvider = _messages.MessageField('TypeProvider', 2)


class DeploymentmanagerTypeProvidersListRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerTypeProvidersListTypesRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersListTypesRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
    typeProvider: The name of the type provider for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  typeProvider = _messages.StringField(6, required=True)


class DeploymentmanagerTypeProvidersPatchRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersPatchRequest object.

  Fields:
    project: The project ID for this request.
    typeProvider: The name of the type provider for this request.
    typeProviderResource: A TypeProvider resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  typeProvider = _messages.StringField(2, required=True)
  typeProviderResource = _messages.MessageField('TypeProvider', 3)


class DeploymentmanagerTypeProvidersUpdateRequest(_messages.Message):
  """A DeploymentmanagerTypeProvidersUpdateRequest object.

  Fields:
    project: The project ID for this request.
    typeProvider: The name of the type provider for this request.
    typeProviderResource: A TypeProvider resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  typeProvider = _messages.StringField(2, required=True)
  typeProviderResource = _messages.MessageField('TypeProvider', 3)


class DeploymentmanagerTypesListRequest(_messages.Message):
  """A DeploymentmanagerTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentsCancelPreviewRequest(_messages.Message):
  """DeploymentsCancelPreviewRequest message type.

  Fields:
    fingerprint: Specifies a fingerprint for cancelPreview() requests. A
      fingerprint is a randomly generated value that must be provided in
      cancelPreview() requests to perform optimistic locking. This ensures
      optimistic concurrency so that the deployment does not have conflicting
      requests (e.g. if someone attempts to make a new update request while
      another user attempts to cancel a preview, this would prevent one of the
      requests).  The fingerprint is initially generated by Deployment Manager
      and changes after every request to modify a deployment. To get the
      latest fingerprint value, perform a get() request on the deployment.
  """

  fingerprint = _messages.BytesField(1)


class DeploymentsListResponse(_messages.Message):
  """A response containing a partial list of deployments and a page token used
  to build the next request if the request has been truncated.

  Fields:
    deployments: [Output Only] The deployments contained in this response.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class DeploymentsStopRequest(_messages.Message):
  """DeploymentsStopRequest message type.

  Fields:
    fingerprint: Specifies a fingerprint for stop() requests. A fingerprint is
      a randomly generated value that must be provided in stop() requests to
      perform optimistic locking. This ensures optimistic concurrency so that
      the deployment does not have conflicting requests (e.g. if someone
      attempts to make a new update request while another user attempts to
      stop an ongoing update request, this would prevent a collision).  The
      fingerprint is initially generated by Deployment Manager and changes
      after every request to modify a deployment. To get the latest
      fingerprint value, perform a get() request on the deployment.
  """

  fingerprint = _messages.BytesField(1)


class ImportFile(_messages.Message):
  """ImportFile message type.

  Fields:
    content: The contents of the file.
    name: The name of the file.
  """

  content = _messages.StringField(1)
  name = _messages.StringField(2)


class InputMapping(_messages.Message):
  """InputMapping creates a 'virtual' property that will be injected into the
  properties before sending the request to the underlying API.

  Fields:
    fieldName: The name of the field that is going to be injected.
    location: The location where this mapping applies.
    methodMatch: Regex to evaluate on method to decide if input applies.
    value: A jsonPath expression to select an element.
  """

  fieldName = _messages.StringField(1)
  location = _messages.StringField(2)
  methodMatch = _messages.StringField(3)
  value = _messages.StringField(4)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write

  Fields:
    counter: Counter options.
  """

  counter = _messages.MessageField('LogConfigCounterOptions', 1)


class LogConfigCounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class Manifest(_messages.Message):
  """Manifest message type.

  Fields:
    config: [Output Only] The YAML configuration for this manifest.
    expandedConfig: [Output Only] The fully-expanded configuration file,
      including any templates and references.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    imports: [Output Only] The imported files for this manifest.
    insertTime: [Output Only] Timestamp when the manifest was created, in
      RFC3339 text format.
    layout: [Output Only] The YAML layout for this manifest.
    name: [Output Only] The name of the manifest.
    selfLink: [Output Only] Self link for the manifest.
  """

  config = _messages.MessageField('ConfigFile', 1)
  expandedConfig = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  imports = _messages.MessageField('ImportFile', 4, repeated=True)
  insertTime = _messages.StringField(5)
  layout = _messages.StringField(6)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)


class ManifestsListResponse(_messages.Message):
  """A response containing a partial list of manifests and a page token used
  to build the next request if the request has been truncated.

  Fields:
    manifests: [Output Only] Manifests contained in this list response.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
  """

  manifests = _messages.MessageField('Manifest', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Operation(_messages.Message):
  """An Operation resource, used to manage asynchronous API requests.

  Messages:
    ErrorValue: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    clientOperationId: [Output Only] Reserved for future use.
    creationTimestamp: [Deprecated] This field is deprecated.
    description: [Output Only] A textual description of the operation, which
      is set when the operation is created.
    endTime: [Output Only] The time that this operation was completed. This
      value is in RFC3339 text format.
    error: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    httpErrorMessage: [Output Only] If the operation fails, this field
      contains the HTTP error message that was returned, such as NOT FOUND.
    httpErrorStatusCode: [Output Only] If the operation fails, this field
      contains the HTTP error status code that was returned. For example, a
      404 means the resource was not found.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    insertTime: [Output Only] The time that this operation was requested. This
      value is in RFC3339 text format.
    kind: [Output Only] Type of the resource. Always compute#operation for
      Operation resources.
    name: [Output Only] Name of the resource.
    operationType: [Output Only] The type of operation, such as insert,
      update, or delete, and so on.
    progress: [Output Only] An optional progress indicator that ranges from 0
      to 100. There is no requirement that this be linear or support any
      granularity of operations. This should not be used to guess when the
      operation will be complete. This number should monotonically increase as
      the operation progresses.
    region: [Output Only] The URL of the region where the operation resides.
      Only available when performing regional operations.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTime: [Output Only] The time that this operation was started by the
      server. This value is in RFC3339 text format.
    status: [Output Only] The status of the operation, which can be one of the
      following: PENDING, RUNNING, or DONE.
    statusMessage: [Output Only] An optional textual description of the
      current status of the operation.
    targetId: [Output Only] The unique target ID, which identifies a specific
      incarnation of the target resource.
    targetLink: [Output Only] The URL of the resource that the operation
      modifies. For operations related to creating a snapshot, this points to
      the persistent disk that the snapshot was created from.
    user: [Output Only] User who requested the operation, for example:
      user@example.com.
    warnings: [Output Only] If warning messages are generated during
      processing of the operation, this field will be populated.
    zone: [Output Only] The URL of the zone where the operation resides. Only
      available when performing per-zone operations.
  """

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request that caused
          the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  clientOperationId = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('ErrorValue', 5)
  httpErrorMessage = _messages.StringField(6)
  httpErrorStatusCode = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'deploymentmanager#operation')
  name = _messages.StringField(11)
  operationType = _messages.StringField(12)
  progress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  region = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.StringField(17)
  statusMessage = _messages.StringField(18)
  targetId = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  targetLink = _messages.StringField(20)
  user = _messages.StringField(21)
  warnings = _messages.MessageField('WarningsValueListEntry', 22, repeated=True)
  zone = _messages.StringField(23)


class OperationsListResponse(_messages.Message):
  """A response containing a partial list of operations and a page token used
  to build the next request if the request has been truncated.

  Fields:
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    operations: [Output Only] Operations contained in this list response.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Options(_messages.Message):
  """Options allows customized resource handling by Deployment Manager.

  Fields:
    inputMappings: The mappings that apply for requests.
    validationOptions: Options for how to validate and process properties on a
      resource.
    virtualProperties: Additional properties block described as a jsonSchema,
      these properties will never be part of the json payload, but they can be
      consumed by InputMappings, this must be a valid json schema draft-04.
      The properties specified here will be decouple in a different section.
      This schema will be merged to the schema validation, and properties here
      will be extracted From the payload and consumed explicitly by
      InputMappings. ex: field1: type: string field2: type: number
  """

  inputMappings = _messages.MessageField('InputMapping', 1, repeated=True)
  validationOptions = _messages.MessageField('ValidationOptions', 2)
  virtualProperties = _messages.StringField(3)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.    A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**  { "bindings": [ { "role": "roles/owner",
  "members": [ "user:mike@example.com", "group:admins@example.com",
  "domain:google.com", "serviceAccount:my-other-
  app@appspot.gserviceaccount.com", ] }, { "role": "roles/viewer", "members":
  ["user:sean@example.com"] } ] }  For a description of IAM and its features,
  see the [IAM developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned:
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Resource(_messages.Message):
  """Resource message type.

  Messages:
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    accessControl: The Access Control Policy set on this resource.
    finalProperties: [Output Only] The evaluated properties of the resource
      with references expanded. Returned as serialized YAML.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the resource was created or
      acquired, in RFC3339 text format .
    manifest: [Output Only] URL of the manifest representing the current
      configuration of this resource.
    name: [Output Only] The name of the resource as it appears in the YAML
      config.
    properties: [Output Only] The current properties of the resource before
      any references have been filled in. Returned as serialized YAML.
    type: [Output Only] The type of the resource, for example
      compute.v1.instance, or cloudfunctions.v1beta1.function.
    update: [Output Only] If Deployment Manager is currently updating or
      previewing an update to this resource, the updated configuration appears
      here.
    updateTime: [Output Only] Timestamp when the resource was updated, in
      RFC3339 text format .
    url: [Output Only] The URL of the actual resource.
    warnings: [Output Only] If warning messages are generated during
      processing of this resource, this field will be populated.
  """

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  accessControl = _messages.MessageField('ResourceAccessControl', 1)
  finalProperties = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(4)
  manifest = _messages.StringField(5)
  name = _messages.StringField(6)
  properties = _messages.StringField(7)
  type = _messages.StringField(8)
  update = _messages.MessageField('ResourceUpdate', 9)
  updateTime = _messages.StringField(10)
  url = _messages.StringField(11)
  warnings = _messages.MessageField('WarningsValueListEntry', 12, repeated=True)


class ResourceAccessControl(_messages.Message):
  """The access controls set on the resource.

  Fields:
    gcpIamPolicy: The GCP IAM Policy to set on the resource.
  """

  gcpIamPolicy = _messages.StringField(1)


class ResourceUpdate(_messages.Message):
  """ResourceUpdate message type.

  Messages:
    ErrorValue: [Output Only] If errors are generated during update of the
      resource, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    accessControl: The Access Control Policy to set on this resource after
      updating the resource itself.
    error: [Output Only] If errors are generated during update of the
      resource, this field will be populated.
    finalProperties: [Output Only] The expanded properties of the resource
      with reference values expanded. Returned as serialized YAML.
    intent: [Output Only] The intent of the resource: PREVIEW, UPDATE, or
      CANCEL.
    manifest: [Output Only] URL of the manifest representing the update
      configuration of this resource.
    properties: [Output Only] The set of updated properties for this resource,
      before references are expanded. Returned as serialized YAML.
    state: [Output Only] The state of the resource.
    warnings: [Output Only] If warning messages are generated during
      processing of this resource, this field will be populated.
  """

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during update of the resource,
    this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request that caused
          the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  accessControl = _messages.MessageField('ResourceAccessControl', 1)
  error = _messages.MessageField('ErrorValue', 2)
  finalProperties = _messages.StringField(3)
  intent = _messages.StringField(4)
  manifest = _messages.StringField(5)
  properties = _messages.StringField(6)
  state = _messages.StringField(7)
  warnings = _messages.MessageField('WarningsValueListEntry', 8, repeated=True)


class ResourcesListResponse(_messages.Message):
  """A response containing a partial list of resources and a page token used
  to build the next request if the request has been truncated.

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    resources: Resources contained in this list response.
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Resource', 2, repeated=True)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    ins: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfigs: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIns: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries.
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  action = _messages.StringField(1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  ins = _messages.StringField(4, repeated=True)
  logConfigs = _messages.MessageField('LogConfig', 5, repeated=True)
  notIns = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class TargetConfiguration(_messages.Message):
  """TargetConfiguration message type.

  Fields:
    config: The configuration to use for this deployment.
    imports: Specifies any files to import for this configuration. This can be
      used to import templates or other files. For example, you might import a
      text file in order to use the file in a template.
  """

  config = _messages.MessageField('ConfigFile', 1)
  imports = _messages.MessageField('ImportFile', 2, repeated=True)


class TemplateContents(_messages.Message):
  """Files that make up the template contents of a template type.

  Fields:
    imports: Import files referenced by the main template.
    interpreter: Which interpreter (python or jinja) should be used during
      expansion.
    schema: The contents of the template schema.
    template: The contents of the main template file.
  """

  imports = _messages.MessageField('ImportFile', 1, repeated=True)
  interpreter = _messages.StringField(2)
  schema = _messages.StringField(3)
  template = _messages.StringField(4)


class TestPermissionsRequest(_messages.Message):
  """A TestPermissionsRequest object.

  Fields:
    permissions: The set of permissions to check for the 'resource'.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TestPermissionsResponse(_messages.Message):
  """A TestPermissionsResponse object.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Type(_messages.Message):
  """A resource type supported by Deployment Manager.

  Fields:
    base: Base Type (configurable service) that backs this Type.
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the type was created, in RFC3339
      text format.
    labels: Map of labels; provided by the client when the resource is created
      or updated. Specifically: Label keys must be between 1 and 63 characters
      long and must conform to the following regular expression:
      [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63
      characters long and must conform to the regular expression
      ([a-z]([-a-z0-9]*[a-z0-9])?)?
    name: Name of the type.
    operation: [Output Only] The Operation that most recently ran, or is
      currently running, on this type.
    selfLink: [Output Only] Self link for the type.
  """

  base = _messages.MessageField('BaseType', 1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(4)
  labels = _messages.MessageField('TypeLabelEntry', 5, repeated=True)
  name = _messages.StringField(6)
  operation = _messages.MessageField('Operation', 7)
  selfLink = _messages.StringField(8)


class TypeInfo(_messages.Message):
  """Contains detailed information about a composite type, base type, or base
  type with specific collection.

  Fields:
    description: The description of the type.
    documentationLink: For swagger 2.0 externalDocs field will be used. For
      swagger 1.2 this field will be empty.
    kind: [Output Only] Type of the output. Always deploymentManager#TypeInfo
      for TypeInfo.
    name: The base type or composite type name.
    schema: For base types with a collection, we return a schema and
      documentation link For template types, we return only a schema
    selfLink: [Output Only] Server-defined URL for the resource.
    title: The title on the API descriptor URL provided.
  """

  description = _messages.StringField(1)
  documentationLink = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'deploymentmanager#typeInfo')
  name = _messages.StringField(4)
  schema = _messages.MessageField('TypeInfoSchemaInfo', 5)
  selfLink = _messages.StringField(6)
  title = _messages.StringField(7)


class TypeInfoSchemaInfo(_messages.Message):
  """TypeInfoSchemaInfo message type.

  Fields:
    input: The properties that this composite type or base type collection
      accept as input, represented as a json blob, format is: JSON Schema
      Draft V4
    output: The properties that this composite type or base type collection
      exposes as output, these properties can be used for references,
      represented as json blob, format is: JSON Schema Draft V4
  """

  input = _messages.StringField(1)
  output = _messages.StringField(2)


class TypeLabelEntry(_messages.Message):
  """A TypeLabelEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class TypeProvider(_messages.Message):
  """A type provider that describes a service-backed Type.

  Fields:
    collectionOverrides: Allows resource handling overrides for specific
      collections
    credential: Credential used when interacting with this type.
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    descriptorUrl: Descriptor Url for the this type provider.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the type provider was created, in
      RFC3339 text format.
    labels: Map of labels; provided by the client when the resource is created
      or updated. Specifically: Label keys must be between 1 and 63 characters
      long and must conform to the following regular expression:
      [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63
      characters long and must conform to the regular expression
      ([a-z]([-a-z0-9]*[a-z0-9])?)?
    name: Name of the type provider.
    operation: [Output Only] The Operation that most recently ran, or is
      currently running, on this type provider.
    options: Options to apply when handling any resources in this service.
    selfLink: [Output Only] Self link for the type provider.
  """

  collectionOverrides = _messages.MessageField('CollectionOverride', 1, repeated=True)
  credential = _messages.MessageField('Credential', 2)
  description = _messages.StringField(3)
  descriptorUrl = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(6)
  labels = _messages.MessageField('TypeProviderLabelEntry', 7, repeated=True)
  name = _messages.StringField(8)
  operation = _messages.MessageField('Operation', 9)
  options = _messages.MessageField('Options', 10)
  selfLink = _messages.StringField(11)


class TypeProviderLabelEntry(_messages.Message):
  """A TypeProviderLabelEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class TypeProvidersListResponse(_messages.Message):
  """A response that returns all Type Providers supported by Deployment
  Manager

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    typeProviders: [Output Only] A list of resource type providers supported
      by Deployment Manager.
  """

  nextPageToken = _messages.StringField(1)
  typeProviders = _messages.MessageField('TypeProvider', 2, repeated=True)


class TypeProvidersListTypesResponse(_messages.Message):
  """TypeProvidersListTypesResponse message type.

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    types: [Output Only] A list of resource type info.
  """

  nextPageToken = _messages.StringField(1)
  types = _messages.MessageField('TypeInfo', 2, repeated=True)


class TypesListResponse(_messages.Message):
  """A response that returns all Types supported by Deployment Manager

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    types: [Output Only] A list of resource types supported by Deployment
      Manager.
  """

  nextPageToken = _messages.StringField(1)
  types = _messages.MessageField('Type', 2, repeated=True)


class ValidationOptions(_messages.Message):
  """Options for how to validate and process properties on a resource.

  Fields:
    schemaValidation: Customize how deployment manager will validate the
      resource against schema errors.
    undeclaredProperties: Specify what to do with extra properties when
      executing a request.
  """

  schemaValidation = _messages.StringField(1)
  undeclaredProperties = _messages.StringField(2)


