"""Generated message classes for datapol version v1alpha1.

Google Cloud Datapol API.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datapol'


class Annotation(_messages.Message):
  """An annotation in Data Policy API. An annotation is one data type in a
  policy taxonomy (e.g. ssn). Annotations can be defined in a hierarchy for at
  most two levels. For example, consider the following hierachy:
  Geolocation                    |   ------------------------------------   |
  |                 | LatLong          City              ZipCode Annotation
  "Geolocation" contains three child annotations: "LatLong", "City", and
  "ZipCode".

  Fields:
    annotationName: Name of the annotation. Should be no more than 100
      characters with only letters, numbers, -, and _.
    childAnnotations: Names of child annotations of this annotation.
    description: Description of the annotation. Length of the description is
      limited to 1000 characters.
    name: Resource name of the annotation, which has the format of "orgs/{org_
      id}/policyTaxonomies/{taxonomy_name}/annotations/{annotation_name}".
    parentAnnotation: Name of the parent annotation to this annotation. If
      empty, it means this annotation is a top level annotation.
  """

  annotationName = _messages.StringField(1)
  childAnnotations = _messages.StringField(2, repeated=True)
  description = _messages.StringField(3)
  name = _messages.StringField(4)
  parentAnnotation = _messages.StringField(5)


class AnnotationTag(_messages.Message):
  """An annotation tag on a cloud data asset (e.g. a Cloud spanner table).
  Each data asset can have multiple annotation tags, but only one annotation
  tag from each taxonomy. An annotation tag is identified with the data asset
  it associated with, and the taxonomy that the annotation belongs to.

  Fields:
    annotationName: The value of 'annotation_name' for the tagged
      annotation.The annotation must be a member of the taxonomy included in
      the resource name.
    name: Resource name of the annotation tag, which has the format of "data/{
      resource_name_of_the_data}/orgs/{org_id}/policyTaxonomies/{taxonomy_name
      }/annotationTag" Resouce name of the data asset should be RFC3986
      escaped.
  """

  annotationName = _messages.StringField(1)
  name = _messages.StringField(2)


class ApplyAnnotationTagRequest(_messages.Message):
  """Request message for "DataPolicyAnnotationTagging.ApplyAnnotationTag".

  Fields:
    annotationName: [Required] Name of the annotation tag. The annotation must
      be a valid annotation defined in the data policy taxonomy that is
      specified in the resource name.
  """

  annotationName = _messages.StringField(1)


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConifg must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted. Example Policy with
  multiple AuditConfigs: {   "audit_configs": [     {       "service":
  "allServices"       "audit_log_configs": [         {           "log_type":
  "DATA_READ",           "exempted_members": [
  "user:foo@gmail.com"           ]         },         {           "log_type":
  "DATA_WRITE",         },         {           "log_type": "ADMIN_READ",
  }       ]     },     {       "service": "fooservice@googleapis.com"
  "audit_log_configs": [         {           "log_type": "DATA_READ",
  },         {           "log_type": "DATA_WRITE",
  "exempted_members": [             "user:bar@gmail.com"           ]         }
  ]     }   ] } For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
      Next ID: 4
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    """The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CloudAuditOptions(_messages.Message):
  """Write a Cloud Audit log"""


class Condition(_messages.Message):
  """A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext (go
        /security-realms). When used with IN, the condition indicates "any of
        the request's realms match one of the given values; with NOT_IN, "none
        of the realms match any of the given values". It is not permitted to
        grant access based on the *absence* of a realm, so realm conditions
        can only be used in a "positive" context (e.g., ALLOW/IN or
        DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN). See: go/rpc-security-policy-
        dynamicauth.
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5

  class OpValueValuesEnum(_messages.Enum):
    """An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by any service that owns resources and uses
    the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class CounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  """Write a Data Access (Gin) log"""


class DatapolDataAssetsListResourceNamesRequest(_messages.Message):
  """A DatapolDataAssetsListResourceNamesRequest object.

  Fields:
    annotatableOnly: If set to true, only returns data assets that are
      annotatable by the caller.
    annotations: Resource names of annotations to be looked up.
    filter: A filter string that includes additional predicates for data
      assets.
    includeAnnotatedByGroup: If set to true, for any group annotation, also
      list data assets that are annotated by annotation belongs to this group.
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
  """

  annotatableOnly = _messages.BooleanField(1)
  annotations = _messages.StringField(2, repeated=True)
  filter = _messages.StringField(3)
  includeAnnotatedByGroup = _messages.BooleanField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)


class DatapolDataOrgsAnnotationTagsListRequest(_messages.Message):
  """A DatapolDataOrgsAnnotationTagsListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: [Required] Resource name of the data asset.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatapolDataOrgsPolicyTaxonomiesApplyAnnotationTagRequest(_messages.Message):
  """A DatapolDataOrgsPolicyTaxonomiesApplyAnnotationTagRequest object.

  Fields:
    applyAnnotationTagRequest: A ApplyAnnotationTagRequest resource to be
      passed as the request body.
    name: [Required] Resource name of the tag to be updated.
  """

  applyAnnotationTagRequest = _messages.MessageField('ApplyAnnotationTagRequest', 1)
  name = _messages.StringField(2, required=True)


class DatapolDataOrgsPolicyTaxonomiesDeleteAnnotationTagRequest(_messages.Message):
  """A DatapolDataOrgsPolicyTaxonomiesDeleteAnnotationTagRequest object.

  Fields:
    name: [Required] Resource name of the tag to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatapolOrgsPolicyTaxonomiesAnnotationsCreateRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesAnnotationsCreateRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    parent: [Required] Resource name of the taxonomy that the newly created
      annotation belongs to.
  """

  annotation = _messages.MessageField('Annotation', 1)
  parent = _messages.StringField(2, required=True)


class DatapolOrgsPolicyTaxonomiesAnnotationsDeleteRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesAnnotationsDeleteRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatapolOrgsPolicyTaxonomiesAnnotationsGetRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesAnnotationsGetRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be returned.
  """

  name = _messages.StringField(1, required=True)


class DatapolOrgsPolicyTaxonomiesAnnotationsListRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesAnnotationsListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: [Required] Resource name of a taxonomy.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatapolOrgsPolicyTaxonomiesAnnotationsPatchRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesAnnotationsPatchRequest object.

  Fields:
    name: [Required] Resource name of the annotation to be updated.
    updateAnnotationRequest: A UpdateAnnotationRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateAnnotationRequest = _messages.MessageField('UpdateAnnotationRequest', 2)


class DatapolOrgsPolicyTaxonomiesCreateRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesCreateRequest object.

  Fields:
    parent: [Required] Resource name of the organization that the newly
      created taxonomy belongs to.
    policyTaxonomy: A PolicyTaxonomy resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  policyTaxonomy = _messages.MessageField('PolicyTaxonomy', 2)


class DatapolOrgsPolicyTaxonomiesDeleteRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesDeleteRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatapolOrgsPolicyTaxonomiesGetIamPolicyRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatapolOrgsPolicyTaxonomiesGetRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesGetRequest object.

  Fields:
    name: [Required] Resource name of the taxonomy to be returned.
  """

  name = _messages.StringField(1, required=True)


class DatapolOrgsPolicyTaxonomiesListRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: [Required] Resource name of a org.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatapolOrgsPolicyTaxonomiesSetIamPolicyRequest(_messages.Message):
  """A DatapolOrgsPolicyTaxonomiesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class ListAnnotationTagsResponse(_messages.Message):
  """Response message for "DataPolicyAnnotationTagging.ListAnnotationTags".

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    tags: Annotation tags on a data asset.
  """

  nextPageToken = _messages.StringField(1)
  tags = _messages.MessageField('AnnotationTag', 2, repeated=True)


class ListAnnotationsResponse(_messages.Message):
  """Response message for "DataPolicyAnnotation.ListAnnotations".

  Fields:
    annotations: Annotations that are in this taxonomy.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  annotations = _messages.MessageField('Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAssetsResponse(_messages.Message):
  """Response message for "DataPolicyAnnotationTagging.ListAssets".

  Fields:
    dataAssets: A list of resource names of data assets that are tagged with
      the given annotation tag.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  dataAssets = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListPolicyTaxonomiesResponse(_messages.Message):
  """Response message for "DataPolicyTaxonomy.ListPolicyTaxonomies".

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    taxonomies: Taxonomies that the org owns.
  """

  nextPageToken = _messages.StringField(1)
  taxonomies = _messages.MessageField('PolicyTaxonomy', 2, repeated=True)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com",           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class PolicyTaxonomy(_messages.Message):
  """A taxonomy in DataPolicy API. A taxonomy is a set of data types of
  business significance, typically associated with the substance of the data
  (e.g. credit card, SSN), or how it is used (e.g. account name, user ID).
  There are three IAM roles on each taxonomy:   - role/administrator: use all
  service APIs above.   - role/annotator: use all APIs in service
  DataPolicyAnnotationTagging, and       Get* APIs in service
  DataPolicyTaxonomy and DataPolicyAnnotation.   - role/reader: use Get* and
  List* APIs. When a PolicyTaxonomy is created, the API caller will be added
  to each of those IAM roles above..

  Fields:
    description: Description of the datapol taxonomy. Length of the
      description is limited to 1000 characters.
    name: Resource name of the datapol taxonomy, which has the format of
      "orgs/{org_id}/policyTaxonomies/{taxonomy_name}".
    orgId: Id of the cloud organization that this taxonomy belongs to. If the
      project does not have an organization ID, use the "project:project_id"
      instead, and the scope of the defined taxonomy is limited to this
      project only.
    taxonomyName: Name of the taxonomy. Should be no more than 100 characters
      with only letters, numbers, -, and _.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  orgId = _messages.StringField(3)
  taxonomyName = _messages.StringField(4)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries is the same as for members in a Binding (see
      google/iam/v1/policy.proto).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class UpdateAnnotationRequest(_messages.Message):
  """Request message for "DataPolicyAnnotation.UpdateAnnotation".

  Fields:
    description: New description of the annotation.
  """

  description = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in',
    package=u'datapol')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'datapol')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'datapol')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'datapol')
