"""Generated client library for datapol version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datapol.v1alpha1 import datapol_v1alpha1_messages as messages


class DatapolV1alpha1(base_api.BaseApiClient):
  """Generated client library for service datapol version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://datapol.googleapis.com/'

  _PACKAGE = u'datapol'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/xapi.zoo']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'DatapolV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new datapol handle."""
    url = url or self.BASE_URL
    super(DatapolV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.data_orgs_annotationTags = self.DataOrgsAnnotationTagsService(self)
    self.data_orgs_policyTaxonomies = self.DataOrgsPolicyTaxonomiesService(self)
    self.data_orgs = self.DataOrgsService(self)
    self.data = self.DataService(self)
    self.dataAssets = self.DataAssetsService(self)
    self.orgs_policyTaxonomies_annotations = self.OrgsPolicyTaxonomiesAnnotationsService(self)
    self.orgs_policyTaxonomies = self.OrgsPolicyTaxonomiesService(self)
    self.orgs = self.OrgsService(self)

  class DataOrgsAnnotationTagsService(base_api.BaseApiService):
    """Service class for the data_orgs_annotationTags resource."""

    _NAME = u'data_orgs_annotationTags'

    def __init__(self, client):
      super(DatapolV1alpha1.DataOrgsAnnotationTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists all visible annotation tags on a cloud data set.

      Args:
        request: (DatapolDataOrgsAnnotationTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/orgs/{orgsId}/annotationTags',
        http_method=u'GET',
        method_id=u'datapol.data.orgs.annotationTags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/annotationTags',
        request_field='',
        request_type_name=u'DatapolDataOrgsAnnotationTagsListRequest',
        response_type_name=u'ListAnnotationTagsResponse',
        supports_download=False,
    )

  class DataOrgsPolicyTaxonomiesService(base_api.BaseApiService):
    """Service class for the data_orgs_policyTaxonomies resource."""

    _NAME = u'data_orgs_policyTaxonomies'

    def __init__(self, client):
      super(DatapolV1alpha1.DataOrgsPolicyTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def ApplyAnnotationTag(self, request, global_params=None):
      """Applies an annotation tag on a cloud data set.

      Args:
        request: (DatapolDataOrgsPolicyTaxonomiesApplyAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationTag) The response message.
      """
      config = self.GetMethodConfig('ApplyAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}:applyAnnotationTag',
        http_method=u'POST',
        method_id=u'datapol.data.orgs.policyTaxonomies.applyAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}:applyAnnotationTag',
        request_field=u'applyAnnotationTagRequest',
        request_type_name=u'DatapolDataOrgsPolicyTaxonomiesApplyAnnotationTagRequest',
        response_type_name=u'AnnotationTag',
        supports_download=False,
    )

    def DeleteAnnotationTag(self, request, global_params=None):
      """Deletes an annotation tag from a cloud data set.

      Args:
        request: (DatapolDataOrgsPolicyTaxonomiesDeleteAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DeleteAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotationTag',
        http_method=u'DELETE',
        method_id=u'datapol.data.orgs.policyTaxonomies.deleteAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolDataOrgsPolicyTaxonomiesDeleteAnnotationTagRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

  class DataOrgsService(base_api.BaseApiService):
    """Service class for the data_orgs resource."""

    _NAME = u'data_orgs'

    def __init__(self, client):
      super(DatapolV1alpha1.DataOrgsService, self).__init__(client)
      self._upload_configs = {
          }

  class DataService(base_api.BaseApiService):
    """Service class for the data resource."""

    _NAME = u'data'

    def __init__(self, client):
      super(DatapolV1alpha1.DataService, self).__init__(client)
      self._upload_configs = {
          }

  class DataAssetsService(base_api.BaseApiService):
    """Service class for the dataAssets resource."""

    _NAME = u'dataAssets'

    def __init__(self, client):
      super(DatapolV1alpha1.DataAssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def ListResourceNames(self, request, global_params=None):
      """Lists all cloud data assets with given predicates.

      Args:
        request: (DatapolDataAssetsListResourceNamesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('ListResourceNames')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListResourceNames.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'datapol.dataAssets.listResourceNames',
        ordered_params=[],
        path_params=[],
        query_params=[u'annotatableOnly', u'annotations', u'filter', u'includeAnnotatedByGroup', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/dataAssets:ListResourceNames',
        request_field='',
        request_type_name=u'DatapolDataAssetsListResourceNamesRequest',
        response_type_name=u'ListAssetsResponse',
        supports_download=False,
    )

  class OrgsPolicyTaxonomiesAnnotationsService(base_api.BaseApiService):
    """Service class for the orgs_policyTaxonomies_annotations resource."""

    _NAME = u'orgs_policyTaxonomies_annotations'

    def __init__(self, client):
      super(DatapolV1alpha1.OrgsPolicyTaxonomiesAnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates an annotation in a taxonomy.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesAnnotationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotations',
        http_method=u'POST',
        method_id=u'datapol.orgs.policyTaxonomies.annotations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/annotations',
        request_field=u'annotation',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesAnnotationsCreateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes an annotation. Also deletes all member annotations if the given.
annotation is a group annotation.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'DELETE',
        method_id=u'datapol.orgs.policyTaxonomies.annotations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesAnnotationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Gets definition of an annotation.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'GET',
        method_id=u'datapol.orgs.policyTaxonomies.annotations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all annotations in a taxonomy.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesAnnotationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotations',
        http_method=u'GET',
        method_id=u'datapol.orgs.policyTaxonomies.annotations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/annotations',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesAnnotationsListRequest',
        response_type_name=u'ListAnnotationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      """Updates description of an annotation.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesAnnotationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'PATCH',
        method_id=u'datapol.orgs.policyTaxonomies.annotations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'updateAnnotationRequest',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesAnnotationsPatchRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class OrgsPolicyTaxonomiesService(base_api.BaseApiService):
    """Service class for the orgs_policyTaxonomies resource."""

    _NAME = u'orgs_policyTaxonomies'

    def __init__(self, client):
      super(DatapolV1alpha1.OrgsPolicyTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new data policy taxonomy.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PolicyTaxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies',
        http_method=u'POST',
        method_id=u'datapol.orgs.policyTaxonomies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/policyTaxonomies',
        request_field=u'policyTaxonomy',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesCreateRequest',
        response_type_name=u'PolicyTaxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes a taxonomy. This operation will also delete all annotations in.
this taxonomy.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}',
        http_method=u'DELETE',
        method_id=u'datapol.orgs.policyTaxonomies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Returns the taxonomy referred by name. Size of a taxonomy is at most 100KB.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PolicyTaxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}',
        http_method=u'GET',
        method_id=u'datapol.orgs.policyTaxonomies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesGetRequest',
        response_type_name=u'PolicyTaxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """GetIamPolicy method for the orgs_policyTaxonomies service.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.orgs.policyTaxonomies.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all taxonomies that an org owns.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPolicyTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies',
        http_method=u'GET',
        method_id=u'datapol.orgs.policyTaxonomies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/policyTaxonomies',
        request_field='',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesListRequest',
        response_type_name=u'ListPolicyTaxonomiesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """SetIamPolicy method for the orgs_policyTaxonomies service.

      Args:
        request: (DatapolOrgsPolicyTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/orgs/{orgsId}/policyTaxonomies/{policyTaxonomiesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.orgs.policyTaxonomies.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatapolOrgsPolicyTaxonomiesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class OrgsService(base_api.BaseApiService):
    """Service class for the orgs resource."""

    _NAME = u'orgs'

    def __init__(self, client):
      super(DatapolV1alpha1.OrgsService, self).__init__(client)
      self._upload_configs = {
          }
