"""Generated client library for containeranalysis version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.containeranalysis.v1alpha1 import containeranalysis_v1alpha1_messages as messages


class ContaineranalysisV1alpha1(base_api.BaseApiClient):
  """Generated client library for service containeranalysis version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://containeranalysis.googleapis.com/'

  _PACKAGE = u'containeranalysis'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ContaineranalysisV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new containeranalysis handle."""
    url = url or self.BASE_URL
    super(ContaineranalysisV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.projects_notes_occurrences = self.ProjectsNotesOccurrencesService(self)
    self.projects_notes = self.ProjectsNotesService(self)
    self.projects_occurrences = self.ProjectsOccurrencesService(self)
    self.projects = self.ProjectsService(self)
    self.providers_notes_occurrences = self.ProvidersNotesOccurrencesService(self)
    self.providers_notes = self.ProvidersNotesService(self)
    self.providers = self.ProvidersService(self)

  class ProjectsNotesOccurrencesService(base_api.BaseApiService):
    """Service class for the projects_notes_occurrences resource."""

    _NAME = u'projects_notes_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsNotesOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists the names of Occurrences linked to a particular Note.

      Args:
        request: (ContaineranalysisProjectsNotesOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNoteOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.occurrences.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+name}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesOccurrencesListRequest',
        response_type_name=u'ListNoteOccurrencesResponse',
        supports_download=False,
    )

  class ProjectsNotesService(base_api.BaseApiService):
    """Service class for the projects_notes resource."""

    _NAME = u'projects_notes'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsNotesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new note.

      Args:
        request: (ContaineranalysisProjectsNotesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'name', u'noteId'],
        relative_path=u'v1alpha1/{+parent}/notes',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProjectsNotesCreateRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes the given note from the system.

      Args:
        request: (ContaineranalysisProjectsNotesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.projects.notes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Returns the requested occurrence.

      Args:
        request: (ContaineranalysisProjectsNotesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesGetRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """Gets the access control policy for a note or occurrence resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsNotesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsNotesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all notes for a given project.  Filters can be used on this.
field to list all notes with a specific parameter.

      Args:
        request: (ContaineranalysisProjectsNotesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'name', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesListRequest',
        response_type_name=u'ListNotesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """Sets the access control policy on the specified note or occurrence.
resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project, or a
PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsNotesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsNotesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified note or occurrence.
resource.
Requires list permission on the project (e.g., "storage.objects.list" on
the containing bucket for testing permission of an object).
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsNotesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProjectsNotesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      """Updates an existing note.

      Args:
        request: (Note) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'PUT',
        method_id=u'containeranalysis.projects.notes.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='<request>',
        request_type_name=u'Note',
        response_type_name=u'Note',
        supports_download=False,
    )

  class ProjectsOccurrencesService(base_api.BaseApiService):
    """Service class for the projects_occurrences resource."""

    _NAME = u'projects_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new occurrence.

      Args:
        request: (ContaineranalysisProjectsOccurrencesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'name'],
        relative_path=u'v1alpha1/{+parent}/occurrences',
        request_field=u'occurrence',
        request_type_name=u'ContaineranalysisProjectsOccurrencesCreateRequest',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes the given occurrence from the system.

      Args:
        request: (ContaineranalysisProjectsOccurrencesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.projects.occurrences.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Returns the requested occurrence.

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetRequest',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """Gets the access control policy for a note or occurrence resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetNotes(self, request, global_params=None):
      """Gets the note that this occurrence is attached to.

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetNotesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('GetNotes')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNotes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.getNotes',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetNotesRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all occurrences for a given project/Digest.  Filters can be used on.
this field to list all digests containing a specific occurrence in a
project.

      Args:
        request: (ContaineranalysisProjectsOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'name', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesListRequest',
        response_type_name=u'ListOccurrencesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """Sets the access control policy on the specified note or occurrence.
resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project, or a
PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsOccurrencesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified note or occurrence.
resource.
Requires list permission on the project (e.g., "storage.objects.list" on
the containing bucket for testing permission of an object).
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      """Updates an existing occurrence.

      Args:
        request: (Occurrence) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'PUT',
        method_id=u'containeranalysis.projects.occurrences.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='<request>',
        request_type_name=u'Occurrence',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProvidersNotesOccurrencesService(base_api.BaseApiService):
    """Service class for the providers_notes_occurrences resource."""

    _NAME = u'providers_notes_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersNotesOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists the names of Occurrences linked to a particular Note.

      Args:
        request: (ContaineranalysisProvidersNotesOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNoteOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.occurrences.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+name}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesOccurrencesListRequest',
        response_type_name=u'ListNoteOccurrencesResponse',
        supports_download=False,
    )

  class ProvidersNotesService(base_api.BaseApiService):
    """Service class for the providers_notes resource."""

    _NAME = u'providers_notes'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersNotesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new note.

      Args:
        request: (ContaineranalysisProvidersNotesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'noteId', u'parent'],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProvidersNotesCreateRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes the given note from the system.

      Args:
        request: (ContaineranalysisProvidersNotesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.providers.notes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Returns the requested occurrence.

      Args:
        request: (ContaineranalysisProvidersNotesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesGetRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """Gets the access control policy for a note or occurrence resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProvidersNotesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProvidersNotesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all notes for a given project.  Filters can be used on this.
field to list all notes with a specific parameter.

      Args:
        request: (ContaineranalysisProvidersNotesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken', u'parent'],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesListRequest',
        response_type_name=u'ListNotesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """Sets the access control policy on the specified note or occurrence.
resource.
Requires "containeranalysis.notes.setIamPolicy" or
"containeranalysis.occurrences.setIamPolicy" permission if the resource is
a note or occurrence, respectively.
Attempting this RPC on a resource without the needed permission will note
in a PERMISSION_DENIED error.
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project, or a
PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProvidersNotesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProvidersNotesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified note or occurrence.
resource.
Requires list permission on the project (e.g., "storage.objects.list" on
the containing bucket for testing permission of an object).
Attempting this RPC on a non-existent resource will result in a NOT_FOUND
error if the user has list permission on the project,
or a PERMISSION_DENIED error otherwise.
The resource takes the following formats:
projects/{projectid}/occurrences/{occurrenceid} for occurrences and
projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProvidersNotesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProvidersNotesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      """Updates an existing note.

      Args:
        request: (Note) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'PUT',
        method_id=u'containeranalysis.providers.notes.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='<request>',
        request_type_name=u'Note',
        response_type_name=u'Note',
        supports_download=False,
    )

  class ProvidersService(base_api.BaseApiService):
    """Service class for the providers resource."""

    _NAME = u'providers'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersService, self).__init__(client)
      self._upload_configs = {
          }
