"""Generated message classes for container version v1.

The Google Container Engine API is used for building and managing container
based applications, powered by the open source Kubernetes technology.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'container'


class AddonsConfig(_messages.Message):
  """Configuration for the addons that can be automatically spun up in the
  cluster, enabling additional functionality.

  Fields:
    horizontalPodAutoscaling: Configuration for the horizontal pod autoscaling
      feature, which increases or decreases the number of replica pods a
      replication controller has based on the resource usage of the existing
      pods.
    httpLoadBalancing: Configuration for the HTTP (L7) load balancing
      controller addon, which makes it easy to set up HTTP load balancers for
      services in a cluster.
  """

  horizontalPodAutoscaling = _messages.MessageField('HorizontalPodAutoscaling', 1)
  httpLoadBalancing = _messages.MessageField('HttpLoadBalancing', 2)


class AuthenticateRequest(_messages.Message):
  """A request to authenticate a user based on a provided OAuth2 token.  This
  should look very close to the TokenReview struct in http://github.com/kubern
  etes/kubernetes/blob/master/pkg/apis/authentication.k8s.io/v1beta1/types.go.
  This message has 4 GKE-specific fields that get mapped from the path, but
  the other fields (the expected JSON payload) must match TokenReview.

  Fields:
    apiVersion: The api version of the TokenReview object.
    kind: Fields from "pkg/apis/authentication.k8s.io/v1beta1".TokenReview:
      The "kind" of the TokenReview object.
    metadata: "pkg/api/types".ObjectMeta TODO (b/30563544): Remove these
      unused fields.
    spec: The information about the request being evaluated. It contains the
      token that the server should authenticate.
    status: The response for the provided request. (this won't be filled in
      for an AuthenticateRequest, but it is part of the struct, so we need it
      here to be safe).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('TokenReviewSpec', 4)
  status = _messages.MessageField('TokenReviewStatus', 5)


class AuthenticateResponse(_messages.Message):
  """A response with the authenticated identity. This should match exactly
  with the TokenReview struct from http://github.com/kubernetes/kubernetes/blo
  b/master/pkg/apis/authentication.k8s.io/types.go.

  Fields:
    apiVersion: The api version of the TokenReview object.
    kind: The "kind" of the TokenReview object.
    spec: The information about the request that was evaluated. This field
      (along with kind & api_version) are returned unchanged from the
      AuthenticateRequest. The caller probably doesn't care, but it would
      allow the caller to verify the question the server thought it was
      answering.
    status: The response for the provided request.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  spec = _messages.MessageField('TokenReviewSpec', 3)
  status = _messages.MessageField('TokenReviewStatus', 4)


class AuthorizeRequest(_messages.Message):
  """A request to authorize a user action. The request contains the attributes
  of the action the user is attempting. These attributes are mapped to a GKE
  IAM permission and policy to check.  This should look very close to the
  SubjectAccessReview struct in http://github.com/kubernetes/kubernetes/blob/m
  aster/pkg/apis/authorization/v1beta1/types.go. This message has 4 GKE-
  specific fields that get mapped from the path, but the other fields (the
  expected JSON payload) must match SubjectAccessReview.

  Fields:
    apiVersion: The api version of the SubjectAccessReview object.
    kind: Fields from "pkg/apis/authorization/v1beta1".SubjectAccessReview:
      The "kind" of the SubjectAccessReview object.
    metadata: Fields from "pkg/api/types".ObjectMeta TODO (b/30563544): Remove
      these unused fields.
    spec: The information about the user action being evaluated.
    status: The response for the provided request (this won't be filled in for
      an AuthorizeRequest, but it is part of the struct, so we need it here to
      be safe).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('SubjectAccessReviewSpec', 4)
  status = _messages.MessageField('SubjectAccessReviewStatus', 5)


class AuthorizeResponse(_messages.Message):
  """A response to a request for authorization. This should match exactly with
  the SubjectAccessReview struct from http://github.com/kubernetes/kubernetes/
  blob/master/pkg/apis/v1beta1/authorization/types.go.

  Fields:
    apiVersion: The api version of the SubjectAccessReview object.
    kind: The "kind" of the SubjectAccessReview object.
    spec: The information about the request that was evaluated. This field
      (along with kind & api_version) are returned unchanged from the
      AuthorizeRequest. The caller probably doesn't care, but it would allow
      the caller to verify the question the server thought it was answering.
    status: The response for the provided request.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  spec = _messages.MessageField('SubjectAccessReviewSpec', 3)
  status = _messages.MessageField('SubjectAccessReviewStatus', 4)


class AutoUpgradeOptions(_messages.Message):
  """AutoUpgradeOptions defines the set of options for the user to control how
  the Auto Upgrades will proceed.

  Fields:
    autoUpgradeStartTime: [Output only] This field is set when upgrades are
      about to commence with the approximate start time for the upgrades, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    description: [Output only] This field is set when upgrades are about to
      commence with the description of the upgrade.
    requestedUpgradeStartTime: User requested start time, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
  """

  autoUpgradeStartTime = _messages.StringField(1)
  description = _messages.StringField(2)
  requestedUpgradeStartTime = _messages.StringField(3)


class CIDR(_messages.Message):
  """CIDR contains an optional name and one CIDR block.

  Fields:
    name: Network name is an optional field for users to identify CIDR blocks.
    network: Authorized network must be specified in CIDR notation.
  """

  name = _messages.StringField(1)
  network = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  """CancelOperationRequest cancels a single operation."""


class CertificateSigningRequest(_messages.Message):
  """A request to sign a certificate. These fields must match the OSS
  definition in "pkg/apis/certificates/v1beta1", with additional fields
  prepending as part of the "SignCertificate" rpc definition.

  Fields:
    apiVersion: The api version of the CertificateSigningRequest object.
    clusterId: The name of this master's cluster.
    kind: The "kind" of the CertificateSigningRequest object.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    metadata: Additional metadata about the Kubernetes object.
    projectNumber: The project number for which the certificate is being
      signed. This is the project in which this master's cluster resides.
      This is an int64, so it must be a project number, not a project ID.
    spec: The specification holds information about the certificate requesting
      to be signed.
    status: The status is populated at response time, and holds information
      about the success or failure of the operation along with the signed
      certificate.
    zone: The zone of this master's cluster.
  """

  apiVersion = _messages.StringField(1)
  clusterId = _messages.StringField(2)
  kind = _messages.StringField(3)
  masterProjectId = _messages.StringField(4)
  metadata = _messages.MessageField('ObjectMeta', 5)
  projectNumber = _messages.IntegerField(6)
  spec = _messages.MessageField('CertificateSigningRequestSpec', 7)
  status = _messages.MessageField('CertificateSigningRequestStatus', 8)
  zone = _messages.StringField(9)


class CertificateSigningRequestCondition(_messages.Message):
  """A detailed condition of the state of the certificate signing request,
  such as whether it has been approved or denied. This must match the OSS
  definition in "pkg/apis/certificates/v1beta1".

  Fields:
    lastUpdateTime: The timestamp of the last update to this condition.
    message: A human-readable message with details about the request state.
    reason: A brief reason for the request state.
    type: The request approval state, currently either Approved or Denied.
  """

  lastUpdateTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  type = _messages.StringField(4)


class CertificateSigningRequestSpec(_messages.Message):
  """The specification for a certificate to be signed. This must match the OSS
  definition in "pkg/apis/certificates/v1beta1".

  Fields:
    groups: An optional list of groups for this request.
    request: The PEM-encoded body of the certificate.
    uid: An optional UID for the CSR object.
    usages: Allowed usages that the certificate will be valid for. See:
      https://tools.ietf.org/html/rfc5280#section-4.2.1.3
      https://tools.ietf.org/html/rfc5280#section-4.2.1.12
    username: Information about the requesting user (if relevant).
  """

  groups = _messages.StringField(1, repeated=True)
  request = _messages.BytesField(2)
  uid = _messages.StringField(3)
  usages = _messages.StringField(4, repeated=True)
  username = _messages.StringField(5)


class CertificateSigningRequestStatus(_messages.Message):
  """The status of the certificate signing request, populated at response
  time. This must match the OSS definition in "pkg/apis/certificates/v1beta1".

  Fields:
    certificate: The bytes of the signed certificate, on success.
    conditions: Conditions applied to the request, such as approval or denial.
  """

  certificate = _messages.BytesField(1)
  conditions = _messages.MessageField('CertificateSigningRequestCondition', 2, repeated=True)


class Cluster(_messages.Message):
  """A Google Container Engine cluster.

  Enums:
    StatusValueValuesEnum: [Output only] The current status of this cluster.

  Fields:
    addonsConfig: Configurations for the various addons available to run in
      the cluster.
    clusterIpv4Cidr: The IP address range of the container pods in this
      cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one
      automatically chosen or specify a `/14` block in `10.0.0.0/8`.
    createTime: [Output only] The time the cluster was created, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    currentMasterVersion: [Output only] The current software version of the
      master endpoint.
    currentNodeCount: [Output only] The number of nodes currently in the
      cluster.
    currentNodeVersion: [Output only] The current version of the node software
      components. If they are currently at multiple versions because they're
      in the process of being upgraded, this reflects the minimum version of
      all nodes.
    description: An optional description of this cluster.
    enableKubernetesAlpha: Kubernetes alpha features are enabled on this
      cluster. This includes alpha API groups (e.g. v1alpha1) and features
      that may not be production ready in the kubernetes version of the master
      and nodes. The cluster has no SLA for uptime and master/node upgrades
      are disabled. Alpha enabled clusters are automatically deleted thirty
      days after creation.
    endpoint: [Output only] The IP address of this cluster's master endpoint.
      The endpoint can be accessed from the internet at
      `https://username:password@endpoint/`.  See the `masterAuth` property of
      this resource for username and password information.
    expireTime: [Output only] The time the cluster will be automatically
      deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    initialClusterVersion: [Output only] The software version of the master
      endpoint and kubelets used in the cluster when it was first created. The
      version can be upgraded over time.
    initialNodeCount: The number of nodes to create in this cluster. You must
      ensure that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota. For requests,
      this field should only be used in lieu of a "node_pool" object, since
      this configuration (along with the "node_config") will be used to create
      a "NodePool" object with an auto-generated name. Do not use this and a
      node_pool at the same time.
    instanceGroupUrls: [Output only] The resource URLs of [instance
      groups](/compute/docs/instance-groups/) associated with this cluster.
    labelFingerprint: The fingerprint of the set of labels for this cluster.
    legacyAbac: Configuration for the legacy ABAC authorization mode.
    locations: The list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located.
    loggingService: The logging service the cluster should use to write logs.
      Currently available options:  * `logging.googleapis.com` - the Google
      Cloud Logging service. * `none` - no logs will be exported from the
      cluster. * if left as an empty string,`logging.googleapis.com` will be
      used.
    masterAuth: The authentication information for accessing the master
      endpoint.
    masterAuthorizedNetworks: The configuration options for master authorized
      networks feature.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options:  * `monitoring.googleapis.com` -
      the Google Cloud Monitoring service. * `none` - no metrics will be
      exported from the cluster. * if left as an empty string,
      `monitoring.googleapis.com` will be used.
    name: The name of this cluster. The name must be unique within this
      project and zone, and can be up to 40 characters with the following
      restrictions:  * Lowercase letters, numbers, and hyphens only. * Must
      start with a letter. * Must end with a number or a letter.
    network: The name of the Google Compute Engine [network](/compute/docs
      /networks-and-firewalls#networks) to which the cluster is connected. If
      left unspecified, the `default` network will be used.
    nodeConfig: Parameters used in creating the cluster's nodes. See
      `nodeConfig` for the description of its properties. For requests, this
      field should only be used in lieu of a "node_pool" object, since this
      configuration (along with the "initial_node_count") will be used to
      create a "NodePool" object with an auto-generated name. Do not use this
      and a node_pool at the same time. For responses, this field will be
      populated with the node configuration of the first node pool.  If
      unspecified, the defaults are used.
    nodeIpv4CidrSize: [Output only] The size of the address space on each node
      for hosting containers. This is provisioned from within the
      `container_ipv4_cidr` range.
    nodePools: The node pools associated with this cluster. This field should
      not be set if "node_config" or "initial_node_count" are specified.
    resourceLabels: The resource labels for the cluster to use to annotate any
      related GCE resources.
    selfLink: [Output only] Server-defined URL for the resource.
    servicesIpv4Cidr: [Output only] The IP address range of the Kubernetes
      services in this cluster, in [CIDR](http://en.wikipedia.org/wiki
      /Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`). Service
      addresses are typically put in the last `/16` from the container CIDR.
    status: [Output only] The current status of this cluster.
    statusMessage: [Output only] Additional information about the current
      status of this cluster, if available.
    subnetwork: The name of the Google Compute Engine
      [subnetwork](/compute/docs/subnetworks) to which the cluster is
      connected.
    zone: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output only] The current status of this cluster.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the cluster, such as upgrading the master or node
        software. Details can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster may be unusable. Details
        can be found in the `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  clusterIpv4Cidr = _messages.StringField(2)
  createTime = _messages.StringField(3)
  currentMasterVersion = _messages.StringField(4)
  currentNodeCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  currentNodeVersion = _messages.StringField(6)
  description = _messages.StringField(7)
  enableKubernetesAlpha = _messages.BooleanField(8)
  endpoint = _messages.StringField(9)
  expireTime = _messages.StringField(10)
  initialClusterVersion = _messages.StringField(11)
  initialNodeCount = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(13, repeated=True)
  labelFingerprint = _messages.StringField(14)
  legacyAbac = _messages.MessageField('LegacyAbac', 15)
  locations = _messages.StringField(16, repeated=True)
  loggingService = _messages.StringField(17)
  masterAuth = _messages.MessageField('MasterAuth', 18)
  masterAuthorizedNetworks = _messages.MessageField('MasterAuthorizedNetworks', 19)
  monitoringService = _messages.StringField(20)
  name = _messages.StringField(21)
  network = _messages.StringField(22)
  nodeConfig = _messages.MessageField('NodeConfig', 23)
  nodeIpv4CidrSize = _messages.IntegerField(24, variant=_messages.Variant.INT32)
  nodePools = _messages.MessageField('NodePool', 25, repeated=True)
  resourceLabels = _messages.MessageField('ResourceLabels', 26)
  selfLink = _messages.StringField(27)
  servicesIpv4Cidr = _messages.StringField(28)
  status = _messages.EnumField('StatusValueValuesEnum', 29)
  statusMessage = _messages.StringField(30)
  subnetwork = _messages.StringField(31)
  zone = _messages.StringField(32)


class ClusterUpdate(_messages.Message):
  """ClusterUpdate describes an update to the cluster. Exactly one update can
  be applied to a cluster with each request, so at most one field can be
  provided.

  Fields:
    desiredAddonsConfig: Configurations for the various addons available to
      run in the cluster.
    desiredImageType: The desired image type for the node pool. NOTE: Set the
      "desired_node_pool" field as well.
    desiredLocations: The desired list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located. Changing the locations a cluster is in will result in
      nodes being either created or removed from the cluster, depending on
      whether locations are being added or removed.  This list must always
      include the cluster's primary zone.
    desiredMasterAuthorizedNetworks: The desired configuration options for
      master authorized networks feature.
    desiredMasterMachineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-8`) to change the
      master to.
    desiredMasterVersion: The Kubernetes version to change the master to. The
      only valid value is the latest supported version. Use "-" to have the
      server automatically select the latest version.
    desiredMonitoringService: The monitoring service the cluster should use to
      write metrics. Currently available options:  *
      "monitoring.googleapis.com" - the Google Cloud Monitoring service *
      "none" - no metrics will be exported from the cluster
    desiredNodePoolAutoscaling: Autoscaler configuration for the node pool
      specified in desired_node_pool_id. If there is only one pool in the
      cluster and desired_node_pool_id is not provided then the change applies
      to that single node pool.
    desiredNodePoolId: The node pool to be upgraded. This field is mandatory
      if "desired_node_version", "desired_image_family" or
      "desired_node_pool_autoscaling" is specified and there is more than one
      node pool on the cluster.
    desiredNodeVersion: The Kubernetes version to change the nodes to
      (typically an upgrade). Use `-` to upgrade to the latest version
      supported by the server.
  """

  desiredAddonsConfig = _messages.MessageField('AddonsConfig', 1)
  desiredImageType = _messages.StringField(2)
  desiredLocations = _messages.StringField(3, repeated=True)
  desiredMasterAuthorizedNetworks = _messages.MessageField('MasterAuthorizedNetworks', 4)
  desiredMasterMachineType = _messages.StringField(5)
  desiredMasterVersion = _messages.StringField(6)
  desiredMonitoringService = _messages.StringField(7)
  desiredNodePoolAutoscaling = _messages.MessageField('NodePoolAutoscaling', 8)
  desiredNodePoolId = _messages.StringField(9)
  desiredNodeVersion = _messages.StringField(10)


class ContainerMasterProjectsZonesAuthenticateRequest(_messages.Message):
  """A ContainerMasterProjectsZonesAuthenticateRequest object.

  Fields:
    authenticateRequest: A AuthenticateRequest resource to be passed as the
      request body.
    clusterId: The name of this master's cluster.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    projectNumber: The project number for which the signed URLs are being
      requested.  This is the project in which this master's cluster resides.
      Note that this must be a project number, not a project ID.
    zone: The zone of this master's cluster.
  """

  authenticateRequest = _messages.MessageField('AuthenticateRequest', 1)
  clusterId = _messages.StringField(2, required=True)
  masterProjectId = _messages.StringField(3, required=True)
  projectNumber = _messages.IntegerField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerMasterProjectsZonesAuthorizeRequest(_messages.Message):
  """A ContainerMasterProjectsZonesAuthorizeRequest object.

  Fields:
    authorizeRequest: A AuthorizeRequest resource to be passed as the request
      body.
    clusterId: The name of this master's cluster.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    projectNumber: The project number for which the request is being
      authorized.  This is the project in which this master's cluster resides.
      This is an int64, so it must be a project number, not a project ID.
    zone: The zone of this master's cluster.
  """

  authorizeRequest = _messages.MessageField('AuthorizeRequest', 1)
  clusterId = _messages.StringField(2, required=True)
  masterProjectId = _messages.StringField(3, required=True)
  projectNumber = _messages.IntegerField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerMasterProjectsZonesImagereviewRequest(_messages.Message):
  """A ContainerMasterProjectsZonesImagereviewRequest object.

  Fields:
    clusterId: The name of this master's cluster.
    imageReviewRequest: A ImageReviewRequest resource to be passed as the
      request body.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    projectNumber: The project number for which the request is being
      authorized.  This is the project in which this master's cluster resides.
      This is an int64, so it must be a project number, not a project ID.
    zone: The zone of this master's cluster.
  """

  clusterId = _messages.StringField(1, required=True)
  imageReviewRequest = _messages.MessageField('ImageReviewRequest', 2)
  masterProjectId = _messages.StringField(3, required=True)
  projectNumber = _messages.IntegerField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerMasterProjectsZonesSignedUrlsCreateRequest(_messages.Message):
  """A ContainerMasterProjectsZonesSignedUrlsCreateRequest object.

  Fields:
    createSignedUrlsRequest: A CreateSignedUrlsRequest resource to be passed
      as the request body.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The zone of this master's cluster.
  """

  createSignedUrlsRequest = _messages.MessageField('CreateSignedUrlsRequest', 1)
  masterProjectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerMasterProjectsZonesTokensCreateRequest(_messages.Message):
  """A ContainerMasterProjectsZonesTokensCreateRequest object.

  Fields:
    createTokenRequest: A CreateTokenRequest resource to be passed as the
      request body.
    masterProjectId: The hosted master project in which this master resides.
      This can be either a [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The zone of this master's cluster.
  """

  createTokenRequest = _messages.MessageField('CreateTokenRequest', 1)
  masterProjectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersCreateRequest(_messages.Message):
  """A ContainerProjectsZonesClustersCreateRequest object.

  Fields:
    createClusterRequest: A CreateClusterRequest resource to be passed as the
      request body.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  createClusterRequest = _messages.MessageField('CreateClusterRequest', 1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersDeleteRequest(_messages.Message):
  """A ContainerProjectsZonesClustersDeleteRequest object.

  Fields:
    clusterId: The name of the cluster to delete.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersGetRequest(_messages.Message):
  """A ContainerProjectsZonesClustersGetRequest object.

  Fields:
    clusterId: The name of the cluster to retrieve.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersLegacyAbacRequest(_messages.Message):
  """A ContainerProjectsZonesClustersLegacyAbacRequest object.

  Fields:
    clusterId: The name of the cluster to update.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    setLegacyAbacRequest: A SetLegacyAbacRequest resource to be passed as the
      request body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  setLegacyAbacRequest = _messages.MessageField('SetLegacyAbacRequest', 3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersListRequest(_messages.Message):
  """A ContainerProjectsZonesClustersListRequest object.

  Fields:
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides, or
      "-" for all zones.
  """

  projectId = _messages.StringField(1, required=True)
  zone = _messages.StringField(2, required=True)


class ContainerProjectsZonesClustersNodePoolsCreateRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsCreateRequest object.

  Fields:
    clusterId: The name of the cluster.
    createNodePoolRequest: A CreateNodePoolRequest resource to be passed as
      the request body.
    projectId: The Google Developers Console [project ID or project
      number](https://developers.google.com/console/help/new/#projectnumber).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  createNodePoolRequest = _messages.MessageField('CreateNodePoolRequest', 2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersNodePoolsDeleteRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: The name of the cluster.
    nodePoolId: The name of the node pool to delete.
    projectId: The Google Developers Console [project ID or project
      number](https://developers.google.com/console/help/new/#projectnumber).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  nodePoolId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersNodePoolsGetRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsGetRequest object.

  Fields:
    clusterId: The name of the cluster.
    nodePoolId: The name of the node pool.
    projectId: The Google Developers Console [project ID or project
      number](https://developers.google.com/console/help/new/#projectnumber).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  nodePoolId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersNodePoolsListRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsListRequest object.

  Fields:
    clusterId: The name of the cluster.
    projectId: The Google Developers Console [project ID or project
      number](https://developers.google.com/console/help/new/#projectnumber).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersNodePoolsRollbackRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsRollbackRequest object.

  Fields:
    clusterId: The name of the cluster to rollback.
    nodePoolId: The name of the node pool to rollback.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    rollbackNodePoolUpgradeRequest: A RollbackNodePoolUpgradeRequest resource
      to be passed as the request body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  nodePoolId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  rollbackNodePoolUpgradeRequest = _messages.MessageField('RollbackNodePoolUpgradeRequest', 4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersNodePoolsSetManagementRequest(_messages.Message):
  """A ContainerProjectsZonesClustersNodePoolsSetManagementRequest object.

  Fields:
    clusterId: The name of the cluster to update.
    nodePoolId: The name of the node pool to update.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    setNodePoolManagementRequest: A SetNodePoolManagementRequest resource to
      be passed as the request body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  nodePoolId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  setNodePoolManagementRequest = _messages.MessageField('SetNodePoolManagementRequest', 4)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersResourceLabelsRequest(_messages.Message):
  """A ContainerProjectsZonesClustersResourceLabelsRequest object.

  Fields:
    clusterId: The name of the cluster.
    projectId: The Google Developers Console [project ID or project
      number](https://developers.google.com/console/help/new/#projectnumber).
    setLabelsRequest: A SetLabelsRequest resource to be passed as the request
      body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  setLabelsRequest = _messages.MessageField('SetLabelsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersSetMasterAuthRequest(_messages.Message):
  """A ContainerProjectsZonesClustersSetMasterAuthRequest object.

  Fields:
    clusterId: The name of the cluster to upgrade.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    setMasterAuthRequest: A SetMasterAuthRequest resource to be passed as the
      request body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  setMasterAuthRequest = _messages.MessageField('SetMasterAuthRequest', 3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersUpdateRequest(_messages.Message):
  """A ContainerProjectsZonesClustersUpdateRequest object.

  Fields:
    clusterId: The name of the cluster to upgrade.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    updateClusterRequest: A UpdateClusterRequest resource to be passed as the
      request body.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  updateClusterRequest = _messages.MessageField('UpdateClusterRequest', 3)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesGetServerconfigRequest(_messages.Message):
  """A ContainerProjectsZonesGetServerconfigRequest object.

  Fields:
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for.
  """

  projectId = _messages.StringField(1, required=True)
  zone = _messages.StringField(2, required=True)


class ContainerProjectsZonesOperationsCancelRequest(_messages.Message):
  """A ContainerProjectsZonesOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    operationId: The server-assigned `name` of the operation.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation resides.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  operationId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesOperationsGetRequest(_messages.Message):
  """A ContainerProjectsZonesOperationsGetRequest object.

  Fields:
    operationId: The server-assigned `name` of the operation.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  operationId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesOperationsListRequest(_messages.Message):
  """A ContainerProjectsZonesOperationsListRequest object.

  Fields:
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for, or `-`
      for all zones.
  """

  projectId = _messages.StringField(1, required=True)
  zone = _messages.StringField(2, required=True)


class CreateClusterRequest(_messages.Message):
  """CreateClusterRequest creates a cluster.

  Fields:
    cluster: A [cluster resource](/container-
      engine/reference/rest/v1/projects.zones.clusters)
  """

  cluster = _messages.MessageField('Cluster', 1)


class CreateNodePoolRequest(_messages.Message):
  """CreateNodePoolRequest creates a node pool for a cluster.

  Fields:
    nodePool: The node pool to create.
  """

  nodePool = _messages.MessageField('NodePool', 1)


class CreateSignedUrlsRequest(_messages.Message):
  """A request for signed URLs that allow for writing a file to a private GCS
  bucket for storing backups of hosted master data.

  Fields:
    clusterId: The name of this master's cluster.
    filenames: The names of the files for which a signed URLs are being
      requested.
    projectNumber: The project number for which the signed URLs are being
      requested.  This is the project in which this master's cluster resides.
      Note that this must be a project number, not a project ID.
  """

  clusterId = _messages.StringField(1)
  filenames = _messages.StringField(2, repeated=True)
  projectNumber = _messages.IntegerField(3)


class CreateTokenRequest(_messages.Message):
  """A request for a compute-read-write
  (https://www.googleapis.com/auth/compute) scoped OAuth2 access token for
  <project_number>, to allow hosted masters to make modifications to a user's
  project.

  Fields:
    clusterId: The name of this master's cluster.
    projectNumber: The project number for which the access is being requested.
      This is the project in which this master's cluster resides.  Note that
      this must be a project number, not a project ID.
  """

  clusterId = _messages.StringField(1)
  projectNumber = _messages.IntegerField(2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExtraValue(_messages.Message):
  """ExtraValue allows the extra field to be a mapstringstring

  Fields:
    items: items, if empty, will result in an empty slice
  """

  items = _messages.StringField(1, repeated=True)


class HorizontalPodAutoscaling(_messages.Message):
  """Configuration options for the horizontal pod autoscaling feature, which
  increases or decreases the number of replica pods a replication controller
  has based on the resource usage of the existing pods.

  Fields:
    disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the
      cluster. When enabled, it ensures that a Heapster pod is running in the
      cluster, which is also used by the Cloud Monitoring service.
  """

  disabled = _messages.BooleanField(1)


class HttpLoadBalancing(_messages.Message):
  """Configuration options for the HTTP (L7) load balancing controller addon,
  which makes it easy to set up HTTP load balancers for services in a cluster.

  Fields:
    disabled: Whether the HTTP Load Balancing controller is enabled in the
      cluster. When enabled, it runs a small pod in the cluster that manages
      the load balancers.
  """

  disabled = _messages.BooleanField(1)


class ImageReviewContainerSpec(_messages.Message):
  """ImageReviewContainerSpec is a description of a container within the
  creation request.

  Fields:
    image: This can be in the form image:tag or image@SHA:012345679abcdef.
  """

  image = _messages.StringField(1)


class ImageReviewRequest(_messages.Message):
  """A request to verify an image. The request contains the attributes of the
  container to create. These are passed to BCID for verification.  This should
  look very close to the ImageReview struct in http://github.com/kubernetes/ku
  bernetes/blob/master/pkg/apis/imagepolicy/v1beta1/types.go. This message has
  4 GKE-specific fields that get mapped from the path, but the other fields
  (the expected JSON payload) must match ImageReview.

  Fields:
    apiVersion: The api version of the SubjectAccessReview object.
    kind: Fields from "pkg/apis/authorization/v1beta1".SubjectAccessReview:
      The "kind" of the SubjectAccessReview object.
    metadata: Fields from "pkg/api/types".ObjectMeta TODO (b/30563544): Remove
      these unused fields.
    spec: The information about the user action being evaluated.
    status: The response for the provided request (this won't be filled in for
      an AuthorizeRequest, but it is part of the struct, so we need it here to
      be safe).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ImageReviewSpec', 4)
  status = _messages.MessageField('ImageReviewStatus', 5)


class ImageReviewResponse(_messages.Message):
  """A response to a request for image verification. This should match exactly
  with the ImageReview struct from http://github.com/kubernetes/kubernetes/blo
  b/master/pkg/apis/v1beta1/authorization/types.go.

  Fields:
    apiVersion: The api version of the ImageReview object.
    kind: The "kind" of the ImageReview object.
    spec: The information about the request that was evaluated. This field
      (along with kind & api_version) are returned unchanged from the
      ImageReviewRequest. The caller probably doesn't care, but it would allow
      the caller to verify the question the server thought it was answering.
    status: The response for the provided request.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  spec = _messages.MessageField('ImageReviewSpec', 3)
  status = _messages.MessageField('ImageReviewStatus', 4)


class ImageReviewSpec(_messages.Message):
  """ImageReviewSpec is a description of the pod creation request.

  Messages:
    AnnotationsValue: Annotations is a list of key-value pairs extracted from
      the Pod's annotations. It only includes keys which match the pattern
      `*.image-policy.k8s.io/*`. It is up to each webhook backend to determine
      how to interpret these annotations, if at all.

  Fields:
    annotations: Annotations is a list of key-value pairs extracted from the
      Pod's annotations. It only includes keys which match the pattern
      `*.image-policy.k8s.io/*`. It is up to each webhook backend to determine
      how to interpret these annotations, if at all.
    containers: Container is a subset of the information in the container
      being created.
    namespace: Namespace is the namespace the pod is being created in.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    """Annotations is a list of key-value pairs extracted from the Pod's
    annotations. It only includes keys which match the pattern `*.image-
    policy.k8s.io/*`. It is up to each webhook backend to determine how to
    interpret these annotations, if at all.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  containers = _messages.MessageField('ImageReviewContainerSpec', 2, repeated=True)
  namespace = _messages.StringField(3)


class ImageReviewStatus(_messages.Message):
  """ImageReviewStatus is the result of the token authentication request.

  Fields:
    allowed: Allowed indicates that the image is allowed to run.
    reason: Reason should be empty unless Allowed is false in which case it
      may contain a short description of what is wrong.  Kubernetes may
      truncate excessively long errors when displaying to the user.
  """

  allowed = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class Item(_messages.Message):
  """A label to be applied to Google Compute Engine resources. It must comply
  with RFC1035 for each key and value.

  Fields:
    key: The Key for this label.
    value: The Value for this label.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class LegacyAbac(_messages.Message):
  """Configuration for the legacy Attribute Based Access Control authorization
  mode.

  Fields:
    enabled: Whether the ABAC authorizer is enabled for this cluster. When
      enabled, identities in the system, including service accounts, nodes,
      and controllers, will have statically granted permissions beyond those
      provided by the RBAC configuration or IAM.
  """

  enabled = _messages.BooleanField(1)


class ListClustersResponse(_messages.Message):
  """ListClustersResponse is the result of ListClustersRequest.

  Fields:
    clusters: A list of clusters in the project in the specified zone, or
      across all ones.
    missingZones: If any zones are listed here, the list of clusters returned
      may be missing those zones.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  missingZones = _messages.StringField(2, repeated=True)


class ListNodePoolsResponse(_messages.Message):
  """ListNodePoolsResponse is the result of ListNodePoolsRequest.

  Fields:
    nodePools: A list of node pools for a cluster.
  """

  nodePools = _messages.MessageField('NodePool', 1, repeated=True)


class ListOperationsResponse(_messages.Message):
  """ListOperationsResponse is the result of ListOperationsRequest.

  Fields:
    missingZones: If any zones are listed here, the list of operations
      returned may be missing the operations from those zones.
    operations: A list of operations in the project in the specified zone.
  """

  missingZones = _messages.StringField(1, repeated=True)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class MasterAuth(_messages.Message):
  """The authentication information for accessing the master endpoint.
  Authentication can be done using HTTP basic auth or using client
  certificates.

  Fields:
    clientCertificate: [Output only] Base64-encoded public certificate used by
      clients to authenticate to the cluster endpoint.
    clientKey: [Output only] Base64-encoded private key used by clients to
      authenticate to the cluster endpoint.
    clusterCaCertificate: [Output only] Base64-encoded public certificate that
      is the root of trust for the cluster.
    password: The password to use for HTTP basic authentication to the master
      endpoint. Because the master endpoint is open to the Internet, you
      should create a strong password.
    username: The username to use for HTTP basic authentication to the master
      endpoint.
  """

  clientCertificate = _messages.StringField(1)
  clientKey = _messages.StringField(2)
  clusterCaCertificate = _messages.StringField(3)
  password = _messages.StringField(4)
  username = _messages.StringField(5)


class MasterAuthorizedNetworks(_messages.Message):
  """Configuration options for the master authorized networks feature. Enabled
  master authorized networks will disallow all external traffic to access
  Kubernetes master through HTTPS except traffic from the given CIDR blocks,
  GCE Public IPs and Google Prod IPs.

  Fields:
    cidrs: Network CIDRs define up to 10 external networks that could access
      Kubernetes master through HTTPS.
    enabled: Whether or not master authorized networks is enabled.
  """

  cidrs = _messages.MessageField('CIDR', 1, repeated=True)
  enabled = _messages.BooleanField(2)


class NodeConfig(_messages.Message):
  """Parameters that describe the nodes in a cluster.

  Messages:
    LabelsValue: The map of Kubernetes labels (key/value pairs) to be applied
      to each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      http://kubernetes.io/v1.1/docs/user-guide/labels.html
    MetadataValue: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      four reserved keys: "instance-template", "kube-env", "startup-script",
      and "user-data"  Values are free-form strings, and only have meaning as
      interpreted by the image running in the instance. The only restriction
      placed on them is that each value's size must be less than or equal to
      32 KB.  The total size of all keys and values must be less than 512 KB.

  Fields:
    diskSizeGb: Size of the disk attached to each node, specified in GB. The
      smallest allowed disk size is 10GB.  If unspecified, the default disk
      size is 100GB.
    imageType: The image type to use for this node. Note that for a given
      image type, the latest version of it will be used.
    labels: The map of Kubernetes labels (key/value pairs) to be applied to
      each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      http://kubernetes.io/v1.1/docs/user-guide/labels.html
    localSsdCount: The number of local SSD disks to be attached to the node.
      The limit for this value is dependant upon the maximum number of disks
      available on a machine per zone. See:
      https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
      for more information.
    machineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-1`).  If
      unspecified, the default machine type is `n1-standard-1`.
    metadata: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      four reserved keys: "instance-template", "kube-env", "startup-script",
      and "user-data"  Values are free-form strings, and only have meaning as
      interpreted by the image running in the instance. The only restriction
      placed on them is that each value's size must be less than or equal to
      32 KB.  The total size of all keys and values must be less than 512 KB.
    oauthScopes: The set of Google API scopes to be made available on all of
      the node VMs under the "default" service account.  The following scopes
      are recommended, but not required, and by default are not included:  *
      `https://www.googleapis.com/auth/compute` is required for mounting
      persistent storage on your nodes. *
      `https://www.googleapis.com/auth/devstorage.read_only` is required for
      communicating with **gcr.io** (the [Google Container Registry
      ](/container-registry/)).  If unspecified, no scopes are added, unless
      Cloud Logging or Cloud Monitoring are enabled, in which case their
      required scopes will be added.
    preemptible: Whether the nodes are created as preemptible VM instances.
      See: https://cloud.google.com/compute/docs/instances/preemptible for
      more inforamtion about preemptible VM instances.
    serviceAccount: The Google Cloud Platform Service Account to be used by
      the node VMs. If no Service Account is specified, the "default" service
      account is used.
    tags: The list of instance tags applied to all nodes. Tags are used to
      identify valid sources or targets for network firewalls and are
      specified by the client during cluster or node pool creation. Each tag
      within the list must comply with RFC1035.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """The map of Kubernetes labels (key/value pairs) to be applied to each
    node. These will added in addition to any default label(s) that Kubernetes
    may apply to the node. In case of conflict in label keys, the applied set
    may differ depending on the Kubernetes version -- it's best to assume the
    behavior is undefined and conflicts should be avoided. For more
    information, including usage and the valid values, see:
    http://kubernetes.io/v1.1/docs/user-guide/labels.html

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """The metadata key/value pairs assigned to instances in the cluster.
    Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
    in length. These are reflected as part of a URL in the metadata server.
    Additionally, to avoid ambiguity, keys must not conflict with any other
    metadata keys for the project or be one of the four reserved keys:
    "instance-template", "kube-env", "startup-script", and "user-data"  Values
    are free-form strings, and only have meaning as interpreted by the image
    running in the instance. The only restriction placed on them is that each
    value's size must be less than or equal to 32 KB.  The total size of all
    keys and values must be less than 512 KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  diskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  imageType = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  localSsdCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  machineType = _messages.StringField(5)
  metadata = _messages.MessageField('MetadataValue', 6)
  oauthScopes = _messages.StringField(7, repeated=True)
  preemptible = _messages.BooleanField(8)
  serviceAccount = _messages.StringField(9)
  tags = _messages.StringField(10, repeated=True)


class NodeManagement(_messages.Message):
  """NodeManagement defines the set of node management services turned on for
  the node pool.

  Fields:
    autoRepair: A flag that specifies whether the node auto-repair is enabled
      for the node pool. If enabled, the nodes in this node pool will be
      monitored and, if they fail health checks too many times, an automatic
      repair action will be triggered.
    autoUpgrade: A flag that specifies whether node auto-upgrade is enabled
      for the node pool. If enabled, node auto-upgrade helps keep the nodes in
      your node pool up to date with the latest release version of Kubernetes.
    upgradeOptions: Specifies the Auto Upgrade knobs for the node pool.
  """

  autoRepair = _messages.BooleanField(1)
  autoUpgrade = _messages.BooleanField(2)
  upgradeOptions = _messages.MessageField('AutoUpgradeOptions', 3)


class NodePool(_messages.Message):
  """NodePool contains the name and configuration for a cluster's node pool.
  Node pools are a set of nodes (i.e. VM's), with a common configuration and
  specification, under the control of the cluster master. They may have a set
  of Kubernetes labels applied to them, which may be used to reference them
  during pod scheduling. They may also be resized up or down, to accommodate
  the workload.

  Enums:
    StatusValueValuesEnum: [Output only] The status of the nodes in this pool
      instance.

  Fields:
    autoscaling: Autoscaler configuration for this NodePool. Autoscaler is
      enabled only if a valid configuration is present.
    config: The node configuration of the pool.
    initialNodeCount: The initial node count for the pool. You must ensure
      that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota.
    instanceGroupUrls: [Output only] The resource URLs of [instance
      groups](/compute/docs/instance-groups/) associated with this node pool.
    management: NodeManagement configuration for this NodePool.
    name: The name of the node pool.
    selfLink: [Output only] Server-defined URL for the resource.
    status: [Output only] The status of the nodes in this pool instance.
    statusMessage: [Output only] Additional information about the current
      status of this node pool instance, if available.
    version: [Output only] The version of the Kubernetes of this node.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output only] The status of the nodes in this pool instance.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RUNNING_WITH_ERROR: The RUNNING_WITH_ERROR state indicates the node pool
        has been created and is partially usable. Some error state has
        occurred and some functionality may be impaired. Customer may need to
        reissue a request or trigger a new update.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the node pool, such as upgrading node software. Details
        can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool may be unusable. Details
        can be found in the `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RUNNING_WITH_ERROR = 3
    RECONCILING = 4
    STOPPING = 5
    ERROR = 6

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  config = _messages.MessageField('NodeConfig', 2)
  initialNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(4, repeated=True)
  management = _messages.MessageField('NodeManagement', 5)
  name = _messages.StringField(6)
  selfLink = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  statusMessage = _messages.StringField(9)
  version = _messages.StringField(10)


class NodePoolAutoscaling(_messages.Message):
  """NodePoolAutoscaling contains information required by cluster autoscaler
  to adjust the size of the node pool to the current cluster usage.

  Fields:
    enabled: Is autoscaling enabled for this node pool.
    maxNodeCount: Maximum number of nodes in the NodePool. Must be >=
      min_node_count. There has to enough quota to scale up the cluster.
    minNodeCount: Minimum number of nodes in the NodePool. Must be >= 1 and <=
      max_node_count.
  """

  enabled = _messages.BooleanField(1)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class NonResourceAttributes(_messages.Message):
  """The authorization attributes of a non-resource request. This should match
  the NonResourceAttributes struct in pkg/apis/authorization/v1beta1/types.go.

  Fields:
    path: The URL path of the request.
    verb: The verb of the request
  """

  path = _messages.StringField(1)
  verb = _messages.StringField(2)


class ObjectMeta(_messages.Message):
  """This maps to the "apimachinery/pkg/apis/meta/v1".ObjectMeta type,
  although not all fields are populated and represented here. TODO
  (b/30563544, b/34947157): Remove unused fields.  Currently, if a request
  includes metadata fields that aren't explicitly modeled here, the caller
  will receive a 400 response instead of ignoring the unrecognized fields. We
  should consider following b/28297888 to enable "ignore_unknown_fields" in
  order to make this less brittle.

  Fields:
    creationTimestamp: Timestamp representing the server time when this object
      was created.
    generateName: An optional prefix, used by the server, to generate a unique
      name ONLY IF the name field has not been provided.
    name: The name of the resource, unique within a namespace.
    resourceVersion: An opaque value that represents the internal version of
      this object that can be used by clients to determine when objects have
      changed.
    selfLink: A URL representing this object.
    uid: A unique identifier in time and space for this object.
  """

  creationTimestamp = _messages.StringField(1)
  generateName = _messages.StringField(2)
  name = _messages.StringField(3)
  resourceVersion = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  uid = _messages.StringField(6)


class Operation(_messages.Message):
  """This operation resource represents operations that may have happened or
  are happening on the cluster. All fields are output only.

  Enums:
    OperationTypeValueValuesEnum: The operation type.
    StatusValueValuesEnum: The current status of the operation.

  Fields:
    detail: Detailed operation progress, if available.
    name: The server-assigned ID for the operation.
    operationType: The operation type.
    selfLink: Server-defined URL for the resource.
    status: The current status of the operation.
    statusMessage: If an error has occurred, a textual description of the
      error.
    targetLink: Server-defined URL for the target of the operation.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation is taking
      place.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    """The operation type.

    Values:
      TYPE_UNSPECIFIED: Not set.
      CREATE_CLUSTER: Cluster create.
      DELETE_CLUSTER: Cluster delete.
      UPGRADE_MASTER: A master upgrade.
      UPGRADE_NODES: A node upgrade.
      REPAIR_CLUSTER: Cluster repair.
      UPDATE_CLUSTER: Cluster update.
      CREATE_NODE_POOL: Node pool create.
      DELETE_NODE_POOL: Node pool delete.
      SET_NODE_POOL_MANAGEMENT: Set node pool management.
      AUTO_REPAIR_NODES: Automatic node pool repair.
      AUTO_UPGRADE_NODES: Automatic node upgrade.
      SET_LABELS: Set labels.
      SET_MASTER_AUTH: Set/generate master auth materials
    """
    TYPE_UNSPECIFIED = 0
    CREATE_CLUSTER = 1
    DELETE_CLUSTER = 2
    UPGRADE_MASTER = 3
    UPGRADE_NODES = 4
    REPAIR_CLUSTER = 5
    UPDATE_CLUSTER = 6
    CREATE_NODE_POOL = 7
    DELETE_NODE_POOL = 8
    SET_NODE_POOL_MANAGEMENT = 9
    AUTO_REPAIR_NODES = 10
    AUTO_UPGRADE_NODES = 11
    SET_LABELS = 12
    SET_MASTER_AUTH = 13

  class StatusValueValuesEnum(_messages.Enum):
    """The current status of the operation.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
      ABORTING: The operation is aborting.
    """
    STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    ABORTING = 4

  detail = _messages.StringField(1)
  name = _messages.StringField(2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  selfLink = _messages.StringField(4)
  status = _messages.EnumField('StatusValueValuesEnum', 5)
  statusMessage = _messages.StringField(6)
  targetLink = _messages.StringField(7)
  zone = _messages.StringField(8)


class ResourceAttributes(_messages.Message):
  """The authorization attributes of the resource request. This should match
  the ResourceAttributes struct in pkg/apis/authorization/v1beta1/types.go.

  Fields:
    group: The API group of the resource.
    name: The name of the resource in the request.
    namespace: The namespace of the request.
    resource: The type of the resource in the request.
    subresource: The type of the subresource in the request.
    verb: The Kubernetes verb of the request (e.g. get, create, list, etc.)
    version: The API version of the resource.
  """

  group = _messages.StringField(1)
  name = _messages.StringField(2)
  namespace = _messages.StringField(3)
  resource = _messages.StringField(4)
  subresource = _messages.StringField(5)
  verb = _messages.StringField(6)
  version = _messages.StringField(7)


class ResourceLabels(_messages.Message):
  """The set of Google Compute Engine labels that will be applied to any
  underlying resources that the Google Container Cluster creates or uses.
  These are merely metadata on the resources, and do not change the behavior
  of the cluster.

  Fields:
    items: The list of labels.
  """

  items = _messages.MessageField('Item', 1, repeated=True)


class RollbackNodePoolUpgradeRequest(_messages.Message):
  """RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
  NodePool upgrade. This will be an no-op if the last upgrade successfully
  completed.
  """



class ServerConfig(_messages.Message):
  """Container Engine service configuration.

  Fields:
    buildClientInfo: apiserver build BuildData::ClientInfo()
    defaultClusterVersion: Version of Kubernetes the service deploys by
      default.
    defaultImageType: Default image type.
    validImageTypes: List of valid image types.
    validMasterVersions: List of valid master versions.
    validNodeVersions: List of valid node upgrade target versions.
  """

  buildClientInfo = _messages.StringField(1)
  defaultClusterVersion = _messages.StringField(2)
  defaultImageType = _messages.StringField(3)
  validImageTypes = _messages.StringField(4, repeated=True)
  validMasterVersions = _messages.StringField(5, repeated=True)
  validNodeVersions = _messages.StringField(6, repeated=True)


class SetLabelsRequest(_messages.Message):
  """SetLabelsRequest sets the Google Cloud Platform labels on a Google
  Container Engine cluster, which will in turn set them for Google Compute
  Engine resources used by that cluster

  Fields:
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Container Engine and changes after every request to modify
      or update labels. You must always provide an up-to-date fingerprint hash
      when updating or changing labels. Make a <code>get()</code> request to
      the resource to get the latest fingerprint.
    resourceLabels: The labels to set for that cluster.
  """

  labelFingerprint = _messages.StringField(1)
  resourceLabels = _messages.MessageField('ResourceLabels', 2)


class SetLegacyAbacRequest(_messages.Message):
  """SetLegacyAbacRequest enables or disables the ABAC authorization mechanism
  for a cluster.

  Fields:
    enabled: Whether ABAC authorization will be enabled in the cluster.
  """

  enabled = _messages.BooleanField(1)


class SetMasterAuthRequest(_messages.Message):
  """SetMasterAuthRequest updates the admin password of a cluster.

  Enums:
    ActionValueValuesEnum: The exact form of action to be taken on the master
      auth

  Fields:
    action: The exact form of action to be taken on the master auth
    update: A description of the update.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """The exact form of action to be taken on the master auth

    Values:
      UNKNOWN: Operation is unknown and will error out
      SET_PASSWORD: Set the password to a user generated value.
      GENERATE_PASSWORD: Generate a new password and set it to that.
    """
    UNKNOWN = 0
    SET_PASSWORD = 1
    GENERATE_PASSWORD = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  update = _messages.MessageField('MasterAuth', 2)


class SetNodePoolManagementRequest(_messages.Message):
  """SetNodePoolManagementRequest sets the node management properties of a
  node pool.

  Fields:
    management: NodeManagement configuration for the node pool.
  """

  management = _messages.MessageField('NodeManagement', 1)


class SignedUrls(_messages.Message):
  """Signed URLs that allow for writing a file to a private GCS bucket for
  storing backups of hosted master data.

  Fields:
    signedUrls: The signed URLs for writing the request files, in the same
      order as the filenames in the request.
  """

  signedUrls = _messages.StringField(1, repeated=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class SubjectAccessReviewSpec(_messages.Message):
  """The description of the request for authorization. This should match the
  SubjectAccessReviewSpec struct in pkg/apis/authorization/v1beta1/types.go

  Messages:
    ExtraValue: Any "extra" data from the user being authorized. Note:
      normally this field would be called "extras", but we have to match the
      struct in Kubernetes.

  Fields:
    extra: Any "extra" data from the user being authorized. Note: normally
      this field would be called "extras", but we have to match the struct in
      Kubernetes.
    group: Any groups this user may be a part of (this is not used for GKE
      IAM). Note: normally this field would be called "groups", but we have to
      match the struct in Kubernetes.
    nonResourceAttributes: The attributes of the request for a non-resource
      request. If this field is set, ResourceAttributes should not be set (and
      will be ignored).
    resourceAttributes: The attributes of the request for a resource request.
      If this field is set, NonResourceAttributes should not be set (and will
      be ignored).
    user: The user making the request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtraValue(_messages.Message):
    """Any "extra" data from the user being authorized. Note: normally this
    field would be called "extras", but we have to match the struct in
    Kubernetes.

    Messages:
      AdditionalProperty: An additional property for a ExtraValue object.

    Fields:
      additionalProperties: Additional properties of type ExtraValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ExtraValue object.

      Fields:
        key: Name of the additional property.
        value: A ExtraValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ExtraValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  extra = _messages.MessageField('ExtraValue', 1)
  group = _messages.StringField(2, repeated=True)
  nonResourceAttributes = _messages.MessageField('NonResourceAttributes', 3)
  resourceAttributes = _messages.MessageField('ResourceAttributes', 4)
  user = _messages.StringField(5)


class SubjectAccessReviewStatus(_messages.Message):
  """The result of the request for authorization. This should match the
  SubjectAccessReviewStatus struct in pkg/apis/authorization/v1beta1/types.go.

  Fields:
    allowed: Is the action authorized.
    reason: Error message if unauthorized.
  """

  allowed = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class Token(_messages.Message):
  """A compute-read-write (https://www.googleapis.com/auth/compute) scoped
  OAuth2 access token, to allow hosted masters to make modifications to a
  user's project.

  Fields:
    accessToken: The OAuth2 access token
    expireTime: The expiration time of the token.
  """

  accessToken = _messages.StringField(1)
  expireTime = _messages.StringField(2)


class TokenReviewSpec(_messages.Message):
  """The description of the request for review of an OAuth2 token for purposes
  of authentication. This should match the TokenReviewSpec struct in
  pkg/apis/authentication.k8s.io/v1beta1/types.go

  Fields:
    token: The token for the server to authenticate.
  """

  token = _messages.StringField(1)


class TokenReviewStatus(_messages.Message):
  """The result of the request for authentication. This should match the
  TokenReviewStatus struct in pkg/apis/authentication.k8s.io/v1beta1/types.go

  Fields:
    authenticated: Whether the server was able to authenticate the token.
    user: The authenticated user associated with the token.
  """

  authenticated = _messages.BooleanField(1)
  user = _messages.MessageField('UserInfo', 2)


class UpdateClusterRequest(_messages.Message):
  """UpdateClusterRequest updates the settings of a cluster.

  Fields:
    update: A description of the update.
  """

  update = _messages.MessageField('ClusterUpdate', 1)


class UserInfo(_messages.Message):
  """The attributes of an authenticated user. This should match the UserInfo
  struct in pkg/apis/authentication.k8s.io/v1beta1/types.go

  Fields:
    groups: Groups that this user is a part of. This is not currently filled
      in for GKE.
    uid: A unique identifier (across time) for the user. This is not currently
      filled in for GKE.
    username: The name of the user. This should be the email address
      associated with the GAIA identity of the user.
  """

  groups = _messages.StringField(1, repeated=True)
  uid = _messages.StringField(2)
  username = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'container')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'container')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'container')
