"""Generated message classes for cloudresourcemanager version v1.

The Google Cloud Resource Manager API provides methods for creating, reading,
and updating project metadata.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudresourcemanager'


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConifg must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted. Example Policy with
  multiple AuditConfigs: {   "audit_configs": [     {       "service":
  "allServices"       "audit_log_configs": [         {           "log_type":
  "DATA_READ",           "exempted_members": [
  "user:foo@gmail.com"           ]         },         {           "log_type":
  "DATA_WRITE",         },         {           "log_type": "ADMIN_READ",
  }       ]     },     {       "service": "fooservice@googleapis.com"
  "audit_log_configs": [         {           "log_type": "DATA_READ",
  },         {           "log_type": "DATA_WRITE",
  "exempted_members": [             "user:bar@gmail.com"           ]         }
  ]     }   ] } For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
      Next ID: 4
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    """The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class BooleanConstraint(_messages.Message):
  """A `Constraint` that is either enforced or not.  For example a constraint
  `constraints/compute.disableSerialPortAccess`. If it is enforced on a VM
  instance, serial port connections will not be opened to that instance.
  """



class BooleanPolicy(_messages.Message):
  """Used in `policy_type` to specify how `boolean_policy` will behave at this
  resource.

  Fields:
    enforced: If `true`, then the `Policy` is enforced. If `false`, then any
      configuration is acceptable.  Suppose you have a `Constraint`
      `constraints/compute.disableSerialPortAccess` with `constraint_default`
      set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
      behavior:   - If the `Policy` at this resource has enforced set to
      `false`, serial     port connection attempts will be allowed.   - If the
      `Policy` at this resource has enforced set to `true`, serial     port
      connection attempts will be refused.   - If the `Policy` at this
      resource is `RestoreDefault`, serial port     connection attempts will
      be allowed.   - If no `Policy` is set at this resource or anywhere
      higher in the     resource hierarchy, serial port connection attempts
      will be allowed.   - If no `Policy` is set at this resource, but one
      exists higher in the     resource hierarchy, the behavior is as if
      the`Policy` were set at     this resource.  The following examples
      demonstrate the different possible layerings:  Example 1 (nearest
      `Constraint` wins):   `organizations/foo` has a `Policy` with:
      {enforced: false}   `projects/bar` has no `Policy` set. The constraint
      at `projects/bar` and `organizations/foo` will not be enforced.  Example
      2 (enforcement gets replaced):   `organizations/foo` has a `Policy`
      with:     {enforced: false}   `projects/bar` has a `Policy` with:
      {enforced: true} The constraint at `organizations/foo` is not enforced.
      The constraint at `projects/bar` is enforced.  Example 3
      (RestoreDefault):   `organizations/foo` has a `Policy` with:
      {enforced: true}   `projects/bar` has a `Policy` with:
      {RestoreDefault: {}} The constraint at `organizations/foo` is enforced.
      The constraint at `projects/bar` is not enforced, because
      `constraint_default` for the `Constraint` is `ALLOW`.
  """

  enforced = _messages.BooleanField(1)


class ClearOrgPolicyRequest(_messages.Message):
  """The request sent to the ClearOrgPolicy method.

  Fields:
    constraint: Name of the `Constraint` of the `Policy` to clear.
    etag: The current version, for concurrency control. Not sending an `etag`
      will cause the `Policy` to be cleared blindly.
  """

  constraint = _messages.StringField(1)
  etag = _messages.BytesField(2)


class CloudresourcemanagerLiensDeleteRequest(_messages.Message):
  """A CloudresourcemanagerLiensDeleteRequest object.

  Fields:
    liensId: Part of `name`. The name/identifier of the Lien to delete.
  """

  liensId = _messages.StringField(1, required=True)


class CloudresourcemanagerLiensListRequest(_messages.Message):
  """A CloudresourcemanagerLiensListRequest object.

  Fields:
    pageSize: The maximum number of items to return. This is a suggestion for
      the server.
    pageToken: The `next_page_token` value returned from a previous List
      request, if any.
    parent: The name of the resource to list all attached Liens. For example,
      `projects/1234`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)


class CloudresourcemanagerOperationsGetRequest(_messages.Message):
  """A CloudresourcemanagerOperationsGetRequest object.

  Fields:
    operationsId: Part of `name`. The name of the operation resource.
  """

  operationsId = _messages.StringField(1, required=True)


class CloudresourcemanagerOrganizationsClearOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsClearOrgPolicyRequest object.

  Fields:
    clearOrgPolicyRequest: A ClearOrgPolicyRequest resource to be passed as
      the request body.
    organizationsId: Part of `resource`. Name of the resource for the `Policy`
      to clear.
  """

  clearOrgPolicyRequest = _messages.MessageField('ClearOrgPolicyRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest object.

  Fields:
    getEffectiveOrgPolicyRequest: A GetEffectiveOrgPolicyRequest resource to
      be passed as the request body.
    organizationsId: Part of `resource`. The name of the resource to start
      computing the effective `Policy`.
  """

  getEffectiveOrgPolicyRequest = _messages.MessageField('GetEffectiveOrgPolicyRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsGetIamPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy is being requested. See the operation documentation for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsGetOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsGetOrgPolicyRequest object.

  Fields:
    getOrgPolicyRequest: A GetOrgPolicyRequest resource to be passed as the
      request body.
    organizationsId: Part of `resource`. Name of the resource the `Policy` is
      set on.
  """

  getOrgPolicyRequest = _messages.MessageField('GetOrgPolicyRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsGetRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsGetRequest object.

  Fields:
    organizationsId: Part of `name`. The resource name of the Organization to
      fetch, e.g. "organizations/1234".
  """

  organizationsId = _messages.StringField(1, required=True)


class CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest(_messages.Message):
  """A
  CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest
  object.

  Fields:
    listAvailableOrgPolicyConstraintsRequest: A
      ListAvailableOrgPolicyConstraintsRequest resource to be passed as the
      request body.
    organizationsId: Part of `resource`. Name of the resource to list
      `Constraints` for.
  """

  listAvailableOrgPolicyConstraintsRequest = _messages.MessageField('ListAvailableOrgPolicyConstraintsRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsListOrgPoliciesRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsListOrgPoliciesRequest object.

  Fields:
    listOrgPoliciesRequest: A ListOrgPoliciesRequest resource to be passed as
      the request body.
    organizationsId: Part of `resource`. Name of the resource to list Policies
      for.
  """

  listOrgPoliciesRequest = _messages.MessageField('ListOrgPoliciesRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsSetIamPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsSetIamPolicyRequest object.

  Fields:
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy is being specified. See the operation documentation for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  organizationsId = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudresourcemanagerOrganizationsSetOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsSetOrgPolicyRequest object.

  Fields:
    organizationsId: Part of `resource`. Resource name of the resource to
      attach the `Policy`.
    setOrgPolicyRequest: A SetOrgPolicyRequest resource to be passed as the
      request body.
  """

  organizationsId = _messages.StringField(1, required=True)
  setOrgPolicyRequest = _messages.MessageField('SetOrgPolicyRequest', 2)


class CloudresourcemanagerOrganizationsTestIamPermissionsRequest(_messages.Message):
  """A CloudresourcemanagerOrganizationsTestIamPermissionsRequest object.

  Fields:
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy detail is being requested. See the operation documentation for
      the appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  organizationsId = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudresourcemanagerProjectsClearOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsClearOrgPolicyRequest object.

  Fields:
    clearOrgPolicyRequest: A ClearOrgPolicyRequest resource to be passed as
      the request body.
    projectsId: Part of `resource`. Name of the resource for the `Policy` to
      clear.
  """

  clearOrgPolicyRequest = _messages.MessageField('ClearOrgPolicyRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsDeleteRequest(_messages.Message):
  """A CloudresourcemanagerProjectsDeleteRequest object.

  Fields:
    projectId: The Project ID (for example, `foo-bar-123`).  Required.
  """

  projectId = _messages.StringField(1, required=True)


class CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest object.

  Fields:
    getEffectiveOrgPolicyRequest: A GetEffectiveOrgPolicyRequest resource to
      be passed as the request body.
    projectsId: Part of `resource`. The name of the resource to start
      computing the effective `Policy`.
  """

  getEffectiveOrgPolicyRequest = _messages.MessageField('GetEffectiveOrgPolicyRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsGetIamPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsGetOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsGetOrgPolicyRequest object.

  Fields:
    getOrgPolicyRequest: A GetOrgPolicyRequest resource to be passed as the
      request body.
    projectsId: Part of `resource`. Name of the resource the `Policy` is set
      on.
  """

  getOrgPolicyRequest = _messages.MessageField('GetOrgPolicyRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsGetRequest(_messages.Message):
  """A CloudresourcemanagerProjectsGetRequest object.

  Fields:
    projectId: The Project ID (for example, `my-project-123`).  Required.
  """

  projectId = _messages.StringField(1, required=True)


class CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest(_messages.Message):
  """A CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest
  object.

  Fields:
    listAvailableOrgPolicyConstraintsRequest: A
      ListAvailableOrgPolicyConstraintsRequest resource to be passed as the
      request body.
    projectsId: Part of `resource`. Name of the resource to list `Constraints`
      for.
  """

  listAvailableOrgPolicyConstraintsRequest = _messages.MessageField('ListAvailableOrgPolicyConstraintsRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsListOrgPoliciesRequest(_messages.Message):
  """A CloudresourcemanagerProjectsListOrgPoliciesRequest object.

  Fields:
    listOrgPoliciesRequest: A ListOrgPoliciesRequest resource to be passed as
      the request body.
    projectsId: Part of `resource`. Name of the resource to list Policies for.
  """

  listOrgPoliciesRequest = _messages.MessageField('ListOrgPoliciesRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsListRequest(_messages.Message):
  """A CloudresourcemanagerProjectsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request.  Filter
      rules are case insensitive. The fields eligible for filtering are:  +
      `name` + `id` + <code>labels.<em>key</em></code> where *key* is the name
      of a label  Some examples of using labels as filters:
      |Filter|Description| |------|-----------| |name:*|The project has a
      name.| |name:Howl|The project's name is `Howl` or `howl`.|
      |name:HOWL|Equivalent to above.| |NAME:howl|Equivalent to above.|
      |labels.color:*|The project has the label `color`.|
      |labels.color:red|The project's label `color` has the value `red`.|
      |labels.color:red&nbsp;labels.size:big|The project's label `color` has
      the value `red` and its label `size` has the value `big`.  Optional.
    pageSize: The maximum number of Projects to return in the response. The
      server can return fewer Projects than requested. If unspecified, server
      picks an appropriate default.  Optional.
    pageToken: A pagination token returned from a previous call to
      ListProjects that indicates from where listing should continue.
      Optional.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class CloudresourcemanagerProjectsSetIamPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudresourcemanagerProjectsSetOrgPolicyRequest(_messages.Message):
  """A CloudresourcemanagerProjectsSetOrgPolicyRequest object.

  Fields:
    projectsId: Part of `resource`. Resource name of the resource to attach
      the `Policy`.
    setOrgPolicyRequest: A SetOrgPolicyRequest resource to be passed as the
      request body.
  """

  projectsId = _messages.StringField(1, required=True)
  setOrgPolicyRequest = _messages.MessageField('SetOrgPolicyRequest', 2)


class CloudresourcemanagerProjectsTestIamPermissionsRequest(_messages.Message):
  """A CloudresourcemanagerProjectsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudresourcemanagerProjectsUndeleteRequest(_messages.Message):
  """A CloudresourcemanagerProjectsUndeleteRequest object.

  Fields:
    projectId: The project ID (for example, `foo-bar-123`).  Required.
    undeleteProjectRequest: A UndeleteProjectRequest resource to be passed as
      the request body.
  """

  projectId = _messages.StringField(1, required=True)
  undeleteProjectRequest = _messages.MessageField('UndeleteProjectRequest', 2)


class Constraint(_messages.Message):
  """A `Constraint` describes a way in which a resource's configuration can be
  restricted. For example, it controls which cloud services can be activated
  across an organization, or whether a Compute Engine instance can have serial
  port connections established. `Constraints` can be configured by the
  organization's policy adminstrator to fit the needs of the organzation by
  setting Policies for `Constraints` at different locations in the
  organization's resource hierarchy. Policies are inherited down the resource
  hierarchy from higher levels, but can also be overridden. For details about
  the inheritance rules please read about Policies.  `Constraints` have a
  default behavior determined by the `constraint_default` field, which is the
  enforcement behavior that is used in the absence of a `Policy` being defined
  or inherited for the resource in question.

  Enums:
    ConstraintDefaultValueValuesEnum: The evaluation behavior of this
      constraint in the absense of 'Policy'.

  Fields:
    booleanConstraint: Defines this constraint as being a BooleanConstraint.
    constraintDefault: The evaluation behavior of this constraint in the
      absense of 'Policy'.
    description: Detailed description of what this `Constraint` controls as
      well as how and where it is enforced.  Mutable.
    displayName: The human readable name.  Mutable.
    listConstraint: Defines this constraint as being a ListConstraint.
    name: Immutable value, required to globally be unique. For example,
      `constraints/serviceuser.services`
    version: Version of the `Constraint`. Default version is 0;
  """

  class ConstraintDefaultValueValuesEnum(_messages.Enum):
    """The evaluation behavior of this constraint in the absense of 'Policy'.

    Values:
      CONSTRAINT_DEFAULT_UNSPECIFIED: This is only used for distinguishing
        unset values and should never be used.
      ALLOW: Indicate that all values are allowed for list constraints.
        Indicate that enforcement is off for boolean constraints.
      DENY: Indicate that all values are denied for list constraints. Indicate
        that enforcement is on for boolean constraints.
    """
    CONSTRAINT_DEFAULT_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  booleanConstraint = _messages.MessageField('BooleanConstraint', 1)
  constraintDefault = _messages.EnumField('ConstraintDefaultValueValuesEnum', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  listConstraint = _messages.MessageField('ListConstraint', 5)
  name = _messages.StringField(6)
  version = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GetEffectiveOrgPolicyRequest(_messages.Message):
  """The request sent to the GetEffectiveOrgPolicy method.

  Fields:
    constraint: The name of the `Constraint` to compute the effective
      `Policy`.
  """

  constraint = _messages.StringField(1)


class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class GetOrgPolicyRequest(_messages.Message):
  """The request sent to the GetOrgPolicy method.

  Fields:
    constraint: Name of the `Constraint` to get the `Policy`.
  """

  constraint = _messages.StringField(1)


class Lien(_messages.Message):
  """A Lien represents an encumbrance on the actions that can be performed on
  a resource.

  Fields:
    createTime: The creation time of this Lien.
    name: A system-generated unique identifier for this Lien.  Example:
      `liens/1234abcd`
    origin: A stable, user-visible/meaningful string identifying the origin of
      the Lien, intended to be inspected programmatically. Maximum length of
      200 characters.  Example: 'compute.googleapis.com'
    parent: A reference to the resource this Lien is attached to. The server
      will validate the parent against those for which Liens are supported.
      Example: `projects/1234`
    reason: Concise user-visible strings indicating why an action cannot be
      performed on a resource. Maximum lenth of 200 characters.  Example:
      'Holds production API key'
    restrictions: The types of operations which should be blocked as a result
      of this Lien. Each value should correspond to an IAM permission. The
      server will validate the permissions against those for which Liens are
      supported.  An empty list is meaningless and will be rejected.  Example:
      ['resourcemanager.projects.delete']
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  origin = _messages.StringField(3)
  parent = _messages.StringField(4)
  reason = _messages.StringField(5)
  restrictions = _messages.StringField(6, repeated=True)


class ListAvailableOrgPolicyConstraintsRequest(_messages.Message):
  """The request sent to the [ListAvailableOrgPolicyConstraints]
  google.cloud.OrgPolicy.v1.ListAvailableOrgPolicyConstraints] method.

  Fields:
    pageSize: Size of the pages to be returned. This is currently unsupported
      and will be ignored. The server may at any point start using this field
      to limit page size.
    pageToken: Page token used to retrieve the next page. This is currently
      unsupported and will be ignored. The server may at any point start using
      this field.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class ListAvailableOrgPolicyConstraintsResponse(_messages.Message):
  """The response returned from the ListAvailableOrgPolicyConstraints method.
  Returns all `Constraints` that could be set at this level of the hierarchy
  (contrast with the response from `ListPolicies`, which returns all policies
  which are set).

  Fields:
    constraints: The collection of constraints that are settable on the
      request resource.
    nextPageToken: Page token used to retrieve the next page. This is
      currently not used.
  """

  constraints = _messages.MessageField('Constraint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListConstraint(_messages.Message):
  """A `Constraint` that allows or disallows a list of string values, which
  are configured by an Organization's policy administrator with a `Policy`.

  Fields:
    suggestedValue: Optional. The Google Cloud Console will try to default to
      a configuration that matches the value specified in this `Constraint`.
  """

  suggestedValue = _messages.StringField(1)


class ListLiensResponse(_messages.Message):
  """The response message for Liens.ListLiens.

  Fields:
    liens: A list of Liens.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  liens = _messages.MessageField('Lien', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOrgPoliciesRequest(_messages.Message):
  """The request sent to the ListOrgPolicies method.

  Fields:
    pageSize: Size of the pages to be returned. This is currently unsupported
      and will be ignored. The server may at any point start using this field
      to limit page size.
    pageToken: Page token used to retrieve the next page. This is currently
      unsupported and will be ignored. The server may at any point start using
      this field.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class ListOrgPoliciesResponse(_messages.Message):
  """The response returned from the ListOrgPolicies method. It will be empty
  if no `Policies` are set on the resource.

  Fields:
    nextPageToken: Page token used to retrieve the next page. This is
      currently not used, but the server may at any point start supplying a
      valid token.
    policies: The `Policies` that are set on the resource. It will be empty if
      no `Policies` are set.
  """

  nextPageToken = _messages.StringField(1)
  policies = _messages.MessageField('OrgPolicy', 2, repeated=True)


class ListPolicy(_messages.Message):
  """Used in `policy_type` to specify how `list_policy` behaves at this
  resource.  A `ListPolicy` can define specific values that are allowed or
  denied by setting either the `allowed_values` or `denied_values` fields. It
  can also be used to allow or deny all values, by setting the `all_values`
  field. If `all_values` is `ALL_VALUES_UNSPECIFIED`, exactly one of
  `allowed_values` or `denied_values` must be set (attempting to set both or
  neither will result in a failed request). If `all_values` is set to either
  `ALLOW` or `DENY`, `allowed_values` and `denied_values` must be unset.

  Enums:
    AllValuesValueValuesEnum: The policy all_values state.

  Fields:
    allValues: The policy all_values state.
    allowedValues: List of values allowed  at this resource. an only be set if
      no values are set for `denied_values` and `all_values` is set to
      `ALL_VALUES_UNSPECIFIED`.
    deniedValues: List of values denied at this resource. Can only be set if
      no values are set for `allowed_values` and `all_values` is set to
      `ALL_VALUES_UNSPECIFIED`.
    inheritFromParent: Determines the inheritance behavior for this `Policy`.
      By default, a `ListPolicy` set at a resource supercedes any `Policy` set
      anywhere up the resource hierarchy. However, if `inherit_from_parent` is
      set to `true`, then the values from the effective `Policy` of the parent
      resource are inherited, meaning the values set in this `Policy` are
      added to the values inherited up the hierarchy.  Setting `Policy`
      hierarchies that inherit both allowed values and denied values isn't
      recommended in most circumstances to keep the configuration simple and
      understandable. However, it is possible to set a `Policy` with
      `allowed_values` set that inherits a `Policy` with `denied_values` set.
      In this case, the values that are allowed must be in `allowed_values`
      and not present in `denied_values`.  For example, suppose you have a
      `Constraint` `constraints/serviceuser.services`, which has a
      `constraint_type` of `list_constraint`, and with `constraint_default`
      set to `ALLOW`. Suppose that at the Organization level, a `Policy` is
      applied that restricts the allowed API activations to {`E1`, `E2`}.
      Then, if a `Policy` is applied to a project below the Organization that
      has `inherit_from_parent` set to `false` and field all_values set to
      DENY, then an attempt to activate any API will be denied.  The following
      examples demonstrate different possible layerings:  Example 1 (no
      inherited values):   `organizations/foo` has a `Policy` with values:
      {allowed_values: \u201cE1\u201d allowed_values:\u201dE2\u201d}   ``projects/bar`` has
      `inherit_from_parent` `false` and values:     {allowed_values: "E3"
      allowed_values: "E4"} The accepted values at `organizations/foo` are
      `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`.
      Example 2 (inherited values):   `organizations/foo` has a `Policy` with
      values:     {allowed_values: \u201cE1\u201d allowed_values:\u201dE2\u201d}   `projects/bar`
      has a `Policy` with values:     {value: \u201cE3\u201d value: \u201dE4\u201d
      inherit_from_parent: true} The accepted values at `organizations/foo`
      are `E1`, `E2`. The accepted values at `projects/bar` are `E1`, `E2`,
      `E3`, and `E4`.  Example 3 (inheriting both allowed and denied values):
      `organizations/foo` has a `Policy` with values:     {allowed_values:
      "E1" allowed_values: "E2"}   `projects/bar` has a `Policy` with:
      {denied_values: "E1"} The accepted values at `organizations/foo` are
      `E1`, `E2`. The value accepted at `projects/bar` is `E2`.  Example 4
      (RestoreDefault):   `organizations/foo` has a `Policy` with values:
      {allowed_values: \u201cE1\u201d allowed_values:\u201dE2\u201d}   `projects/bar` has a
      `Policy` with values:     {RestoreDefault: {}} The accepted values at
      `organizations/foo` are `E1`, `E2`. The accepted values at
      `projects/bar` are either all or none depending on the value of
      `constraint_default` (if `ALLOW`, all; if `DENY`, none).  Example 5 (no
      policy inherits parent policy):   `organizations/foo` has no `Policy`
      set.   `projects/bar` has no `Policy` set. The accepted values at both
      levels are either all or none depending on the value of
      `constraint_default` (if `ALLOW`, all; if `DENY`, none).  Example 6
      (ListConstraint allowing all):   `organizations/foo` has a `Policy` with
      values:     {allowed_values: \u201cE1\u201d allowed_values: \u201dE2\u201d}   `projects/bar`
      has a `Policy` with:     {all: ALLOW} The accepted values at
      `organizations/foo` are `E1`, E2`. Any value is accepted at
      `projects/bar`.  Example 7 (ListConstraint allowing none):
      `organizations/foo` has a `Policy` with values:     {allowed_values:
      \u201cE1\u201d allowed_values: \u201dE2\u201d}   `projects/bar` has a `Policy` with:
      {all: DENY} The accepted values at `organizations/foo` are `E1`, E2`. No
      value is accepted at `projects/bar`.
    suggestedValue: Optional. The Google Cloud Console will try to default to
      a configuration that matches the value specified in this `Policy`. If
      `suggested_value` is not set, it will inherit the value specified higher
      in the hierarchy, unless `inherit_from_parent` is `false`.
  """

  class AllValuesValueValuesEnum(_messages.Enum):
    """The policy all_values state.

    Values:
      ALL_VALUES_UNSPECIFIED: Indicates that either allowed_values or
        denied_values must be set.
      ALLOW: A policy with this set allows all values.
      DENY: A policy with this set denies all values.
    """
    ALL_VALUES_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  allValues = _messages.EnumField('AllValuesValueValuesEnum', 1)
  allowedValues = _messages.StringField(2, repeated=True)
  deniedValues = _messages.StringField(3, repeated=True)
  inheritFromParent = _messages.BooleanField(4)
  suggestedValue = _messages.StringField(5)


class ListProjectsResponse(_messages.Message):
  """A page of the response received from the ListProjects method.  A
  paginated response where more pages are available has `next_page_token` set.
  This token can be used in a subsequent request to retrieve the next request
  page.

  Fields:
    nextPageToken: Pagination token.  If the result set is too large to fit in
      a single response, this token is returned. It encodes the position of
      the current result cursor. Feeding this value into a new list request
      with the `page_token` parameter gives the next page of the results.
      When `next_page_token` is not filled in, there is no next page and the
      list returned is the last page in the result set.  Pagination tokens
      have a limited lifetime.
    projects: The list of Projects that matched the list filter. This list can
      be paginated.
  """

  nextPageToken = _messages.StringField(1)
  projects = _messages.MessageField('Project', 2, repeated=True)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OrgPolicy(_messages.Message):
  """Defines a Cloud Organization `Policy` which is used to specify
  `Constraints` for configurations of Cloud Platform resources.

  Fields:
    booleanPolicy: For boolean `Constraints`, whether to enforce the
      `Constraint` or not.
    constraint: The name of the `Constraint` the `Policy` is configuring, for
      example, `constraints/serviceuser.services`.  Immutable after creation.
    etag: An opaque tag indicating the current version of the `Policy`, used
      for concurrency control.  When the `Policy` is returned from either a
      `GetPolicy` or a `ListOrgPolicy` request, this `etag` indicates the
      version of the current `Policy` to use when executing a read-modify-
      write loop.  When the `Policy` is returned from a `GetEffectivePolicy`
      request, the `etag` will be unset.  When the `Policy` is used in a
      `SetOrgPolicy` method, use the `etag` value that was returned from a
      `GetOrgPolicy` request as part of a read-modify-write loop for
      concurrency control. Not setting the `etag`in a `SetOrgPolicy` request
      will result in an unconditional write of the `Policy`.
    listPolicy: List of values either allowed or disallowed.
    restoreDefault: Restores the default behavior of the constraint;
      independent of `Constraint` type.
    updateTime: The time stamp the `Policy` was previously updated. This is
      set by the server, not specified by the caller, and represents the last
      time a call to `SetOrgPolicy` was made for that `Policy`. Any value set
      by the client will be ignored.
    version: Version of the `Policy`. Default version is 0;
  """

  booleanPolicy = _messages.MessageField('BooleanPolicy', 1)
  constraint = _messages.StringField(2)
  etag = _messages.BytesField(3)
  listPolicy = _messages.MessageField('ListPolicy', 4)
  restoreDefault = _messages.MessageField('RestoreDefault', 5)
  updateTime = _messages.StringField(6)
  version = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class Organization(_messages.Message):
  """The root node in the resource hierarchy to which a particular entity's
  (e.g., company) resources belong.

  Enums:
    LifecycleStateValueValuesEnum: The organization's current lifecycle state.
      Assigned by the server. @OutputOnly

  Fields:
    creationTime: Timestamp when the Organization was created. Assigned by the
      server. @OutputOnly
    displayName: A friendly string to be used to refer to the Organization in
      the UI. Assigned by the server, set to the primary domain of the G Suite
      customer that owns the organization. @OutputOnly
    lifecycleState: The organization's current lifecycle state. Assigned by
      the server. @OutputOnly
    name: Output Only. The resource name of the organization. This is the
      organization's relative path in the API. Its format is
      "organizations/[organization_id]". For example, "organizations/1234".
    owner: The owner of this Organization. The owner should be specified on
      creation. Once set, it cannot be changed. This field is required.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    """The organization's current lifecycle state. Assigned by the server.
    @OutputOnly

    Values:
      LIFECYCLE_STATE_UNSPECIFIED: Unspecified state.  This is only useful for
        distinguishing unset values.
      ACTIVE: The normal and active state.
      DELETE_REQUESTED: The organization has been marked for deletion by the
        user.
    """
    LIFECYCLE_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETE_REQUESTED = 2

  creationTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 3)
  name = _messages.StringField(4)
  owner = _messages.MessageField('OrganizationOwner', 5)


class OrganizationOwner(_messages.Message):
  """The entity that owns an Organization. The lifetime of the Organization
  and all of its descendants are bound to the `OrganizationOwner`. If the
  `OrganizationOwner` is deleted, the Organization and all its descendants
  will be deleted.

  Fields:
    directoryCustomerId: The Google for Work customer id used in the Directory
      API.
  """

  directoryCustomerId = _messages.StringField(1)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com",           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Project(_messages.Message):
  """A Project is a high-level Google Cloud Platform entity.  It is a
  container for ACLs, APIs, App Engine Apps, VMs, and other Google Cloud
  Platform resources.

  Enums:
    LifecycleStateValueValuesEnum: The Project lifecycle state.  Read-only.

  Messages:
    LabelsValue: The labels associated with this Project.  Label keys must be
      between 1 and 63 characters long and must conform to the following
      regular expression: \[a-z\](\[-a-z0-9\]*\[a-z0-9\])?.  Label values must
      be between 0 and 63 characters long and must conform to the regular
      expression (\[a-z\](\[-a-z0-9\]*\[a-z0-9\])?)?.  No more than 256 labels
      can be associated with a given resource.  Clients should store labels in
      a representation such as JSON that does not depend on specific
      characters being disallowed.  Example: <code>"environment" :
      "dev"</code> Read-write.

  Fields:
    createTime: Creation time.  Read-only.
    labels: The labels associated with this Project.  Label keys must be
      between 1 and 63 characters long and must conform to the following
      regular expression: \[a-z\](\[-a-z0-9\]*\[a-z0-9\])?.  Label values must
      be between 0 and 63 characters long and must conform to the regular
      expression (\[a-z\](\[-a-z0-9\]*\[a-z0-9\])?)?.  No more than 256 labels
      can be associated with a given resource.  Clients should store labels in
      a representation such as JSON that does not depend on specific
      characters being disallowed.  Example: <code>"environment" :
      "dev"</code> Read-write.
    lifecycleState: The Project lifecycle state.  Read-only.
    name: The user-assigned display name of the Project. It must be 4 to 30
      characters. Allowed characters are: lowercase and uppercase letters,
      numbers, hyphen, single-quote, double-quote, space, and exclamation
      point.  Example: <code>My Project</code> Read-write.
    parent: An optional reference to a parent Resource.  The only supported
      parent type is "organization". Once set, the parent cannot be modified.
      The `parent` can be set on creation or using the `UpdateProject` method;
      the end user must have the `resourcemanager.projects.create` permission
      on the parent.  Read-write.
    projectId: The unique, user-assigned ID of the Project. It must be 6 to 30
      lowercase letters, digits, or hyphens. It must start with a letter.
      Trailing hyphens are prohibited.  Example: <code>tokyo-rain-123</code>
      Read-only after creation.
    projectNumber: The number uniquely identifying the project.  Example:
      <code>415104041262</code> Read-only.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    """The Project lifecycle state.  Read-only.

    Values:
      LIFECYCLE_STATE_UNSPECIFIED: Unspecified state.  This is only
        used/useful for distinguishing unset values.
      ACTIVE: The normal and active state.
      DELETE_REQUESTED: The project has been marked for deletion by the user
        (by invoking DeleteProject) or by the system (Google Cloud Platform).
        This can generally be reversed by invoking UndeleteProject.
      DELETE_IN_PROGRESS: This lifecycle state is no longer used and not
        returned by the API.
    """
    LIFECYCLE_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETE_REQUESTED = 2
    DELETE_IN_PROGRESS = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """The labels associated with this Project.  Label keys must be between 1
    and 63 characters long and must conform to the following regular
    expression: \[a-z\](\[-a-z0-9\]*\[a-z0-9\])?.  Label values must be
    between 0 and 63 characters long and must conform to the regular
    expression (\[a-z\](\[-a-z0-9\]*\[a-z0-9\])?)?.  No more than 256 labels
    can be associated with a given resource.  Clients should store labels in a
    representation such as JSON that does not depend on specific characters
    being disallowed.  Example: <code>"environment" : "dev"</code> Read-write.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 3)
  name = _messages.StringField(4)
  parent = _messages.MessageField('ResourceId', 5)
  projectId = _messages.StringField(6)
  projectNumber = _messages.IntegerField(7)


class ProjectCreationStatus(_messages.Message):
  """A status object which is used as the `metadata` field for the Operation
  returned by CreateProject. It provides insight for when significant phases
  of Project creation have completed.

  Fields:
    createTime: Creation time of the project creation workflow.
    gettable: True if the project can be retrieved using GetProject. No other
      operations on the project are guaranteed to work until the project
      creation is complete.
    ready: True if the project creation process is complete.
  """

  createTime = _messages.StringField(1)
  gettable = _messages.BooleanField(2)
  ready = _messages.BooleanField(3)


class ResourceId(_messages.Message):
  """A container to reference an id for any resource type. A `resource` in
  Google Cloud Platform is a generic term for something you (a developer) may
  want to interact with through one of our API's. Some examples are an App
  Engine app, a Compute Engine instance, a Cloud SQL database, and so on.

  Fields:
    id: Required field for the type-specific id. This should correspond to the
      id used in the type-specific API's.
    type: Required field representing the resource type this id is for. At
      present, the valid types are: "organization"
  """

  id = _messages.StringField(1)
  type = _messages.StringField(2)


class RestoreDefault(_messages.Message):
  """Ignores policies set above this resource and restores the
  `constraint_default` enforcement behavior of the specific `Constraint` at
  this resource.  Suppose that `constraint_default` is set to `ALLOW` for the
  `Constraint` `constraints/serviceuser.services`. Suppose that organization
  foo.com sets a `Policy` at their Organization resource node that restricts
  the allowed service activations to deny all service activations. They could
  then set a `Policy` with the `policy_type` `restore_default` on several
  experimental projects, restoring the `constraint_default` enforcement of the
  `Constraint` for only those projects, allowing those projects to have all
  services activated.
  """



class SearchOrganizationsRequest(_messages.Message):
  """The request sent to the `SearchOrganizations` method.

  Fields:
    filter: An optional query string used to filter the Organizations to
      return in the response. Filter rules are case-insensitive.
      Organizations may be filtered by `owner.directoryCustomerId` or by
      `domain`, where the domain is a Google for Work domain, for example:
      |Filter|Description| |------|-----------|
      |owner.directorycustomerid:123456789|Organizations with
      `owner.directory_customer_id` equal to `123456789`.|
      |domain:google.com|Organizations corresponding to the domain
      `google.com`.|  This field is optional.
    pageSize: The maximum number of Organizations to return in the response.
      This field is optional.
    pageToken: A pagination token returned from a previous call to
      `SearchOrganizations` that indicates from where listing should continue.
      This field is optional.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class SearchOrganizationsResponse(_messages.Message):
  """The response returned from the `SearchOrganizations` method.

  Fields:
    nextPageToken: A pagination token to be used to retrieve the next page of
      results. If the result is too large to fit within the page size
      specified in the request, this field will be set with a token that can
      be used to fetch the next page of results. If this field is empty, it
      indicates that this response contains the last page of results.
    organizations: The list of Organizations that matched the search query,
      possibly paginated.
  """

  nextPageToken = _messages.StringField(1)
  organizations = _messages.MessageField('Organization', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SetOrgPolicyRequest(_messages.Message):
  """The request sent to the SetOrgPolicyRequest method.

  Fields:
    policy: `Policy` to set on the resource.
  """

  policy = _messages.MessageField('OrgPolicy', 1)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  """Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  """Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeleteProjectRequest(_messages.Message):
  """The request sent to the UndeleteProject
method."""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'cloudresourcemanager')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'cloudresourcemanager')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'cloudresourcemanager')
