"""Generated message classes for appengine version v1.

Provisions and manages App Engine applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'appengine'


class ApiConfigHandler(_messages.Message):
  """Google Cloud Endpoints
  (https://cloud.google.com/appengine/docs/python/endpoints/) configuration
  for API handlers.

  Enums:
    AuthFailActionValueValuesEnum: Action to take when users access resources
      that require authentication. Defaults to redirect.
    LoginValueValuesEnum: Level of login required to access this resource.
      Defaults to optional.
    SecurityLevelValueValuesEnum: Security (HTTPS) enforcement for this URL.

  Fields:
    authFailAction: Action to take when users access resources that require
      authentication. Defaults to redirect.
    login: Level of login required to access this resource. Defaults to
      optional.
    script: Path to the script from the application root directory.
    securityLevel: Security (HTTPS) enforcement for this URL.
    url: URL to serve the endpoint at.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    """Action to take when users access resources that require authentication.
    Defaults to redirect.

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed.
      AUTH_FAIL_ACTION_REDIRECT: Redirects user to "accounts.google.com". The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: Rejects request with a 401 HTTP status
        code and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    """Level of login required to access this resource. Defaults to optional.

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the auth_fail_action is
        taken. In addition, if the user is not an administrator for the
        application, they are given an error message regardless of
        auth_fail_action. If the user is an administrator, the handler
        proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class SecurityLevelValueValuesEnum(_messages.Enum):
    """Security (HTTPS) enforcement for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 1)
  login = _messages.EnumField('LoginValueValuesEnum', 2)
  script = _messages.StringField(3)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 4)
  url = _messages.StringField(5)


class ApiEndpointHandler(_messages.Message):
  """Uses Google Cloud Endpoints to handle requests.

  Fields:
    scriptPath: Path to the script from the application root directory.
  """

  scriptPath = _messages.StringField(1)


class AppengineAppsGetRequest(_messages.Message):
  """A AppengineAppsGetRequest object.

  Fields:
    name: Name of the Application resource to get. Example: apps/myapp.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsLocationsGetRequest(_messages.Message):
  """A AppengineAppsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsLocationsListRequest(_messages.Message):
  """A AppengineAppsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AppengineAppsOperationsGetRequest(_messages.Message):
  """A AppengineAppsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsOperationsListRequest(_messages.Message):
  """A AppengineAppsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AppengineAppsPatchRequest(_messages.Message):
  """A AppengineAppsPatchRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    name: Name of the Application resource to update. Example: apps/myapp.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  application = _messages.MessageField('Application', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AppengineAppsRepairRequest(_messages.Message):
  """A AppengineAppsRepairRequest object.

  Fields:
    name: Name of the application to repair. Example: apps/myapp
    repairApplicationRequest: A RepairApplicationRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  repairApplicationRequest = _messages.MessageField('RepairApplicationRequest', 2)


class AppengineAppsServicesDeleteRequest(_messages.Message):
  """A AppengineAppsServicesDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesGetRequest(_messages.Message):
  """A AppengineAppsServicesGetRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesListRequest(_messages.Message):
  """A AppengineAppsServicesListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsServicesPatchRequest(_messages.Message):
  """A AppengineAppsServicesPatchRequest object.

  Fields:
    migrateTraffic: Set to true to gradually shift traffic to one or more
      versions that you specify. By default, traffic is shifted immediately.
      For gradual traffic migration, the target versions must be located
      within instances that are configured for both warmup requests
      (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services.versions#inboundservicetype) and
      automatic scaling (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services.versions#automaticscaling). You must
      specify the shardBy (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services#shardby) field in the Service
      resource. Gradual traffic migration is not supported in the App Engine
      flexible environment. For examples, see Migrating and Splitting Traffic
      (https://cloud.google.com/appengine/docs/admin-api/migrating-splitting-
      traffic).
    name: Name of the resource to update. Example:
      apps/myapp/services/default.
    service: A Service resource to be passed as the request body.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  migrateTraffic = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  service = _messages.MessageField('Service', 3)
  updateMask = _messages.StringField(4)


class AppengineAppsServicesVersionsCreateRequest(_messages.Message):
  """A AppengineAppsServicesVersionsCreateRequest object.

  Fields:
    parent: Name of the parent resource to create this version under. Example:
      apps/myapp/services/default.
    version: A Version resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  version = _messages.MessageField('Version', 2)


class AppengineAppsServicesVersionsDeleteRequest(_messages.Message):
  """A AppengineAppsServicesVersionsDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsGetRequest(_messages.Message):
  """A AppengineAppsServicesVersionsGetRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the Get
      response.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1.
    view: Controls the set of fields returned in the Get response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Controls the set of fields returned in the Get response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class AppengineAppsServicesVersionsInstancesDebugRequest(_messages.Message):
  """A AppengineAppsServicesVersionsInstancesDebugRequest object.

  Fields:
    debugInstanceRequest: A DebugInstanceRequest resource to be passed as the
      request body.
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  debugInstanceRequest = _messages.MessageField('DebugInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class AppengineAppsServicesVersionsInstancesDeleteRequest(_messages.Message):
  """A AppengineAppsServicesVersionsInstancesDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsInstancesGetRequest(_messages.Message):
  """A AppengineAppsServicesVersionsInstancesGetRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsInstancesListRequest(_messages.Message):
  """A AppengineAppsServicesVersionsInstancesListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Version resource. Example:
      apps/myapp/services/default/versions/v1.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsServicesVersionsListRequest(_messages.Message):
  """A AppengineAppsServicesVersionsListRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the List
      response.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Service resource. Example:
      apps/myapp/services/default.
    view: Controls the set of fields returned in the List response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Controls the set of fields returned in the List response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class AppengineAppsServicesVersionsPatchRequest(_messages.Message):
  """A AppengineAppsServicesVersionsPatchRequest object.

  Fields:
    name: Name of the resource to update. Example:
      apps/myapp/services/default/versions/1.
    updateMask: Standard field mask for the set of fields to be updated.
    version: A Version resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class Application(_messages.Message):
  """An Application resource contains the top-level configuration of an App
  Engine application.

  Enums:
    ServingStatusValueValuesEnum: Serving status of this application.

  Fields:
    authDomain: Google Apps authentication domain that controls which users
      can access this application.Defaults to open access for any Google
      Account.
    codeBucket: Google Cloud Storage bucket that can be used for storing files
      associated with this application. This bucket is associated with the
      application and can be used by the gcloud deployment
      commands.@OutputOnly
    defaultBucket: Google Cloud Storage bucket that can be used by this
      application to store content.@OutputOnly
    defaultCookieExpiration: Cookie expiration policy for this application.
    defaultHostname: Hostname used to reach this application, as resolved by
      App Engine.@OutputOnly
    dispatchRules: HTTP path dispatch rules for requests to the application
      that do not explicitly target a service or version. Rules are order-
      dependent. Up to 20 dispatch rules can be supported.@OutputOnly
    gcrDomain: The Google Container Registry domain used for storing managed
      build docker images for this application.
    iap: A IdentityAwareProxy attribute.
    id: Identifier of the Application resource. This identifier is equivalent
      to the project ID of the Google Cloud Platform project where you want to
      deploy your application. Example: myapp.
    locationId: Location from which this application will be run. Application
      instances will run out of data centers in the chosen location, which is
      also where all of the application's end user content is stored.Defaults
      to us-central.Options are:us-central - Central USeurope-west - Western
      Europeus-east1 - Eastern US
    name: Full path to the Application resource in the API. Example:
      apps/myapp.@OutputOnly
    servingStatus: Serving status of this application.
  """

  class ServingStatusValueValuesEnum(_messages.Enum):
    """Serving status of this application.

    Values:
      UNSPECIFIED: Serving status is unspecified.
      SERVING: Application is serving.
      USER_DISABLED: Application has been disabled by the user.
      SYSTEM_DISABLED: Application has been disabled by the system.
    """
    UNSPECIFIED = 0
    SERVING = 1
    USER_DISABLED = 2
    SYSTEM_DISABLED = 3

  authDomain = _messages.StringField(1)
  codeBucket = _messages.StringField(2)
  defaultBucket = _messages.StringField(3)
  defaultCookieExpiration = _messages.StringField(4)
  defaultHostname = _messages.StringField(5)
  dispatchRules = _messages.MessageField('UrlDispatchRule', 6, repeated=True)
  gcrDomain = _messages.StringField(7)
  iap = _messages.MessageField('IdentityAwareProxy', 8)
  id = _messages.StringField(9)
  locationId = _messages.StringField(10)
  name = _messages.StringField(11)
  servingStatus = _messages.EnumField('ServingStatusValueValuesEnum', 12)


class AutomaticScaling(_messages.Message):
  """Automatic scaling is based on request rate, response latencies, and other
  application metrics.

  Fields:
    coolDownPeriod: Amount of time that the Autoscaler
      (https://cloud.google.com/compute/docs/autoscaler/) should wait between
      changes to the number of virtual machines. Only applicable for VM
      runtimes.
    cpuUtilization: Target scaling by CPU usage.
    diskUtilization: Target scaling by disk usage.
    maxConcurrentRequests: Number of concurrent requests an automatic scaling
      instance can accept before the scheduler spawns a new instance.Defaults
      to a runtime-specific value.
    maxIdleInstances: Maximum number of idle instances that should be
      maintained for this version.
    maxPendingLatency: Maximum amount of time that a request should wait in
      the pending queue before starting a new instance to handle it.
    maxTotalInstances: Maximum number of instances that should be started to
      handle requests.
    minIdleInstances: Minimum number of idle instances that should be
      maintained for this version. Only applicable for the default version of
      a service.
    minPendingLatency: Minimum amount of time a request should wait in the
      pending queue before starting a new instance to handle it.
    minTotalInstances: Minimum number of instances that should be maintained
      for this version.
    networkUtilization: Target scaling by network usage.
    requestUtilization: Target scaling by request utilization.
  """

  coolDownPeriod = _messages.StringField(1)
  cpuUtilization = _messages.MessageField('CpuUtilization', 2)
  diskUtilization = _messages.MessageField('DiskUtilization', 3)
  maxConcurrentRequests = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxIdleInstances = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxPendingLatency = _messages.StringField(6)
  maxTotalInstances = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  minIdleInstances = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  minPendingLatency = _messages.StringField(9)
  minTotalInstances = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  networkUtilization = _messages.MessageField('NetworkUtilization', 11)
  requestUtilization = _messages.MessageField('RequestUtilization', 12)


class BasicScaling(_messages.Message):
  """A service with basic scaling will create an instance when the application
  receives a request. The instance will be turned down when the app becomes
  idle. Basic scaling is ideal for work that is intermittent or driven by user
  activity.

  Fields:
    idleTimeout: Duration of time after the last request that an instance must
      wait before the instance is shut down.
    maxInstances: Maximum number of instances to create for this version.
  """

  idleTimeout = _messages.StringField(1)
  maxInstances = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ContainerInfo(_messages.Message):
  """Docker image that is used to create a container and start a VM instance
  for the version that you deploy. Only applicable for instances running in
  the App Engine flexible environment.

  Fields:
    image: URI to the hosted container image in Google Container Registry. The
      URI must be fully qualified and include a tag or digest. Examples:
      "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
  """

  image = _messages.StringField(1)


class CpuUtilization(_messages.Message):
  """Target scaling by CPU usage.

  Fields:
    aggregationWindowLength: Period of time over which CPU utilization is
      calculated.
    targetUtilization: Target CPU utilization ratio to maintain when scaling.
      Must be between 0 and 1.
  """

  aggregationWindowLength = _messages.StringField(1)
  targetUtilization = _messages.FloatField(2)


class DebugInstanceRequest(_messages.Message):
  """Request message for Instances.DebugInstance.

  Fields:
    sshKey: Public SSH key to add to the instance. Examples: [USERNAME]:ssh-
      rsa [KEY_VALUE] [USERNAME] [USERNAME]:ssh-rsa [KEY_VALUE] google-ssh
      {"userName":"[USERNAME]","expireOn":"[EXPIRE_TIME]"}For more
      information, see Adding and Removing SSH Keys
      (https://cloud.google.com/compute/docs/instances/adding-removing-ssh-
      keys).
  """

  sshKey = _messages.StringField(1)


class Deployment(_messages.Message):
  """Code and application artifacts used to deploy a version to App Engine.

  Messages:
    FilesValue: Manifest of the files stored in Google Cloud Storage that are
      included as part of this version. All files must be readable using the
      credentials supplied with this call.

  Fields:
    container: The Docker image for the container that runs the version. Only
      applicable for instances running in the App Engine flexible environment.
    files: Manifest of the files stored in Google Cloud Storage that are
      included as part of this version. All files must be readable using the
      credentials supplied with this call.
    zip: The zip file for this deployment, if this is a zip deployment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilesValue(_messages.Message):
    """Manifest of the files stored in Google Cloud Storage that are included
    as part of this version. All files must be readable using the credentials
    supplied with this call.

    Messages:
      AdditionalProperty: An additional property for a FilesValue object.

    Fields:
      additionalProperties: Additional properties of type FilesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a FilesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileInfo attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileInfo', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  container = _messages.MessageField('ContainerInfo', 1)
  files = _messages.MessageField('FilesValue', 2)
  zip = _messages.MessageField('ZipInfo', 3)


class DiskUtilization(_messages.Message):
  """Target scaling by disk usage. Only applicable for VM runtimes.

  Fields:
    targetReadBytesPerSecond: Target bytes read per second.
    targetReadOpsPerSecond: Target ops read per seconds.
    targetWriteBytesPerSecond: Target bytes written per second.
    targetWriteOpsPerSecond: Target ops written per second.
  """

  targetReadBytesPerSecond = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReadOpsPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetWriteBytesPerSecond = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetWriteOpsPerSecond = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class EndpointsApiService(_messages.Message):
  """Cloud Endpoints (https://cloud.google.com/endpoints) configuration. The
  Endpoints API Service provides tooling for serving Open API and gRPC
  endpoints via an NGINX proxy.The fields here refer to the name and
  configuration id of a "service" resource in the Service Management API
  (https://cloud.google.com/service-management/overview).

  Fields:
    configId: Endpoints service configuration id as specified by the Service
      Management API. For example "2016-09-19r1"
    name: Endpoints service name which is the name of the "service" resource
      in the Service Management API. For example
      "myapi.endpoints.myproject.cloud.goog"
  """

  configId = _messages.StringField(1)
  name = _messages.StringField(2)


class ErrorHandler(_messages.Message):
  """Custom static error page to be served when an error occurs.

  Enums:
    ErrorCodeValueValuesEnum: Error condition this handler applies to.

  Fields:
    errorCode: Error condition this handler applies to.
    mimeType: MIME type of file. Defaults to text/html.
    staticFile: Static file content to be served for this error.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    """Error condition this handler applies to.

    Values:
      ERROR_CODE_UNSPECIFIED: Not specified. ERROR_CODE_DEFAULT is assumed.
      ERROR_CODE_DEFAULT: All other error types.
      ERROR_CODE_OVER_QUOTA: Application has exceeded a resource quota.
      ERROR_CODE_DOS_API_DENIAL: Client blocked by the application's Denial of
        Service protection configuration.
      ERROR_CODE_TIMEOUT: Deadline reached before the application responds.
    """
    ERROR_CODE_UNSPECIFIED = 0
    ERROR_CODE_DEFAULT = 1
    ERROR_CODE_OVER_QUOTA = 2
    ERROR_CODE_DOS_API_DENIAL = 3
    ERROR_CODE_TIMEOUT = 4

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  mimeType = _messages.StringField(2)
  staticFile = _messages.StringField(3)


class FileInfo(_messages.Message):
  """Single source file that is part of the version to be deployed. Each
  source file that is deployed must be specified separately.

  Fields:
    mimeType: The MIME type of the file.Defaults to the value from Google
      Cloud Storage.
    sha1Sum: The SHA1 hash of the file, in hex.
    sourceUrl: URL source to use to fetch this file. Must be a URL to a
      resource in Google Cloud Storage in the form
      'http(s)://storage.googleapis.com/<bucket>/<object>'.
  """

  mimeType = _messages.StringField(1)
  sha1Sum = _messages.StringField(2)
  sourceUrl = _messages.StringField(3)


class HealthCheck(_messages.Message):
  """Health checking configuration for VM instances. Unhealthy instances are
  killed and replaced with new instances. Only applicable for instances in App
  Engine flexible environment.

  Fields:
    checkInterval: Interval between health checks.
    disableHealthCheck: Whether to explicitly disable health checks for this
      instance.
    healthyThreshold: Number of consecutive successful health checks required
      before receiving traffic.
    host: Host header to send when performing an HTTP health check. Example:
      "myapp.appspot.com"
    restartThreshold: Number of consecutive failed health checks required
      before an instance is restarted.
    timeout: Time before the health check is considered failed.
    unhealthyThreshold: Number of consecutive failed health checks required
      before removing traffic.
  """

  checkInterval = _messages.StringField(1)
  disableHealthCheck = _messages.BooleanField(2)
  healthyThreshold = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  host = _messages.StringField(4)
  restartThreshold = _messages.IntegerField(5, variant=_messages.Variant.UINT32)
  timeout = _messages.StringField(6)
  unhealthyThreshold = _messages.IntegerField(7, variant=_messages.Variant.UINT32)


class IdentityAwareProxy(_messages.Message):
  """Identity-Aware Proxy

  Fields:
    enabled: Whether the serving infrastructure will authenticate and
      authorize all incoming requests.If true, the oauth2_client_id and
      oauth2_client_secret fields must be non-empty.
    oauth2ClientId: OAuth2 client ID to use for the authentication flow.
    oauth2ClientSecret: OAuth2 client secret to use for the authentication
      flow.For security reasons, this value cannot be retrieved via the API.
      Instead, the SHA-256 hash of the value is returned in the
      oauth2_client_secret_sha256 field.@InputOnly
    oauth2ClientSecretSha256: Hex-encoded SHA-256 hash of the client
      secret.@OutputOnly
  """

  enabled = _messages.BooleanField(1)
  oauth2ClientId = _messages.StringField(2)
  oauth2ClientSecret = _messages.StringField(3)
  oauth2ClientSecretSha256 = _messages.StringField(4)


class Instance(_messages.Message):
  """An Instance resource is the computing unit that App Engine uses to
  automatically scale an application.

  Enums:
    AvailabilityValueValuesEnum: Availability of the instance.@OutputOnly

  Fields:
    appEngineRelease: App Engine release this instance is running
      on.@OutputOnly
    availability: Availability of the instance.@OutputOnly
    averageLatency: Average latency (ms) over the last minute.@OutputOnly
    errors: Number of errors since this instance was started.@OutputOnly
    id: Relative name of the instance within the version. Example:
      instance-1.@OutputOnly
    memoryUsage: Total memory in use (bytes).@OutputOnly
    name: Full path to the Instance resource in the API. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.@OutputOnly
    qps: Average queries per second (QPS) over the last minute.@OutputOnly
    requests: Number of requests since this instance was started.@OutputOnly
    startTime: Time that this instance was started.@OutputOnly
    vmDebugEnabled: Whether this instance is in debug mode. Only applicable
      for instances in App Engine flexible environment.@OutputOnly
    vmId: Virtual machine ID of this instance. Only applicable for instances
      in App Engine flexible environment.@OutputOnly
    vmIp: The IP address of this instance. Only applicable for instances in
      App Engine flexible environment.@OutputOnly
    vmName: Name of the virtual machine where this instance lives. Only
      applicable for instances in App Engine flexible environment.@OutputOnly
    vmStatus: Status of the virtual machine where this instance lives. Only
      applicable for instances in App Engine flexible environment.@OutputOnly
    vmZoneName: Zone where the virtual machine is located. Only applicable for
      instances in App Engine flexible environment.@OutputOnly
  """

  class AvailabilityValueValuesEnum(_messages.Enum):
    """Availability of the instance.@OutputOnly

    Values:
      UNSPECIFIED: <no description>
      RESIDENT: <no description>
      DYNAMIC: <no description>
    """
    UNSPECIFIED = 0
    RESIDENT = 1
    DYNAMIC = 2

  appEngineRelease = _messages.StringField(1)
  availability = _messages.EnumField('AvailabilityValueValuesEnum', 2)
  averageLatency = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  errors = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  id = _messages.StringField(5)
  memoryUsage = _messages.IntegerField(6)
  name = _messages.StringField(7)
  qps = _messages.FloatField(8, variant=_messages.Variant.FLOAT)
  requests = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(10)
  vmDebugEnabled = _messages.BooleanField(11)
  vmId = _messages.StringField(12)
  vmIp = _messages.StringField(13)
  vmName = _messages.StringField(14)
  vmStatus = _messages.StringField(15)
  vmZoneName = _messages.StringField(16)


class Library(_messages.Message):
  """Third-party Python runtime library that is required by the application.

  Fields:
    name: Name of the library. Example: "django".
    version: Version of the library to select, or "latest".
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class ListInstancesResponse(_messages.Message):
  """Response message for Instances.ListInstances.

  Fields:
    instances: The instances belonging to the requested version.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  """The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServicesResponse(_messages.Message):
  """Response message for Services.ListServices.

  Fields:
    nextPageToken: Continuation token for fetching the next page of results.
    services: The services belonging to the requested application.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)


class ListVersionsResponse(_messages.Message):
  """Response message for Versions.ListVersions.

  Fields:
    nextPageToken: Continuation token for fetching the next page of results.
    versions: The versions belonging to the requested service.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('Version', 2, repeated=True)


class LivenessCheck(_messages.Message):
  """Health checking configuration for VM instances. Unhealthy instances are
  killed and replaced with new instances.

  Fields:
    checkInterval: Interval between health checks.
    healthyThreshold: Number of consecutive successful checks required before
      considering the VM healthy.
    host: Host header to send when performing a HTTP Liveness check. Example:
      "myapp.appspot.com"
    initialDelay: The initial delay before starting to execute the checks.
    path: The request path.
    timeout: Time before the check is considered failed.
    unhealthyThreshold: Number of consecutive failed checks required before
      considering the VM unhealthy.
  """

  checkInterval = _messages.StringField(1)
  healthyThreshold = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  host = _messages.StringField(3)
  initialDelay = _messages.StringField(4)
  path = _messages.StringField(5)
  timeout = _messages.StringField(6)
  unhealthyThreshold = _messages.IntegerField(7, variant=_messages.Variant.UINT32)


class Location(_messages.Message):
  """A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: "us-east1".
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: "projects/example-project/locations/us-
      east1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  locationId = _messages.StringField(2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)


class LocationMetadata(_messages.Message):
  """Metadata for the given google.cloud.location.Location.

  Fields:
    flexibleEnvironmentAvailable: App Engine Flexible Environment is available
      in the given location.@OutputOnly
    standardEnvironmentAvailable: App Engine Standard Environment is available
      in the given location.@OutputOnly
  """

  flexibleEnvironmentAvailable = _messages.BooleanField(1)
  standardEnvironmentAvailable = _messages.BooleanField(2)


class ManualScaling(_messages.Message):
  """A service with manual scaling runs continuously, allowing you to perform
  complex initialization and rely on the state of its memory over time.

  Fields:
    instances: Number of instances to assign to the service at the start. This
      number can later be altered by using the Modules API
      (https://cloud.google.com/appengine/docs/python/modules/functions)
      set_num_instances() function.
  """

  instances = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Network(_messages.Message):
  """Extra network settings. Only applicable for VM runtimes.

  Fields:
    forwardedPorts: List of ports, or port pairs, to forward from the virtual
      machine to the application container.
    instanceTag: Tag to apply to the VM instance during creation.
    name: Google Cloud Platform network where the virtual machines are
      created. Specify the short name, not the resource path.Defaults to
      default.
    subnetworkName: Google Cloud Platform sub-network where the virtual
      machines are created. Specify the short name, not the resource path.If a
      subnetwork name is specified, a network name will also be required
      unless it is for the default network. If the network the VM instance is
      being created in is a Legacy network, then the IP address is allocated
      from the IPv4Range. If the network the VM instance is being created in
      is an auto Subnet Mode Network, then only network name should be
      specified (not the subnetwork_name) and the IP address is created from
      the IPCidrRange of the subnetwork that exists in that zone for that
      network. If the network the VM instance is being created in is a custom
      Subnet Mode Network, then the subnetwork_name must be specified and the
      IP address is created from the IPCidrRange of the subnetwork.If
      specified, the subnetwork must exist in the same region as the Flex app.
  """

  forwardedPorts = _messages.StringField(1, repeated=True)
  instanceTag = _messages.StringField(2)
  name = _messages.StringField(3)
  subnetworkName = _messages.StringField(4)


class NetworkUtilization(_messages.Message):
  """Target scaling by network usage. Only applicable for VM runtimes.

  Fields:
    targetReceivedBytesPerSecond: Target bytes received per second.
    targetReceivedPacketsPerSecond: Target packets received per second.
    targetSentBytesPerSecond: Target bytes sent per second.
    targetSentPacketsPerSecond: Target packets sent per second.
  """

  targetReceivedBytesPerSecond = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReceivedPacketsPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetSentBytesPerSecond = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetSentPacketsPerSecond = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should have the format of operations/some/unique/name.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation completed.@OutputOnly
    insertTime: Timestamp that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1beta4.Version.CreateVersion.@OutputOnly
    operationType: Type of this operation. Deprecated, use method field
      instead. Example: "create_version".@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/modules/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  operationType = _messages.StringField(4)
  target = _messages.StringField(5)
  user = _messages.StringField(6)


class OperationMetadataExperimental(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Time that this operation completed.@OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.experimental.CustomDomains.CreateCustomDomain.@OutputOn
      ly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/customDomains/example.com.@OutputOnly
    user: User who requested this operation.@OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  target = _messages.StringField(4)
  user = _messages.StringField(5)


class OperationMetadataV1(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Time that this operation completed.@OutputOnly
    ephemeralMessage: Ephemeral message that may change every time the
      operation is polled. @OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1.Versions.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
    warning: Durable messages that persist on every operation poll.
      @OutputOnly
  """

  endTime = _messages.StringField(1)
  ephemeralMessage = _messages.StringField(2)
  insertTime = _messages.StringField(3)
  method = _messages.StringField(4)
  target = _messages.StringField(5)
  user = _messages.StringField(6)
  warning = _messages.StringField(7, repeated=True)


class OperationMetadataV1Beta(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Time that this operation completed.@OutputOnly
    ephemeralMessage: Ephemeral message that may change every time the
      operation is polled. @OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1beta.Versions.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
    warning: Durable messages that persist on every operation poll.
      @OutputOnly
  """

  endTime = _messages.StringField(1)
  ephemeralMessage = _messages.StringField(2)
  insertTime = _messages.StringField(3)
  method = _messages.StringField(4)
  target = _messages.StringField(5)
  user = _messages.StringField(6)
  warning = _messages.StringField(7, repeated=True)


class OperationMetadataV1Beta5(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation completed.@OutputOnly
    insertTime: Timestamp that this operation was created.@OutputOnly
    method: API method name that initiated this operation. Example:
      google.appengine.v1beta5.Version.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  target = _messages.StringField(4)
  user = _messages.StringField(5)


class ReadinessCheck(_messages.Message):
  """Readiness checking configuration for VM instances. Unhealthy instances
  are removed from traffic rotation.

  Fields:
    checkInterval: Interval between health checks.
    healthyThreshold: Number of consecutive successful checks required before
      receiving traffic.
    host: Host header to send when performing a HTTP Readiness check. Example:
      "myapp.appspot.com"
    path: The request path.
    timeout: Time before the check is considered failed.
    unhealthyThreshold: Number of consecutive failed checks required before
      removing traffic.
  """

  checkInterval = _messages.StringField(1)
  healthyThreshold = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  host = _messages.StringField(3)
  path = _messages.StringField(4)
  timeout = _messages.StringField(5)
  unhealthyThreshold = _messages.IntegerField(6, variant=_messages.Variant.UINT32)


class RepairApplicationRequest(_messages.Message):
  """Request message for 'Applications.RepairApplication'."""


class RequestUtilization(_messages.Message):
  """Target scaling by request utilization. Only applicable for VM runtimes.

  Fields:
    targetConcurrentRequests: Target number of concurrent requests.
    targetRequestCountPerSecond: Target requests per second.
  """

  targetConcurrentRequests = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetRequestCountPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Resources(_messages.Message):
  """Machine resources for a version.

  Fields:
    cpu: Number of CPU cores needed.
    diskGb: Disk size (GB) needed.
    memoryGb: Memory (GB) needed.
    volumes: User specified volumes.
  """

  cpu = _messages.FloatField(1)
  diskGb = _messages.FloatField(2)
  memoryGb = _messages.FloatField(3)
  volumes = _messages.MessageField('Volume', 4, repeated=True)


class ScriptHandler(_messages.Message):
  """Executes a script to handle the request that matches the URL pattern.

  Fields:
    scriptPath: Path to the script from the application root directory.
  """

  scriptPath = _messages.StringField(1)


class Service(_messages.Message):
  """A Service resource is a logical component of an application that can
  share state and communicate in a secure fashion with other services. For
  example, an application that handles customer requests might include
  separate services to handle tasks such as backend data analysis or API
  requests from mobile devices. Each service has a collection of versions that
  define a specific set of code used to implement the functionality of that
  service.

  Fields:
    id: Relative name of the service within the application. Example:
      default.@OutputOnly
    name: Full path to the Service resource in the API. Example:
      apps/myapp/services/default.@OutputOnly
    split: Mapping that defines fractional HTTP traffic diversion to different
      versions within the service.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  split = _messages.MessageField('TrafficSplit', 3)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class StaticFilesHandler(_messages.Message):
  """Files served directly to the user for a given URL, such as images, CSS
  stylesheets, or JavaScript source files. Static file handlers describe which
  files in the application directory are static files, and which URLs serve
  them.

  Messages:
    HttpHeadersValue: HTTP headers to use for all responses from these URLs.

  Fields:
    applicationReadable: Whether files should also be uploaded as code data.
      By default, files declared in static file handlers are uploaded as
      static data and are only served to end users; they cannot be read by the
      application. If enabled, uploads are charged against both your code and
      static data storage resource quotas.
    expiration: Time a static file served by this handler should be cached by
      web proxies and browsers.
    httpHeaders: HTTP headers to use for all responses from these URLs.
    mimeType: MIME type used to serve all files served by this
      handler.Defaults to file-specific MIME types, which are derived from
      each file's filename extension.
    path: Path to the static files matched by the URL pattern, from the
      application root directory. The path can refer to text matched in
      groupings in the URL pattern.
    requireMatchingFile: Whether this handler should match the request if the
      file referenced by the handler does not exist.
    uploadPathRegex: Regular expression that matches the file paths for all
      files that should be referenced by this handler.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HttpHeadersValue(_messages.Message):
    """HTTP headers to use for all responses from these URLs.

    Messages:
      AdditionalProperty: An additional property for a HttpHeadersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HttpHeadersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HttpHeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  applicationReadable = _messages.BooleanField(1)
  expiration = _messages.StringField(2)
  httpHeaders = _messages.MessageField('HttpHeadersValue', 3)
  mimeType = _messages.StringField(4)
  path = _messages.StringField(5)
  requireMatchingFile = _messages.BooleanField(6)
  uploadPathRegex = _messages.StringField(7)


class Status(_messages.Message):
  """The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). The error model is designed to be:
  Simple to use and understand for most users Flexible enough to meet
  unexpected needsOverviewThe Status message contains three pieces of data:
  error code, error message, and error details. The error code should be an
  enum value of google.rpc.Code, but it may accept additional error codes if
  needed. The error message should be a developer-facing English message that
  helps developers understand and resolve the error. If a localized user-
  facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package google.rpc which can be used for common error
  conditions.Language mappingThe Status message is the logical representation
  of the error model, but it is not necessarily the actual wire format. When
  the Status message is exposed in different client libraries and different
  wire protocols, it can be mapped differently. For example, it will likely be
  mapped to some exceptions in Java, but more likely mapped to some error
  codes in C.Other usesThe error model and the Status message can be used in a
  variety of environments, either with or without APIs, to provide a
  consistent developer experience across different environments.Example uses
  of this error model include: Partial errors. If a service needs to return
  partial errors to the client, it may embed the Status in the normal response
  to indicate the partial errors. Workflow errors. A typical workflow has
  multiple steps. Each step may have a Status message for error reporting
  purpose. Batch operations. If a client uses batch request and batch
  response, the Status message should be used directly inside batch response,
  one for each error sub-response. Asynchronous operations. If an API call
  embeds asynchronous operation results in its response, the status of those
  operations should be represented directly using the Status message. Logging.
  If some API errors are stored in logs, the message Status could be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TrafficSplit(_messages.Message):
  """Traffic routing configuration for versions within a single service.
  Traffic splits define how traffic directed to the service is assigned to
  versions.

  Enums:
    ShardByValueValuesEnum: Mechanism used to determine which version a
      request is sent to. The traffic selection algorithm will be stable for
      either type until allocations are changed.

  Messages:
    AllocationsValue: Mapping from version IDs within the service to
      fractional (0.000, 1] allocations of traffic for that version. Each
      version can be specified only once, but some versions in the service may
      not have any traffic allocation. Services that have traffic allocated
      cannot be deleted until either the service is deleted or their traffic
      allocation is removed. Allocations must sum to 1. Up to two decimal
      place precision is supported for IP-based splits and up to three decimal
      places is supported for cookie-based splits.

  Fields:
    allocations: Mapping from version IDs within the service to fractional
      (0.000, 1] allocations of traffic for that version. Each version can be
      specified only once, but some versions in the service may not have any
      traffic allocation. Services that have traffic allocated cannot be
      deleted until either the service is deleted or their traffic allocation
      is removed. Allocations must sum to 1. Up to two decimal place precision
      is supported for IP-based splits and up to three decimal places is
      supported for cookie-based splits.
    shardBy: Mechanism used to determine which version a request is sent to.
      The traffic selection algorithm will be stable for either type until
      allocations are changed.
  """

  class ShardByValueValuesEnum(_messages.Enum):
    """Mechanism used to determine which version a request is sent to. The
    traffic selection algorithm will be stable for either type until
    allocations are changed.

    Values:
      UNSPECIFIED: Diversion method unspecified.
      COOKIE: Diversion based on a specially named cookie, "GOOGAPPUID." The
        cookie must be set by the application itself or no diversion will
        occur.
      IP: Diversion based on applying the modulus operation to a fingerprint
        of the IP address.
      RANDOM: Diversion based on weighted random assignment. An incoming
        request is randomly routed to a version in the traffic split, with
        probability proportional to the version's traffic share.
    """
    UNSPECIFIED = 0
    COOKIE = 1
    IP = 2
    RANDOM = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AllocationsValue(_messages.Message):
    """Mapping from version IDs within the service to fractional (0.000, 1]
    allocations of traffic for that version. Each version can be specified
    only once, but some versions in the service may not have any traffic
    allocation. Services that have traffic allocated cannot be deleted until
    either the service is deleted or their traffic allocation is removed.
    Allocations must sum to 1. Up to two decimal place precision is supported
    for IP-based splits and up to three decimal places is supported for
    cookie-based splits.

    Messages:
      AdditionalProperty: An additional property for a AllocationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AllocationsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a AllocationsValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allocations = _messages.MessageField('AllocationsValue', 1)
  shardBy = _messages.EnumField('ShardByValueValuesEnum', 2)


class UrlDispatchRule(_messages.Message):
  """Rules to match an HTTP request and dispatch that request to a service.

  Fields:
    domain: Domain name to match against. The wildcard "*" is supported if
      specified before a period: "*.".Defaults to matching all domains: "*".
    path: Pathname within the host. Must start with a "/". A single "*" can be
      included at the end of the path.The sum of the lengths of the domain and
      path may not exceed 100 characters.
    service: Resource ID of a service in this application that should serve
      the matched request. The service must already exist. Example: default.
  """

  domain = _messages.StringField(1)
  path = _messages.StringField(2)
  service = _messages.StringField(3)


class UrlMap(_messages.Message):
  """URL pattern and description of how the URL should be handled. App Engine
  can handle URLs by executing application code or by serving static files
  uploaded with the version, such as images, CSS, or JavaScript.

  Enums:
    AuthFailActionValueValuesEnum: Action to take when users access resources
      that require authentication. Defaults to redirect.
    LoginValueValuesEnum: Level of login required to access this resource.
    RedirectHttpResponseCodeValueValuesEnum: 30x code to use when performing
      redirects for the secure field. Defaults to 302.
    SecurityLevelValueValuesEnum: Security (HTTPS) enforcement for this URL.

  Fields:
    apiEndpoint: Uses API Endpoints to handle requests.
    authFailAction: Action to take when users access resources that require
      authentication. Defaults to redirect.
    login: Level of login required to access this resource.
    redirectHttpResponseCode: 30x code to use when performing redirects for
      the secure field. Defaults to 302.
    script: Executes a script to handle the request that matches this URL
      pattern.
    securityLevel: Security (HTTPS) enforcement for this URL.
    staticFiles: Returns the contents of a file, such as an image, as the
      response.
    urlRegex: URL prefix. Uses regular expression syntax, which means regexp
      special characters must be escaped, but should not contain groupings.
      All URLs that begin with this prefix are handled by this handler, using
      the portion of the URL after the prefix as part of the file path.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    """Action to take when users access resources that require authentication.
    Defaults to redirect.

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed.
      AUTH_FAIL_ACTION_REDIRECT: Redirects user to "accounts.google.com". The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: Rejects request with a 401 HTTP status
        code and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    """Level of login required to access this resource.

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the auth_fail_action is
        taken. In addition, if the user is not an administrator for the
        application, they are given an error message regardless of
        auth_fail_action. If the user is an administrator, the handler
        proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class RedirectHttpResponseCodeValueValuesEnum(_messages.Enum):
    """30x code to use when performing redirects for the secure field.
    Defaults to 302.

    Values:
      REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED: Not specified. 302 is assumed.
      REDIRECT_HTTP_RESPONSE_CODE_301: 301 Moved Permanently code.
      REDIRECT_HTTP_RESPONSE_CODE_302: 302 Moved Temporarily code.
      REDIRECT_HTTP_RESPONSE_CODE_303: 303 See Other code.
      REDIRECT_HTTP_RESPONSE_CODE_307: 307 Temporary Redirect code.
    """
    REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED = 0
    REDIRECT_HTTP_RESPONSE_CODE_301 = 1
    REDIRECT_HTTP_RESPONSE_CODE_302 = 2
    REDIRECT_HTTP_RESPONSE_CODE_303 = 3
    REDIRECT_HTTP_RESPONSE_CODE_307 = 4

  class SecurityLevelValueValuesEnum(_messages.Enum):
    """Security (HTTPS) enforcement for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  apiEndpoint = _messages.MessageField('ApiEndpointHandler', 1)
  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 2)
  login = _messages.EnumField('LoginValueValuesEnum', 3)
  redirectHttpResponseCode = _messages.EnumField('RedirectHttpResponseCodeValueValuesEnum', 4)
  script = _messages.MessageField('ScriptHandler', 5)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 6)
  staticFiles = _messages.MessageField('StaticFilesHandler', 7)
  urlRegex = _messages.StringField(8)


class Version(_messages.Message):
  """A Version resource is a specific set of source code and configuration
  files that are deployed into a service.

  Enums:
    InboundServicesValueListEntryValuesEnum:
    ServingStatusValueValuesEnum: Current serving status of this version. Only
      the versions with a SERVING status create instances and can be
      billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
      SERVING.

  Messages:
    BetaSettingsValue: Metadata settings that are supplied to this version to
      enable beta runtime features.
    EnvVariablesValue: Environment variables available to the application.Only
      returned in GET requests if view=FULL is set.

  Fields:
    apiConfig: Serving configuration for Google Cloud Endpoints
      (https://cloud.google.com/appengine/docs/python/endpoints/).Only
      returned in GET requests if view=FULL is set.
    automaticScaling: Automatic scaling is based on request rate, response
      latencies, and other application metrics.
    basicScaling: A service with basic scaling will create an instance when
      the application receives a request. The instance will be turned down
      when the app becomes idle. Basic scaling is ideal for work that is
      intermittent or driven by user activity.
    betaSettings: Metadata settings that are supplied to this version to
      enable beta runtime features.
    createTime: Time that this version was created.@OutputOnly
    createdBy: Email address of the user who created this version.@OutputOnly
    defaultExpiration: Duration that static files should be cached by web
      proxies and browsers. Only applicable if the corresponding
      StaticFilesHandler (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services.versions#staticfileshandler) does
      not specify its own expiration time.Only returned in GET requests if
      view=FULL is set.
    deployment: Code and application artifacts that make up this version.Only
      returned in GET requests if view=FULL is set.
    diskUsageBytes: Total size in bytes of all the files that are included in
      this version and curerntly hosted on the App Engine disk.@OutputOnly
    endpointsApiService: Cloud Endpoints configuration.If
      endpoints_api_service is set, the Cloud Endpoints Extensible Service
      Proxy will be provided to serve the API implemented by the app.
    env: App Engine execution environment for this version.Defaults to
      standard.
    envVariables: Environment variables available to the application.Only
      returned in GET requests if view=FULL is set.
    errorHandlers: Custom static error pages. Limited to 10KB per page.Only
      returned in GET requests if view=FULL is set.
    handlers: An ordered list of URL-matching patterns that should be applied
      to incoming requests. The first matching URL handles the request and
      other request handlers are not attempted.Only returned in GET requests
      if view=FULL is set.
    healthCheck: Configures health checking for VM instances. Unhealthy
      instances are stopped and replaced with new instances. Only applicable
      for VM runtimes.Only returned in GET requests if view=FULL is set.
    id: Relative name of the version within the service. Example: v1. Version
      names can contain only lowercase letters, numbers, or hyphens. Reserved
      names: "default", "latest", and any name with the prefix "ah-".
    inboundServices: Before an application can receive email or XMPP messages,
      the application must be configured to enable the service.
    instanceClass: Instance class that is used to run this version. Valid
      values are: AutomaticScaling: F1, F2, F4, F4_1G ManualScaling or
      BasicScaling: B1, B2, B4, B8, B4_1GDefaults to F1 for AutomaticScaling
      and B1 for ManualScaling or BasicScaling.
    libraries: Configuration for third-party Python runtime libraries that are
      required by the application.Only returned in GET requests if view=FULL
      is set.
    livenessCheck: Configures liveness health checking for VM instances.
      Unhealthy instances are stopped and replaced with new instancesOnly
      returned in GET requests if view=FULL is set.
    manualScaling: A service with manual scaling runs continuously, allowing
      you to perform complex initialization and rely on the state of its
      memory over time.
    name: Full path to the Version resource in the API. Example:
      apps/myapp/services/default/versions/v1.@OutputOnly
    network: Extra network settings. Only applicable for VM runtimes.
    nobuildFilesRegex: Files that match this pattern will not be built into
      this version. Only applicable for Go runtimes.Only returned in GET
      requests if view=FULL is set.
    readinessCheck: Configures readiness health checking for VM instances.
      Unhealthy instances are not put into the backend traffic rotation.Only
      returned in GET requests if view=FULL is set.
    resources: Machine resources for this version. Only applicable for VM
      runtimes.
    runtime: Desired runtime. Example: python27.
    servingStatus: Current serving status of this version. Only the versions
      with a SERVING status create instances and can be
      billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
      SERVING.
    threadsafe: Whether multiple requests can be dispatched to this version at
      once.
    versionUrl: Serving URL for this version. Example: "https://myversion-dot-
      myservice-dot-myapp.appspot.com"@OutputOnly
    vm: Whether to deploy this version in a container on a virtual machine.
  """

  class InboundServicesValueListEntryValuesEnum(_messages.Enum):
    """InboundServicesValueListEntryValuesEnum enum type.

    Values:
      INBOUND_SERVICE_UNSPECIFIED: <no description>
      INBOUND_SERVICE_MAIL: <no description>
      INBOUND_SERVICE_MAIL_BOUNCE: <no description>
      INBOUND_SERVICE_XMPP_ERROR: <no description>
      INBOUND_SERVICE_XMPP_MESSAGE: <no description>
      INBOUND_SERVICE_XMPP_SUBSCRIBE: <no description>
      INBOUND_SERVICE_XMPP_PRESENCE: <no description>
      INBOUND_SERVICE_CHANNEL_PRESENCE: <no description>
      INBOUND_SERVICE_WARMUP: <no description>
    """
    INBOUND_SERVICE_UNSPECIFIED = 0
    INBOUND_SERVICE_MAIL = 1
    INBOUND_SERVICE_MAIL_BOUNCE = 2
    INBOUND_SERVICE_XMPP_ERROR = 3
    INBOUND_SERVICE_XMPP_MESSAGE = 4
    INBOUND_SERVICE_XMPP_SUBSCRIBE = 5
    INBOUND_SERVICE_XMPP_PRESENCE = 6
    INBOUND_SERVICE_CHANNEL_PRESENCE = 7
    INBOUND_SERVICE_WARMUP = 8

  class ServingStatusValueValuesEnum(_messages.Enum):
    """Current serving status of this version. Only the versions with a
    SERVING status create instances and can be
    billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
    SERVING.

    Values:
      SERVING_STATUS_UNSPECIFIED: Not specified.
      SERVING: Currently serving. Instances are created according to the
        scaling settings of the version.
      STOPPED: Disabled. No instances will be created and the scaling settings
        are ignored until the state of the version changes to SERVING.
    """
    SERVING_STATUS_UNSPECIFIED = 0
    SERVING = 1
    STOPPED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BetaSettingsValue(_messages.Message):
    """Metadata settings that are supplied to this version to enable beta
    runtime features.

    Messages:
      AdditionalProperty: An additional property for a BetaSettingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BetaSettingsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a BetaSettingsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvVariablesValue(_messages.Message):
    """Environment variables available to the application.Only returned in GET
    requests if view=FULL is set.

    Messages:
      AdditionalProperty: An additional property for a EnvVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a EnvVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  apiConfig = _messages.MessageField('ApiConfigHandler', 1)
  automaticScaling = _messages.MessageField('AutomaticScaling', 2)
  basicScaling = _messages.MessageField('BasicScaling', 3)
  betaSettings = _messages.MessageField('BetaSettingsValue', 4)
  createTime = _messages.StringField(5)
  createdBy = _messages.StringField(6)
  defaultExpiration = _messages.StringField(7)
  deployment = _messages.MessageField('Deployment', 8)
  diskUsageBytes = _messages.IntegerField(9)
  endpointsApiService = _messages.MessageField('EndpointsApiService', 10)
  env = _messages.StringField(11)
  envVariables = _messages.MessageField('EnvVariablesValue', 12)
  errorHandlers = _messages.MessageField('ErrorHandler', 13, repeated=True)
  handlers = _messages.MessageField('UrlMap', 14, repeated=True)
  healthCheck = _messages.MessageField('HealthCheck', 15)
  id = _messages.StringField(16)
  inboundServices = _messages.EnumField('InboundServicesValueListEntryValuesEnum', 17, repeated=True)
  instanceClass = _messages.StringField(18)
  libraries = _messages.MessageField('Library', 19, repeated=True)
  livenessCheck = _messages.MessageField('LivenessCheck', 20)
  manualScaling = _messages.MessageField('ManualScaling', 21)
  name = _messages.StringField(22)
  network = _messages.MessageField('Network', 23)
  nobuildFilesRegex = _messages.StringField(24)
  readinessCheck = _messages.MessageField('ReadinessCheck', 25)
  resources = _messages.MessageField('Resources', 26)
  runtime = _messages.StringField(27)
  servingStatus = _messages.EnumField('ServingStatusValueValuesEnum', 28)
  threadsafe = _messages.BooleanField(29)
  versionUrl = _messages.StringField(30)
  vm = _messages.BooleanField(31)


class Volume(_messages.Message):
  """Volumes mounted within the app container. Only applicable for VM
  runtimes.

  Fields:
    name: Unique name for the volume.
    sizeGb: Volume size in gigabytes.
    volumeType: Underlying volume type, e.g. 'tmpfs'.
  """

  name = _messages.StringField(1)
  sizeGb = _messages.FloatField(2)
  volumeType = _messages.StringField(3)


class ZipInfo(_messages.Message):
  """The zip file information for a zip deployment.

  Fields:
    filesCount: An estimate of the number of files in a zip for a zip
      deployment. If set, must be greater than or equal to the actual number
      of files. Used for optimizing performance; if not provided, deployment
      may be slow.
    sourceUrl: URL of the zip file to deploy from. Must be a URL to a resource
      in Google Cloud Storage in the form
      'http(s)://storage.googleapis.com/<bucket>/<object>'.
  """

  filesCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  sourceUrl = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'appengine')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'appengine')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'appengine')
