# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Utility functions for opening a GCE URL and getting contents."""

import os
import urllib2

from googlecloudsdk.core import properties

GOOGLE_GCE_METADATA_URI = 'http://{}/computeMetadata/v1'.format(
    os.getenv('GOOGLE_METADATA_ROOT', 'metadata.google.internal'))

GOOGLE_GCE_METADATA_DEFAULT_ACCOUNT_URI = (
    GOOGLE_GCE_METADATA_URI + '/instance/service-accounts/default/email')

GOOGLE_GCE_METADATA_PROJECT_URI = (
    GOOGLE_GCE_METADATA_URI + '/project/project-id')

GOOGLE_GCE_METADATA_NUMERIC_PROJECT_URI = (
    GOOGLE_GCE_METADATA_URI + '/project/numeric-project-id')

GOOGLE_GCE_METADATA_ACCOUNTS_URI = (
    GOOGLE_GCE_METADATA_URI + '/instance/service-accounts')

GOOGLE_GCE_METADATA_ACCOUNT_URI = (
    GOOGLE_GCE_METADATA_ACCOUNTS_URI + '/{account}/email')

GOOGLE_GCE_METADATA_ZONE_URI = (
    GOOGLE_GCE_METADATA_URI + '/instance/zone')

GOOGLE_GCE_METADATA_HEADERS = {'Metadata-Flavor': 'Google'}


def ReadNoProxy(uri):
  """Opens a URI with metadata headers, without a proxy, and reads all data.."""
  request = urllib2.Request(uri, headers=GOOGLE_GCE_METADATA_HEADERS)
  timeout_property = (
      properties.VALUES.compute.gce_metadata_read_timeout_sec.GetInt())
  return urllib2.build_opener(urllib2.ProxyHandler({})).open(
      request, timeout=timeout_property).read()
