package zbuf

import (
	"github.com/brimdata/zed"
	"github.com/brimdata/zed/order"
	"github.com/brimdata/zed/runtime/sam/expr"
)

func NewComparator(zctx *zed.Context, sortKeys []order.SortKey) *expr.Comparator {
	exprs := make([]expr.SortEvaluator, len(sortKeys))
	for i, k := range sortKeys {
		exprs[i] = expr.NewSortEvaluator(expr.NewDottedExpr(zctx, k.Key), k.Order)
	}
	// valueAsBytes establishes a total order.
	exprs = append(exprs, expr.NewSortEvaluator(&valueAsBytes{}, order.Asc))
	nullsMax := sortKeys[0].Order == order.Asc
	return expr.NewComparator(nullsMax, exprs...).WithMissingAsNull()
}

func NewComparatorNullsMax(zctx *zed.Context, sortKeys order.SortKeys) *expr.Comparator {
	exprs := make([]expr.SortEvaluator, len(sortKeys))
	for i, k := range sortKeys {
		exprs[i] = expr.NewSortEvaluator(expr.NewDottedExpr(zctx, k.Key), k.Order)
	}
	var o order.Which
	if !sortKeys.IsNil() {
		o = sortKeys.Primary().Order
	}
	// valueAsBytes establishes a total order.
	exprs = append(exprs, expr.NewSortEvaluator(&valueAsBytes{}, o))
	return expr.NewComparator(true, exprs...).WithMissingAsNull()
}

type valueAsBytes struct{}

func (v *valueAsBytes) Eval(ectx expr.Context, val zed.Value) zed.Value {
	return zed.NewBytes(val.Bytes())
}
