### Aggregate Function

&emsp; **sum** &mdash; sum of input values

### Synopsis
```
sum(number) -> number
```
### Description

The _sum_ aggregate function computes the mathematical sum of its input.

### Examples

Sume of simple sequence:
```mdtest-command
echo '1 2 3 4' | zq -z 'sum(this)' -
```
=>
```mdtest-output
{sum:10}
```

Continuous sum of simple sequence:
```mdtest-command
echo '1 2 3 4' | zq -z 'yield sum(this)' -
```
=>
```mdtest-output
1
3
6
10
```
Unrecognized types are ignored:
```mdtest-command
echo '1 2 3 4 "foo"' | zq -z 'sum(this)' -
```
=>
```mdtest-output
{sum:10}
```
