package yqlib

import (
	"container/list"
	"fmt"

	yaml "gopkg.in/yaml.v3"
)

func lengthOperator(d *dataTreeNavigator, matchMap *list.List, expressionNode *ExpressionNode) (*list.List, error) {
	log.Debugf("-- lengthOperation")
	var results = list.New()

	for el := matchMap.Front(); el != nil; el = el.Next() {
		candidate := el.Value.(*CandidateNode)
		targetNode := unwrapDoc(candidate.Node)
		var length int
		switch targetNode.Kind {
		case yaml.ScalarNode:
			length = len(targetNode.Value)
		case yaml.MappingNode:
			length = len(targetNode.Content) / 2
		case yaml.SequenceNode:
			length = len(targetNode.Content)
		default:
			length = 0
		}

		node := &yaml.Node{Kind: yaml.ScalarNode, Value: fmt.Sprintf("%v", length), Tag: "!!int"}
		result := candidate.CreateChild(nil, node)
		results.PushBack(result)
	}

	return results, nil
}
