import { useEffect, useState } from 'react'
import classNames from 'classnames'
import Button from '@hashicorp/react-button'
import Mask from './Mask'
import Logos from './Logos'
import usePrefersReducedMotion from 'lib/hooks/usePrefersReducedMotion'
import s from './style.module.css'

interface HeroProps {
  heading: React.ReactNode
  description: string
  link: {
    title: string
    url: string
  }
}

export default function Hero({
  heading,
  description,
  link,
}: HeroProps): JSX.Element {
  const prefersReducedMotion = usePrefersReducedMotion()
  const [loaded, setLoaded] = useState(false)
  useEffect(() => {
    if (prefersReducedMotion) {
      setLoaded(true)
      return
    }
    setTimeout(() => {
      setLoaded(true)
    }, 250)
  }, [])
  return (
    <header className={s.hero}>
      <div className={s.heroInner}>
        <h1 className={s.heroHeading}>{heading}</h1>
        <p className={s.heroDescription}>{description}</p>
        <div className={s.heroButton}>
          <Button
            {...link}
            theme={{
              brand: 'waypoint',
            }}
          />
        </div>
      </div>
      <div
        className={classNames(s.heroGraphic, {
          [s.visible]: loaded,
        })}
      >
        <div className={s.heroMask}>
          <Mask />
        </div>
        <div className={s.heroLogos}>
          <Logos />
        </div>
      </div>
    </header>
  )
}

function KubernetesLogo() {
  return (
    <svg
      width="21"
      height="21"
      viewBox="0 0 21 21"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M10.427.096c-.185.01-.367.057-.535.138l-7.3 3.563a1.4 1.4 0 0 0-.756.96l-1.8 8.002a1.432 1.432 0 0 0 .268 1.197l5.053 6.417a1.398 1.398 0 0 0 1.092.532l8.103-.002a1.382 1.382 0 0 0 1.092-.53l5.051-6.419a1.423 1.423 0 0 0 .27-1.197l-1.804-8.002a1.423 1.423 0 0 0-.755-.96L11.104.235a1.38 1.38 0 0 0-.677-.139Z"
        fill="#326CE5"
      />
      <path
        d="M10.498 2.82c-.241 0-.437.221-.437.495v.127c.006.158.04.279.06.424.037.312.067.57.048.81a.489.489 0 0 1-.142.23l-.01.19a5.578 5.578 0 0 0-3.645 1.79 7.342 7.342 0 0 1-.158-.115c-.078.01-.157.036-.26-.026-.195-.134-.373-.32-.589-.543-.098-.107-.17-.209-.287-.312l-.097-.08a.513.513 0 0 0-.305-.116.417.417 0 0 0-.348.157c-.15.193-.102.487.107.658l.007.005c.029.024.064.054.09.074.125.094.239.142.363.217.261.164.478.301.65.466.067.073.078.202.087.257l.14.128a5.873 5.873 0 0 0-.891 4.026l-.183.055c-.048.063-.117.163-.188.193-.225.073-.478.1-.783.132-.144.012-.267.005-.42.034l-.116.028h-.004l-.006.003c-.258.063-.424.305-.37.543.053.239.305.383.564.326h.006l.009-.003c.036-.008.081-.017.113-.026.15-.041.257-.101.392-.154.289-.106.528-.194.762-.229.097-.007.2.062.25.091l.191-.033a5.787 5.787 0 0 0 2.52 3.213l-.079.195c.029.075.06.178.039.252-.085.225-.23.462-.396.726-.08.123-.162.217-.234.357-.017.034-.04.085-.056.12-.112.246-.03.528.186.634.217.107.486-.005.603-.251v-.002c.018-.035.041-.081.055-.114.062-.145.083-.269.126-.409.116-.296.18-.608.338-.802.044-.053.115-.073.189-.093l.099-.183a5.536 5.536 0 0 0 4.032.01l.094.172c.075.025.156.038.223.138.119.208.2.454.3.75.043.14.065.265.127.41.014.033.037.08.054.114.116.247.386.36.604.253.215-.106.298-.389.186-.634-.017-.036-.04-.087-.057-.12-.073-.14-.155-.234-.235-.356-.165-.265-.302-.484-.387-.709-.036-.116.006-.188.033-.263-.016-.02-.051-.129-.072-.18a5.789 5.789 0 0 0 2.519-3.237 6.7 6.7 0 0 1 .187.034c.065-.045.126-.102.244-.093.233.034.473.123.762.229.134.052.243.113.392.154.032.009.077.017.113.025l.009.003.006.001c.26.057.51-.088.564-.326.053-.238-.112-.48-.37-.544-.037-.008-.09-.023-.127-.03-.152-.03-.276-.022-.419-.035-.305-.032-.558-.059-.783-.131-.092-.037-.157-.148-.189-.194l-.176-.052a5.882 5.882 0 0 0-.91-4.017l.154-.142c.007-.08.001-.164.082-.253.172-.165.389-.301.65-.466.124-.075.239-.123.364-.216.028-.022.066-.055.096-.08.21-.17.258-.465.107-.658-.15-.192-.442-.21-.652-.04-.03.024-.07.056-.097.08-.117.103-.19.204-.288.311-.216.224-.394.41-.59.545-.084.05-.208.033-.265.03l-.166.12a5.68 5.68 0 0 0-3.627-1.79c-.004-.059-.01-.166-.01-.199-.057-.055-.126-.103-.143-.223-.02-.24.012-.498.05-.81.02-.145.053-.266.059-.424.001-.036 0-.088-.001-.127 0-.274-.196-.496-.437-.496ZM9.95 6.28l-.13 2.341-.01.005a.389.389 0 0 1-.384.377.378.378 0 0 1-.227-.076l-.004.002-1.88-1.36A4.475 4.475 0 0 1 9.952 6.28Zm1.095 0a4.502 4.502 0 0 1 2.618 1.29l-1.867 1.352-.007-.003a.38.38 0 0 1-.528-.073.396.396 0 0 1-.084-.228h-.002l-.13-2.338Zm-4.41 2.163 1.715 1.568-.002.01a.399.399 0 0 1 .049.54.385.385 0 0 1-.2.135l-.002.008-2.2.648a4.676 4.676 0 0 1 .64-2.91Zm7.712 0a4.746 4.746 0 0 1 .658 2.9l-2.21-.649-.002-.01a.394.394 0 0 1-.274-.466.392.392 0 0 1 .123-.21l-.001-.004 1.707-1.56Zm-4.202 1.689h.703l.437.558-.157.696-.631.31-.633-.311-.157-.696.438-.557Zm2.254 1.909a.37.37 0 0 1 .089.007l.003-.005 2.276.393a4.587 4.587 0 0 1-1.822 2.337l-.883-2.179.003-.004a.398.398 0 0 1 .186-.51.378.378 0 0 1 .148-.04Zm-3.822.01c.174.002.33.125.37.306a.398.398 0 0 1-.021.242l.006.008-.874 2.157a4.605 4.605 0 0 1-1.816-2.32l2.256-.392.004.005a.39.39 0 0 1 .075-.007Zm1.906.944a.386.386 0 0 1 .353.207h.008l1.112 2.053a4.43 4.43 0 0 1-2.91-.003l1.11-2.049h.001a.385.385 0 0 1 .326-.208Z"
        fill="#fff"
        stroke="#fff"
        strokeWidth=".283"
      />
      <path
        d="M10.427.096c-.185.01-.367.057-.535.138l-7.3 3.563a1.4 1.4 0 0 0-.756.96l-1.8 8.002a1.432 1.432 0 0 0 .268 1.197l5.053 6.417a1.398 1.398 0 0 0 1.092.532l8.103-.002a1.382 1.382 0 0 0 1.092-.53l5.051-6.419a1.423 1.423 0 0 0 .27-1.197l-1.804-8.002a1.423 1.423 0 0 0-.755-.96L11.104.235a1.38 1.38 0 0 0-.677-.139Z"
        fill="#326CE5"
      />
      <path
        d="M10.498 2.82c-.241 0-.437.221-.437.495v.127c.006.158.04.279.06.424.037.312.067.57.048.81a.489.489 0 0 1-.142.23l-.01.19a5.578 5.578 0 0 0-3.645 1.79 7.342 7.342 0 0 1-.158-.115c-.078.01-.157.036-.26-.026-.195-.134-.373-.32-.589-.543-.098-.107-.17-.209-.287-.312l-.097-.08a.513.513 0 0 0-.305-.116.417.417 0 0 0-.348.157c-.15.193-.102.487.107.658l.007.005c.029.024.064.054.09.074.125.094.239.142.363.217.261.164.478.301.65.466.067.073.078.202.087.257l.14.128a5.873 5.873 0 0 0-.891 4.026l-.183.055c-.048.063-.117.163-.188.193-.225.073-.478.1-.783.132-.144.012-.267.005-.42.034l-.116.028h-.004l-.006.003c-.258.063-.424.305-.37.543.053.239.305.383.564.326h.006l.009-.003c.036-.008.081-.017.113-.026.15-.041.257-.101.392-.154.289-.106.528-.194.762-.229.097-.007.2.062.25.091l.191-.033a5.787 5.787 0 0 0 2.52 3.213l-.079.195c.029.075.06.178.039.252-.085.225-.23.462-.396.726-.08.123-.162.217-.234.357-.017.034-.04.085-.056.12-.112.246-.03.528.186.634.217.107.486-.005.603-.251v-.002c.018-.035.041-.081.055-.114.062-.145.083-.269.126-.409.116-.296.18-.608.338-.802.044-.053.115-.073.189-.093l.099-.183a5.536 5.536 0 0 0 4.032.01l.094.172c.075.025.156.038.223.138.119.208.2.454.3.75.043.14.065.265.127.41.014.033.037.08.054.114.116.247.386.36.604.253.215-.106.298-.389.186-.634-.017-.036-.04-.087-.057-.12-.073-.14-.155-.234-.235-.356-.165-.265-.302-.484-.387-.709-.036-.116.006-.188.033-.263-.016-.02-.051-.129-.072-.18a5.789 5.789 0 0 0 2.519-3.237 6.7 6.7 0 0 1 .187.034c.065-.045.126-.102.244-.093.233.034.473.123.762.229.134.052.243.113.392.154.032.009.077.017.113.025l.009.003.006.001c.26.057.51-.088.564-.326.053-.238-.112-.48-.37-.544-.037-.008-.09-.023-.127-.03-.152-.03-.276-.022-.419-.035-.305-.032-.558-.059-.783-.131-.092-.037-.157-.148-.189-.194l-.176-.052a5.882 5.882 0 0 0-.91-4.017l.154-.142c.007-.08.001-.164.082-.253.172-.165.389-.301.65-.466.124-.075.239-.123.364-.216.028-.022.066-.055.096-.08.21-.17.258-.465.107-.658-.15-.192-.442-.21-.652-.04-.03.024-.07.056-.097.08-.117.103-.19.204-.288.311-.216.224-.394.41-.59.545-.084.05-.208.033-.265.03l-.166.12a5.68 5.68 0 0 0-3.627-1.79c-.004-.059-.01-.166-.01-.199-.057-.055-.126-.103-.143-.223-.02-.24.012-.498.05-.81.02-.145.053-.266.059-.424.001-.036 0-.088-.001-.127 0-.274-.196-.496-.437-.496ZM9.95 6.28l-.13 2.341-.01.005a.389.389 0 0 1-.384.377.378.378 0 0 1-.227-.076l-.004.002-1.88-1.36A4.475 4.475 0 0 1 9.952 6.28Zm1.095 0a4.502 4.502 0 0 1 2.618 1.29l-1.867 1.352-.007-.003a.38.38 0 0 1-.528-.073.396.396 0 0 1-.084-.228h-.002l-.13-2.338Zm-4.41 2.163 1.715 1.568-.002.01a.399.399 0 0 1 .049.54.385.385 0 0 1-.2.135l-.002.008-2.2.648a4.676 4.676 0 0 1 .64-2.91Zm7.712 0a4.746 4.746 0 0 1 .658 2.9l-2.21-.649-.002-.01a.394.394 0 0 1-.274-.466.392.392 0 0 1 .123-.21l-.001-.004 1.707-1.56Zm-4.202 1.689h.703l.437.558-.157.696-.631.31-.633-.311-.157-.696.438-.557Zm2.254 1.909a.37.37 0 0 1 .089.007l.003-.005 2.276.393a4.587 4.587 0 0 1-1.822 2.337l-.883-2.179.003-.004a.398.398 0 0 1 .186-.51.378.378 0 0 1 .148-.04Zm-3.822.01c.174.002.33.125.37.306a.398.398 0 0 1-.021.242l.006.008-.874 2.157a4.605 4.605 0 0 1-1.816-2.32l2.256-.392.004.005a.39.39 0 0 1 .075-.007Zm1.906.944a.386.386 0 0 1 .353.207h.008l1.112 2.053a4.43 4.43 0 0 1-2.91-.003l1.11-2.049h.001a.385.385 0 0 1 .326-.208Z"
        fill="#fff"
        stroke="#fff"
        strokeWidth=".283"
      />
    </svg>
  )
}

function EcsLogo() {
  return (
    <svg
      width="20"
      height="18"
      viewBox="0 0 20 18"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="m1.251 16.782 4.156-7.465L1.25 1.254l-1.054.509v14.51l1.054.509ZM11.343 4.996 4.455 3.868l1.556-2.135 6.96 3.014-1.628.25Zm.082 8.013-8.167 1.308 1.709 2.295 8.003-3.373-1.545-.23Z"
        fill="#9D5125"
      />
      <path d="M3.709 1.803v14.42l-2.457.558V1.254l2.457.549Z" fill="#F58534" />
      <path
        d="m3.708 17.98-1.29-.63V.685l1.29-.628 2.425 9.969-2.425 7.953ZM12.97 4.746l-1.637.25v7.993l1.637.25 1.495-4.062-1.495-4.431Z"
        fill="#9D5125"
      />
      <path d="M6.215.755v16.536l-2.508.688V.057l2.508.698Z" fill="#F58534" />
      <path
        d="M14.68 14.956V12.93L3.706 14.916v3.063l10.972-3.023ZM14.7 3.1v1.966L3.707 3.031V.057L14.7 3.1Z"
        fill="#F58534"
      />
      <path d="M12.969 15.425V2.622l1.76.469v11.865l-1.76.47Z" fill="#F58534" />
      <path
        d="m18.273 3.81 1.618 3.642-4.719.219-1.668-.11 4.77-3.752Z"
        fill="#6B3B19"
      />
      <path d="M13.504 4.567v2.994l4.77-.27V3.81l-4.77.758Z" fill="#9D5125" />
      <path
        d="M11.292 7.41 9.01 7.262l4.841-4.75 2.457 4.59-5.016.31Z"
        fill="#6B3B19"
      />
      <path
        d="M9.01 3.609V7.26l4.841-.399v-4.35L9.01 3.608Zm4.493 9.93v-2.994l6.387.1-1.617 3.642-4.77-.748Z"
        fill="#9D5125"
      />
      <path
        d="M9.01 14.486v-3.652l7.298.16-2.457 4.59-4.841-1.098Z"
        fill="#9D5125"
      />
      <path
        d="m11.292 10.684-2.282.15 4.841.398 2.457-.239-5.016-.309Zm6.98.12 1.618-.16-4.719-.21-1.668.11 4.77.26Z"
        fill="#FCBF92"
      />
      <path
        d="M18.273 3.808v3.483l1.617.16V4.278l-1.617-.47Zm-1.965-.579v3.873l-2.456-.24v-4.35l2.456.718Zm1.965 11.057v-3.482l1.617-.16v3.174l-1.617.469Zm-1.965.58v-3.873l-2.456.24v4.351l2.456-.718Z"
        fill="#F58534"
      />
    </svg>
  )
}
