import { helper } from '@ember/component/helper';

// stripAnsi
export function stripAnsi([text]: [string]): string {
  if (!text) return '';

  const pattern = [
    '[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)',
    '(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))',
  ].join('|');

  const regex = new RegExp(pattern, 'g');
  return text.replace(regex, '');
}

export default helper(stripAnsi);
