// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointLoginTokenRequest hashicorp waypoint login token request
//
// swagger:model hashicorp.waypoint.LoginTokenRequest
type HashicorpWaypointLoginTokenRequest struct {

	// How long the token should be valid from the time the request
	// is made. If this is empty then the login token never expires on its own.
	Duration string `json:"duration,omitempty"`

	// The token generated will only be used for Trigger URL actions. The token
	// will not be authorized to make any other requests to any other endpoints
	Trigger bool `json:"trigger,omitempty"`

	// The user to create the login token for. If this is nil, the currently
	// logged in user is used. The calling user must have permission to create
	// a token for the target user if this is set.
	User *HashicorpWaypointRefUser `json:"user,omitempty"`
}

// Validate validates this hashicorp waypoint login token request
func (m *HashicorpWaypointLoginTokenRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointLoginTokenRequest) validateUser(formats strfmt.Registry) error {
	if swag.IsZero(m.User) { // not required
		return nil
	}

	if m.User != nil {
		if err := m.User.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint login token request based on the context it is used
func (m *HashicorpWaypointLoginTokenRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUser(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointLoginTokenRequest) contextValidateUser(ctx context.Context, formats strfmt.Registry) error {

	if m.User != nil {
		if err := m.User.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointLoginTokenRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointLoginTokenRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointLoginTokenRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
