// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointGetJobStreamResponse hashicorp waypoint get job stream response
//
// swagger:model hashicorp.waypoint.GetJobStreamResponse
type HashicorpWaypointGetJobStreamResponse struct {

	// job completion, no more events will follow this one. This can be
	// both success or failure, the event must be checked. Any errors
	// in complete are errors from the job execution itself.
	Complete *HashicorpWaypointGetJobStreamResponseComplete `json:"complete,omitempty"`

	// data downloaded for the job. This is sent after the state is RUNNING
	// when the runner has cloned any data (if necessary) containing information
	// about the data. This is an optional event and may not be sent, indicating
	// that the runner is either older and doesn't support this event or that
	// there was no data download necessary and it is using local data.
	Download *HashicorpWaypointGetJobStreamResponseDownload `json:"download,omitempty"`

	// an error regarding the stream itself, rather than the executing job.
	// For example, if you request a job stream for an invalid job ID,
	// this will be sent back. If this is sent, no further messages will
	// be sent and the stream is terminated.
	//
	// For errors in job execution, see "complete".
	Error *HashicorpWaypointGetJobStreamResponseError `json:"error,omitempty"`

	// Job is sent whenever the job information changes. This is similar to
	// state but is sent when ANY field in the Job structure changes. This
	// can be used to listen for any updates to fields.
	//
	// The updated job is also sent when the state changes. In that case,
	// both "state" and "job" will trigger.
	Job *HashicorpWaypointGetJobStreamResponseJobChange `json:"job,omitempty"`

	// Open is sent as confirmation that the job stream successfully opened.
	// This will be sent immediately by the server if the job ID is valid.
	// This is useful since other events such as terminal output may not
	// happen for a long time while the job is executing, queued, etc.
	//
	// This is ALWAYS sent. If the job is already completed, this will be
	// sent first followed immediately by a Complete.
	Open HashicorpWaypointGetJobStreamResponseOpen `json:"open,omitempty"`

	// state is sent when there is a job state change event. This event is
	// also used if there is job metadata changes. In this case, the state
	// may be the same but the job is different.
	State *HashicorpWaypointGetJobStreamResponseState `json:"state,omitempty"`

	// terminal output. On initial connection, the server may send buffered
	// historical terminal data so there isn't a race between queueing a job
	// and getting its first byte output. You can determine this based on the
	// flag on Terminal.
	Terminal *HashicorpWaypointGetJobStreamResponseTerminal `json:"terminal,omitempty"`
}

// Validate validates this hashicorp waypoint get job stream response
func (m *HashicorpWaypointGetJobStreamResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDownload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTerminal(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.Complete) { // not required
		return nil
	}

	if m.Complete != nil {
		if err := m.Complete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("complete")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("complete")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateDownload(formats strfmt.Registry) error {
	if swag.IsZero(m.Download) { // not required
		return nil
	}

	if m.Download != nil {
		if err := m.Download.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("download")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("download")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) validateTerminal(formats strfmt.Registry) error {
	if swag.IsZero(m.Terminal) { // not required
		return nil
	}

	if m.Terminal != nil {
		if err := m.Terminal.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terminal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terminal")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint get job stream response based on the context it is used
func (m *HashicorpWaypointGetJobStreamResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDownload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTerminal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateComplete(ctx context.Context, formats strfmt.Registry) error {

	if m.Complete != nil {
		if err := m.Complete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("complete")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("complete")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateDownload(ctx context.Context, formats strfmt.Registry) error {

	if m.Download != nil {
		if err := m.Download.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("download")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("download")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointGetJobStreamResponse) contextValidateTerminal(ctx context.Context, formats strfmt.Registry) error {

	if m.Terminal != nil {
		if err := m.Terminal.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terminal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terminal")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointGetJobStreamResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointGetJobStreamResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointGetJobStreamResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
