// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUpsertProjectReader is a Reader for the WaypointUpsertProject structure.
type WaypointUpsertProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUpsertProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUpsertProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUpsertProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUpsertProjectOK creates a WaypointUpsertProjectOK with default headers values
func NewWaypointUpsertProjectOK() *WaypointUpsertProjectOK {
	return &WaypointUpsertProjectOK{}
}

/*
WaypointUpsertProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUpsertProjectOK struct {
	Payload *models.HashicorpWaypointUpsertProjectResponse
}

// IsSuccess returns true when this waypoint upsert project o k response has a 2xx status code
func (o *WaypointUpsertProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint upsert project o k response has a 3xx status code
func (o *WaypointUpsertProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint upsert project o k response has a 4xx status code
func (o *WaypointUpsertProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint upsert project o k response has a 5xx status code
func (o *WaypointUpsertProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint upsert project o k response a status code equal to that given
func (o *WaypointUpsertProjectOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUpsertProjectOK) Error() string {
	return fmt.Sprintf("[POST /project][%d] waypointUpsertProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertProjectOK) String() string {
	return fmt.Sprintf("[POST /project][%d] waypointUpsertProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertProjectOK) GetPayload() *models.HashicorpWaypointUpsertProjectResponse {
	return o.Payload
}

func (o *WaypointUpsertProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUpsertProjectResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUpsertProjectDefault creates a WaypointUpsertProjectDefault with default headers values
func NewWaypointUpsertProjectDefault(code int) *WaypointUpsertProjectDefault {
	return &WaypointUpsertProjectDefault{
		_statusCode: code,
	}
}

/*
WaypointUpsertProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUpsertProjectDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint upsert project default response
func (o *WaypointUpsertProjectDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint upsert project default response has a 2xx status code
func (o *WaypointUpsertProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint upsert project default response has a 3xx status code
func (o *WaypointUpsertProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint upsert project default response has a 4xx status code
func (o *WaypointUpsertProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint upsert project default response has a 5xx status code
func (o *WaypointUpsertProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint upsert project default response a status code equal to that given
func (o *WaypointUpsertProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUpsertProjectDefault) Error() string {
	return fmt.Sprintf("[POST /project][%d] Waypoint_UpsertProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertProjectDefault) String() string {
	return fmt.Sprintf("[POST /project][%d] Waypoint_UpsertProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertProjectDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUpsertProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
