// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetLogStreamReader is a Reader for the WaypointGetLogStream structure.
type WaypointGetLogStreamReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetLogStreamReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetLogStreamOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetLogStreamDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetLogStreamOK creates a WaypointGetLogStreamOK with default headers values
func NewWaypointGetLogStreamOK() *WaypointGetLogStreamOK {
	return &WaypointGetLogStreamOK{}
}

/*
WaypointGetLogStreamOK describes a response with status code 200, with default header values.

A successful response.(streaming responses)
*/
type WaypointGetLogStreamOK struct {
	Payload *WaypointGetLogStreamOKBody
}

// IsSuccess returns true when this waypoint get log stream o k response has a 2xx status code
func (o *WaypointGetLogStreamOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get log stream o k response has a 3xx status code
func (o *WaypointGetLogStreamOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get log stream o k response has a 4xx status code
func (o *WaypointGetLogStreamOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get log stream o k response has a 5xx status code
func (o *WaypointGetLogStreamOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get log stream o k response a status code equal to that given
func (o *WaypointGetLogStreamOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetLogStreamOK) Error() string {
	return fmt.Sprintf("[POST /deployment/{deployment_id}/logs][%d] waypointGetLogStreamOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLogStreamOK) String() string {
	return fmt.Sprintf("[POST /deployment/{deployment_id}/logs][%d] waypointGetLogStreamOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLogStreamOK) GetPayload() *WaypointGetLogStreamOKBody {
	return o.Payload
}

func (o *WaypointGetLogStreamOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(WaypointGetLogStreamOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetLogStreamDefault creates a WaypointGetLogStreamDefault with default headers values
func NewWaypointGetLogStreamDefault(code int) *WaypointGetLogStreamDefault {
	return &WaypointGetLogStreamDefault{
		_statusCode: code,
	}
}

/*
WaypointGetLogStreamDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetLogStreamDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get log stream default response
func (o *WaypointGetLogStreamDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get log stream default response has a 2xx status code
func (o *WaypointGetLogStreamDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get log stream default response has a 3xx status code
func (o *WaypointGetLogStreamDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get log stream default response has a 4xx status code
func (o *WaypointGetLogStreamDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get log stream default response has a 5xx status code
func (o *WaypointGetLogStreamDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get log stream default response a status code equal to that given
func (o *WaypointGetLogStreamDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetLogStreamDefault) Error() string {
	return fmt.Sprintf("[POST /deployment/{deployment_id}/logs][%d] Waypoint_GetLogStream default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLogStreamDefault) String() string {
	return fmt.Sprintf("[POST /deployment/{deployment_id}/logs][%d] Waypoint_GetLogStream default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLogStreamDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetLogStreamDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WaypointGetLogStreamOKBody Stream result of hashicorp.waypoint.LogBatch
swagger:model WaypointGetLogStreamOKBody
*/
type WaypointGetLogStreamOKBody struct {

	// error
	Error *models.GrpcGatewayRuntimeStreamError `json:"error,omitempty"`

	// result
	Result *models.HashicorpWaypointLogBatch `json:"result,omitempty"`
}

// Validate validates this waypoint get log stream o k body
func (o *WaypointGetLogStreamOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateResult(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointGetLogStreamOKBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStreamOK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStreamOK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointGetLogStreamOKBody) validateResult(formats strfmt.Registry) error {
	if swag.IsZero(o.Result) { // not required
		return nil
	}

	if o.Result != nil {
		if err := o.Result.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStreamOK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStreamOK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this waypoint get log stream o k body based on the context it is used
func (o *WaypointGetLogStreamOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResult(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointGetLogStreamOKBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStreamOK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStreamOK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointGetLogStreamOKBody) contextValidateResult(ctx context.Context, formats strfmt.Registry) error {

	if o.Result != nil {
		if err := o.Result.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStreamOK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStreamOK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WaypointGetLogStreamOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WaypointGetLogStreamOKBody) UnmarshalBinary(b []byte) error {
	var res WaypointGetLogStreamOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
