// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetConfig2Params creates a new WaypointGetConfig2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetConfig2Params() *WaypointGetConfig2Params {
	return &WaypointGetConfig2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetConfig2ParamsWithTimeout creates a new WaypointGetConfig2Params object
// with the ability to set a timeout on a request.
func NewWaypointGetConfig2ParamsWithTimeout(timeout time.Duration) *WaypointGetConfig2Params {
	return &WaypointGetConfig2Params{
		timeout: timeout,
	}
}

// NewWaypointGetConfig2ParamsWithContext creates a new WaypointGetConfig2Params object
// with the ability to set a context for a request.
func NewWaypointGetConfig2ParamsWithContext(ctx context.Context) *WaypointGetConfig2Params {
	return &WaypointGetConfig2Params{
		Context: ctx,
	}
}

// NewWaypointGetConfig2ParamsWithHTTPClient creates a new WaypointGetConfig2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetConfig2ParamsWithHTTPClient(client *http.Client) *WaypointGetConfig2Params {
	return &WaypointGetConfig2Params{
		HTTPClient: client,
	}
}

/*
WaypointGetConfig2Params contains all the parameters to send to the API endpoint

	for the waypoint get config2 operation.

	Typically these are written to a http.Request.
*/
type WaypointGetConfig2Params struct {

	// ApplicationApplication.
	ApplicationApplication *string

	// ApplicationProject.
	ApplicationProject *string

	/* Prefix.

	     Get all configuration entries under the given prefix. When empty,
	returns all config variables.
	*/
	Prefix *string

	// ProjectProject.
	ProjectProject string

	// RunnerID.
	RunnerID *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get config2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfig2Params) WithDefaults() *WaypointGetConfig2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get config2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfig2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithTimeout(timeout time.Duration) *WaypointGetConfig2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithContext(ctx context.Context) *WaypointGetConfig2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithHTTPClient(client *http.Client) *WaypointGetConfig2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithApplicationApplication(applicationApplication *string) *WaypointGetConfig2Params {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetApplicationApplication(applicationApplication *string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithApplicationProject(applicationProject *string) *WaypointGetConfig2Params {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetApplicationProject(applicationProject *string) {
	o.ApplicationProject = applicationProject
}

// WithPrefix adds the prefix to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithPrefix(prefix *string) *WaypointGetConfig2Params {
	o.SetPrefix(prefix)
	return o
}

// SetPrefix adds the prefix to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetPrefix(prefix *string) {
	o.Prefix = prefix
}

// WithProjectProject adds the projectProject to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithProjectProject(projectProject string) *WaypointGetConfig2Params {
	o.SetProjectProject(projectProject)
	return o
}

// SetProjectProject adds the projectProject to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetProjectProject(projectProject string) {
	o.ProjectProject = projectProject
}

// WithRunnerID adds the runnerID to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithRunnerID(runnerID *string) *WaypointGetConfig2Params {
	o.SetRunnerID(runnerID)
	return o
}

// SetRunnerID adds the runnerId to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetRunnerID(runnerID *string) {
	o.RunnerID = runnerID
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config2 params
func (o *WaypointGetConfig2Params) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointGetConfig2Params {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config2 params
func (o *WaypointGetConfig2Params) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetConfig2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationApplication != nil {

		// query param application.application
		var qrApplicationApplication string

		if o.ApplicationApplication != nil {
			qrApplicationApplication = *o.ApplicationApplication
		}
		qApplicationApplication := qrApplicationApplication
		if qApplicationApplication != "" {

			if err := r.SetQueryParam("application.application", qApplicationApplication); err != nil {
				return err
			}
		}
	}

	if o.ApplicationProject != nil {

		// query param application.project
		var qrApplicationProject string

		if o.ApplicationProject != nil {
			qrApplicationProject = *o.ApplicationProject
		}
		qApplicationProject := qrApplicationProject
		if qApplicationProject != "" {

			if err := r.SetQueryParam("application.project", qApplicationProject); err != nil {
				return err
			}
		}
	}

	if o.Prefix != nil {

		// query param prefix
		var qrPrefix string

		if o.Prefix != nil {
			qrPrefix = *o.Prefix
		}
		qPrefix := qrPrefix
		if qPrefix != "" {

			if err := r.SetQueryParam("prefix", qPrefix); err != nil {
				return err
			}
		}
	}

	// path param project.project
	if err := r.SetPathParam("project.project", o.ProjectProject); err != nil {
		return err
	}

	if o.RunnerID != nil {

		// query param runner.id
		var qrRunnerID string

		if o.RunnerID != nil {
			qrRunnerID = *o.RunnerID
		}
		qRunnerID := qrRunnerID
		if qRunnerID != "" {

			if err := r.SetQueryParam("runner.id", qRunnerID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
