// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGenerateLoginTokenReader is a Reader for the WaypointGenerateLoginToken structure.
type WaypointGenerateLoginTokenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGenerateLoginTokenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGenerateLoginTokenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGenerateLoginTokenDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGenerateLoginTokenOK creates a WaypointGenerateLoginTokenOK with default headers values
func NewWaypointGenerateLoginTokenOK() *WaypointGenerateLoginTokenOK {
	return &WaypointGenerateLoginTokenOK{}
}

/*
WaypointGenerateLoginTokenOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGenerateLoginTokenOK struct {
	Payload *models.HashicorpWaypointNewTokenResponse
}

// IsSuccess returns true when this waypoint generate login token o k response has a 2xx status code
func (o *WaypointGenerateLoginTokenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint generate login token o k response has a 3xx status code
func (o *WaypointGenerateLoginTokenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint generate login token o k response has a 4xx status code
func (o *WaypointGenerateLoginTokenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint generate login token o k response has a 5xx status code
func (o *WaypointGenerateLoginTokenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint generate login token o k response a status code equal to that given
func (o *WaypointGenerateLoginTokenOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGenerateLoginTokenOK) Error() string {
	return fmt.Sprintf("[POST /token/login][%d] waypointGenerateLoginTokenOK  %+v", 200, o.Payload)
}

func (o *WaypointGenerateLoginTokenOK) String() string {
	return fmt.Sprintf("[POST /token/login][%d] waypointGenerateLoginTokenOK  %+v", 200, o.Payload)
}

func (o *WaypointGenerateLoginTokenOK) GetPayload() *models.HashicorpWaypointNewTokenResponse {
	return o.Payload
}

func (o *WaypointGenerateLoginTokenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointNewTokenResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGenerateLoginTokenDefault creates a WaypointGenerateLoginTokenDefault with default headers values
func NewWaypointGenerateLoginTokenDefault(code int) *WaypointGenerateLoginTokenDefault {
	return &WaypointGenerateLoginTokenDefault{
		_statusCode: code,
	}
}

/*
WaypointGenerateLoginTokenDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGenerateLoginTokenDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint generate login token default response
func (o *WaypointGenerateLoginTokenDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint generate login token default response has a 2xx status code
func (o *WaypointGenerateLoginTokenDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint generate login token default response has a 3xx status code
func (o *WaypointGenerateLoginTokenDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint generate login token default response has a 4xx status code
func (o *WaypointGenerateLoginTokenDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint generate login token default response has a 5xx status code
func (o *WaypointGenerateLoginTokenDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint generate login token default response a status code equal to that given
func (o *WaypointGenerateLoginTokenDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGenerateLoginTokenDefault) Error() string {
	return fmt.Sprintf("[POST /token/login][%d] Waypoint_GenerateLoginToken default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGenerateLoginTokenDefault) String() string {
	return fmt.Sprintf("[POST /token/login][%d] Waypoint_GenerateLoginToken default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGenerateLoginTokenDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGenerateLoginTokenDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
