// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGenerateInviteTokenReader is a Reader for the WaypointGenerateInviteToken structure.
type WaypointGenerateInviteTokenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGenerateInviteTokenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGenerateInviteTokenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGenerateInviteTokenDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGenerateInviteTokenOK creates a WaypointGenerateInviteTokenOK with default headers values
func NewWaypointGenerateInviteTokenOK() *WaypointGenerateInviteTokenOK {
	return &WaypointGenerateInviteTokenOK{}
}

/*
WaypointGenerateInviteTokenOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGenerateInviteTokenOK struct {
	Payload *models.HashicorpWaypointNewTokenResponse
}

// IsSuccess returns true when this waypoint generate invite token o k response has a 2xx status code
func (o *WaypointGenerateInviteTokenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint generate invite token o k response has a 3xx status code
func (o *WaypointGenerateInviteTokenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint generate invite token o k response has a 4xx status code
func (o *WaypointGenerateInviteTokenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint generate invite token o k response has a 5xx status code
func (o *WaypointGenerateInviteTokenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint generate invite token o k response a status code equal to that given
func (o *WaypointGenerateInviteTokenOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGenerateInviteTokenOK) Error() string {
	return fmt.Sprintf("[POST /token/invite][%d] waypointGenerateInviteTokenOK  %+v", 200, o.Payload)
}

func (o *WaypointGenerateInviteTokenOK) String() string {
	return fmt.Sprintf("[POST /token/invite][%d] waypointGenerateInviteTokenOK  %+v", 200, o.Payload)
}

func (o *WaypointGenerateInviteTokenOK) GetPayload() *models.HashicorpWaypointNewTokenResponse {
	return o.Payload
}

func (o *WaypointGenerateInviteTokenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointNewTokenResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGenerateInviteTokenDefault creates a WaypointGenerateInviteTokenDefault with default headers values
func NewWaypointGenerateInviteTokenDefault(code int) *WaypointGenerateInviteTokenDefault {
	return &WaypointGenerateInviteTokenDefault{
		_statusCode: code,
	}
}

/*
WaypointGenerateInviteTokenDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGenerateInviteTokenDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint generate invite token default response
func (o *WaypointGenerateInviteTokenDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint generate invite token default response has a 2xx status code
func (o *WaypointGenerateInviteTokenDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint generate invite token default response has a 3xx status code
func (o *WaypointGenerateInviteTokenDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint generate invite token default response has a 4xx status code
func (o *WaypointGenerateInviteTokenDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint generate invite token default response has a 5xx status code
func (o *WaypointGenerateInviteTokenDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint generate invite token default response a status code equal to that given
func (o *WaypointGenerateInviteTokenDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGenerateInviteTokenDefault) Error() string {
	return fmt.Sprintf("[POST /token/invite][%d] Waypoint_GenerateInviteToken default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGenerateInviteTokenDefault) String() string {
	return fmt.Sprintf("[POST /token/invite][%d] Waypoint_GenerateInviteToken default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGenerateInviteTokenDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGenerateInviteTokenDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
