// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointCancelTask2Reader is a Reader for the WaypointCancelTask2 structure.
type WaypointCancelTask2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointCancelTask2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointCancelTask2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointCancelTask2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointCancelTask2OK creates a WaypointCancelTask2OK with default headers values
func NewWaypointCancelTask2OK() *WaypointCancelTask2OK {
	return &WaypointCancelTask2OK{}
}

/*
WaypointCancelTask2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointCancelTask2OK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint cancel task2 o k response has a 2xx status code
func (o *WaypointCancelTask2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint cancel task2 o k response has a 3xx status code
func (o *WaypointCancelTask2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint cancel task2 o k response has a 4xx status code
func (o *WaypointCancelTask2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint cancel task2 o k response has a 5xx status code
func (o *WaypointCancelTask2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint cancel task2 o k response a status code equal to that given
func (o *WaypointCancelTask2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointCancelTask2OK) Error() string {
	return fmt.Sprintf("[PUT /task/by-job/{ref.job_id}/cancel][%d] waypointCancelTask2OK  %+v", 200, o.Payload)
}

func (o *WaypointCancelTask2OK) String() string {
	return fmt.Sprintf("[PUT /task/by-job/{ref.job_id}/cancel][%d] waypointCancelTask2OK  %+v", 200, o.Payload)
}

func (o *WaypointCancelTask2OK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointCancelTask2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointCancelTask2Default creates a WaypointCancelTask2Default with default headers values
func NewWaypointCancelTask2Default(code int) *WaypointCancelTask2Default {
	return &WaypointCancelTask2Default{
		_statusCode: code,
	}
}

/*
WaypointCancelTask2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointCancelTask2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint cancel task2 default response
func (o *WaypointCancelTask2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint cancel task2 default response has a 2xx status code
func (o *WaypointCancelTask2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint cancel task2 default response has a 3xx status code
func (o *WaypointCancelTask2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint cancel task2 default response has a 4xx status code
func (o *WaypointCancelTask2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint cancel task2 default response has a 5xx status code
func (o *WaypointCancelTask2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint cancel task2 default response a status code equal to that given
func (o *WaypointCancelTask2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointCancelTask2Default) Error() string {
	return fmt.Sprintf("[PUT /task/by-job/{ref.job_id}/cancel][%d] Waypoint_CancelTask2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCancelTask2Default) String() string {
	return fmt.Sprintf("[PUT /task/by-job/{ref.job_id}/cancel][%d] Waypoint_CancelTask2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCancelTask2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointCancelTask2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
