// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointCancelJobReader is a Reader for the WaypointCancelJob structure.
type WaypointCancelJobReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointCancelJobReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointCancelJobOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointCancelJobDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointCancelJobOK creates a WaypointCancelJobOK with default headers values
func NewWaypointCancelJobOK() *WaypointCancelJobOK {
	return &WaypointCancelJobOK{}
}

/*
WaypointCancelJobOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointCancelJobOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint cancel job o k response has a 2xx status code
func (o *WaypointCancelJobOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint cancel job o k response has a 3xx status code
func (o *WaypointCancelJobOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint cancel job o k response has a 4xx status code
func (o *WaypointCancelJobOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint cancel job o k response has a 5xx status code
func (o *WaypointCancelJobOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint cancel job o k response a status code equal to that given
func (o *WaypointCancelJobOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointCancelJobOK) Error() string {
	return fmt.Sprintf("[PUT /jobs/cancel/{job_id}][%d] waypointCancelJobOK  %+v", 200, o.Payload)
}

func (o *WaypointCancelJobOK) String() string {
	return fmt.Sprintf("[PUT /jobs/cancel/{job_id}][%d] waypointCancelJobOK  %+v", 200, o.Payload)
}

func (o *WaypointCancelJobOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointCancelJobOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointCancelJobDefault creates a WaypointCancelJobDefault with default headers values
func NewWaypointCancelJobDefault(code int) *WaypointCancelJobDefault {
	return &WaypointCancelJobDefault{
		_statusCode: code,
	}
}

/*
WaypointCancelJobDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointCancelJobDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint cancel job default response
func (o *WaypointCancelJobDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint cancel job default response has a 2xx status code
func (o *WaypointCancelJobDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint cancel job default response has a 3xx status code
func (o *WaypointCancelJobDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint cancel job default response has a 4xx status code
func (o *WaypointCancelJobDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint cancel job default response has a 5xx status code
func (o *WaypointCancelJobDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint cancel job default response a status code equal to that given
func (o *WaypointCancelJobDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointCancelJobDefault) Error() string {
	return fmt.Sprintf("[PUT /jobs/cancel/{job_id}][%d] Waypoint_CancelJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCancelJobDefault) String() string {
	return fmt.Sprintf("[PUT /jobs/cancel/{job_id}][%d] Waypoint_CancelJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCancelJobDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointCancelJobDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
