// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointAdoptRunnerParams creates a new WaypointAdoptRunnerParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointAdoptRunnerParams() *WaypointAdoptRunnerParams {
	return &WaypointAdoptRunnerParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointAdoptRunnerParamsWithTimeout creates a new WaypointAdoptRunnerParams object
// with the ability to set a timeout on a request.
func NewWaypointAdoptRunnerParamsWithTimeout(timeout time.Duration) *WaypointAdoptRunnerParams {
	return &WaypointAdoptRunnerParams{
		timeout: timeout,
	}
}

// NewWaypointAdoptRunnerParamsWithContext creates a new WaypointAdoptRunnerParams object
// with the ability to set a context for a request.
func NewWaypointAdoptRunnerParamsWithContext(ctx context.Context) *WaypointAdoptRunnerParams {
	return &WaypointAdoptRunnerParams{
		Context: ctx,
	}
}

// NewWaypointAdoptRunnerParamsWithHTTPClient creates a new WaypointAdoptRunnerParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointAdoptRunnerParamsWithHTTPClient(client *http.Client) *WaypointAdoptRunnerParams {
	return &WaypointAdoptRunnerParams{
		HTTPClient: client,
	}
}

/*
WaypointAdoptRunnerParams contains all the parameters to send to the API endpoint

	for the waypoint adopt runner operation.

	Typically these are written to a http.Request.
*/
type WaypointAdoptRunnerParams struct {

	// Body.
	Body *models.HashicorpWaypointAdoptRunnerRequest

	/* RunnerID.

	   ID of the runner to change the adoption status.
	*/
	RunnerID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint adopt runner params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointAdoptRunnerParams) WithDefaults() *WaypointAdoptRunnerParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint adopt runner params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointAdoptRunnerParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) WithTimeout(timeout time.Duration) *WaypointAdoptRunnerParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) WithContext(ctx context.Context) *WaypointAdoptRunnerParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) WithHTTPClient(client *http.Client) *WaypointAdoptRunnerParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) WithBody(body *models.HashicorpWaypointAdoptRunnerRequest) *WaypointAdoptRunnerParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) SetBody(body *models.HashicorpWaypointAdoptRunnerRequest) {
	o.Body = body
}

// WithRunnerID adds the runnerID to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) WithRunnerID(runnerID string) *WaypointAdoptRunnerParams {
	o.SetRunnerID(runnerID)
	return o
}

// SetRunnerID adds the runnerId to the waypoint adopt runner params
func (o *WaypointAdoptRunnerParams) SetRunnerID(runnerID string) {
	o.RunnerID = runnerID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointAdoptRunnerParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param runner_id
	if err := r.SetPathParam("runner_id", o.RunnerID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
