// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointWorkspace hashicorp waypoint workspace
//
// swagger:model hashicorp.waypoint.Workspace
type HashicorpWaypointWorkspace struct {

	// active_time is the last time that this workspace had activity.
	// Format: date-time
	ActiveTime strfmt.DateTime `json:"active_time,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// The list of projects that have executed at least one operation within
	// the context of this workspace.
	Projects []*HashicorpWaypointWorkspaceProject `json:"projects"`
}

// Validate validates this hashicorp waypoint workspace
func (m *HashicorpWaypointWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProjects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointWorkspace) validateActiveTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveTime) { // not required
		return nil
	}

	if err := validate.FormatOf("active_time", "body", "date-time", m.ActiveTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointWorkspace) validateProjects(formats strfmt.Registry) error {
	if swag.IsZero(m.Projects) { // not required
		return nil
	}

	for i := 0; i < len(m.Projects); i++ {
		if swag.IsZero(m.Projects[i]) { // not required
			continue
		}

		if m.Projects[i] != nil {
			if err := m.Projects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("projects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("projects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint workspace based on the context it is used
func (m *HashicorpWaypointWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointWorkspace) contextValidateProjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Projects); i++ {

		if m.Projects[i] != nil {
			if err := m.Projects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("projects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("projects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointWorkspace) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
