// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointUser User represents a single user identity within the Waypoint server. A
// user account may represent multiple authentication methods (OIDC from
// multiple sources, tokens, etc.).
//
// swagger:model hashicorp.waypoint.User
type HashicorpWaypointUser struct {

	// Display name, not used for login. May be blank.
	Display string `json:"display,omitempty"`

	// Email, not used for login. May be blank. May not be verified.
	// Verification currently depends on the auth system. One day maybe
	// Waypoint will handle this.
	Email string `json:"email,omitempty"`

	// Id that is unique to the Waypoint server (usually a ULID).
	ID string `json:"id,omitempty"`

	// Links is the list of account links with 3rd party
	// identity systems.
	Links []*HashicorpWaypointUserLink `json:"links"`

	// username, unique to the Waypoint server. May not be blank,
	// but can be changed. We allow changing so that auth methods
	// such as OIDC can generate non-user-friendly usernames and
	// the user can fix them up later.
	Username string `json:"username,omitempty"`
}

// Validate validates this hashicorp waypoint user
func (m *HashicorpWaypointUser) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointUser) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	for i := 0; i < len(m.Links); i++ {
		if swag.IsZero(m.Links[i]) { // not required
			continue
		}

		if m.Links[i] != nil {
			if err := m.Links[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("links" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("links" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint user based on the context it is used
func (m *HashicorpWaypointUser) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointUser) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Links); i++ {

		if m.Links[i] != nil {
			if err := m.Links[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("links" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("links" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointUser) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointUser) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointUser
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
