// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointValidateJobReader is a Reader for the WaypointValidateJob structure.
type WaypointValidateJobReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointValidateJobReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointValidateJobOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointValidateJobDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointValidateJobOK creates a WaypointValidateJobOK with default headers values
func NewWaypointValidateJobOK() *WaypointValidateJobOK {
	return &WaypointValidateJobOK{}
}

/*
WaypointValidateJobOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointValidateJobOK struct {
	Payload *models.HashicorpWaypointValidateJobResponse
}

// IsSuccess returns true when this waypoint validate job o k response has a 2xx status code
func (o *WaypointValidateJobOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint validate job o k response has a 3xx status code
func (o *WaypointValidateJobOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint validate job o k response has a 4xx status code
func (o *WaypointValidateJobOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint validate job o k response has a 5xx status code
func (o *WaypointValidateJobOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint validate job o k response a status code equal to that given
func (o *WaypointValidateJobOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointValidateJobOK) Error() string {
	return fmt.Sprintf("[POST /jobs/validateJob][%d] waypointValidateJobOK  %+v", 200, o.Payload)
}

func (o *WaypointValidateJobOK) String() string {
	return fmt.Sprintf("[POST /jobs/validateJob][%d] waypointValidateJobOK  %+v", 200, o.Payload)
}

func (o *WaypointValidateJobOK) GetPayload() *models.HashicorpWaypointValidateJobResponse {
	return o.Payload
}

func (o *WaypointValidateJobOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointValidateJobResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointValidateJobDefault creates a WaypointValidateJobDefault with default headers values
func NewWaypointValidateJobDefault(code int) *WaypointValidateJobDefault {
	return &WaypointValidateJobDefault{
		_statusCode: code,
	}
}

/*
WaypointValidateJobDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointValidateJobDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint validate job default response
func (o *WaypointValidateJobDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint validate job default response has a 2xx status code
func (o *WaypointValidateJobDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint validate job default response has a 3xx status code
func (o *WaypointValidateJobDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint validate job default response has a 4xx status code
func (o *WaypointValidateJobDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint validate job default response has a 5xx status code
func (o *WaypointValidateJobDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint validate job default response a status code equal to that given
func (o *WaypointValidateJobDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointValidateJobDefault) Error() string {
	return fmt.Sprintf("[POST /jobs/validateJob][%d] Waypoint_ValidateJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointValidateJobDefault) String() string {
	return fmt.Sprintf("[POST /jobs/validateJob][%d] Waypoint_ValidateJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointValidateJobDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointValidateJobDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
