// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUIListReleasesReader is a Reader for the WaypointUIListReleases structure.
type WaypointUIListReleasesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUIListReleasesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUIListReleasesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUIListReleasesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUIListReleasesOK creates a WaypointUIListReleasesOK with default headers values
func NewWaypointUIListReleasesOK() *WaypointUIListReleasesOK {
	return &WaypointUIListReleasesOK{}
}

/*
WaypointUIListReleasesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUIListReleasesOK struct {
	Payload *models.HashicorpWaypointUIListReleasesResponse
}

// IsSuccess returns true when this waypoint Ui list releases o k response has a 2xx status code
func (o *WaypointUIListReleasesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint Ui list releases o k response has a 3xx status code
func (o *WaypointUIListReleasesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint Ui list releases o k response has a 4xx status code
func (o *WaypointUIListReleasesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint Ui list releases o k response has a 5xx status code
func (o *WaypointUIListReleasesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint Ui list releases o k response a status code equal to that given
func (o *WaypointUIListReleasesOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUIListReleasesOK) Error() string {
	return fmt.Sprintf("[GET /ui/releases/workspace/{workspace.workspace}][%d] waypointUiListReleasesOK  %+v", 200, o.Payload)
}

func (o *WaypointUIListReleasesOK) String() string {
	return fmt.Sprintf("[GET /ui/releases/workspace/{workspace.workspace}][%d] waypointUiListReleasesOK  %+v", 200, o.Payload)
}

func (o *WaypointUIListReleasesOK) GetPayload() *models.HashicorpWaypointUIListReleasesResponse {
	return o.Payload
}

func (o *WaypointUIListReleasesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUIListReleasesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUIListReleasesDefault creates a WaypointUIListReleasesDefault with default headers values
func NewWaypointUIListReleasesDefault(code int) *WaypointUIListReleasesDefault {
	return &WaypointUIListReleasesDefault{
		_statusCode: code,
	}
}

/*
WaypointUIListReleasesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUIListReleasesDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint UI list releases default response
func (o *WaypointUIListReleasesDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint UI list releases default response has a 2xx status code
func (o *WaypointUIListReleasesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint UI list releases default response has a 3xx status code
func (o *WaypointUIListReleasesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint UI list releases default response has a 4xx status code
func (o *WaypointUIListReleasesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint UI list releases default response has a 5xx status code
func (o *WaypointUIListReleasesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint UI list releases default response a status code equal to that given
func (o *WaypointUIListReleasesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUIListReleasesDefault) Error() string {
	return fmt.Sprintf("[GET /ui/releases/workspace/{workspace.workspace}][%d] Waypoint_UI_ListReleases default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIListReleasesDefault) String() string {
	return fmt.Sprintf("[GET /ui/releases/workspace/{workspace.workspace}][%d] Waypoint_UI_ListReleases default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIListReleasesDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUIListReleasesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
