// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListTaskReader is a Reader for the WaypointListTask structure.
type WaypointListTaskReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListTaskReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListTaskOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListTaskDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListTaskOK creates a WaypointListTaskOK with default headers values
func NewWaypointListTaskOK() *WaypointListTaskOK {
	return &WaypointListTaskOK{}
}

/*
WaypointListTaskOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListTaskOK struct {
	Payload *models.HashicorpWaypointListTaskResponse
}

// IsSuccess returns true when this waypoint list task o k response has a 2xx status code
func (o *WaypointListTaskOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list task o k response has a 3xx status code
func (o *WaypointListTaskOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list task o k response has a 4xx status code
func (o *WaypointListTaskOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list task o k response has a 5xx status code
func (o *WaypointListTaskOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list task o k response a status code equal to that given
func (o *WaypointListTaskOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListTaskOK) Error() string {
	return fmt.Sprintf("[GET /tasks][%d] waypointListTaskOK  %+v", 200, o.Payload)
}

func (o *WaypointListTaskOK) String() string {
	return fmt.Sprintf("[GET /tasks][%d] waypointListTaskOK  %+v", 200, o.Payload)
}

func (o *WaypointListTaskOK) GetPayload() *models.HashicorpWaypointListTaskResponse {
	return o.Payload
}

func (o *WaypointListTaskOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListTaskResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListTaskDefault creates a WaypointListTaskDefault with default headers values
func NewWaypointListTaskDefault(code int) *WaypointListTaskDefault {
	return &WaypointListTaskDefault{
		_statusCode: code,
	}
}

/*
WaypointListTaskDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListTaskDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list task default response
func (o *WaypointListTaskDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list task default response has a 2xx status code
func (o *WaypointListTaskDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list task default response has a 3xx status code
func (o *WaypointListTaskDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list task default response has a 4xx status code
func (o *WaypointListTaskDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list task default response has a 5xx status code
func (o *WaypointListTaskDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list task default response a status code equal to that given
func (o *WaypointListTaskDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListTaskDefault) Error() string {
	return fmt.Sprintf("[GET /tasks][%d] Waypoint_ListTask default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTaskDefault) String() string {
	return fmt.Sprintf("[GET /tasks][%d] Waypoint_ListTask default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTaskDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListTaskDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
