// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetTask2Params creates a new WaypointGetTask2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetTask2Params() *WaypointGetTask2Params {
	return &WaypointGetTask2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetTask2ParamsWithTimeout creates a new WaypointGetTask2Params object
// with the ability to set a timeout on a request.
func NewWaypointGetTask2ParamsWithTimeout(timeout time.Duration) *WaypointGetTask2Params {
	return &WaypointGetTask2Params{
		timeout: timeout,
	}
}

// NewWaypointGetTask2ParamsWithContext creates a new WaypointGetTask2Params object
// with the ability to set a context for a request.
func NewWaypointGetTask2ParamsWithContext(ctx context.Context) *WaypointGetTask2Params {
	return &WaypointGetTask2Params{
		Context: ctx,
	}
}

// NewWaypointGetTask2ParamsWithHTTPClient creates a new WaypointGetTask2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetTask2ParamsWithHTTPClient(client *http.Client) *WaypointGetTask2Params {
	return &WaypointGetTask2Params{
		HTTPClient: client,
	}
}

/*
WaypointGetTask2Params contains all the parameters to send to the API endpoint

	for the waypoint get task2 operation.

	Typically these are written to a http.Request.
*/
type WaypointGetTask2Params struct {

	/* RefID.

	   the id of the tracktask record.
	*/
	RefID *string

	/* RefJobID.

	   The main "run" job ID that the task initiated
	*/
	RefJobID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get task2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetTask2Params) WithDefaults() *WaypointGetTask2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get task2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetTask2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get task2 params
func (o *WaypointGetTask2Params) WithTimeout(timeout time.Duration) *WaypointGetTask2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get task2 params
func (o *WaypointGetTask2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get task2 params
func (o *WaypointGetTask2Params) WithContext(ctx context.Context) *WaypointGetTask2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get task2 params
func (o *WaypointGetTask2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get task2 params
func (o *WaypointGetTask2Params) WithHTTPClient(client *http.Client) *WaypointGetTask2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get task2 params
func (o *WaypointGetTask2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithRefID adds the refID to the waypoint get task2 params
func (o *WaypointGetTask2Params) WithRefID(refID *string) *WaypointGetTask2Params {
	o.SetRefID(refID)
	return o
}

// SetRefID adds the refId to the waypoint get task2 params
func (o *WaypointGetTask2Params) SetRefID(refID *string) {
	o.RefID = refID
}

// WithRefJobID adds the refJobID to the waypoint get task2 params
func (o *WaypointGetTask2Params) WithRefJobID(refJobID string) *WaypointGetTask2Params {
	o.SetRefJobID(refJobID)
	return o
}

// SetRefJobID adds the refJobId to the waypoint get task2 params
func (o *WaypointGetTask2Params) SetRefJobID(refJobID string) {
	o.RefJobID = refJobID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetTask2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.RefID != nil {

		// query param ref.id
		var qrRefID string

		if o.RefID != nil {
			qrRefID = *o.RefID
		}
		qRefID := qrRefID
		if qRefID != "" {

			if err := r.SetQueryParam("ref.id", qRefID); err != nil {
				return err
			}
		}
	}

	// path param ref.job_id
	if err := r.SetPathParam("ref.job_id", o.RefJobID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
