// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointDeleteAuthMethodReader is a Reader for the WaypointDeleteAuthMethod structure.
type WaypointDeleteAuthMethodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointDeleteAuthMethodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointDeleteAuthMethodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointDeleteAuthMethodDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointDeleteAuthMethodOK creates a WaypointDeleteAuthMethodOK with default headers values
func NewWaypointDeleteAuthMethodOK() *WaypointDeleteAuthMethodOK {
	return &WaypointDeleteAuthMethodOK{}
}

/*
WaypointDeleteAuthMethodOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointDeleteAuthMethodOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint delete auth method o k response has a 2xx status code
func (o *WaypointDeleteAuthMethodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint delete auth method o k response has a 3xx status code
func (o *WaypointDeleteAuthMethodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint delete auth method o k response has a 4xx status code
func (o *WaypointDeleteAuthMethodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint delete auth method o k response has a 5xx status code
func (o *WaypointDeleteAuthMethodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint delete auth method o k response a status code equal to that given
func (o *WaypointDeleteAuthMethodOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointDeleteAuthMethodOK) Error() string {
	return fmt.Sprintf("[DELETE /auth-method/{auth_method.name}][%d] waypointDeleteAuthMethodOK  %+v", 200, o.Payload)
}

func (o *WaypointDeleteAuthMethodOK) String() string {
	return fmt.Sprintf("[DELETE /auth-method/{auth_method.name}][%d] waypointDeleteAuthMethodOK  %+v", 200, o.Payload)
}

func (o *WaypointDeleteAuthMethodOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointDeleteAuthMethodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointDeleteAuthMethodDefault creates a WaypointDeleteAuthMethodDefault with default headers values
func NewWaypointDeleteAuthMethodDefault(code int) *WaypointDeleteAuthMethodDefault {
	return &WaypointDeleteAuthMethodDefault{
		_statusCode: code,
	}
}

/*
WaypointDeleteAuthMethodDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointDeleteAuthMethodDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint delete auth method default response
func (o *WaypointDeleteAuthMethodDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint delete auth method default response has a 2xx status code
func (o *WaypointDeleteAuthMethodDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint delete auth method default response has a 3xx status code
func (o *WaypointDeleteAuthMethodDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint delete auth method default response has a 4xx status code
func (o *WaypointDeleteAuthMethodDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint delete auth method default response has a 5xx status code
func (o *WaypointDeleteAuthMethodDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint delete auth method default response a status code equal to that given
func (o *WaypointDeleteAuthMethodDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointDeleteAuthMethodDefault) Error() string {
	return fmt.Sprintf("[DELETE /auth-method/{auth_method.name}][%d] Waypoint_DeleteAuthMethod default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDeleteAuthMethodDefault) String() string {
	return fmt.Sprintf("[DELETE /auth-method/{auth_method.name}][%d] Waypoint_DeleteAuthMethod default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDeleteAuthMethodDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointDeleteAuthMethodDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
