// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointProject hashicorp waypoint project
//
// swagger:model hashicorp.waypoint.Project
type HashicorpWaypointProject struct {

	// The set of applications that are known about this project. Note that
	// this may not exactly represent the project configuration if a user hasn't
	// run `waypoint init` yet.
	//
	// The applications cannot be modified in any Project APIs. You must
	// use the dedicated Application APIs.
	Applications []*HashicorpWaypointApplication `json:"applications"`

	// Where data is sourced for remote operations. If this isn't set, then
	// there is no default data source and it will be an error if a job is
	// queued for this project without a data source set. This is usually
	// set using the `runner {}` block in the waypoint config.
	DataSource *HashicorpWaypointJobDataSource `json:"data_source,omitempty"`

	// Polling settings. Polling will trigger a "waypoint up" whenever a
	// new data is detected on the data source. For now, polling is only done
	// on the `default` workspace. A future version of Waypoint will expand
	// polling to other workspaces.
	//
	// Each polling event is tracked as a separate job. You can query the
	// poll operations and their success/failure by using the ListJobs API.
	DataSourcePoll *HashicorpWaypointProjectPoll `json:"data_source_poll,omitempty"`

	// Indicates signal to be sent to any applications when their config files
	// change.
	FileChangeSignal string `json:"file_change_signal,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// If true, then the `-remote` flag or the `waypoint build project/app`
	// syntax can be used with a remote runner. If this is false, then
	// this is not allowed. This is typically configured using the
	// `runner {}` block in the waypoint config.
	RemoteEnabled bool `json:"remote_enabled,omitempty"`

	// state
	State *HashicorpWaypointProjectProjectState `json:"state,omitempty"`

	// Application polling settings. Polling will trigger a "StatusFunc" for collecting a
	// report on the current status of the application.
	// For now, polling is only done on the `default` workspace. A future
	// version of Waypoint will expand polling to other workspaces.
	//
	// Each polling event is tracked as a separate job. You can query the
	// poll operations and their success/failure by using the ListJobs API.
	StatusReportPoll *HashicorpWaypointProjectAppStatusPoll `json:"status_report_poll,omitempty"`

	// Variable values stored on the server. These values are set in the UI.
	Variables []*HashicorpWaypointVariable `json:"variables"`

	// The contents of a default waypoint.hcl file. This will be used ONLY IF
	// this project does not have a waypoint.hcl file when an operation is
	// executed. When this is used, local operations can't be run any more
	// since the CLI usually determines the project based on the waypoint.hcl
	// file. The CLI may still be used for remote operations by executing
	// i.e. waypoint up <project>
	// Format: byte
	WaypointHcl strfmt.Base64 `json:"waypoint_hcl,omitempty"`

	// waypoint hcl format
	WaypointHclFormat *HashicorpWaypointHclFormat `json:"waypoint_hcl_format,omitempty"`
}

// Validate validates this hashicorp waypoint project
func (m *HashicorpWaypointProject) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplications(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSourcePoll(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusReportPoll(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariables(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWaypointHclFormat(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointProject) validateApplications(formats strfmt.Registry) error {
	if swag.IsZero(m.Applications) { // not required
		return nil
	}

	for i := 0; i < len(m.Applications); i++ {
		if swag.IsZero(m.Applications[i]) { // not required
			continue
		}

		if m.Applications[i] != nil {
			if err := m.Applications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applications" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointProject) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSource) { // not required
		return nil
	}

	if m.DataSource != nil {
		if err := m.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) validateDataSourcePoll(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSourcePoll) { // not required
		return nil
	}

	if m.DataSourcePoll != nil {
		if err := m.DataSourcePoll.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source_poll")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source_poll")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) validateStatusReportPoll(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusReportPoll) { // not required
		return nil
	}

	if m.StatusReportPoll != nil {
		if err := m.StatusReportPoll.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report_poll")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report_poll")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) validateVariables(formats strfmt.Registry) error {
	if swag.IsZero(m.Variables) { // not required
		return nil
	}

	for i := 0; i < len(m.Variables); i++ {
		if swag.IsZero(m.Variables[i]) { // not required
			continue
		}

		if m.Variables[i] != nil {
			if err := m.Variables[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointProject) validateWaypointHclFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.WaypointHclFormat) { // not required
		return nil
	}

	if m.WaypointHclFormat != nil {
		if err := m.WaypointHclFormat.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypoint_hcl_format")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypoint_hcl_format")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint project based on the context it is used
func (m *HashicorpWaypointProject) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSourcePoll(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusReportPoll(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariables(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWaypointHclFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointProject) contextValidateApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Applications); i++ {

		if m.Applications[i] != nil {
			if err := m.Applications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applications" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSource != nil {
		if err := m.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateDataSourcePoll(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSourcePoll != nil {
		if err := m.DataSourcePoll.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source_poll")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source_poll")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateStatusReportPoll(ctx context.Context, formats strfmt.Registry) error {

	if m.StatusReportPoll != nil {
		if err := m.StatusReportPoll.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report_poll")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report_poll")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateVariables(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Variables); i++ {

		if m.Variables[i] != nil {
			if err := m.Variables[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointProject) contextValidateWaypointHclFormat(ctx context.Context, formats strfmt.Registry) error {

	if m.WaypointHclFormat != nil {
		if err := m.WaypointHclFormat.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypoint_hcl_format")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypoint_hcl_format")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointProject) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointProject) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointProject
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
