// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointJobGitRef Ref is used to populate DataSource.Ref
//
// swagger:model hashicorp.waypoint.Job.Git.Ref
type HashicorpWaypointJobGitRef struct {

	// commit is the full commit hash
	Commit string `json:"commit,omitempty"`

	// commit_message is the commit message, contains arbitrary text
	CommitMessage string `json:"commit_message,omitempty"`

	// timestamp is the timestamp of the commit
	// Format: date-time
	Timestamp strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this hashicorp waypoint job git ref
func (m *HashicorpWaypointJobGitRef) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobGitRef) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hashicorp waypoint job git ref based on context it is used
func (m *HashicorpWaypointJobGitRef) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJobGitRef) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJobGitRef) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJobGitRef
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
