// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointDeploymentPreload hashicorp waypoint deployment preload
//
// swagger:model hashicorp.waypoint.Deployment.Preload
type HashicorpWaypointDeploymentPreload struct {

	// Populated when a Deployment is read with LoadDetails set
	// to ARTIFACT or BUILD
	Artifact *HashicorpWaypointPushedArtifact `json:"artifact,omitempty"`

	// Populated when a Deployment is read with LoadDetails set to BUILD
	Build *HashicorpWaypointBuild `json:"build,omitempty"`

	// The deployment-specific URL from the URL service. This is set on
	// all deployment API calls. This will be empty if the URL service
	// is not enabled or there was an error loading this information.
	DeployURL string `json:"deploy_url,omitempty"`

	// The ref that was used in the job to run this operation. This is
	// also accessible by querying the job via the job_id and should always
	// match.
	//
	// This may be null under multiple circumstances: (1) the job was
	// manually triggered with local data (no datasource) or (2) the job
	// was run in earlier versions of Waypoint before we tracked this or
	// (3) the job hasn't yet loaded the data.
	//
	// This is always pre-populated if it is exists.
	JobDataSourceRef *HashicorpWaypointJobDataSourceRef `json:"job_data_source_ref,omitempty"`
}

// Validate validates this hashicorp waypoint deployment preload
func (m *HashicorpWaypointDeploymentPreload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArtifact(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJobDataSourceRef(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointDeploymentPreload) validateArtifact(formats strfmt.Registry) error {
	if swag.IsZero(m.Artifact) { // not required
		return nil
	}

	if m.Artifact != nil {
		if err := m.Artifact.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("artifact")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("artifact")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeploymentPreload) validateBuild(formats strfmt.Registry) error {
	if swag.IsZero(m.Build) { // not required
		return nil
	}

	if m.Build != nil {
		if err := m.Build.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeploymentPreload) validateJobDataSourceRef(formats strfmt.Registry) error {
	if swag.IsZero(m.JobDataSourceRef) { // not required
		return nil
	}

	if m.JobDataSourceRef != nil {
		if err := m.JobDataSourceRef.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_data_source_ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_data_source_ref")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint deployment preload based on the context it is used
func (m *HashicorpWaypointDeploymentPreload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArtifact(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBuild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJobDataSourceRef(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointDeploymentPreload) contextValidateArtifact(ctx context.Context, formats strfmt.Registry) error {

	if m.Artifact != nil {
		if err := m.Artifact.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("artifact")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("artifact")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeploymentPreload) contextValidateBuild(ctx context.Context, formats strfmt.Registry) error {

	if m.Build != nil {
		if err := m.Build.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeploymentPreload) contextValidateJobDataSourceRef(ctx context.Context, formats strfmt.Registry) error {

	if m.JobDataSourceRef != nil {
		if err := m.JobDataSourceRef.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_data_source_ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_data_source_ref")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointDeploymentPreload) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointDeploymentPreload) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointDeploymentPreload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
