// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUIGetProjectReader is a Reader for the WaypointUIGetProject structure.
type WaypointUIGetProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUIGetProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUIGetProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUIGetProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUIGetProjectOK creates a WaypointUIGetProjectOK with default headers values
func NewWaypointUIGetProjectOK() *WaypointUIGetProjectOK {
	return &WaypointUIGetProjectOK{}
}

/*
WaypointUIGetProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUIGetProjectOK struct {
	Payload *models.HashicorpWaypointUIGetProjectResponse
}

// IsSuccess returns true when this waypoint Ui get project o k response has a 2xx status code
func (o *WaypointUIGetProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint Ui get project o k response has a 3xx status code
func (o *WaypointUIGetProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint Ui get project o k response has a 4xx status code
func (o *WaypointUIGetProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint Ui get project o k response has a 5xx status code
func (o *WaypointUIGetProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint Ui get project o k response a status code equal to that given
func (o *WaypointUIGetProjectOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUIGetProjectOK) Error() string {
	return fmt.Sprintf("[GET /ui/project/{project.project}][%d] waypointUiGetProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointUIGetProjectOK) String() string {
	return fmt.Sprintf("[GET /ui/project/{project.project}][%d] waypointUiGetProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointUIGetProjectOK) GetPayload() *models.HashicorpWaypointUIGetProjectResponse {
	return o.Payload
}

func (o *WaypointUIGetProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUIGetProjectResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUIGetProjectDefault creates a WaypointUIGetProjectDefault with default headers values
func NewWaypointUIGetProjectDefault(code int) *WaypointUIGetProjectDefault {
	return &WaypointUIGetProjectDefault{
		_statusCode: code,
	}
}

/*
WaypointUIGetProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUIGetProjectDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint UI get project default response
func (o *WaypointUIGetProjectDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint UI get project default response has a 2xx status code
func (o *WaypointUIGetProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint UI get project default response has a 3xx status code
func (o *WaypointUIGetProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint UI get project default response has a 4xx status code
func (o *WaypointUIGetProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint UI get project default response has a 5xx status code
func (o *WaypointUIGetProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint UI get project default response a status code equal to that given
func (o *WaypointUIGetProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUIGetProjectDefault) Error() string {
	return fmt.Sprintf("[GET /ui/project/{project.project}][%d] Waypoint_UI_GetProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIGetProjectDefault) String() string {
	return fmt.Sprintf("[GET /ui/project/{project.project}][%d] Waypoint_UI_GetProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIGetProjectDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUIGetProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
