// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointStartExecStreamReader is a Reader for the WaypointStartExecStream structure.
type WaypointStartExecStreamReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointStartExecStreamReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointStartExecStreamOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointStartExecStreamDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointStartExecStreamOK creates a WaypointStartExecStreamOK with default headers values
func NewWaypointStartExecStreamOK() *WaypointStartExecStreamOK {
	return &WaypointStartExecStreamOK{}
}

/*
WaypointStartExecStreamOK describes a response with status code 200, with default header values.

A successful response.(streaming responses)
*/
type WaypointStartExecStreamOK struct {
	Payload *WaypointStartExecStreamOKBody
}

// IsSuccess returns true when this waypoint start exec stream o k response has a 2xx status code
func (o *WaypointStartExecStreamOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint start exec stream o k response has a 3xx status code
func (o *WaypointStartExecStreamOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint start exec stream o k response has a 4xx status code
func (o *WaypointStartExecStreamOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint start exec stream o k response has a 5xx status code
func (o *WaypointStartExecStreamOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint start exec stream o k response a status code equal to that given
func (o *WaypointStartExecStreamOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointStartExecStreamOK) Error() string {
	return fmt.Sprintf("[POST /exec][%d] waypointStartExecStreamOK  %+v", 200, o.Payload)
}

func (o *WaypointStartExecStreamOK) String() string {
	return fmt.Sprintf("[POST /exec][%d] waypointStartExecStreamOK  %+v", 200, o.Payload)
}

func (o *WaypointStartExecStreamOK) GetPayload() *WaypointStartExecStreamOKBody {
	return o.Payload
}

func (o *WaypointStartExecStreamOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(WaypointStartExecStreamOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointStartExecStreamDefault creates a WaypointStartExecStreamDefault with default headers values
func NewWaypointStartExecStreamDefault(code int) *WaypointStartExecStreamDefault {
	return &WaypointStartExecStreamDefault{
		_statusCode: code,
	}
}

/*
WaypointStartExecStreamDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointStartExecStreamDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint start exec stream default response
func (o *WaypointStartExecStreamDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint start exec stream default response has a 2xx status code
func (o *WaypointStartExecStreamDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint start exec stream default response has a 3xx status code
func (o *WaypointStartExecStreamDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint start exec stream default response has a 4xx status code
func (o *WaypointStartExecStreamDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint start exec stream default response has a 5xx status code
func (o *WaypointStartExecStreamDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint start exec stream default response a status code equal to that given
func (o *WaypointStartExecStreamDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointStartExecStreamDefault) Error() string {
	return fmt.Sprintf("[POST /exec][%d] Waypoint_StartExecStream default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointStartExecStreamDefault) String() string {
	return fmt.Sprintf("[POST /exec][%d] Waypoint_StartExecStream default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointStartExecStreamDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointStartExecStreamDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WaypointStartExecStreamOKBody Stream result of hashicorp.waypoint.ExecStreamResponse
swagger:model WaypointStartExecStreamOKBody
*/
type WaypointStartExecStreamOKBody struct {

	// error
	Error *models.GrpcGatewayRuntimeStreamError `json:"error,omitempty"`

	// result
	Result *models.HashicorpWaypointExecStreamResponse `json:"result,omitempty"`
}

// Validate validates this waypoint start exec stream o k body
func (o *WaypointStartExecStreamOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateResult(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointStartExecStreamOKBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointStartExecStreamOK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointStartExecStreamOK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointStartExecStreamOKBody) validateResult(formats strfmt.Registry) error {
	if swag.IsZero(o.Result) { // not required
		return nil
	}

	if o.Result != nil {
		if err := o.Result.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointStartExecStreamOK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointStartExecStreamOK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this waypoint start exec stream o k body based on the context it is used
func (o *WaypointStartExecStreamOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResult(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointStartExecStreamOKBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointStartExecStreamOK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointStartExecStreamOK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointStartExecStreamOKBody) contextValidateResult(ctx context.Context, formats strfmt.Registry) error {

	if o.Result != nil {
		if err := o.Result.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointStartExecStreamOK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointStartExecStreamOK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WaypointStartExecStreamOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WaypointStartExecStreamOKBody) UnmarshalBinary(b []byte) error {
	var res WaypointStartExecStreamOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
