// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListStatusReports2Reader is a Reader for the WaypointListStatusReports2 structure.
type WaypointListStatusReports2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListStatusReports2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListStatusReports2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListStatusReports2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListStatusReports2OK creates a WaypointListStatusReports2OK with default headers values
func NewWaypointListStatusReports2OK() *WaypointListStatusReports2OK {
	return &WaypointListStatusReports2OK{}
}

/*
WaypointListStatusReports2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListStatusReports2OK struct {
	Payload *models.HashicorpWaypointListStatusReportsResponse
}

// IsSuccess returns true when this waypoint list status reports2 o k response has a 2xx status code
func (o *WaypointListStatusReports2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list status reports2 o k response has a 3xx status code
func (o *WaypointListStatusReports2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list status reports2 o k response has a 4xx status code
func (o *WaypointListStatusReports2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list status reports2 o k response has a 5xx status code
func (o *WaypointListStatusReports2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list status reports2 o k response a status code equal to that given
func (o *WaypointListStatusReports2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListStatusReports2OK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-reports][%d] waypointListStatusReports2OK  %+v", 200, o.Payload)
}

func (o *WaypointListStatusReports2OK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-reports][%d] waypointListStatusReports2OK  %+v", 200, o.Payload)
}

func (o *WaypointListStatusReports2OK) GetPayload() *models.HashicorpWaypointListStatusReportsResponse {
	return o.Payload
}

func (o *WaypointListStatusReports2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListStatusReportsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListStatusReports2Default creates a WaypointListStatusReports2Default with default headers values
func NewWaypointListStatusReports2Default(code int) *WaypointListStatusReports2Default {
	return &WaypointListStatusReports2Default{
		_statusCode: code,
	}
}

/*
WaypointListStatusReports2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListStatusReports2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list status reports2 default response
func (o *WaypointListStatusReports2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list status reports2 default response has a 2xx status code
func (o *WaypointListStatusReports2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list status reports2 default response has a 3xx status code
func (o *WaypointListStatusReports2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list status reports2 default response has a 4xx status code
func (o *WaypointListStatusReports2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list status reports2 default response has a 5xx status code
func (o *WaypointListStatusReports2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list status reports2 default response a status code equal to that given
func (o *WaypointListStatusReports2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListStatusReports2Default) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-reports][%d] Waypoint_ListStatusReports2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListStatusReports2Default) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-reports][%d] Waypoint_ListStatusReports2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListStatusReports2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListStatusReports2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
