// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListReleasesReader is a Reader for the WaypointListReleases structure.
type WaypointListReleasesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListReleasesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListReleasesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListReleasesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListReleasesOK creates a WaypointListReleasesOK with default headers values
func NewWaypointListReleasesOK() *WaypointListReleasesOK {
	return &WaypointListReleasesOK{}
}

/*
WaypointListReleasesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListReleasesOK struct {
	Payload *models.HashicorpWaypointListReleasesResponse
}

// IsSuccess returns true when this waypoint list releases o k response has a 2xx status code
func (o *WaypointListReleasesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list releases o k response has a 3xx status code
func (o *WaypointListReleasesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list releases o k response has a 4xx status code
func (o *WaypointListReleasesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list releases o k response has a 5xx status code
func (o *WaypointListReleasesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list releases o k response a status code equal to that given
func (o *WaypointListReleasesOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListReleasesOK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/releases][%d] waypointListReleasesOK  %+v", 200, o.Payload)
}

func (o *WaypointListReleasesOK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/releases][%d] waypointListReleasesOK  %+v", 200, o.Payload)
}

func (o *WaypointListReleasesOK) GetPayload() *models.HashicorpWaypointListReleasesResponse {
	return o.Payload
}

func (o *WaypointListReleasesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListReleasesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListReleasesDefault creates a WaypointListReleasesDefault with default headers values
func NewWaypointListReleasesDefault(code int) *WaypointListReleasesDefault {
	return &WaypointListReleasesDefault{
		_statusCode: code,
	}
}

/*
WaypointListReleasesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListReleasesDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list releases default response
func (o *WaypointListReleasesDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list releases default response has a 2xx status code
func (o *WaypointListReleasesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list releases default response has a 3xx status code
func (o *WaypointListReleasesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list releases default response has a 4xx status code
func (o *WaypointListReleasesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list releases default response has a 5xx status code
func (o *WaypointListReleasesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list releases default response a status code equal to that given
func (o *WaypointListReleasesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListReleasesDefault) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/releases][%d] Waypoint_ListReleases default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListReleasesDefault) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/releases][%d] Waypoint_ListReleases default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListReleasesDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListReleasesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
