// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListPipelineRuns2Reader is a Reader for the WaypointListPipelineRuns2 structure.
type WaypointListPipelineRuns2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListPipelineRuns2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListPipelineRuns2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListPipelineRuns2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListPipelineRuns2OK creates a WaypointListPipelineRuns2OK with default headers values
func NewWaypointListPipelineRuns2OK() *WaypointListPipelineRuns2OK {
	return &WaypointListPipelineRuns2OK{}
}

/*
WaypointListPipelineRuns2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListPipelineRuns2OK struct {
	Payload *models.HashicorpWaypointListPipelineRunsResponse
}

// IsSuccess returns true when this waypoint list pipeline runs2 o k response has a 2xx status code
func (o *WaypointListPipelineRuns2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list pipeline runs2 o k response has a 3xx status code
func (o *WaypointListPipelineRuns2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list pipeline runs2 o k response has a 4xx status code
func (o *WaypointListPipelineRuns2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list pipeline runs2 o k response has a 5xx status code
func (o *WaypointListPipelineRuns2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list pipeline runs2 o k response a status code equal to that given
func (o *WaypointListPipelineRuns2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListPipelineRuns2OK) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/runs][%d] waypointListPipelineRuns2OK  %+v", 200, o.Payload)
}

func (o *WaypointListPipelineRuns2OK) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/runs][%d] waypointListPipelineRuns2OK  %+v", 200, o.Payload)
}

func (o *WaypointListPipelineRuns2OK) GetPayload() *models.HashicorpWaypointListPipelineRunsResponse {
	return o.Payload
}

func (o *WaypointListPipelineRuns2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListPipelineRunsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListPipelineRuns2Default creates a WaypointListPipelineRuns2Default with default headers values
func NewWaypointListPipelineRuns2Default(code int) *WaypointListPipelineRuns2Default {
	return &WaypointListPipelineRuns2Default{
		_statusCode: code,
	}
}

/*
WaypointListPipelineRuns2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListPipelineRuns2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list pipeline runs2 default response
func (o *WaypointListPipelineRuns2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list pipeline runs2 default response has a 2xx status code
func (o *WaypointListPipelineRuns2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list pipeline runs2 default response has a 3xx status code
func (o *WaypointListPipelineRuns2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list pipeline runs2 default response has a 4xx status code
func (o *WaypointListPipelineRuns2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list pipeline runs2 default response has a 5xx status code
func (o *WaypointListPipelineRuns2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list pipeline runs2 default response a status code equal to that given
func (o *WaypointListPipelineRuns2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListPipelineRuns2Default) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/runs][%d] Waypoint_ListPipelineRuns2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListPipelineRuns2Default) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/runs][%d] Waypoint_ListPipelineRuns2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListPipelineRuns2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListPipelineRuns2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
