// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListInstancesReader is a Reader for the WaypointListInstances structure.
type WaypointListInstancesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListInstancesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListInstancesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListInstancesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListInstancesOK creates a WaypointListInstancesOK with default headers values
func NewWaypointListInstancesOK() *WaypointListInstancesOK {
	return &WaypointListInstancesOK{}
}

/*
WaypointListInstancesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListInstancesOK struct {
	Payload *models.HashicorpWaypointListInstancesResponse
}

// IsSuccess returns true when this waypoint list instances o k response has a 2xx status code
func (o *WaypointListInstancesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list instances o k response has a 3xx status code
func (o *WaypointListInstancesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list instances o k response has a 4xx status code
func (o *WaypointListInstancesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list instances o k response has a 5xx status code
func (o *WaypointListInstancesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list instances o k response a status code equal to that given
func (o *WaypointListInstancesOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListInstancesOK) Error() string {
	return fmt.Sprintf("[GET /instances/{deployment_id}][%d] waypointListInstancesOK  %+v", 200, o.Payload)
}

func (o *WaypointListInstancesOK) String() string {
	return fmt.Sprintf("[GET /instances/{deployment_id}][%d] waypointListInstancesOK  %+v", 200, o.Payload)
}

func (o *WaypointListInstancesOK) GetPayload() *models.HashicorpWaypointListInstancesResponse {
	return o.Payload
}

func (o *WaypointListInstancesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListInstancesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListInstancesDefault creates a WaypointListInstancesDefault with default headers values
func NewWaypointListInstancesDefault(code int) *WaypointListInstancesDefault {
	return &WaypointListInstancesDefault{
		_statusCode: code,
	}
}

/*
WaypointListInstancesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListInstancesDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list instances default response
func (o *WaypointListInstancesDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list instances default response has a 2xx status code
func (o *WaypointListInstancesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list instances default response has a 3xx status code
func (o *WaypointListInstancesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list instances default response has a 4xx status code
func (o *WaypointListInstancesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list instances default response has a 5xx status code
func (o *WaypointListInstancesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list instances default response a status code equal to that given
func (o *WaypointListInstancesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListInstancesDefault) Error() string {
	return fmt.Sprintf("[GET /instances/{deployment_id}][%d] Waypoint_ListInstances default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListInstancesDefault) String() string {
	return fmt.Sprintf("[GET /instances/{deployment_id}][%d] Waypoint_ListInstances default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListInstancesDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListInstancesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
