// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListHostnamesReader is a Reader for the WaypointListHostnames structure.
type WaypointListHostnamesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListHostnamesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListHostnamesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListHostnamesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListHostnamesOK creates a WaypointListHostnamesOK with default headers values
func NewWaypointListHostnamesOK() *WaypointListHostnamesOK {
	return &WaypointListHostnamesOK{}
}

/*
WaypointListHostnamesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListHostnamesOK struct {
	Payload *models.HashicorpWaypointListHostnamesResponse
}

// IsSuccess returns true when this waypoint list hostnames o k response has a 2xx status code
func (o *WaypointListHostnamesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list hostnames o k response has a 3xx status code
func (o *WaypointListHostnamesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list hostnames o k response has a 4xx status code
func (o *WaypointListHostnamesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list hostnames o k response has a 5xx status code
func (o *WaypointListHostnamesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list hostnames o k response a status code equal to that given
func (o *WaypointListHostnamesOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListHostnamesOK) Error() string {
	return fmt.Sprintf("[GET /project/{target.application.application.project}/application/{target.application.application.application}/hostnames][%d] waypointListHostnamesOK  %+v", 200, o.Payload)
}

func (o *WaypointListHostnamesOK) String() string {
	return fmt.Sprintf("[GET /project/{target.application.application.project}/application/{target.application.application.application}/hostnames][%d] waypointListHostnamesOK  %+v", 200, o.Payload)
}

func (o *WaypointListHostnamesOK) GetPayload() *models.HashicorpWaypointListHostnamesResponse {
	return o.Payload
}

func (o *WaypointListHostnamesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListHostnamesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListHostnamesDefault creates a WaypointListHostnamesDefault with default headers values
func NewWaypointListHostnamesDefault(code int) *WaypointListHostnamesDefault {
	return &WaypointListHostnamesDefault{
		_statusCode: code,
	}
}

/*
WaypointListHostnamesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListHostnamesDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list hostnames default response
func (o *WaypointListHostnamesDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list hostnames default response has a 2xx status code
func (o *WaypointListHostnamesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list hostnames default response has a 3xx status code
func (o *WaypointListHostnamesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list hostnames default response has a 4xx status code
func (o *WaypointListHostnamesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list hostnames default response has a 5xx status code
func (o *WaypointListHostnamesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list hostnames default response a status code equal to that given
func (o *WaypointListHostnamesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListHostnamesDefault) Error() string {
	return fmt.Sprintf("[GET /project/{target.application.application.project}/application/{target.application.application.application}/hostnames][%d] Waypoint_ListHostnames default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListHostnamesDefault) String() string {
	return fmt.Sprintf("[GET /project/{target.application.application.project}/application/{target.application.application.application}/hostnames][%d] Waypoint_ListHostnames default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListHostnamesDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListHostnamesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
