// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetWorkspaceReader is a Reader for the WaypointGetWorkspace structure.
type WaypointGetWorkspaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetWorkspaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetWorkspaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetWorkspaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetWorkspaceOK creates a WaypointGetWorkspaceOK with default headers values
func NewWaypointGetWorkspaceOK() *WaypointGetWorkspaceOK {
	return &WaypointGetWorkspaceOK{}
}

/*
WaypointGetWorkspaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetWorkspaceOK struct {
	Payload *models.HashicorpWaypointGetWorkspaceResponse
}

// IsSuccess returns true when this waypoint get workspace o k response has a 2xx status code
func (o *WaypointGetWorkspaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get workspace o k response has a 3xx status code
func (o *WaypointGetWorkspaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get workspace o k response has a 4xx status code
func (o *WaypointGetWorkspaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get workspace o k response has a 5xx status code
func (o *WaypointGetWorkspaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get workspace o k response a status code equal to that given
func (o *WaypointGetWorkspaceOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetWorkspaceOK) Error() string {
	return fmt.Sprintf("[GET /workspace/{workspace.workspace}][%d] waypointGetWorkspaceOK  %+v", 200, o.Payload)
}

func (o *WaypointGetWorkspaceOK) String() string {
	return fmt.Sprintf("[GET /workspace/{workspace.workspace}][%d] waypointGetWorkspaceOK  %+v", 200, o.Payload)
}

func (o *WaypointGetWorkspaceOK) GetPayload() *models.HashicorpWaypointGetWorkspaceResponse {
	return o.Payload
}

func (o *WaypointGetWorkspaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetWorkspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetWorkspaceDefault creates a WaypointGetWorkspaceDefault with default headers values
func NewWaypointGetWorkspaceDefault(code int) *WaypointGetWorkspaceDefault {
	return &WaypointGetWorkspaceDefault{
		_statusCode: code,
	}
}

/*
WaypointGetWorkspaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetWorkspaceDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get workspace default response
func (o *WaypointGetWorkspaceDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get workspace default response has a 2xx status code
func (o *WaypointGetWorkspaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get workspace default response has a 3xx status code
func (o *WaypointGetWorkspaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get workspace default response has a 4xx status code
func (o *WaypointGetWorkspaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get workspace default response has a 5xx status code
func (o *WaypointGetWorkspaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get workspace default response a status code equal to that given
func (o *WaypointGetWorkspaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetWorkspaceDefault) Error() string {
	return fmt.Sprintf("[GET /workspace/{workspace.workspace}][%d] Waypoint_GetWorkspace default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetWorkspaceDefault) String() string {
	return fmt.Sprintf("[GET /workspace/{workspace.workspace}][%d] Waypoint_GetWorkspace default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetWorkspaceDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetWorkspaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
