// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetPipelineRun2Reader is a Reader for the WaypointGetPipelineRun2 structure.
type WaypointGetPipelineRun2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetPipelineRun2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetPipelineRun2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetPipelineRun2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetPipelineRun2OK creates a WaypointGetPipelineRun2OK with default headers values
func NewWaypointGetPipelineRun2OK() *WaypointGetPipelineRun2OK {
	return &WaypointGetPipelineRun2OK{}
}

/*
WaypointGetPipelineRun2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetPipelineRun2OK struct {
	Payload *models.HashicorpWaypointGetPipelineRunResponse
}

// IsSuccess returns true when this waypoint get pipeline run2 o k response has a 2xx status code
func (o *WaypointGetPipelineRun2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get pipeline run2 o k response has a 3xx status code
func (o *WaypointGetPipelineRun2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get pipeline run2 o k response has a 4xx status code
func (o *WaypointGetPipelineRun2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get pipeline run2 o k response has a 5xx status code
func (o *WaypointGetPipelineRun2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get pipeline run2 o k response a status code equal to that given
func (o *WaypointGetPipelineRun2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetPipelineRun2OK) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/run/{sequence}][%d] waypointGetPipelineRun2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipelineRun2OK) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/run/{sequence}][%d] waypointGetPipelineRun2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipelineRun2OK) GetPayload() *models.HashicorpWaypointGetPipelineRunResponse {
	return o.Payload
}

func (o *WaypointGetPipelineRun2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetPipelineRunResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetPipelineRun2Default creates a WaypointGetPipelineRun2Default with default headers values
func NewWaypointGetPipelineRun2Default(code int) *WaypointGetPipelineRun2Default {
	return &WaypointGetPipelineRun2Default{
		_statusCode: code,
	}
}

/*
WaypointGetPipelineRun2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetPipelineRun2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get pipeline run2 default response
func (o *WaypointGetPipelineRun2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get pipeline run2 default response has a 2xx status code
func (o *WaypointGetPipelineRun2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get pipeline run2 default response has a 3xx status code
func (o *WaypointGetPipelineRun2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get pipeline run2 default response has a 4xx status code
func (o *WaypointGetPipelineRun2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get pipeline run2 default response has a 5xx status code
func (o *WaypointGetPipelineRun2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get pipeline run2 default response a status code equal to that given
func (o *WaypointGetPipelineRun2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetPipelineRun2Default) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/run/{sequence}][%d] Waypoint_GetPipelineRun2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipelineRun2Default) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}/run/{sequence}][%d] Waypoint_GetPipelineRun2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipelineRun2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetPipelineRun2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
